#ifndef _UOS_RECOVERY_OSTREE_SYSTEM_H_
#define _UOS_RECOVERY_OSTREE_SYSTEM_H_
#include "SystemRecovery.h"
#include <QtDBus/QDBusInterface>

class OSTreeTask;
class CheckTask;

class OSTreeSystem : public SystemRecovery
{
    Q_OBJECT
public:
    OSTreeSystem();
    ~OSTreeSystem();

    // 分区方式是否支持OStree
    bool supported(FSTabInfoList &fsTabInfoList) override;
    // 获取备份默认存放路径
    QString getDefaultBackupDeviceUUID(const QString &rootPath) override;
    // 备份系统
    ErrorCode systemBackup(const SystemBackupRequest &request) override;
    // 还原系统
    ErrorCode systemRestore(const SystemRestoreRequest &request) override;
    // 制作uimg
    ErrorCode createUImg(const QString &backupDir) override;

    BackupInfoList listSystemBackup(QStringList &destUUIDs) override;

    ErrorCode removeSystemBackup(const RemoveUserDataBackupRequest &request) override;

    ErrorCode checkFullSystemBackupSpace(SystemBackupRequest &request) override;
    ErrorCode checkIncSystemBackupSpace(const SystemBackupRequest &request) override;
    virtual bool isRunning() override;

Q_SIGNALS:
    void StateChanged(int operate, int state, const QString &version, const QString &msg);

private Q_SLOTS:
    void onStateChanged(int operate, int state, const QString &version, const QString &msg);

private:
    void initConnection();
    QString buildCommitSubject(const BackupInfo &backupInfo);
    void fillBackupInfo(const SystemBackupRequest &request);
    void subject2BackupInfoList(const QStringList &subjectList, BackupInfoList &backupInfoList);
    void subject2BackupInfo(const QJsonObject &jsonObj, BackupInfo &backupInfo);
    static QString getOSVersion();
    QString getErrorMsgByErrorCode(int errCode);
    QString getCurRepoUuid();

private:
    QDBusInterface *m_atomicUpgradeInterface = nullptr;
    OSTreeTask *m_pOSTreeTask = nullptr;
    CheckTask *m_checkTask = nullptr;
    BackupInfo m_backupInfo;
    QString m_curOperateID;
};

#endif
