//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/10/18.
//

#ifndef UOS_RECOVERY_WORKER_THREAD_H
#define UOS_RECOVERY_WORKER_THREAD_H

#include <QThread>
#include <QJsonObject>
#include <QList>
#include <QStringList>
#include "utils/global.h"

enum class FsType {
    Empty,
    Btrfs,
    EFI,
    Ext2,
    Ext3,
    Ext4,
    F2fs,
    Fat16,
    Fat32,
    VFat,
    Hfs,
    HfsPlus,
    Jfs,
    LinuxSwap,
    LVM2PV,
    Nilfs2,
    NTFS,
    Others,
    Reiser4,
    Reiserfs,
    Xfs,
    Recovery,
    Unknown,
};
QDebug& operator<<(QDebug& debug, const FsType& fs_type);

// Convert between FsType enum and its name.
FsType GetFsTypeByName(const QString& name);
QString GetFsTypeName(FsType fs_type);
typedef QList<FsType> FsTypeList;

class WorkerThread : public QThread {
    Q_OBJECT
public:
    explicit WorkerThread(ActionType actionType);
    virtual ~WorkerThread();

    void run() override;
    void setBackupRequest(const V20BackupReq &request);
    void setSystemRestoreRequest(const V20RestoreReq &request);
    static QString getLiveFlagPath();

Q_SIGNALS:
    void error(int errCode);
    void success();

private:
    void V20Backup(const V20BackupReq &req);
    void v20Restore(const V20RestoreReq &req);
    //void factoryRestore(const SystemRestoreRequest &request);
    int checkBackupV20(const V20BackupReq &request);
    ErrorType check(const QString &backupPath, ActionType actionType, const QString &lang, bool isAutoReboot, bool formatData);
    QString getUUID(const QString &path);
    qint64 getPathFreeSpace(const QString &path);
    qint64 getPathUsageSpace(const QString &path);
    QString getMountPoint(const QStringList &devices, const QString &uuid);
    QString getAbsolutePathFsType(const QStringList &devices, const QString &path);
    QString checkMountPoint(const QString &path);
    int writePathToJsonFile(const QString &mountPoint, const QJsonObject &obj);
    bool checkMd5Valid(const QString &path);
    bool isDeviceMountedReadOnly(const QString &path);
    // Read partition usage at |partition_path| with type |fs_type|
    // Returns false if failed, both |freespace| and |total| are set to -1.
    bool ReadUsage(const QString& partition_path, FsType fs_type, qint64& freespace, qint64& total);
    void cancelBackupOrRestore20();

protected:
    ActionType m_actionType;
    QString m_operateID;
    V20BackupReq m_backupReq;
    V20RestoreReq m_restoreReq;
};

#endif //UOS_RECOVERY_WORKER_THREAD_H
