# CiviCRM 5.11.0

Released March 6, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |         |
| Change the database schema?                                     |         |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     |         |
| Fix problems installing or upgrading to a previous version?     | **yes** |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[dev/core#635](https://lab.civicrm.org/dev/core/issues/635) Implement
  reconnect/replay-on-write for database connections
  ([13489](https://github.com/civicrm/civicrm-core/pull/13489),
  [13514](https://github.com/civicrm/civicrm-core/pull/13514),
  [13496](https://github.com/civicrm/civicrm-core/pull/13496) and
  [13394](https://github.com/civicrm/civicrm-core/pull/13394)) Continued Work**

  These changes move towards making CiviCRM compatibility with a split DB
  architecture in which one routes MySQL requests to (a) read-only slave DBs
  and/or (b) read-write master DB. Specifically by implementing a
  "reconnect-on-write" or "replay-on-write" (RPOW) mechanism.

- **[dev/core#561](https://lab.civicrm.org/dev/core/issues/561) Replace
  jcalendar instances with datepicker
  ([13485](https://github.com/civicrm/civicrm-core/pull/13485),
  [13211](https://github.com/civicrm/civicrm-core/pull/13211),
  [13422](https://github.com/civicrm/civicrm-core/pull/13422) and
  [13423](https://github.com/civicrm/civicrm-core/pull/13423))**

  These changes switch fields that store dates from using jcalendar to use the
  datepicker in the following places: the grant task form fields, grant search
  fields, campaign date fields and activity followup form fields.

- **Add routine for updating smartgroups, currently handling datepicker
  conversion ([13395](https://github.com/civicrm/civicrm-core/pull/13395))**

  This change converts fields from smart groups using grant date fields to new
  datepicker format.

- **[dev/core#491](https://lab.civicrm.org/dev/core/issues/491) Report results
  don't show inactive campaigns
  ([13382](https://github.com/civicrm/civicrm-core/pull/13382))**

  This change standardizes the campaign fields offered on the the Activity,
  Member, Contribution Detail and Member Lapse reports.

- **[dev/core#527](https://lab.civicrm.org/dev/core/issues/527) Non translatable
  fields in profile schema
  ([13185](https://github.com/civicrm/civicrm-core/pull/13185))**

  This change adds the ability to set translated text for the Submit and Cancel
  buttons on a profile.

- **[dev/core#682](https://lab.civicrm.org/dev/core/issues/682) Add basic
  contact filters to Summary Contributions Report
  ([13498](https://github.com/civicrm/civicrm-core/pull/13498))**

  This change adds the basic contact filters and columns to the Summary
  Contributions Report.

- **[dev/core#686](https://lab.civicrm.org/dev/core/issues/686) Make "Amount
  Statistics" columns optional on Membership Summary report
  ([13507](https://github.com/civicrm/civicrm-core/pull/13507))**

  This change makes it so users can choose whether or not to include the "Amount
  Statistics" columns on the Member Summary report.

- **Respect pre hook for relationship to alter id in $params
  ([12834](https://github.com/civicrm/civicrm-core/pull/12834))**

  This change makes it so developers can use the pre hook to alter the id in
  $params for Relationships.

- **use number widget for weight and other numeric fields in more forms
  ([13526](https://github.com/civicrm/civicrm-core/pull/13526))**

  This change works towards a consistent ui by making all forms "weight and
  other numeric" fields number input widgets, before this change some were
  plain-text inputs and some were number input widgets.

- **Survey form - use number widget for number fields
  ([13503](https://github.com/civicrm/civicrm-core/pull/13503))**

  This change works towards a more consistent user experience by making the
  survey form use the number widget for all number fields.

- **use number widget for weight fields in all forms
  ([13520](https://github.com/civicrm/civicrm-core/pull/13520))**

  This change works towards a more consistent user experience by making all
  weight fields use the number input widget (before this change some were number
  input widget and some were plain text inputs).

- **Allow help text to be overridden from an .extra.hlp file
  ([13488](https://github.com/civicrm/civicrm-core/pull/13488))**

  This change makes it so that .extra.hlp files can be used to override help
  text. Before this change .extra.hlp files could be used to append help text
  but not override help text.

- **Add extension compatibility list
  ([13298](https://github.com/civicrm/civicrm-core/pull/13298))**

  Extensions whose functionality is now redundant with core may cause problems
  if left installed. This change makes it so that: Obsolete extensions are
  automatically disabled during core upgrades, obsolete extensions are filtered
  out of the list of downloadable extensions, obsolete extensions are ignored
  when considering dependencies.

- **Add selectWhere hook call to the query that generates the 'annual' query -
  the 'amount this year' on a contact dash
  ([13319](https://github.com/civicrm/civicrm-core/pull/13319))**

  This change adds the selectWhere hook to the getAnnualQuery function so that
  extension developers can use the selectWhere hook to alter the the amount &
  count values for donations this year on a contact dashboard.

- **Convert Campaign widgets to entityRef
  ([13491](https://github.com/civicrm/civicrm-core/pull/13491) and
  [13613](https://github.com/civicrm/civicrm-core/pull/13613))**

  This change cleans up the code and UI for selecting a campaign. Specifically,
  instead of a select list with a button to load past campaigns, now the entire
  list of campaigns is searchable and filterable. Additionally this makes it so
  new campaigns can be created on-the-fly.

- **geocode job: Provide country_id to geocoders.
  ([13456](https://github.com/civicrm/civicrm-core/pull/13456))**

  This change ensures that geocoders receive the country name and id (before
  this change they only received the name). This change fixes a compatibility
  issue with the org.wikimedia.geocoder extension.

- **Use icon for timepicker placeholder
  ([13438](https://github.com/civicrm/civicrm-core/pull/13438))**

  This change adds a clock icon to all timepicker fields.

- **Add default for domain_id for report_instance.
  ([13426](https://github.com/civicrm/civicrm-core/pull/13426))**

  This change makes it so when using ReportInstance.create the domain_id
  defaults to the current domain.

- **Added support to generic settings form for sorting settings by weight.
  ([13345](https://github.com/civicrm/civicrm-core/pull/13345))**

  This change makes it so one can order a generic settings form by weight.

### CiviCase

- **C51-384: Added case tokens on Email Activity Modal
  ([13473](https://github.com/civicrm/civicrm-core/pull/13473))**

  This change makes case tokens available in the email activity modal.

- **Translate untranslated string
  ([13466](https://github.com/civicrm/civicrm-core/pull/13466))**

  This change makes it so the case activity subject when sending a copy of a
  case activity can be translated.

### CiviContribute

- **Speed up loading of contribution tab on contacts with large number of
  contributions in a large database
  ([13512](https://github.com/civicrm/civicrm-core/pull/13512))**

  This change enhances performance when loading the contribution tab on a
  contact.

- **CRM/Contribute - Add query optimization for creditnote_id
  ([13511](https://github.com/civicrm/civicrm-core/pull/13511))**

  This change improves performance when cancelling or refunding contributions.

- **Fix order api to support a pseudoConstant for financial_type_id
  ([13317](https://github.com/civicrm/civicrm-core/pull/13317))**

  This change makes it so the api Order.create supports both the name or the id
  for financial_type_id. This improves consistency with Contribution.create api
  and others

### Backdrop Integration

- **Add main nav icon for CiviCRM (Backdrop)
  ([13481](https://github.com/civicrm/civicrm-core/pull/13481))**

  This change adds the CiviCRM logo to the Backdrop main navigation item for
  CiviCRM.

### Wordpress Integration

- **[dev/wordpress#11](https://lab.civicrm.org/dev/wordpress/issues/11) Code
  style ([146](https://github.com/civicrm/civicrm-wordpress/pull/146))**

  This change adds an editor config file, that makes it so Editors that respect
  `.editorconfig` settings will default to double-space-indented code as is the
  Wordpress code style norm.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#434](https://lab.civicrm.org/dev/core/issues/434) Scheduled
  Reminder Error On Using Absolute Date With Repeat
  ([12923](https://github.com/civicrm/civicrm-core/pull/12923))**

  This change fixes a SQL error when editing a scheduled reminder with an
  'absolute_date' to 'Repeat'.

- **[dev/core#506](https://lab.civicrm.org/dev/core/issues/506) Advanced Search:
  There is an error when the user tries to display results as Cases
  ([13480](https://github.com/civicrm/civicrm-core/pull/13480))**

  This change ensures on the Advanced Search Form the "Display Results As" field
  only shows enabled components.

- **[dev/core#731](https://lab.civicrm.org/dev/core/issues/731) Smart Group DB
  Errors post-upgrade, specifically 1292 Truncated incorrect DOUBLE value
  (https://github.com/civicrm/civicrm-core/pull/13731)**

  A new feature was introduced recently that allows multiple email addresses on
  a contact to receive bulk mailings.  This changed the "On Hold" field to be
  options besides `1` and `0`, and the search was updated to allow searching
  multiple values.  Old smart groups had not been updated, though: this adds an
  upgrade step to fix them.

- **[dev/core#745](https://lab.civicrm.org/dev/core/issues/745) Smart groups
  broken when "Enable multiple bulk email address for a contact" setting is off
  ([13754](https://github.com/civicrm/civicrm-core/pull/13754))**

- **[dev/core#609](https://lab.civicrm.org/dev/core/issues/609) Can't view
  "Advanced Search" links on Mailing Report without "View All Contacts"
  permission ([13390](https://github.com/civicrm/civicrm-core/pull/13390))**

  This change makes it so that users without the permission "View All Contacts"
  can view the "Advanced Search" links on mailing reports.

- **[dev/core#636](https://lab.civicrm.org/dev/core/issues/636) Custom field for
  Address: The "No" value is not defaulted
  ([13397](https://github.com/civicrm/civicrm-core/pull/13397))**

  This change ensures that if a contact has selected "No" for an Address custom
  field (of type boolean yes/no), when editing that field it defaults to "No".
  Before this change, if a user had an Address custom field with the value set
  to 0 or False (like "No" does when using a Yes/No boolean) then when editing
  that field it would appear unfilled.

- **[dev/core#649](https://lab.civicrm.org/dev/core/issues/649) DB error on Find
  Activities with follow up criteria
  ([13420](https://github.com/civicrm/civicrm-core/pull/13420))**

  This change fixes a DB error when using the Find Activities search with the
  "Has a Followup Activity" search field sent to "Yes".

- **[dev/core#650](https://lab.civicrm.org/dev/core/issues/650) Use popups for
  links ([13421](https://github.com/civicrm/civicrm-core/pull/13421))**

  This change makes it so that when viewing a membership, when one clicks the
  "View Recurring Contribution" Link it opens as a popup instead of as a new
  page. This change also makes it so that when viewing a Recurring Contribution
  with a membership, when one clicks on the "Membership" it opens in a popup
  instead of a new page.

- **[dev/core#652](https://lab.civicrm.org/dev/core/issues/652) Copying activity
  file custom data doesn't copy mime type
  ([13427](https://github.com/civicrm/civicrm-core/pull/13427))**

- **[dev/core#658](https://lab.civicrm.org/dev/core/issues/658) Consider
  specifying the $frontend argument as true in getNotifyUrl()
  ([13482](https://github.com/civicrm/civicrm-core/pull/13482))**

  This change specifies that Test-drive contribution pages are front end which
  ensures that they display on the front end in Wordpress and that the IPN
  notification URLs point to the front end.

- **[dev/core#676](https://lab.civicrm.org/dev/core/issues/676)
  CRM_Utils_GeocodeTest throwing test-negatives everywhere
  ([13495](https://github.com/civicrm/civicrm-core/pull/13495))**

- **[dev/core#677](https://lab.civicrm.org/dev/core/issues/677) Current Employer
  'refine search' dropdown includes criteria irrelevant to organisations
  ([13493](https://github.com/civicrm/civicrm-core/pull/13493))**

- **[dev/core#698](https://lab.civicrm.org/dev/core/issues/698)
  Organisation/Individual: image isn't displayed
  ([13544](https://github.com/civicrm/civicrm-core/pull/13544))**

  This change fixes a bug where Contact images with the .jpg file extension were
  not being displayed in Internet Explorer 11.

- **[dev/core#715](https://lab.civicrm.org/dev/core/issues/715) Cannot delete
  relationship type through UI
  ([13581](https://github.com/civicrm/civicrm-core/pull/13581))**

  This change fixes a fatal error that was being thrown when deleting a
  relationship type.

- **[dev/core#639](https://lab.civicrm.org/dev/core/issues/639) Note: No
  restriction of the Subject field length
  ([13403](https://github.com/civicrm/civicrm-core/pull/13403))**

  This change restricts the subject field input to 255 chars, before this change
  there was no restriction on the input field (so no validation) but the
  database field is limited to 255 chars so entering more than 255 chars would
  result in an error.

- **Used field name defined in DAO file for Activity Subject
  ([13530](https://github.com/civicrm/civicrm-core/pull/13530))**

  This change limits the activity subject field input size (before this change
  it was unlimited).

- **Add html type for civicrm_note.privacy field
  ([13532](https://github.com/civicrm/civicrm-core/pull/13532))**

- **l10n.js - Reload when logging in as new user
  ([13518](https://github.com/civicrm/civicrm-core/pull/13518))**

  This change prevents a bug where clientside settings could be served from a
  stale browser cache when switching users.

- **Fix permission checks on contact create popups
  ([13506](https://github.com/civicrm/civicrm-core/pull/13506))**

  This change ensures that users can only see the buttons to create a new
  contact on a profile form if they have permissions to create a new contact.

- **Fix undefined throwing error in CRM.checkPerm
  ([13513](https://github.com/civicrm/civicrm-core/pull/13513))**

- **Fix broken date fields in survey response form
  ([13490](https://github.com/civicrm/civicrm-core/pull/13490))**

  This change fixes a couple broken date fields (that were displaying as blank)
  on the Record Survey Responses screen.

- **setLocale: precaution for when setLocale is called on an unilingual site
  ([13465](https://github.com/civicrm/civicrm-core/pull/13465))**

  This change ensures that calling `setLocale()` on a non-multilingual DB does
  not result in SQL queries failing.

- **Fix undefined index warning
  ([13433](https://github.com/civicrm/civicrm-core/pull/13433))**

  Fixes an undefined index warning and the recent items list, when viewing an
  activity with no subject.

- **Fix activity.getcount function to filter out unpermitted activities.
  ([13377](https://github.com/civicrm/civicrm-core/pull/13377))**

  This change ensures that the activity.getcount function only returns
  activities the user is permitted to access.

- **Do not show delete task option on create new report
  ([13402](https://github.com/civicrm/civicrm-core/pull/13402))**

- **Fix bug where getsingle calls chained actions twice
  ([13406](https://github.com/civicrm/civicrm-core/pull/13406))**

- **Fix  \Civi\Token\TokenRow::customToken() failure if field is not set
  ([13280](https://github.com/civicrm/civicrm-core/pull/13280))**

  This change ensures that calling \Civi\Token\TokenRow::customToken() with a
  custom field that is not set works.

- **Prevent \Civi\Token\TokenCompatSubscriber::evaluate() erroring when no
  contactId is given.
  ([13284](https://github.com/civicrm/civicrm-core/pull/13284))**

- **Format token custom fields with value of 0 correctly
  ([13282](https://github.com/civicrm/civicrm-core/pull/13282))**

- **PHP 7.1 incompatibility error fix for -> Error: Using $this when not in
  object context in civicrm_form_data()
  ([541](https://github.com/civicrm/civicrm-drupal/pull/541))**

- **[dev/core#757](https://lab.civicrm.org/dev/core/issues/757) Viewing Contact
  Note comments is broken in 5.10.4
  ([13709](https://github.com/civicrm/civicrm-core/pull/13709))**

- **Don't break loop if address fields not found while formatting rows in
  Reports ([13725](https://github.com/civicrm/civicrm-core/pull/13725))**

  This resolves a bug with state/province, country, and county IDs not being
  translated into names on CSV export from reports.

- **[dev/core#768](https://lab.civicrm.org/dev/core/issues/768) Fatal error on
  group search ([13738](https://github.com/civicrm/civicrm-core/pull/13738) and
  [13743](https://github.com/civicrm/civicrm-core/pull/13743))**

  The query for groups and tags did not properly handle the case when no group
  IDs are specified.  This caused a fatal error when using Search Builder to
  find contacts where groups or tags `IS NULL`.

### CiviCase

- **Case type management fixes
  ([12647](https://github.com/civicrm/civicrm-core/pull/12647))**

  This change ensures that only active relationships are displayed when
  selecting case roles for a case type. Additionally this change ensures that
  users can edit case types activity types even if the case type uses an
  activity type that has been deleted. Before this change trying to edit a case
  type that used an activity type that had been deleted resulted in a fatal
  error.

- **[dev/core#500](https://lab.civicrm.org/dev/core/issues/500) CiviCase:
  dashboard summary count includes cases from inactive relationships
  ([13134](https://github.com/civicrm/civicrm-core/pull/13134))**

  This change ensures that only active relationships are counted in the summary
  count on the case dashboard.

- **[dev/core#670](https://lab.civicrm.org/dev/core/issues/670) Cases: Edit
  Activity does not save tags
  ([13486](https://github.com/civicrm/civicrm-core/pull/13486))**

- **[dev/core#681](https://lab.civicrm.org/dev/core/issues/681) - Fatal Error on
  submitting "Change Case Status" activity form.
  ([13497](https://github.com/civicrm/civicrm-core/pull/13497))**

- **[dev/core#693](https://lab.civicrm.org/dev/core/issues/693) On contact
  summary page, on submitting a 'New Case' form doesn't redirect to 'Manage
  Case' screen ([13527](https://github.com/civicrm/civicrm-core/pull/13527))**

- **Display error instead of fatal error when trying to view a case that you
  don't have permission to access
  ([13505](https://github.com/civicrm/civicrm-core/pull/13505))**

### CiviContribute

- **[dev/financial#39](https://lab.civicrm.org/dev/financial/issues/39)
  Authorize.net doesn't support MD5 hashing at the end of the month
  ([13474](https://github.com/civicrm/civicrm-core/pull/13474))**

  Authorize.net is phasing out MD5 based transHash element in favor of the
  SHA-512 based transHashSHA2. This change removes the MD5 check in the
  Authorize.net payment processor to prevent it from breaking when MD5 based
  transHash is phased out.

- **[dev/financial#46](https://lab.civicrm.org/dev/financial/issues/46)
  (Regression) Contribution page amounts change on save when > $1,000
  ([13721](https://github.com/civicrm/civicrm-core/pull/13721) and
  [13723](https://github.com/civicrm/civicrm-core/pull/13723))**

  This formats money at the form layer on the contribution page in order to
  avoid problems with the comma (in locales using it as a thousands delimiter)
  is treated as a decimal delimiter.

- **Do not check financial permissions on contribution.create if
  check_perrmissions is FALSE.
  ([13318](https://github.com/civicrm/civicrm-core/pull/13318))**

- **Simplify billingblock in Contribution/Form/Main template
  ([13437](https://github.com/civicrm/civicrm-core/pull/13437))**

  This change ensures the billing block is only loaded once. Before this change
  it was being loaded twice once by CRM/Financial/Form/Payment.tpl and once by
  CRM/Core/BillingBlock.tpl.

- **Convert Paypal Standard IPN payment_date to system's time zone
  ([13439](https://github.com/civicrm/civicrm-core/pull/13439))**

  This change ensures the Paypal Standard IPN payment_date uses the system's time
  zone. Before this change the `payment_date` was set to the local time for Paypal
  (a Pacific time zone of `PST` or `PDT` is part of the timestamp). This led to
  the wrong time being written to the database.

- **Remove inappropriate exception handling.
  ([13442](https://github.com/civicrm/civicrm-core/pull/13442))**

  This change removes an exception when a payment is recorded through the api
  for a contribution that has a status other than "Partially paid" or "Pending
  (pay later)".

- **[dev/core#586](https://lab.civicrm.org/dev/core/issues/586) PCP Report does
  not show accurate total amount and total donors
  ([13252](https://github.com/civicrm/civicrm-core/pull/13252))**

  This change ensures that the "Personal Campaign Page Report" provides accurate
  numbers for the "Committed Amount" and the "Number of Donors" in the report
  rows.

- **[dev/core#756](https://lab.civicrm.org/dev/core/issues/756) Error on
  Contributions tab with soft credits in multiple currencies
  ([13711](https://github.com/civicrm/civicrm-core/pull/13711))**

### CiviEvent

- **[dev/core#646](https://lab.civicrm.org/dev/core/issues/646) Event date
  sorting doesn't work for ical listing
  ([13409](https://github.com/civicrm/civicrm-core/pull/13409))**

  This change ensures that on the ical listing of events, when sorting by event
  dates, the dates get sorted by ASC/DSC for start date instead of alphabetical
  order.

- **[dev/core#766](https://lab.civicrm.org/dev/core/issues/766) New Event using
  a template - clicking "Continue" doesn't save custom data
  ([13755](https://github.com/civicrm/civicrm-core/pull/13755))**

- **Don't require CiviEvent permission to create repeating activity
  ([13405](https://github.com/civicrm/civicrm-core/pull/13405))**

### CiviMail

- **[dev/mail#32](https://lab.civicrm.org/dev/mail/issues/32) Deduping test
  email is case sensitive
  ([13401](https://github.com/civicrm/civicrm-core/pull/13401) and
  [13392](https://github.com/civicrm/civicrm-core/pull/13392))**

  When composing a mailing, the email address used in the "send test email to"
  field at the bottom is deduped, this change ensures that the deduping is not
  case sensitive so that emails that are the same but have different upper/lower
  case combinations match appropriately.

- **[dev/mail#36](https://lab.civicrm.org/dev/mail/issues/36) Bounce processing
  fails for invalid unicode characters
  ([13396](https://github.com/civicrm/civicrm-core/pull/13396))**

  This change ensures that bounce messages containing invalid unicode characters
  are processed. Before this change an exception was thrown and a bounce was not
  stored in the datebase, but mail was moved to the processed folder. After this
  change: invalid characters are replaced with unicode replacement characters,
  No exception is thrown and the bounce is saved.

- **[dev/mail#37](https://lab.civicrm.org/dev/mail/issues/37) Bounce processing
  fails for 4-byte unicode characters
  ([13419](https://github.com/civicrm/civicrm-core/pull/13419))**

  This change ensures that bounce messages containing 4-byte unicode characters
  are processed appropriately. Before this change when a bounce message
  contained a 4-byte unicode character: an exception was thrown, the bounce was
  not stored in the database, the mail was moved to the processed folder. After
  this change: 4-bytes unicode characters are replaced with unicode replacement
  characters, no exception is thrown and the bounce is saved.

### CiviMember

- **[dev/core#644](https://lab.civicrm.org/dev/core/issues/644) "From" address
  on membership renewal notices is wrong
  ([13408](https://github.com/civicrm/civicrm-core/pull/13408),
  [13407](https://github.com/civicrm/civicrm-core/pull/13407), and
  [13737](https://github.com/civicrm/civicrm-core/pull/13737))**

  This change ensures Membership renewal notifications and receipts are sent
  "From" the logged-in users name and email. Before this change the "From" was
  set as the logged in users contact id.

- **Membership custom fields sometimes don't display
  ([13411](https://github.com/civicrm/civicrm-core/pull/13411))**

  There change fixes a bug where some Membership custom field sets would
  sometimes not display.

- **[dev/membership#10](https://lab.civicrm.org/dev/membership/issues/10) "Start
  date must be the same or later than Member since" triggered when dates are the
  same ([13734](https://github.com/civicrm/civicrm-core/pull/13734))**

### Drupal Integration

- **[dev/drupal#43](https://lab.civicrm.org/dev/drupal/issues/43) Drupal8:
  composer requires psr/log ~1.0.0, incompatible with psr/log 1.1.0
  ([13424](https://github.com/civicrm/civicrm-core/pull/13424))**

  This change updates the civicrm-cxn-rpc and psr/log requirements so that they
  are a compatible with Drupal8.

- **[dev/core#381](https://lab.civicrm.org/dev/core/issues/381)
  civicrm/file/imagefile serving up wrong images
  ([542](https://github.com/civicrm/civicrm-drupal/pull/542))**

  This change fixes a bug where files saved in CiviCRM with ids and event ids
  were not loading properly in drupal views.

- **Email sent from CiviCRM for a new Case and Activity does not evaluate the
  $activityTypeName or $manageCaseURL tokens
  ([13324](https://github.com/civicrm/civicrm-core/pull/13324))**

### Wordpress Integration

- **Fix shortcode button when popup setting is disabled
  ([13502](https://github.com/civicrm/civicrm-core/pull/13502) and
  [145](https://github.com/civicrm/civicrm-wordpress/pull/145))**

  This change makes it so that the WP shortcode button works regardless of
  whether ajax popups are disabled in CiviCRM settings.

- **[dev/core#666](https://lab.civicrm.org/dev/core/issues/666) Prevent trailing
  ampersand in some URLs in WordPress
  ([13461](https://github.com/civicrm/civicrm-core/pull/13461))**

## <a name="misc"></a>Miscellany

- **[dev/core#647](https://lab.civicrm.org/dev/core/issues/647) Not all unit
  tests classes are used by jenkins
  ([13415](https://github.com/civicrm/civicrm-core/pull/13415) and
  [13416](https://github.com/civicrm/civicrm-core/pull/13416))**

- **Deprecate unused function
  ([13452](https://github.com/civicrm/civicrm-core/pull/13452))**

- **Removed '>' from comment
  ([13492](https://github.com/civicrm/civicrm-core/pull/13492))**

- **Fix regression whereby making receive_date required breaks back offic…
  ([13572](https://github.com/civicrm/civicrm-core/pull/13572))**

- **Update 5.10.0.md
  ([13552](https://github.com/civicrm/civicrm-core/pull/13552))**

- **(NFC) Add 'schema' to \Civi\Token\TokenProcessor()
  ([13286](https://github.com/civicrm/civicrm-core/pull/13286))**

- **(NFC) Add listTokens() function to return formatted list of tokens for forms
  ([13279](https://github.com/civicrm/civicrm-core/pull/13279))**

- **(NFC) Ensure that when loading in the test data it is done with UTF8 …
  ([13413](https://github.com/civicrm/civicrm-core/pull/13413))**

- **(NFC) Add unit test of creating notes from the contact.create API
  ([13471](https://github.com/civicrm/civicrm-core/pull/13471))**

- **[tidy-up] remove a couple of useless bits of code
  ([13447](https://github.com/civicrm/civicrm-core/pull/13447))**

- **Add unit test for emailing receipts from additional payment page
  ([13455](https://github.com/civicrm/civicrm-core/pull/13455))**

- **remove duplicated call to createCreditNoteId()
  ([13509](https://github.com/civicrm/civicrm-core/pull/13509))**

- **[REF] Replace ->assign with CRM_Core_Smarty::singleton()->assign in
  preparation for making function shareable
  ([13444](https://github.com/civicrm/civicrm-core/pull/13444))**

- **[REF] Create pseudo bao CRM_Financial_BAO_Payment & move create function to
  it ([13443](https://github.com/civicrm/civicrm-core/pull/13443))**

- **REF Convert forms to standard customData template
  ([13412](https://github.com/civicrm/civicrm-core/pull/13412))**

- **REF Remove redundant function
  ([13428](https://github.com/civicrm/civicrm-core/pull/13428))**

- **(REF) Make activeTokens a class property of
  \Civi\Token\AbstractTokenSubscriber
  ([13278](https://github.com/civicrm/civicrm-core/pull/13278))**

- **REF Remove duplicate call to session singleton
  ([13458](https://github.com/civicrm/civicrm-core/pull/13458))**

- **REF Remove undefined variable when creating note
  ([13457](https://github.com/civicrm/civicrm-core/pull/13457))**

- **(REF) Add CRM_Utils_Cache::nack(). Use it for NaiveHasTrait.
  ([13500](https://github.com/civicrm/civicrm-core/pull/13500))**

- **[dev/core#562](https://lab.civicrm.org/dev/core/issues/562) Remove instances
  of $dao->free ([13393](https://github.com/civicrm/civicrm-core/pull/13393))**

- **Re-run gencode for fix on PriceField DAO
  ([13547](https://github.com/civicrm/civicrm-core/pull/13547))**

- **Performance fix for alternate getActivity listing function
  ([13522](https://github.com/civicrm/civicrm-core/pull/13522))**

- **Convert deprecated OptionGroup::getLabel to PseudoConstant::getLabel for
  cases ([13460](https://github.com/civicrm/civicrm-core/pull/13460))**

- **removed unwanted parameter from getLineItems()
  ([13479](https://github.com/civicrm/civicrm-core/pull/13479))**

- **Escape the header title & section title in reports to better support
  extensions ([13453](https://github.com/civicrm/civicrm-core/pull/13453))**

- **Upgrade Jquery contained within KcFinder
  ([239](https://github.com/civicrm/civicrm-packages/pull/239))**

- **Remove tests that no longer work due to dead service
  ([13673](https://github.com/civicrm/civicrm-core/pull/13673))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Agileware Team, Alok
Patel, Francis Whittle, Justin Freeman; Australian Greens - Seamus Lee; CEDC -
Laryn Kragt Bakker; Christian Wach; Circle Interactive - Dave Jenkins; CiviCRM -
Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp - Debarshi
Bhaumik, René Olivo, Vinu Varshith Sekar; Coop SymbioTIC - Mathieu Lutfy;
Electronic Frontier Foundation - Mark Burdett; Francesc Bassas i Bullich; Frank
J. Gómez; Fuzion - Jitendra Purohit; Greenpeace Central and Eastern Europe -
Patrick Figel; iXiam - Luciano Spiegel; JMA Consulting - Monish Deb; Joinery -
Allen Shaw; Ken West; Liquid Web, Inc. - Jason Gillman Jr.; Megaphone Technology
Consulting - Jon Goldberg; MillerTech - Chamil Wijesooriya; MJW Consulting -
Matthew Wire; Oxfam Germany - Thomas Schüttler; PeaceWorks Technology Solutions -
Martin Hansen; Pradeep Nayak; Progressive Technology Project - Jamie
McClelland; Squiffle Consulting - Aidan Saunders; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

British Humanist Association - Andrew West; CiviDesk - Nicolas Ganivet; Clare
Marsh; CompuCorp - Shitij Gugnani; Fuzion - Peter Davis; JMA Consulting - Joe
Murray; Lighthouse Design and Consulting - Brian Shaughnessy; Richard van
Oosterhout; QED42 - Swastik Pareek; Tadpole Collective - Kevin Cristiano

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
