# CiviCRM 5.67.0

Released November 1, 2023

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **SearchKit - Improve metadata, joins and links
  ([27407](https://github.com/civicrm/civicrm-core/pull/27407))**

  Miscellaneous fixes and improvements to SearchKit and FormBuilder, toward the
  goal of search displays that can replace existing core pages.

- **Afform - Make Afform Core extension required
  ([27293](https://github.com/civicrm/civicrm-core/pull/27293))**

  Makes Afform and Authx required so that the process of replacing core pages
  and forms with Afform/SearchKit can begin.

- **ContactSummary - Replace Relationships tab with SearchKit display
  ([27701](https://github.com/civicrm/civicrm-core/pull/27701))**

  Replaces the Contact Summary -> Relationship tab with a SearchKit display.

- **ContactSummary - Replace Notes tab with SearchKit display  
  ([27610](https://github.com/civicrm/civicrm-core/pull/27610))**

  Replaces the Contact Summary -> Notes tab with a SearchKit display.

- **Convert CiviCampaign Dashboard to SearchKit
  ([27271](https://github.com/civicrm/civicrm-core/pull/27271))**

  Converts the CiviCampaign Dashboard to a SearchKit display.

- **Translation support for Afforms & Managed Search Displays
  ([dev/core#2396](https://lab.civicrm.org/dev/core/-/issues/2396):
  [27553](https://github.com/civicrm/civicrm-core/pull/27553))**

  Multilingual support for Afforms.

- **API - Improve ACL processing, deprecate `hook_civicrm_notePrivacy`
  ([27472](https://github.com/civicrm/civicrm-core/pull/27472))**

  Expands the capabilities of ACLs checking for API get actions while improving
  efficiency.

- **APIv4 - Add Individual, Household, Organization pseudo-entities
  ([27659](https://github.com/civicrm/civicrm-core/pull/27659))**

  Extends APIv4 with 3 pseudo-entities for the 3 base contact types.

- **Api4 - Enable file attachments to be displayed in SearchKit
  ([27379](https://github.com/civicrm/civicrm-core/pull/27379))**

  Makes it so file attachments can be displayed in SearchKit.

- **APIv4 - Add dfk metadata to getfields
  ([27520](https://github.com/civicrm/civicrm-core/pull/27520))**

  Improves APIv4 metadata about Dynamic foreign keys (DFKs), aka `entity_table`
  and `entity_id` combos.

- **Add Entity batch to Search kit
  ([27414](https://github.com/civicrm/civicrm-core/pull/27414))**

  Makes Entity batch available in SearchKit.

- **SearchKit - Expose Address.proximity filter as Afform search filter
  ([27631](https://github.com/civicrm/civicrm-core/pull/27631))**

  Exposes Address Proximity as an Afform Search Filter.

- **Afform - Scan core ang/afform directory
  ([27647](https://github.com/civicrm/civicrm-core/pull/27647))**

  Makes it so CiviCRM Core can define Afforms.

- **Afform - Switch to user-oriented breadcrumbs, move admin link to hover
  button ([27618](https://github.com/civicrm/civicrm-core/pull/27618))**

  Adds an edit form link to view of forms built with afform and improves afform
  breadcrumb usability.

- **allows showing detailed error messages from AJAX
  ([27637](https://github.com/civicrm/civicrm-core/pull/27637))**

  Makes it so users without "View Debug Output" can see a detailed ajax error
  message in Afform.

- **SearchKit - Improve performance of downloading spreadsheet
  ([27417](https://github.com/civicrm/civicrm-core/pull/27417))**

  Improves performance of downloading SearchKit spreadsheets.

- **SearchKit - Add crm-search-col-type-* css classes
  ([27461](https://github.com/civicrm/civicrm-core/pull/27461))**

  Add css classes for styling search display columns based on the type.

- **Remove "Save and New" buttons from most places
  ([dev/user-interface#53](https://lab.civicrm.org/dev/user-interface/-/issues/53):
  [27029](https://github.com/civicrm/civicrm-core/pull/27029))**

  Reduces presence of Save and Done/New on forms.

- **[PHP 8.1] Registered Templates: Undefined array key "weight"
  ([dev/core#4716](https://lab.civicrm.org/dev/core/-/issues/4716):
  [27939](https://github.com/civicrm/civicrm-core/pull/27939) and
  [27949](https://github.com/civicrm/civicrm-core/pull/27949))**

  The action links (e.g. edit, preview, etc.) on price fields, duplicate
  matching rules, and report templates now have weights assigned in code,
  allowing them to be reordered using hooks and resolving a warning in PHP 8.1.

- **Upgrade Smarty to Smarty3+ (Work Towards
  [dev/core#4146](https://lab.civicrm.org/dev/core/-/issues/4146):
  [27620](https://github.com/civicrm/civicrm-core/pull/27620),
  [27594](https://github.com/civicrm/civicrm-core/pull/27594),
  [27676](https://github.com/civicrm/civicrm-core/pull/27676),
  [27621](https://github.com/civicrm/civicrm-core/pull/27621),
  [27582](https://github.com/civicrm/civicrm-core/pull/27582),
  [27588](https://github.com/civicrm/civicrm-core/pull/27588),
  [27604](https://github.com/civicrm/civicrm-core/pull/27604),
  [27693](https://github.com/civicrm/civicrm-core/pull/27693),
  [27525](https://github.com/civicrm/civicrm-core/pull/27525),
  [27585](https://github.com/civicrm/civicrm-core/pull/27585),
  [27587](https://github.com/civicrm/civicrm-core/pull/27587),
  [27687](https://github.com/civicrm/civicrm-core/pull/27687),
  [27581](https://github.com/civicrm/civicrm-core/pull/27581),
  [27583](https://github.com/civicrm/civicrm-core/pull/27583) and
  [27547](https://github.com/civicrm/civicrm-core/pull/27547))**

  Work towards upgrading to Smarty3+.

- **Tracking: Uses of {php} to remove from Smarty in order to allow upgrade to
  Smarty 3+ (Work towards
  [dev/core#4618](https://lab.civicrm.org/dev/core/-/issues/4618):
  [27584](https://github.com/civicrm/civicrm-core/pull/27584))**

  Updates APIv3 explorer to not encourage php-eval in smarty.

- **Add more search option for email
  ([27656](https://github.com/civicrm/civicrm-core/pull/27656))**

  Adds email fields to the filter on search.

- **Implement OAuthSessionToken
  ([27316](https://github.com/civicrm/civicrm-core/pull/27316))**

  Implements a new type of OAuth token storage: OAuthSessionToken.

- **Feature request - Queue api should respect maintenance mode
  ([dev/core#4490](https://lab.civicrm.org/dev/core/-/issues/4490):
  [27526](https://github.com/civicrm/civicrm-core/pull/27526))**

  Adds a setting and hook to pause/resume background-queues.

- **Finish making legacycustomsearches optional
  ([dev/core#4112](https://lab.civicrm.org/dev/core/-/issues/4112):
  [27400](https://github.com/civicrm/civicrm-core/pull/27400))**

  Stop installing legacycustomsearches on new installs.

- **GettingStarted: add token for System Status
  ([27382](https://github.com/civicrm/civicrm-core/pull/27382))**

  Adds a token for System Status and uses it in the "Getting Started" dashlet.

- **Queue::run() - Add API for running several tasks
  ([27691](https://github.com/civicrm/civicrm-core/pull/27691))**

  Adds a utility for running queued tasks using the newer (higher-level) queuing
  features.

- **Scan core `civicrm/managed` directory for entity declarations
  ([27389](https://github.com/civicrm/civicrm-core/pull/27389))**

  Allows managed entities to be shipped with CiviCRM core, independent of any
  extensions.

- **CRM_Core_Module - Generate optional `$label` property
  ([27392](https://github.com/civicrm/civicrm-core/pull/27392))**

  Adds some extra metadata to the module finder. It's a step toward showing a
  pretty list of options for Managed.module in APIv4 Explorer.

- **CustomGroup - Add metadata, cleanup "Custom FieldSet" form & improve UX
  ([27549](https://github.com/civicrm/civicrm-core/pull/27549))**

  Improves user experience of the Custom Field Set form and adds metadata.

- **Add simple smart group profiler
  ([dev/core#4350](https://lab.civicrm.org/dev/core/-/issues/4350):
  [27232](https://github.com/civicrm/civicrm-core/pull/27232) and
  [27462](https://github.com/civicrm/civicrm-core/pull/27462))**

  Adds a Smart Group profiler to help identify slow smart groups.

- **Standalone: Users' password changing form and API
  ([27681](https://github.com/civicrm/civicrm-core/pull/27681) and
  [27645](https://github.com/civicrm/civicrm-core/pull/27645))**

  Adds Password Reset functionality for Standalone installations.

- **Add Label field for Message Template
  ([27664](https://github.com/civicrm/civicrm-core/pull/27664))**

  Adds "Label" field to Message template so that it can be searched via Custom
  field entity reference field.

- **Add in-app docs re prefilling multiple ids in repeating blocks
  ([27706](https://github.com/civicrm/civicrm-core/pull/27706))**

  Explains comma-separated ID syntax.

### CiviMail

- **Address CiviCRM Mailing table complexity - make queries easier & data more
  prunable (Work towards
  [dev/core#4567](https://lab.civicrm.org/dev/core/-/issues/4567):
  [27640](https://github.com/civicrm/civicrm-core/pull/27640),
  [27644](https://github.com/civicrm/civicrm-core/pull/27644),
  [27513](https://github.com/civicrm/civicrm-core/pull/27513),
  [27557](https://github.com/civicrm/civicrm-core/pull/27557), and
  [27749](https://github.com/civicrm/civicrm-core/pull/27749))**

  Adds Mailing ID to simplify CiviCRM mailing tables.

- **Upgrade: rename the Draft/Sent Mailing menu labels
  ([27697](https://github.com/civicrm/civicrm-core/pull/27697))**

  Simplifies the mailing menu labels and makes them translatable.

### Joomla Integration

- **Migrate installers to "setup" API (Work Towards
  [dev/core#1615](https://lab.civicrm.org/dev/core/-/issues/1615):
  [70](https://github.com/civicrm/civicrm-joomla/pull/70))**

  Migrates the Joomla integration installer to use the Setup API for
  installation.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **CiviCRM Log File: Dates and Security (Work towards
  [dev/core#4270](https://lab.civicrm.org/dev/core/-/issues/4270):
  [27575](https://github.com/civicrm/civicrm-core/pull/27575))**

  Ensures CiviCRM log files use a standard date format.

- **Scheduled jobs stopped working after an update last week - error in
  MailingEventUnsubscribe.php
  ([dev/core#4421](https://lab.civicrm.org/dev/core/-/issues/4421):
  [27403](https://github.com/civicrm/civicrm-core/pull/27403))**

- **(5.66 upgrade error) Action Schedule field is too short
  ([dev/core#4696](https://lab.civicrm.org/dev/core/-/issues/4696):
  [27913](https://github.com/civicrm/civicrm-core/pull/27913))**

  The name field on civicrm_action_schedule is changed to be long enough to
  accommodate potential values. This repeats the upgrade step from 5.66.1, since
  5.66 will not be forward-merged to 5.67. It resolves a potential "data too
  long" error in upgrades to 5.66.0.

- **Scheduled Reminder select2 fields to save/view correctly
  ([dev/core#4732](https://lab.civicrm.org/dev/core/-/issues/4732):
  [27944](https://github.com/civicrm/civicrm-core/pull/27944))**

  This fixes the scheduled reminder form to retrieve values using APIv4 and
  handle serialized values properly.

- **Attempting to move a custom field of type Country bypasses extends check and
  fails ([dev/core#4568](https://lab.civicrm.org/dev/core/-/issues/4568):
  [27413](https://github.com/civicrm/civicrm-core/pull/27413))**

- **ACL's causing invalid SQL
  ([dev/core#4635](https://lab.civicrm.org/dev/core/-/issues/4635):
  [27679](https://github.com/civicrm/civicrm-core/pull/27679))**

- **Add some more weight fields
  ([27728](https://github.com/civicrm/civicrm-core/pull/27728))**

- **Weights for custom field groups page
  ([27416](https://github.com/civicrm/civicrm-core/pull/27416))**

- **Add weights to premium screen
  ([27788](https://github.com/civicrm/civicrm-core/pull/27788))**

- **Add some weights to pcp page
  ([27780](https://github.com/civicrm/civicrm-core/pull/27780))**

- **Saving a group definition lose the current parent groups
  ([dev/core#4703](https://lab.civicrm.org/dev/core/-/issues/4703):
  [27858](https://github.com/civicrm/civicrm-core/pull/27858))

- **On Import in Non English Mode do not import field in saved field mapping is
  not correctly set as default when re-using import
  ([dev/core#4726](https://lab.civicrm.org/dev/core/-/issues/4726):
  [27926](https://github.com/civicrm/civicrm-core/pull/27926))**

  This resolves a bug if a saved field mapping was used for import.  The fields
  mapped as "do not import" would not have that set if the site's using a
  non-English language.

- **getTree: initialize variable before it's used (PHP8 compat)
  ([27718](https://github.com/civicrm/civicrm-core/pull/27718))**

- **Fix sort_name & display_name settings to support new-style tokens
  ([27695](https://github.com/civicrm/civicrm-core/pull/27695))**

- **hook_civicrm_links - Add docblocks and event-checker
  ([27484](https://github.com/civicrm/civicrm-core/pull/27484))**

- **Schema - stop oversharing version numbers
  ([27682](https://github.com/civicrm/civicrm-core/pull/27682))**

- **Do assign unconditionally
  ([27696](https://github.com/civicrm/civicrm-core/pull/27696))**

- **Pass cid=false in include to avoid notice
  ([27677](https://github.com/civicrm/civicrm-core/pull/27677))**

- **Align financial information in participant offline receipt with online
  receipt ([27624](https://github.com/civicrm/civicrm-core/pull/27624))**

- **Add icons to relationship permission metadata
  ([27670](https://github.com/civicrm/civicrm-core/pull/27670))**

- **Stop using undefined properties to specify custom data extends values
  ([27560](https://github.com/civicrm/civicrm-core/pull/27560))**

- **Allow `civicrm_campaign` as `entity_table` for `FinancialItem` API entity
  ([27570](https://github.com/civicrm/civicrm-core/pull/27570))**

- **Use token for tax_amount, quick config mode
  ([27016](https://github.com/civicrm/civicrm-core/pull/27016))**

- **civicrm_admin_ui: add Profile Copy action
  ([26529](https://github.com/civicrm/civicrm-core/pull/26529))**

  Ensures the "Copy" action is available for Profiles for those using the admin
  ui extension.

- **Stop saying N contacts removed when they were already removed.
  ([27534](https://github.com/civicrm/civicrm-core/pull/27534))**

- **APIv4 - Remove function that doesn't do anything, add some type hints
  ([27558](https://github.com/civicrm/civicrm-core/pull/27558))**

- **Replace email smarty var with token
  ([27595](https://github.com/civicrm/civicrm-core/pull/27595))**

- **Loosen action typing - doing nothing is doing something
  ([27567](https://github.com/civicrm/civicrm-core/pull/27567))**

- **Cast _action to an int
  ([27495](https://github.com/civicrm/civicrm-core/pull/27495))**

- **SearchKit - Save In-place edit when pressing enter
  ([27576](https://github.com/civicrm/civicrm-core/pull/27576))**

- **SearchKit - When hiding pager, also hide page count
  ([27616](https://github.com/civicrm/civicrm-core/pull/27616))**

- **SearchKit Toolbar - Fix conditionals, add tests
  ([27527](https://github.com/civicrm/civicrm-core/pull/27527))**

- **Consolidate Profile Preview with other profile code
  ([27482](https://github.com/civicrm/civicrm-core/pull/27482))**

- **Metadata - Add "civicrm_note" to "note_used_for" option group
  ([27396](https://github.com/civicrm/civicrm-core/pull/27396))**

  Fixes API bug due to incomplete metadata.

- **Always assign noCid when the tpl is included
  ([27541](https://github.com/civicrm/civicrm-core/pull/27541))**

- **Simplify CustomField::displayValue to expect an ID & have deprecated
  handling for anything else
  ([27535](https://github.com/civicrm/civicrm-core/pull/27535))**

- **India-provinces update outdated provinces abbreviations
  ([27415](https://github.com/civicrm/civicrm-core/pull/27415))**

- **Fix a couple more places to use tokens participant role
  ([27614](https://github.com/civicrm/civicrm-core/pull/27614))**

- **Fix double fieldset for honoree section
  ([27546](https://github.com/civicrm/civicrm-core/pull/27546))**

- **Fix Smarty help text block
  ([27673](https://github.com/civicrm/civicrm-core/pull/27673))**

- **Fix typos in field.tpl
  ([27627](https://github.com/civicrm/civicrm-core/pull/27627))**

- **Fix those pesky field notices ...again
  ([27590](https://github.com/civicrm/civicrm-core/pull/27590))**

- **[php8] Swap out some tpl variables for tokens in offline receipt template
  ([27598](https://github.com/civicrm/civicrm-core/pull/27598))**

- **Stop accessng _tpl_vars in smarty from property
  ([27589](https://github.com/civicrm/civicrm-core/pull/27589))**

- **Fix undefined property on fromEmails for Participant fee
  ([27578](https://github.com/civicrm/civicrm-core/pull/27578))**

- **AdminUI: Fix filtering logs by scheduled job
  ([27628](https://github.com/civicrm/civicrm-core/pull/27628))**

- **Require all fields in signature, as always passed
  ([27601](https://github.com/civicrm/civicrm-core/pull/27601))**

- **Simplify formatting in text versions of workflow messages
  ([27602](https://github.com/civicrm/civicrm-core/pull/27602))**

- **Pass `NULL` instead of a value where function requires a parameter but
  does not use it
  ([27532](https://github.com/civicrm/civicrm-core/pull/27532))**

- **Fix assigning of customGroup data to be more re-usable & use undefined
  properties less
  ([27552](https://github.com/civicrm/civicrm-core/pull/27552))**

- **Smarty notices & errors, message template screen
  ([27689](https://github.com/civicrm/civicrm-core/pull/27689))**

- **Fix unnecessary pass-by-ref, minor code improvements
  ([27429](https://github.com/civicrm/civicrm-core/pull/27429))**

- **Fix Smarty secure mode for premiums tab
  ([27471](https://github.com/civicrm/civicrm-core/pull/27471))**

- **[PHP 8.0+?] Empty requires tag in info.xml crashes extension list
  ([dev/core#4707](https://lab.civicrm.org/dev/core/-/issues/4707):
  [27856](https://github.com/civicrm/civicrm-core/pull/27856))**

  Don't error if extension has empty `requires` tag.

- **PHP 8.x always assign taxTerm, ppID - backoffice contribution form
  ([27470](https://github.com/civicrm/civicrm-core/pull/27470))**

- **php8.x Fix notice from adding esm_loader to wrong settings form
  ([27530](https://github.com/civicrm/civicrm-core/pull/27530))**

- **php 8.x Ensure profiles are assigned to template, even when empty
  ([27488](https://github.com/civicrm/civicrm-core/pull/27488))**

- **Php 8.x clean up notices on Profiles
  ([27483](https://github.com/civicrm/civicrm-core/pull/27483))**

- **Fix mistake from last week on string wrangling
  ([27537](https://github.com/civicrm/civicrm-core/pull/27537))**

- **Fix legacy custom searches to not use hacky method to access protected
  property on core class
  ([27502](https://github.com/civicrm/civicrm-core/pull/27502))**

- **Hardened smarty - fix mishandling of json
  ([27468](https://github.com/civicrm/civicrm-core/pull/27468))**

- **Suppress rather than declare exception
  ([27424](https://github.com/civicrm/civicrm-core/pull/27424))**

- **Php8.x Fix notices when creating custom field
  ([27516](https://github.com/civicrm/civicrm-core/pull/27516))**

- **8.x Profiles Remove e-notices by removing never assigned help_pre, help_post
  ([27433](https://github.com/civicrm/civicrm-core/pull/27433))**

- **8.x Fix all instances of call Profile template to specify the prefix
  ([27435](https://github.com/civicrm/civicrm-core/pull/27435))**

- **8.x Fix a couple of notices when rendering profiles
  ([27434](https://github.com/civicrm/civicrm-core/pull/27434))**

- **php 8.x Use internal property rather than undefined _type
  ([27241](https://github.com/civicrm/civicrm-core/pull/27241))**

- **VersionCheck: replace hash by sid, add the environment
  ([27385](https://github.com/civicrm/civicrm-core/pull/27385))**

- **hook_civicrm_config: Add extra information to distinguish invocations
  ([27149](https://github.com/civicrm/civicrm-core/pull/27149))**

- **Use internal variable rather than undeclared property
  ([27240](https://github.com/civicrm/civicrm-core/pull/27240))**

- **Standardise fee_label in event workflow messages
  ([27325](https://github.com/civicrm/civicrm-core/pull/27325))**

- **Smarty notices - Fix a couple more templates to look for elements not a
  variable that says the element is present
  ([27402](https://github.com/civicrm/civicrm-core/pull/27402))**

- **Cleanup presentation of total to improve code & reduce notices
  ([27234](https://github.com/civicrm/civicrm-core/pull/27234))**

- **SearchKit: Align column headers according to settings
  ([27642](https://github.com/civicrm/civicrm-core/pull/27642))**

- **SearchKit - Fix and add test for scenario where the same display is used
  twice on a form
  ([27698](https://github.com/civicrm/civicrm-core/pull/27698))**

- **APIv4 - Fix autocomplete for Individual,Household,Organization entities
  ([27713](https://github.com/civicrm/civicrm-core/pull/27713))**

- **APIv4 - ensure action names get camelCase properly
  ([27704](https://github.com/civicrm/civicrm-core/pull/27704))**

- **APIv4 - Trim output of Export action to only non-default values
  ([27700](https://github.com/civicrm/civicrm-core/pull/27700))**

- **APIv4 Explorer - Fix yml input values
  ([27357](https://github.com/civicrm/civicrm-core/pull/27357))**

- **rtrim when converting text tokens to html to avoid trailing newlines
  ([27353](https://github.com/civicrm/civicrm-core/pull/27353))**

- **Fix missing quotes in tpl file
  ([27742](https://github.com/civicrm/civicrm-core/pull/27742))**

- **Afform - Fix display of boolean checkboxes
  ([27592](https://github.com/civicrm/civicrm-core/pull/27592))**

- **Afform - fix undefined function error
  ([27736](https://github.com/civicrm/civicrm-core/pull/27736))**

- **php notices for "description"
  ([27634](https://github.com/civicrm/civicrm-core/pull/27634))**

- **Notice fix ([27730](https://github.com/civicrm/civicrm-core/pull/27730))**

- **Enotice fix ([27725](https://github.com/civicrm/civicrm-core/pull/27725))**

- **Fix e_warning in smarty `{localize}`
  ([27447](https://github.com/civicrm/civicrm-core/pull/27447))**

- **Smarty notice fix
  ([27707](https://github.com/civicrm/civicrm-core/pull/27707))**

- **Fix some variables to always assign
  ([27438](https://github.com/civicrm/civicrm-core/pull/27438))**

- **Remove broken recaptcha from profile preview
  ([27439](https://github.com/civicrm/civicrm-core/pull/27439))**

- **Fix php notices in php dashboard code
  ([27426](https://github.com/civicrm/civicrm-core/pull/27426))**

- **Fix notice on phone_ext
  ([27423](https://github.com/civicrm/civicrm-core/pull/27423))**

- **Afform - Fix getting and setting boolean/numeric types
  ([27294](https://github.com/civicrm/civicrm-core/pull/27294))**

- **Fix MoveField PHP notice
  ([27406](https://github.com/civicrm/civicrm-core/pull/27406))**

- **Do not run financial acls if the setting it not set
  ([27771](https://github.com/civicrm/civicrm-core/pull/27771))**

### CiviCampaign

- **Fix notice on 'new petition' page
  ([27568](https://github.com/civicrm/civicrm-core/pull/27568))**

### CiviCase

- **CaseType managed entity in mgd.php file gets caught in an infinite loop
  ([dev/core#3722](https://lab.civicrm.org/dev/core/-/issues/3722):
  [27430](https://github.com/civicrm/civicrm-core/pull/27430))**

- **CiviCase - Fix SelectWhereClause for Activity queries
  ([27722](https://github.com/civicrm/civicrm-core/pull/27722))**

### CiviContribute

- **Fix fatal error on pledge delete
  ([27878](https://github.com/civicrm/civicrm-core/pull/27878))**

- **fix ordering of contribution page links
  ([27448](https://github.com/civicrm/civicrm-core/pull/27448))**

- **js error on contribution pages - also prevents honoree section toggling
  from working ([dev/core#4616](https://lab.civicrm.org/dev/core/-/issues/4616):
  [27554](https://github.com/civicrm/civicrm-core/pull/27554))**

- **"Check number" field isn't shown on Pending check payments
  ([dev/core#4556](https://lab.civicrm.org/dev/core/-/issues/4556):
  [27332](https://github.com/civicrm/civicrm-core/pull/27332))**

- **Eliminate `contributeMode`
  (Work towards [dev/core#4619](https://lab.civicrm.org/dev/core/-/issues/4619):
  [27562](https://github.com/civicrm/civicrm-core/pull/27562))**

  Removes removable instances of contribute Mode.

- **Remove unnecessary contributeMode reference - just present trxn_id if
  defined ([27369](https://github.com/civicrm/civicrm-core/pull/27369))**

- **Stop checking contributeMode in ContributionPage confirm.tpl before
  displaying billingName
  ([27371](https://github.com/civicrm/civicrm-core/pull/27371))**

- **Fix broken help for edit pledge
  ([27622](https://github.com/civicrm/civicrm-core/pull/27622))**

- **Fix undefined properties on back-office pledge form
  ([27391](https://github.com/civicrm/civicrm-core/pull/27391))**

- **Paypal recur processor_id fix  
  ([27564](https://github.com/civicrm/civicrm-core/pull/27564))**

### CiviEvent

- **[php8.x, workflow template] Fix multiple participant online receipt display
  for quickConfig
  ([27479](https://github.com/civicrm/civicrm-core/pull/27479))**

- **[event][templates] Stop assigning `isPrimary` for WorkFlow Messages at form
  layer ([27556](https://github.com/civicrm/civicrm-core/pull/27556))**

- **Fix event.location token to include supplemental address details, use in
  event receipts ([27625](https://github.com/civicrm/civicrm-core/pull/27625))**

- **Fix notices in text versions of event receipts
  ([27487](https://github.com/civicrm/civicrm-core/pull/27487))**

- **Fix notices when deleting participants
  ([27431](https://github.com/civicrm/civicrm-core/pull/27431))**

- **Fix another EventInfo notice
  ([27427](https://github.com/civicrm/civicrm-core/pull/27427))**

- **Event Custom Field Overwrite
  ([dev/core#4706](https://lab.civicrm.org/dev/core/-/issues/4706):
  [27868](https://github.com/civicrm/civicrm-core/pull/27868))**

  Fixes a bug where event custom fields data was not being displayed properly
  in the user interface.

- **Fix offline event form validation bug when switching events
  ([27287](https://github.com/civicrm/civicrm-core/pull/27287))**

- **php 8 / notices Fix online event receipt to use the same location tokens as
  offline ([27458](https://github.com/civicrm/civicrm-core/pull/27458))**

- **Move Conference slots functionality to event cart
  ([27478](https://github.com/civicrm/civicrm-core/pull/27478))**

- **php 8.x Remove conference sessions from core workflow messages
  ([27455](https://github.com/civicrm/civicrm-core/pull/27455))**

- **Superficial cleanup on Event Confirm - null object
  ([27444](https://github.com/civicrm/civicrm-core/pull/27444))**

- **Whitespace clean up on event online receipt
  ([27457](https://github.com/civicrm/civicrm-core/pull/27457))**

- **Stop enabling event_cart on new installs
  ([27469](https://github.com/civicrm/civicrm-core/pull/27469))**

- **Remove event cart sessions handling from offline event receipt text as gone
  from html ([27497](https://github.com/civicrm/civicrm-core/pull/27497))**

- **Fix last notices on Online event registration by removing variables
  ([27489](https://github.com/civicrm/civicrm-core/pull/27489))**

### CiviGrant

- **CiviGrant - Cleanup and simplify grant form, remove unused tab code  
  ([27411](https://github.com/civicrm/civicrm-core/pull/27411))**

### CiviMail

- **CiviMail - Generate email auth-code as random string
  ([27533](https://github.com/civicrm/civicrm-core/pull/27533))**

  Use random string rather than sha string.

- **CiviMail - VERP should no longer require job_id for verification
  ([27531](https://github.com/civicrm/civicrm-core/pull/27531))**

- **Exclude inactive groups on recipient lists for mailings
  ([27491](https://github.com/civicrm/civicrm-core/pull/27491))**

### CiviMember

- **Fix set default for custom field on membership renewal form
  ([26047](https://github.com/civicrm/civicrm-core/pull/26047))**

### Drupal Integration

- **Views notice fix. Remove duplicate call to constructor.
  ([669](https://github.com/civicrm/civicrm-drupal/pull/669))**

## <a name="misc"></a>Miscellany

- **APIv4 - Delete unnecessary contact spec provider
  ([27657](https://github.com/civicrm/civicrm-core/pull/27657))**

- **Share event lookup functions in a trait
  ([27612](https://github.com/civicrm/civicrm-core/pull/27612))**

- **Switch new queue listener to be a conventional hook
  ([27655](https://github.com/civicrm/civicrm-core/pull/27655))**

- **PHP 7.x - Use get_class() instead of $object::class
  ([27536](https://github.com/civicrm/civicrm-core/pull/27536))**

- **Move the participantCount logic to the template
  ([27699](https://github.com/civicrm/civicrm-core/pull/27699))**

- **APIv4 - Remove always-true if
  ([27662](https://github.com/civicrm/civicrm-core/pull/27662))**

- **Remove references to deleted file
  ([27665](https://github.com/civicrm/civicrm-core/pull/27665))**

- **Flatten array
  ([27650](https://github.com/civicrm/civicrm-core/pull/27650))**

- **Clean up event message templates line items
  ([27683](https://github.com/civicrm/civicrm-core/pull/27683))**

- **Upgrade all core extensions to civix 23.02.1
  ([27641](https://github.com/civicrm/civicrm-core/pull/27641))**

- **Afform - run `civix upgrade`
  ([27617](https://github.com/civicrm/civicrm-core/pull/27617))**

- **Delete unused Smarty block serialize
  ([27619](https://github.com/civicrm/civicrm-core/pull/27619))**

- **Move nasty chunk of code to where it is used
  ([27517](https://github.com/civicrm/civicrm-core/pull/27517))**

- **Run regen
  ([27514](https://github.com/civicrm/civicrm-core/pull/27514))**

- **Regenerate CRM_Event_DAO_Event
  ([27510](https://github.com/civicrm/civicrm-core/pull/27510))**

- **Rename locally assigned variable for clarity
  ([27473](https://github.com/civicrm/civicrm-core/pull/27473))**

- **Add deprecation annotations for getVar & setVar
  ([27503](https://github.com/civicrm/civicrm-core/pull/27503))**

- **Remove getVar call, access protected property in same class directly
  ([27507](https://github.com/civicrm/civicrm-core/pull/27507))**

- **Deprecate Form_Event::testSubmit, migrate test to full flow
  ([27477](https://github.com/civicrm/civicrm-core/pull/27477))**

- **Superficial tidy up in backoffice contribution form
  ([27467](https://github.com/civicrm/civicrm-core/pull/27467))**

- **Separate delete participant form from edit participant form
  ([27660](https://github.com/civicrm/civicrm-core/pull/27660))**

- **Move our security for fetch in smarty 2 to hack smarty rather than an
  override ([372](https://github.com/civicrm/civicrm-packages/pull/372))**

- **PHP8.2 Pass variables rather than co-erce properties when caling
  `AbstractEditPayment:processBillingAddress`
  ([27522](https://github.com/civicrm/civicrm-core/pull/27522))**

- **Add since to deprecated tag
  ([27658](https://github.com/civicrm/civicrm-core/pull/27658))**

- **Add deprecated notice to unreachable code
  ([27600](https://github.com/civicrm/civicrm-core/pull/27600))**

- **Add deprecation notice to code that seems to be superceded
  ([27436](https://github.com/civicrm/civicrm-core/pull/27436))**

- **CRM_Utils_String - Deprecate startsWith and endsWith
  ([27716](https://github.com/civicrm/civicrm-core/pull/27716))**

- **Angular - Noisily deprecate 'settings' in favor of 'settingsFactory'
  ([27798](https://github.com/civicrm/civicrm-core/pull/27798))**

- **Stop passing unused parameter
  ([27609](https://github.com/civicrm/civicrm-core/pull/27609))**

- **Flatten array
  ([27605](https://github.com/civicrm/civicrm-core/pull/27605))**

- **Fix regression when searching by contact ID from quickSearch (if you hit
  enter quickly) ([27854](https://github.com/civicrm/civicrm-core/pull/27854))**

- **regen
  ([27418](https://github.com/civicrm/civicrm-core/pull/27418))**

- **Re-run regen
  ([27719](https://github.com/civicrm/civicrm-core/pull/27719))**

- **Event tokens clean up
  ([27349](https://github.com/civicrm/civicrm-core/pull/27349))**

- **Add Smarty3 to packages in it's own folder
  ([373](https://github.com/civicrm/civicrm-packages/pull/373))**

- **Remove unused property
  ([27651](https://github.com/civicrm/civicrm-core/pull/27651))**

- **Remove weird `<br>` tag on clear buttons on custom radio fields
  ([27635](https://github.com/civicrm/civicrm-core/pull/27635))**

- **Remove unreachable code
  ([27675](https://github.com/civicrm/civicrm-core/pull/27675))**

- **Remove backticks from a couple of places where tokens are already supported
  ([27672](https://github.com/civicrm/civicrm-core/pull/27672))**

- **Remove undeclared properties `_contributorEmail`, `_toDoNotEmail` from
  participant form
  ([27597](https://github.com/civicrm/civicrm-core/pull/27597))**

- **Remove unused templates/CRM/Price/Form/LineItem.tpl
  ([27548](https://github.com/civicrm/civicrm-core/pull/27548))**

- **Remove some unused undeclared properties on SelfSvcTransfer form
  ([27425](https://github.com/civicrm/civicrm-core/pull/27425))**

- **Remove unused variable from function signature
  ([27442](https://github.com/civicrm/civicrm-core/pull/27442))**

- **Remove some copy & paste...
  ([27539](https://github.com/civicrm/civicrm-core/pull/27539))**

- **Remove always true if
  ([27623](https://github.com/civicrm/civicrm-core/pull/27623))**

- **Remove references to invalid action
  ([27437](https://github.com/civicrm/civicrm-core/pull/27437))**

- **Remove always-same parameter from function signature
  ([27606](https://github.com/civicrm/civicrm-core/pull/27606))**

- **Remove unused/ unnecessary table name variables
  ([27303](https://github.com/civicrm/civicrm-core/pull/27303))**

- **Remove always true if for required role_id field, add test for value
  ([27366](https://github.com/civicrm/civicrm-core/pull/27366))**

- **Remove dead code - checkSQLConstraint functions
  ([27607](https://github.com/civicrm/civicrm-core/pull/27607))**

- **php8.x Remove never-used undeclared property
  ([27474](https://github.com/civicrm/civicrm-core/pull/27474))**

- **[php8.x[ Remove notice-causing code that seems unreachable
  ([27540](https://github.com/civicrm/civicrm-core/pull/27540))**

- **Remove legacy error handling
  ([27419](https://github.com/civicrm/civicrm-core/pull/27419))**

- **Remove unused place_holder
  ([27633](https://github.com/civicrm/civicrm-core/pull/27633))**

- **Remove unreachable code
  ([27636](https://github.com/civicrm/civicrm-core/pull/27636))**

- **Remove unreachable code
  ([27563](https://github.com/civicrm/civicrm-core/pull/27563))**

- **Remove {php} in hlp test
  ([27555](https://github.com/civicrm/civicrm-core/pull/27555))**

- **Remove unintentionally added test file
  ([27572](https://github.com/civicrm/civicrm-core/pull/27572))**

- **php8.2 stop using yet-another undeclared property for _membershipId.
  ([27509](https://github.com/civicrm/civicrm-core/pull/27509))**

- **[php 8.2] Declare _paymentFields with public visibility
  ([27485](https://github.com/civicrm/civicrm-core/pull/27485))**

- **php 8.2, ensure properties are declared on activity report
  ([27490](https://github.com/civicrm/civicrm-core/pull/27490))**

- **PHP8.2 Remove undefined property userName
  ([27456](https://github.com/civicrm/civicrm-core/pull/27456))**

- **[NFC] Mail Logger: cleanup CIVICRM_MAIL_LOG_AND SEND
  ([27499](https://github.com/civicrm/civicrm-core/pull/27499))**

- **(NFC) Add comment for IS NOT NULL in moving custom fields
  ([27420](https://github.com/civicrm/civicrm-core/pull/27420))**

- **[NFC] Add in Unit test to ensure that Disabled groups do not appear in
  mailing receipients autocomplete
  ([27708](https://github.com/civicrm/civicrm-core/pull/27708))**

- **(NFC) Queues - Cleanup comments
  ([27690](https://github.com/civicrm/civicrm-core/pull/27690))**

- **[NFC] Proper syntax for null in DedupeMerge
  ([27603](https://github.com/civicrm/civicrm-core/pull/27603))**

- **[NFC] APIv4 - Update contact type api comment
  ([27712](https://github.com/civicrm/civicrm-core/pull/27712))**

- **[NFC] phpunit 9 compatibility
  ([27463](https://github.com/civicrm/civicrm-core/pull/27463))**

- **[NFC] Correct urls in eway single core extension
  ([27669](https://github.com/civicrm/civicrm-core/pull/27669))**

- **Disable broken unit test
  ([27388](https://github.com/civicrm/civicrm-core/pull/27388))**

- **APIv4 - Fix conformance test for entities with multiple primary keys
  ([27393](https://github.com/civicrm/civicrm-core/pull/27393))**

- **Add test cover for handling of returnPath
  ([27398](https://github.com/civicrm/civicrm-core/pull/27398))**

- **Remove isset from template within unit tests
  ([27441](https://github.com/civicrm/civicrm-core/pull/27441))**

- **[REF] Convert arrays to short syntax (
  [27705](https://github.com/civicrm/civicrm-core/pull/27705))**

- **[REF][PHP8.1] Fix deprecation notice on passing NULL as the 3rd param to
  str_replace for Google geocoding
  ([27702](https://github.com/civicrm/civicrm-core/pull/27702))**

- **[REF][PHP8.2] Fix deprecated usage of mb_convert_encoding with HTML-Entities
  ([26042](https://github.com/civicrm/civicrm-core/pull/26042))**

- **[REF][PHP8.2] Tidy up properties in scheduled jobs
  ([27460](https://github.com/civicrm/civicrm-core/pull/27460))**

- **[REF][PHP8.2] Declare properties in CRM_Queue_ErrorPolicy
  ([27599](https://github.com/civicrm/civicrm-core/pull/27599))**

- **[REF][PHP8.2] Remove dynamic property use in api_v3_CustomValueTest
  ([27449](https://github.com/civicrm/civicrm-core/pull/27449))**

- **Add test cover, use token for `event.is_share`
  ([27476](https://github.com/civicrm/civicrm-core/pull/27476))**

- **Fix test template to use the same tokens as the templates
  ([27466](https://github.com/civicrm/civicrm-core/pull/27466))**

- **PHPStorm - Add PHPSTORM_META about test functions
  ([27663](https://github.com/civicrm/civicrm-core/pull/27663))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin and Andie Hunt; Artful Robot - Rich Lott;
BrightMinded Ltd - Bradley Taylor; Christian Wach; Circle Interactive - Pradeep
Nayak; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
civiservice.de - Sebastian Lisken; Coop SymbioTIC - Mathieu Lutfy, Samuel
Vanhove; Dave D; Francesc Bassas i Bullich; Freeform Solutions - Herb van den
Dool; Jens Schuppe; JMA Consulting - Seamus Lee; John Kingsnorth; Lemniscus -
Noah Miller; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; Przemysław Tabor; Squiffle Consulting - Aidan Saunders; Wikimedia
Foundation - Eileen McNaughton; Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Australian Greens - Andrew Cormick-Dockery;
Blackfly Solutions - Alan Dixon; CiviCoop - Jaap Jansma; DevApp; JMA
Consulting - Joe Murray; Nicol Wistreich; Tadpole Collective - Kevin Cristiano;
Third Sector Design - Kurund Jalmi, William Mortada; Wikimedia Foundation -
Elliott Eggleston; xavi-xaloc

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
