/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dwmjack.h"
#include "dwmjack_p.h"

DWMJack::DWMJack(QObject *parent) : QObject(parent)
{

}

bool DWMJack::GetCompositorSwitchStatus(void)
{
    return DWMJackPrivate::_GetCompositorSwitchStatus();
}

int DWMJack::MaximizeWindow(WindowId wid)
{
    return DWMJackPrivate::_MaximizeWindow(wid);
}

int DWMJack::ToggleMultitaskView()
{
    return DWMJackPrivate::_ToggleMultitaskView();
}

int DWMJack::MinimizeWindow(WindowId wid)
{
    return DWMJackPrivate::_MinimizeWindow(wid);
}

char * DWMJack::GetWindowText(WindowId wid)
{
    return DWMJackPrivate::_GetWindowText(wid);
}

Size DWMJack::GetWindowSize(WindowId wid)
{
    return DWMJackPrivate::_GetWindowSize(wid);
}

Position DWMJack::GetWindowPosition(WindowId wid)
{
    return DWMJackPrivate::_GetWindowPosition(wid);
}

WindowId DWMJack::GetActiveWindowID()
{
    return DWMJackPrivate::_GetActiveWindowID();
}

WindowId DWMJack::GetDesktopWindowID()
{
    return DWMJackPrivate::_GetDesktopWindowID();
}

int DWMJack::GetWindowChildren(WindowId wid, WindowId **pChildIDs)
{
    return DWMJackPrivate::_GetWindowChildren(wid, pChildIDs);
}

Position DWMJack::GetPointerPosition()
{
    return DWMJackPrivate::_GetPointerPosition();
}

void DWMJack::FreeWindowList(WindowId *windownlist)
{
    DWMJackPrivate::_FreeWindowList(windownlist);
}

int DWMJack::GetWindowPID(WindowId wid)
{
    return DWMJackPrivate::_GetWindowPID(wid);
}

