/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DWMJACK_P_H
#define DWMJACK_P_H

#include <QObject>
#include <dtk_wmjack.h>

class DWMJackPrivate : public QObject
{
    Q_OBJECT
public:
    static bool _GetCompositorSwitchStatus(void) {
        return GetCompositorSwitchStatus();
    }

    static int _MaximizeWindow(WindowId wid) {
        return MaximizeWindow(wid);
    }

    static int _ToggleMultitaskView() {
        return ToggleMultitaskView();
    }

    static int _MinimizeWindow(WindowId wid) {
        return MinimizeWindow(wid);
    }

    static char * _GetWindowText(WindowId wid) {
        return GetWindowText(wid);
    }

    static Size _GetWindowSize(WindowId wid) {
        return GetWindowSize(wid);
    }

    static Position _GetWindowPosition(WindowId wid) {
        return GetWindowPosition(wid);
    }

    static WindowId _GetActiveWindowID() {
        return GetActiveWindowID();
    }

    static WindowId _GetDesktopWindowID() {
        return GetDesktopWindowID();
    }

    static int _GetWindowChildren(WindowId wid, WindowId **pChildIDs) {
        return GetWindowChildren(wid, pChildIDs);
    }

    static Position _GetPointerPosition() {
        return GetPointerPosition();
    }

    static void _FreeWindowList(WindowId *windownlist) {
        FreeWindowList(windownlist);
    }

    static int _GetWindowPID(WindowId wid)
    {
        return GetWindowPID(wid);
    }
};

#endif // DWMJACK_P_H