<!--
%CopyrightBegin%

Copyright Ericsson AB 2023-2024. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

%CopyrightEnd%
-->
# Standards Compliance

## Purpose

This section describes the current state of standards compliance of the ssl
application.

## Common (prior to TLS 1.3)

- For security reasons RSA key exchange cipher suites are no longer supported by
  default, but can be configured. (OTP 21)
- For security reasons DES cipher suites are no longer supported by default, but
  can be configured. (OTP 20)
- For security reasons 3DES cipher suites are no longer supported by default,
  but can be configured. (OTP 21)
- Renegotiation Indication Extension
  [RFC 5746](http://www.ietf.org/rfc/rfc5746.txt) is supported
- Ephemeral Diffie-Hellman cipher suites are supported, but not Diffie Hellman
  Certificates cipher suites.
- Elliptic Curve cipher suites are supported if the Crypto application supports
  it and named curves are used.
- Export cipher suites are not supported as the U.S. lifted its export
  restrictions in early 2000.
- IDEA cipher suites are not supported as they have become deprecated by the TLS
  1.2 specification so it is not motivated to implement them.
- Compression is not supported.
- It is possible to use Pre-Shared Key (PSK) and Secure Remote Password (SRP)
  cipher suites, but they are not enabled by default and need addition configuration.
 
## Common

- CRL validation is supported.
- Policy certificate extensions are supported. (OTP 27)
- 'Server Name Indication' extension
  ([RFC 6066](http://www.ietf.org/rfc/rfc6066.txt)) is supported.
- Application Layer Protocol Negotiation (ALPN) and its successor Next Protocol
  Negotiation (NPN) are supported.

## SSL 2.0

For security reasons SSL-2.0 is not supported. Interoperability with SSL-2.0
enabled clients dropped. (OTP 21)

## SSL 3.0

For security reasons SSL-3.0 is no longer supported at all. (OTP 23)

For security reasons SSL-3.0 is no longer supported by default, but can be
configured. (OTP 19)

## TLS 1.0

For security reasons TLS-1.0 is no longer supported by default, but can be
configured. (OTP 22)

## TLS 1.1

For security reasons TLS-1.1 is no longer supported by default, but can be
configured. (OTP 22)

## TLS 1.2

Supported

## DTLS 1.0

For security reasons DTLS-1.0 (based on TLS 1.1) is no longer supported by
default, but can be configured. (OTP 22)

## DTLS 1.2

Supported (based on TLS 1.2)

## DTLS 1.3

Not yet supported

## TLS 1.3

OTP-22 introduces support for TLS 1.3. The current implementation supports a
selective set of cryptographic algorithms:

- Key Exchange: ECDHE groups supported by default
- Groups: all standard groups supported for the Diffie-Hellman key exchange
- Groups: Support brainpool groups from RFC 8734
- Ciphers: all mandatory cipher suites are supported
- Signature Algorithms: All algorithms form RFC 8446
- Certificates: RSA, ECDSA and EDDSA keys

Other notable features:

- PSK and session resumption is supported (stateful and stateless tickets)
- Anti-replay protection using Bloom-filters with stateless tickets
- Early data and 0-RTT is supported
- Key and Initialization Vector Update is supported

For more detailed information see the
[Standards Compliance](standards_compliance.md#soc_table) below.

The following table describes the current state of standards compliance for TLS
1.3.

(_C_ = Compliant, _NC_ = Non-Compliant, _PC_ = Partially-Compliant, _NA_ = Not
Applicable)

[](){: #soc_table }

| _Section_                                                                                                       | _Feature_                                                                                                                                                                                                                                                                                                 | _State_ | _Since_ |
| --------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------- | ------- |
| [1\.3. Updates Affecting TLS 1.2](https://tools.ietf.org/html/rfc8446#section-1.2)                              |                                                                                                                                                                                                                                                                                                           | _C_     | _24\.1_ |
|                                                                                                                 | Version downgrade protection mechanism                                                                                                                                                                                                                                                                    | _C_     | _22_    |
|                                                                                                                 | RSASSA-PSS signature schemes                                                                                                                                                                                                                                                                              | _C_     | _24\.1_ |
|                                                                                                                 | supported_versions (ClientHello) extension                                                                                                                                                                                                                                                                | _C_     | _22_    |
|                                                                                                                 | signature_algorithms_cert extension                                                                                                                                                                                                                                                                       | _C_     | _24\.1_ |
| [2\. Protocol Overview](https://tools.ietf.org/html/rfc8446#section/2)                                          |                                                                                                                                                                                                                                                                                                           | _PC_    | _22_    |
|                                                                                                                 | (EC)DHE                                                                                                                                                                                                                                                                                                   | _C_     | _22_    |
|                                                                                                                 | PSK-only                                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | PSK with (EC)DHE                                                                                                                                                                                                                                                                                          | _C_     | _22\.2_ |
| [2\.1. Incorrect DHE share](https://tools.ietf.org/html/rfc8446#section-2.1)                                    | HelloRetryRequest                                                                                                                                                                                                                                                                                         | _C_     | _22_    |
| [2\.2. Resumption and Pre-Shared Key (PSK)](https://tools.ietf.org/html/rfc8446#section-2.2)                    |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
| [2\.3. 0-RTT Data](https://tools.ietf.org/html/rfc8446#section-2.3)                                             |                                                                                                                                                                                                                                                                                                           | _PC_    | _23\.3_ |
| [4\.1.1. Cryptographic Negotiation](https://tools.ietf.org/html/rfc8446#section-4.1.1)                          |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
|                                                                                                                 | supported_groups extension                                                                                                                                                                                                                                                                                | _C_     | _22_    |
|                                                                                                                 | signature_algorithms extension                                                                                                                                                                                                                                                                            | _C_     | _22_    |
|                                                                                                                 | pre_shared_key extension                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
| [4\.1.2. Client Hello](https://tools.ietf.org/html/rfc8446#section-4.1.2)                                       | _Client_                                                                                                                                                                                                                                                                                                  | _PC_    | _22\.1_ |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | _C_     | _23\.2_ |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | _C_     | _23\.0_ |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | _C_     | _27\.0_ |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | _C_     | _22\.1_ |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | _C_     | _22\.1_ |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | _C_     | 26\.0   |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | _NC_    |         |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | _C_     | _22\.1_ |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | _NC_    |         |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | padding (RFC7685)                                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | psk_key_exchange_modes (RFC8446)                                                                                                                                                                                                                                                                          | _C_     | _22\.2_ |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | _C_     | _23\.3_ |
|                                                                                                                 | cookie (RFC8446)                                                                                                                                                                                                                                                                                          | _C_     | _23\.1_ |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | _C_     | _22\.1_ |
|                                                                                                                 | certificate_authorities (RFC8446)                                                                                                                                                                                                                                                                         | _C_     | 24\.3   |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | _NC_    |         |
|                                                                                                                 | post_handshake_auth (RFC8446)                                                                                                                                                                                                                                                                             | _NC_    |         |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _PC_    | _22_    |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | _C_     | _23\.2_ |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | _C_     | _23\.0_ |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | _C_     | _22_    |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | _C_     | _22_    |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | _C_     | 26\.0   |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | _NC_    |         |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | _C_     | _22\.1_ |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | _NC_    |         |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | padding (RFC7685)                                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | _C_     | _22_    |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | psk_key_exchange_modes (RFC8446)                                                                                                                                                                                                                                                                          | _C_     | _22\.2_ |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | _C_     | _23\.3_ |
|                                                                                                                 | cookie (RFC8446)                                                                                                                                                                                                                                                                                          | _C_     | _23\.1_ |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | _C_     | _22_    |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | _NC_    |         |
|                                                                                                                 | post_handshake_auth (RFC8446)                                                                                                                                                                                                                                                                             | _NC_    |         |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | _C_     | _22_    |
| [4\.1.3. Server Hello](https://tools.ietf.org/html/rfc8446#section-4.1.3)                                       | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | Version downgrade protection                                                                                                                                                                                                                                                                              | _C_     | _22\.1_ |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | _C_     | _22\.1_ |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | _C_     | 26\.0   |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | Version downgrade protection                                                                                                                                                                                                                                                                              | _C_     | _22_    |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | _C_     | _22_    |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | _C_     | _22_    |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | _C_     | 26\.0   |
| [4\.1.4. Hello Retry Request](https://tools.ietf.org/html/rfc8446#section-4.1.4)                                | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22_    |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | _C_     | _22_    |
|                                                                                                                 | cookie (RFC8446)                                                                                                                                                                                                                                                                                          | _C_     | _23\.1_ |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | _C_     | _22_    |
| [4\.2.1. Supported Versions](https://tools.ietf.org/html/rfc8446#section-4.2.1)                                 | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22_    |
| [4\.2.2. Cookie](https://tools.ietf.org/html/rfc8446#section-4.2.2)                                             | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.1_ |
| [4\.2.3. Signature Algorithms](https://tools.ietf.org/html/rfc8446#section-4.2.3)                               | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _24_    |
|                                                                                                                 | rsa_pkcs1_sha256                                                                                                                                                                                                                                                                                          | _C_     | _22\.1_ |
|                                                                                                                 | rsa_pkcs1_sha384                                                                                                                                                                                                                                                                                          | _C_     | _22\.1_ |
|                                                                                                                 | rsa_pkcs1_sha512                                                                                                                                                                                                                                                                                          | _C_     | _22\.1_ |
|                                                                                                                 | ecdsa_secp256r1_sha256                                                                                                                                                                                                                                                                                    | _C_     | _22\.1_ |
|                                                                                                                 | ecdsa_secp384r1_sha384                                                                                                                                                                                                                                                                                    | _C_     | _22\.1_ |
|                                                                                                                 | ecdsa_secp521r1_sha512                                                                                                                                                                                                                                                                                    | _C_     | _22\.1_ |
|                                                                                                                 | rsa_pss_rsae_sha256                                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | rsa_pss_rsae_sha384                                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | rsa_pss_rsae_sha512                                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | ed25519                                                                                                                                                                                                                                                                                                   | _C_     | _24_    |
|                                                                                                                 | ed448                                                                                                                                                                                                                                                                                                     | _C_     | _24_    |
|                                                                                                                 | rsa_pss_pss_sha256                                                                                                                                                                                                                                                                                        | _C_     | _23_    |
|                                                                                                                 | rsa_pss_pss_sha384                                                                                                                                                                                                                                                                                        | _C_     | _23_    |
|                                                                                                                 | rsa_pss_pss_sha512                                                                                                                                                                                                                                                                                        | _C_     | _23_    |
|                                                                                                                 | rsa_pkcs1_sha1                                                                                                                                                                                                                                                                                            | _C_     | _22\.1_ |
|                                                                                                                 | ecdsa_sha1                                                                                                                                                                                                                                                                                                | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _24_    |
|                                                                                                                 | rsa_pkcs1_sha256                                                                                                                                                                                                                                                                                          | _C_     | _22_    |
|                                                                                                                 | rsa_pkcs1_sha384                                                                                                                                                                                                                                                                                          | _C_     | _22_    |
|                                                                                                                 | rsa_pkcs1_sha512                                                                                                                                                                                                                                                                                          | _C_     | _22_    |
|                                                                                                                 | ecdsa_secp256r1_sha256                                                                                                                                                                                                                                                                                    | _C_     | _22\.1_ |
|                                                                                                                 | ecdsa_secp384r1_sha384                                                                                                                                                                                                                                                                                    | _C_     | _22\.1_ |
|                                                                                                                 | ecdsa_secp521r1_sha512                                                                                                                                                                                                                                                                                    | _C_     | _22\.1_ |
|                                                                                                                 | rsa_pss_rsae_sha256                                                                                                                                                                                                                                                                                       | _C_     | _22_    |
|                                                                                                                 | rsa_pss_rsae_sha384                                                                                                                                                                                                                                                                                       | _C_     | _22_    |
|                                                                                                                 | rsa_pss_rsae_sha512                                                                                                                                                                                                                                                                                       | _C_     | _22_    |
|                                                                                                                 | ed25519                                                                                                                                                                                                                                                                                                   | _C_     | _24_    |
|                                                                                                                 | ed448                                                                                                                                                                                                                                                                                                     | _C_     | _24_    |
|                                                                                                                 | rsa_pss_pss_sha256                                                                                                                                                                                                                                                                                        | _C_     | _23_    |
|                                                                                                                 | rsa_pss_pss_sha384                                                                                                                                                                                                                                                                                        | _C_     | _23_    |
|                                                                                                                 | rsa_pss_pss_sha512                                                                                                                                                                                                                                                                                        | _C_     | _23_    |
|                                                                                                                 | rsa_pkcs1_sha1                                                                                                                                                                                                                                                                                            | _C_     | _22_    |
|                                                                                                                 | ecdsa_sha1                                                                                                                                                                                                                                                                                                | _C_     | _22_    |
| [4\.2.4. Certificate Authorities](https://tools.ietf.org/html/rfc8446#section-4.2.4)                            | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | 24\.3   |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _24\.3_ |
| [4\.2.5. OID Filters](https://tools.ietf.org/html/rfc8446#section-4.2.5)                                        | _Client_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
| [4\.2.6. Post-Handshake Client Authentication](https://tools.ietf.org/html/rfc8446#section-4.2.6)               | _Client_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
| [4\.2.7. Supported Groups](https://tools.ietf.org/html/rfc8446#section-4.2.7)                                   | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.1_ |
|                                                                                                                 | secp256r1                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | secp384r1                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | secp521r1                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | x25519                                                                                                                                                                                                                                                                                                    | _C_     | _22\.1_ |
|                                                                                                                 | x448                                                                                                                                                                                                                                                                                                      | _C_     | _22\.1_ |
|                                                                                                                 | ffdhe2048                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | ffdhe3072                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | ffdhe4096                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | ffdhe6144                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | ffdhe8192                                                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22_    |
|                                                                                                                 | secp256r1                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | secp384r1                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | secp521r1                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | x25519                                                                                                                                                                                                                                                                                                    | _C_     | _22_    |
|                                                                                                                 | x448                                                                                                                                                                                                                                                                                                      | _C_     | _22_    |
|                                                                                                                 | ffdhe2048                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | ffdhe3072                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | ffdhe4096                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | ffdhe6144                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | ffdhe8192                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
| [4\.2.8. Key Share](https://tools.ietf.org/html/rfc8446#section-4.2.8)                                          | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22_    |
| [4\.2.9. Pre-Shared Key Exchange Modes](https://tools.ietf.org/html/rfc8446#section-4.2.9)                      | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
| [4\.2.10. Early Data Indication](https://tools.ietf.org/html/rfc8446#section-4.2.10)                            | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.3_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.3_ |
| [4\.2.11. Pre-Shared Key Extension](https://tools.ietf.org/html/rfc8446#section-4.2.11)                         | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
| [4\.2.11.1. Ticket Age](https://tools.ietf.org/html/rfc8446#section-4.2.11.1)                                   | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
| [4\.2.11.2. PSK Binder](https://tools.ietf.org/html/rfc8446#section-4.2.11.2)                                   | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.2_ |
| [4\.2.11.3. Processing Order](https://tools.ietf.org/html/rfc8446#section-4.2.11.3)                             | _Client_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
| [4\.3.1. Encrypted Extensions](https://tools.ietf.org/html/rfc8446#section-4.3.1)                               | _Client_                                                                                                                                                                                                                                                                                                  | _PC_    | _22\.1_ |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | _C_     | _23\.2_ |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | _C_     | _23\.0_ |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | _NC_    |         |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | _NC_    |         |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | _NC_    |         |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | _C_     | 23\.0   |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | _C_     | _23\.3_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _PC_    | _22_    |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | _C_     | _23\.2_ |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | _C_     | _23\.0_ |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | _NC_    |         |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | _NC_    |         |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | _NC_    |         |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | _C_     | 23\.0   |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | _C_     | _23\.3_ |
| [4\.3.2. Certificate Request](https://tools.ietf.org/html/rfc8446#section-4.3.2)                                | _Client_                                                                                                                                                                                                                                                                                                  | _PC_    | _22\.1_ |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | _C_     | _22\.1_ |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | _NC_    |         |
|                                                                                                                 | certificate_authorities (RFC8446)                                                                                                                                                                                                                                                                         | _C_     | 24\.3   |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | _NC_    |         |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _PC_    | _22_    |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | _C_     | _22_    |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | _NC_    |         |
|                                                                                                                 | certificate_authorities (RFC8446)                                                                                                                                                                                                                                                                         | _C_     | 24\.3   |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | _NC_    |         |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | _C_     | _22_    |
| [4\.4.1. The Transcript Hash](https://tools.ietf.org/html/rfc8446#section-4.4.1)                                |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [4\.4.2. Certificate](https://tools.ietf.org/html/rfc8446#section-4.4.2)                                        | _Client_                                                                                                                                                                                                                                                                                                  | _PC_    | _22\.1_ |
|                                                                                                                 | Arbitrary certificate chain orderings                                                                                                                                                                                                                                                                     | _C_     | _22\.2_ |
|                                                                                                                 | Extraneous certificates in chain                                                                                                                                                                                                                                                                          | _C_     | _23\.2_ |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | _C_     | 27\.0   |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | _NC_    |         |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _PC_    | _22_    |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | _NC_    |         |
| [4\.4.2.1. OCSP Status and SCT Extensions](https://tools.ietf.org/html/rfc8446#section-4.4.2.1)                 | _Client_                                                                                                                                                                                                                                                                                                  | _PC_    | _27\.0_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
| [4\.4.2.2. Server Certificate Selection](https://tools.ietf.org/html/rfc8446#section-4.4.2.2)                   |                                                                                                                                                                                                                                                                                                           | _C_     | _24\.3_ |
|                                                                                                                 | The certificate type MUST be X.509v3, unless explicitly negotiated otherwise                                                                                                                                                                                                                              | _C_     | _22_    |
|                                                                                                                 | The server's end-entity certificate's public key (and associated restrictions) MUST be compatible with the selected authentication algorithm from the client's "signature_algorithms" extension (currently RSA, ECDSA, or EdDSA).                                                                         | _C_     | _22_    |
|                                                                                                                 | The certificate MUST allow the key to be used for signing with a signature scheme indicated in the client's "signature_algorithms"/"signature_algorithms_cert" extensions                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | The "server_name" and "certificate_authorities" extensions are used to guide certificate selection. As servers MAY require the presence of the "server_name" extension, clients SHOULD send this extension, when applicable.                                                                              | _C_     | _24\.3_ |
| [4\.4.2.3. Client Certificate Selection](https://tools.ietf.org/html/rfc8446#section-4.4.2.3)                   |                                                                                                                                                                                                                                                                                                           | _PC_    | _22\.1_ |
|                                                                                                                 | The certificate type MUST be X.509v3, unless explicitly negotiated otherwise                                                                                                                                                                                                                              | _C_     | _22\.1_ |
|                                                                                                                 | If the "certificate_authorities" extension in the CertificateRequest message was present, at least one of the certificates in the certificate chain SHOULD be issued by one of the listed CAs.                                                                                                            | _C_     | _24\.3_ |
|                                                                                                                 | The certificates MUST be signed using an acceptable signature algorithm                                                                                                                                                                                                                                   | _C_     | _22\.1_ |
|                                                                                                                 | If the CertificateRequest message contained a non-empty "oid_filters" extension, the end-entity certificate MUST match the extension OIDs that are recognized by the client                                                                                                                               | _NC_    |         |
| [4\.4.2.4. Receiving a Certificate Message](https://tools.ietf.org/html/rfc8446#section-4.4.2.4)                | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22_    |
| [4\.4.3. Certificate Verify](https://tools.ietf.org/html/rfc8446#section-4.4.3)                                 | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22_    |
| [4\.4.4. Finished](https://tools.ietf.org/html/rfc8446#section-4.4.4)                                           | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.1_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22_    |
| [4\.5. End of Early Data](https://tools.ietf.org/html/rfc8446#section-4.5)                                      | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.3_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.3_ |
| [4\.6.1. New Session Ticket Message](https://tools.ietf.org/html/rfc8446#section-4.6.1)                         | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.3_ |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | _C_     | _23\.3_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _23\.3_ |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | _C_     | _23\.3_ |
| [4\.6.2. Post-Handshake Authentication](https://tools.ietf.org/html/rfc8446#section-4.6.2)                      | _Client_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _NC_    |         |
| [4\.6.3. Key and Initialization Vector Update](https://tools.ietf.org/html/rfc8446#section-4.6.3)               | _Client_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.3_ |
|                                                                                                                 | _Server_                                                                                                                                                                                                                                                                                                  | _C_     | _22\.3_ |
| [5\.1. Record Layer](https://tools.ietf.org/html/rfc8446#section-5.1)                                           |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
|                                                                                                                 | MUST NOT be interleaved with other record types                                                                                                                                                                                                                                                           | _C_     | _22_    |
|                                                                                                                 | MUST NOT span key changes                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | MUST NOT send zero-length fragments                                                                                                                                                                                                                                                                       | _C_     | _22_    |
|                                                                                                                 | Alert messages MUST NOT be fragmented                                                                                                                                                                                                                                                                     | _C_     | _22_    |
| [5\.2. Record Payload Protection](https://tools.ietf.org/html/rfc8446#section-5.2)                              |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [5\.3. Per-Record Nonce](https://tools.ietf.org/html/rfc8446#section-5.3)                                       |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [5\.4. Record Padding](https://tools.ietf.org/html/rfc8446#section-5.4)                                         |                                                                                                                                                                                                                                                                                                           | _PC_    | _22_    |
|                                                                                                                 | MAY choose to pad                                                                                                                                                                                                                                                                                         | _NC_    |         |
|                                                                                                                 | MUST NOT send Handshake and Alert records that have a zero-length TLSInnerPlaintext.content                                                                                                                                                                                                               | _NC_    |         |
|                                                                                                                 | The padding sent is automatically verified                                                                                                                                                                                                                                                                | _C_     | _22_    |
| [5\.5. Limits on Key Usage](https://tools.ietf.org/html/rfc8446#section-5.5)                                    |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.3_ |
| [6\.1. Closure Alerts](https://tools.ietf.org/html/rfc8446#section-6.1)                                         |                                                                                                                                                                                                                                                                                                           | _22_    |         |
|                                                                                                                 | close_notify                                                                                                                                                                                                                                                                                              | _C_     | _22_    |     |
|                                                                                                                 | user_cancelled                                                                                                                                                                                                                                                                                            | _C_     | _22_    |     |
| [6\.2. Error Alerts](https://tools.ietf.org/html/rfc8446#section-6.2)                                           |                                                                                                                                                                                                                                                                                                           | _PC_    | _22_    |
| [7\.1. Key Schedule](https://tools.ietf.org/html/rfc8446#section-7.1)                                           |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [7\.2. Updating Traffic Secrets](https://tools.ietf.org/html/rfc8446#section-7.2)                               |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [7\.3. Traffic Key Calculation](https://tools.ietf.org/html/rfc8446#section-7.3)                                |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [7\.5. Exporters](https://tools.ietf.org/html/rfc8446#section-7.5)                                              |                                                                                                                                                                                                                                                                                                           | _PC_    | _26\.3_ |
| [8\. 0-RTT and Anti-Replay](https://tools.ietf.org/html/rfc8446#section/8)                                      |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
| [8\.1. Single-Use Tickets](https://tools.ietf.org/html/rfc8446#section-8.1)                                     |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
| [8\.2. Client Hello Recording](https://tools.ietf.org/html/rfc8446#section-8.2)                                 |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
| [8\.3. Freshness Checks](https://tools.ietf.org/html/rfc8446#section-8.3)                                       |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
| [9\.1. Mandatory-to-Implement Cipher Suites](https://tools.ietf.org/html/rfc8446#section-9.1)                   |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.1_ |
|                                                                                                                 | MUST implement the TLS_AES_128_GCM_SHA256                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | SHOULD implement the TLS_AES_256_GCM_SHA384                                                                                                                                                                                                                                                               | _C_     | _22_    |
|                                                                                                                 | SHOULD implement the TLS_CHACHA20_POLY1305_SHA256                                                                                                                                                                                                                                                         | _C_     | _22_    |
|                                                                                                                 | _Digital signatures_                                                                                                                                                                                                                                                                                      | _C_     | _22\.1_ |
|                                                                                                                 | MUST support rsa_pkcs1_sha256 (for certificates)                                                                                                                                                                                                                                                          | _C_     | _22_    |
|                                                                                                                 | MUST support rsa_pss_rsae_sha256 (for CertificateVerify and certificates)                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | MUST support ecdsa_secp256r1_sha256                                                                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | _Key Exchange_                                                                                                                                                                                                                                                                                            | _C_     | _22_    |
|                                                                                                                 | MUST support key exchange with secp256r1                                                                                                                                                                                                                                                                  | _C_     | _22_    |
|                                                                                                                 | SHOULD support key exchange with X25519                                                                                                                                                                                                                                                                   | _C_     | _22_    |
| [9\.2. Mandatory-to-Implement Extensions](https://tools.ietf.org/html/rfc8446#section-9.2)                      |                                                                                                                                                                                                                                                                                                           | _C_     | _23\.2_ |
|                                                                                                                 | Supported Versions                                                                                                                                                                                                                                                                                        | _C_     | _22_    |
|                                                                                                                 | Cookie                                                                                                                                                                                                                                                                                                    | _C_     | _23\.1_ |
|                                                                                                                 | Signature Algorithms                                                                                                                                                                                                                                                                                      | _C_     | _22_    |
|                                                                                                                 | Signature Algorithms Certificate                                                                                                                                                                                                                                                                          | _C_     | _22_    |
|                                                                                                                 | Negotiated Groups                                                                                                                                                                                                                                                                                         | _C_     | _22_    |
|                                                                                                                 | Key Share                                                                                                                                                                                                                                                                                                 | _C_     | _22_    |
|                                                                                                                 | Server Name Indication                                                                                                                                                                                                                                                                                    | _C_     | _23\.2_ |
|                                                                                                                 | _MUST send and use these extensions_                                                                                                                                                                                                                                                                      | _C_     | _22\.2_ |
|                                                                                                                 | "supported_versions" is REQUIRED for ClientHello, ServerHello and HelloRetryRequest                                                                                                                                                                                                                       | _C_     | _22\.1_ |
|                                                                                                                 | "signature_algorithms" is REQUIRED for certificate authentication                                                                                                                                                                                                                                         | _C_     | _22_    |
|                                                                                                                 | "supported_groups" is REQUIRED for ClientHello messages using (EC)DHE key exchange                                                                                                                                                                                                                        | _C_     | _22_    |
|                                                                                                                 | "key_share" is REQUIRED for (EC)DHE key exchange                                                                                                                                                                                                                                                          | _C_     | _22_    |
|                                                                                                                 | "pre_shared_key" is REQUIRED for PSK key agreement                                                                                                                                                                                                                                                        | _C_     | _22\.2_ |
|                                                                                                                 | "psk_key_exchange_modes" is REQUIRED for PSK key agreement                                                                                                                                                                                                                                                | _C_     | _22\.2_ |
|                                                                                                                 | _TLS 1.3 ClientHello_                                                                                                                                                                                                                                                                                     | _C_     | _22\.1_ |
|                                                                                                                 | If not containing a "pre_shared_key" extension, it MUST contain both a "signature_algorithms" extension and a "supported_groups" extension.                                                                                                                                                               | _C_     | _22\.1_ |
|                                                                                                                 | If containing a "supported_groups" extension, it MUST also contain a "key_share" extension, and vice versa. An empty KeyShare.client_shares vector is permitted.                                                                                                                                          | _C_     | _22\.1_ |
|                                                                                                                 | _TLS 1.3 ServerHello_                                                                                                                                                                                                                                                                                     | _C_     | _23\.2_ |
|                                                                                                                 | MUST support the use of the "server_name" extension                                                                                                                                                                                                                                                       | _C_     | _23\.2_ |
| [9\.3. Protocol Invariants](https://tools.ietf.org/html/rfc8446#section-9.3)                                    |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.1_ |
|                                                                                                                 | _MUST correctly handle extensible fields_                                                                                                                                                                                                                                                                 | _C_     | _22\.1_ |
|                                                                                                                 | A client sending a ClientHello MUST support all parameters advertised in it. Otherwise, the server may fail to interoperate by selecting one of those parameters.                                                                                                                                         | _C_     | _22\.1_ |
|                                                                                                                 | A server receiving a ClientHello MUST correctly ignore all unrecognized cipher suites, extensions, and other parameters. Otherwise, it may fail to interoperate with newer clients. In TLS 1.3, a client receiving a CertificateRequest or NewSessionTicket MUST also ignore all unrecognized extensions. | _C_     | _22\.1_ |
|                                                                                                                 | A middlebox which terminates a TLS connection MUST behave as a compliant TLS server                                                                                                                                                                                                                       | _NA_    |         |
|                                                                                                                 | A middlebox which forwards ClientHello parameters it does not understand MUST NOT process any messages beyond that ClientHello. It MUST forward all subsequent traffic unmodified. Otherwise, it may fail to interoperate with newer clients and servers.                                                 | _NA_    |         |
| [B.4. Cipher Suites](https://tools.ietf.org/html/rfc8446#section-B.4)                                           |                                                                                                                                                                                                                                                                                                           | _C_     | _23_    |
|                                                                                                                 | TLS_AES_128_GCM_SHA256                                                                                                                                                                                                                                                                                    | _C_     | _22_    |
|                                                                                                                 | TLS_AES_256_GCM_SHA384                                                                                                                                                                                                                                                                                    | _C_     | _22_    |
|                                                                                                                 | TLS_CHACHA20_POLY1305_SHA256                                                                                                                                                                                                                                                                              | _C_     | _22_    |
|                                                                                                                 | TLS_AES_128_CCM_SHA256                                                                                                                                                                                                                                                                                    | _C_     | _22_    |
|                                                                                                                 | TLS_AES_128_CCM_8_SHA256                                                                                                                                                                                                                                                                                  | _C_     | _23_    |
| [C.1. Random Number Generation and Seeding](https://tools.ietf.org/html/rfc8446#section-C.1)                    |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [C.2. Certificates and Authentication](https://tools.ietf.org/html/rfc8446#section-C.2)                         |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [C.3. Implementation Pitfalls](https://tools.ietf.org/html/rfc8446#section-C.3)                                 |                                                                                                                                                                                                                                                                                                           | _PC_    | _22_    |
| [C.4. Client Tracking Prevention](https://tools.ietf.org/html/rfc8446#section-C.4)                              |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
| [C.5. Unauthenticated Operation](https://tools.ietf.org/html/rfc8446#section-C.5)                               |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [D.1. Negotiating with an Older Server](https://tools.ietf.org/html/rfc8446#section-D.1)                        |                                                                                                                                                                                                                                                                                                           | _C_     | _22\.2_ |
| [D.2. Negotiating with an Older Client](https://tools.ietf.org/html/rfc8446#section-D.2)                        |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |
| [D.3. 0-RTT Backward Compatibility](https://tools.ietf.org/html/rfc8446#section-D.3)                            |                                                                                                                                                                                                                                                                                                           | _NC_    |         |
| [D.4. Middlebox Compatibility Mode](https://tools.ietf.org/html/rfc8446#section-D.4)                            |                                                                                                                                                                                                                                                                                                           | _C_     | _23_    |
| [D.5. Security Restrictions Related to Backward Compatibility](https://tools.ietf.org/html/rfc8446#section-D.5) |                                                                                                                                                                                                                                                                                                           | _C_     | _22_    |

_Table: Standards Compliance_
