//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpowerbidedicated

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AutoScaleVCoresClient contains the methods for the AutoScaleVCores group.
// Don't use this type directly, use NewAutoScaleVCoresClient() instead.
type AutoScaleVCoresClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewAutoScaleVCoresClient creates a new instance of AutoScaleVCoresClient with the specified values.
// subscriptionID - A unique identifier for a Microsoft Azure subscription. The subscription ID forms part of the URI for
// every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAutoScaleVCoresClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AutoScaleVCoresClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AutoScaleVCoresClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Create - Provisions the specified auto scale v-core based on the configuration specified in the request.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-01-01
// resourceGroupName - The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name
// must be at least 1 character in length, and no more than 90.
// vcoreName - The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
// vCoreParameters - Contains the information used to provision the auto scale v-core.
// options - AutoScaleVCoresClientCreateOptions contains the optional parameters for the AutoScaleVCoresClient.Create method.
func (client *AutoScaleVCoresClient) Create(ctx context.Context, resourceGroupName string, vcoreName string, vCoreParameters AutoScaleVCore, options *AutoScaleVCoresClientCreateOptions) (AutoScaleVCoresClientCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, vcoreName, vCoreParameters, options)
	if err != nil {
		return AutoScaleVCoresClientCreateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AutoScaleVCoresClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AutoScaleVCoresClientCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *AutoScaleVCoresClient) createCreateRequest(ctx context.Context, resourceGroupName string, vcoreName string, vCoreParameters AutoScaleVCore, options *AutoScaleVCoresClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vcoreName == "" {
		return nil, errors.New("parameter vcoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vcoreName}", url.PathEscape(vcoreName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, vCoreParameters)
}

// createHandleResponse handles the Create response.
func (client *AutoScaleVCoresClient) createHandleResponse(resp *http.Response) (AutoScaleVCoresClientCreateResponse, error) {
	result := AutoScaleVCoresClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AutoScaleVCore); err != nil {
		return AutoScaleVCoresClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes the specified auto scale v-core.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-01-01
// resourceGroupName - The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name
// must be at least 1 character in length, and no more than 90.
// vcoreName - The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
// options - AutoScaleVCoresClientDeleteOptions contains the optional parameters for the AutoScaleVCoresClient.Delete method.
func (client *AutoScaleVCoresClient) Delete(ctx context.Context, resourceGroupName string, vcoreName string, options *AutoScaleVCoresClientDeleteOptions) (AutoScaleVCoresClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, vcoreName, options)
	if err != nil {
		return AutoScaleVCoresClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AutoScaleVCoresClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return AutoScaleVCoresClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return AutoScaleVCoresClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *AutoScaleVCoresClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, vcoreName string, options *AutoScaleVCoresClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vcoreName == "" {
		return nil, errors.New("parameter vcoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vcoreName}", url.PathEscape(vcoreName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets details about the specified auto scale v-core.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-01-01
// resourceGroupName - The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name
// must be at least 1 character in length, and no more than 90.
// vcoreName - The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
// options - AutoScaleVCoresClientGetOptions contains the optional parameters for the AutoScaleVCoresClient.Get method.
func (client *AutoScaleVCoresClient) Get(ctx context.Context, resourceGroupName string, vcoreName string, options *AutoScaleVCoresClientGetOptions) (AutoScaleVCoresClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, vcoreName, options)
	if err != nil {
		return AutoScaleVCoresClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AutoScaleVCoresClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AutoScaleVCoresClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *AutoScaleVCoresClient) getCreateRequest(ctx context.Context, resourceGroupName string, vcoreName string, options *AutoScaleVCoresClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vcoreName == "" {
		return nil, errors.New("parameter vcoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vcoreName}", url.PathEscape(vcoreName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AutoScaleVCoresClient) getHandleResponse(resp *http.Response) (AutoScaleVCoresClientGetResponse, error) {
	result := AutoScaleVCoresClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AutoScaleVCore); err != nil {
		return AutoScaleVCoresClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Gets all the auto scale v-cores for the given resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-01-01
// resourceGroupName - The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name
// must be at least 1 character in length, and no more than 90.
// options - AutoScaleVCoresClientListByResourceGroupOptions contains the optional parameters for the AutoScaleVCoresClient.ListByResourceGroup
// method.
func (client *AutoScaleVCoresClient) NewListByResourceGroupPager(resourceGroupName string, options *AutoScaleVCoresClientListByResourceGroupOptions) *runtime.Pager[AutoScaleVCoresClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[AutoScaleVCoresClientListByResourceGroupResponse]{
		More: func(page AutoScaleVCoresClientListByResourceGroupResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *AutoScaleVCoresClientListByResourceGroupResponse) (AutoScaleVCoresClientListByResourceGroupResponse, error) {
			req, err := client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			if err != nil {
				return AutoScaleVCoresClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AutoScaleVCoresClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AutoScaleVCoresClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *AutoScaleVCoresClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *AutoScaleVCoresClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *AutoScaleVCoresClient) listByResourceGroupHandleResponse(resp *http.Response) (AutoScaleVCoresClientListByResourceGroupResponse, error) {
	result := AutoScaleVCoresClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AutoScaleVCoreListResult); err != nil {
		return AutoScaleVCoresClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Lists all the auto scale v-cores for the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-01-01
// options - AutoScaleVCoresClientListBySubscriptionOptions contains the optional parameters for the AutoScaleVCoresClient.ListBySubscription
// method.
func (client *AutoScaleVCoresClient) NewListBySubscriptionPager(options *AutoScaleVCoresClientListBySubscriptionOptions) *runtime.Pager[AutoScaleVCoresClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[AutoScaleVCoresClientListBySubscriptionResponse]{
		More: func(page AutoScaleVCoresClientListBySubscriptionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *AutoScaleVCoresClientListBySubscriptionResponse) (AutoScaleVCoresClientListBySubscriptionResponse, error) {
			req, err := client.listBySubscriptionCreateRequest(ctx, options)
			if err != nil {
				return AutoScaleVCoresClientListBySubscriptionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AutoScaleVCoresClientListBySubscriptionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AutoScaleVCoresClientListBySubscriptionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *AutoScaleVCoresClient) listBySubscriptionCreateRequest(ctx context.Context, options *AutoScaleVCoresClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PowerBIDedicated/autoScaleVCores"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *AutoScaleVCoresClient) listBySubscriptionHandleResponse(resp *http.Response) (AutoScaleVCoresClientListBySubscriptionResponse, error) {
	result := AutoScaleVCoresClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AutoScaleVCoreListResult); err != nil {
		return AutoScaleVCoresClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Update - Updates the current state of the specified auto scale v-core.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-01-01
// resourceGroupName - The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name
// must be at least 1 character in length, and no more than 90.
// vcoreName - The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
// vCoreUpdateParameters - Request object that contains the updated information for the auto scale v-core.
// options - AutoScaleVCoresClientUpdateOptions contains the optional parameters for the AutoScaleVCoresClient.Update method.
func (client *AutoScaleVCoresClient) Update(ctx context.Context, resourceGroupName string, vcoreName string, vCoreUpdateParameters AutoScaleVCoreUpdateParameters, options *AutoScaleVCoresClientUpdateOptions) (AutoScaleVCoresClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, vcoreName, vCoreUpdateParameters, options)
	if err != nil {
		return AutoScaleVCoresClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AutoScaleVCoresClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AutoScaleVCoresClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *AutoScaleVCoresClient) updateCreateRequest(ctx context.Context, resourceGroupName string, vcoreName string, vCoreUpdateParameters AutoScaleVCoreUpdateParameters, options *AutoScaleVCoresClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if vcoreName == "" {
		return nil, errors.New("parameter vcoreName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vcoreName}", url.PathEscape(vcoreName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, vCoreUpdateParameters)
}

// updateHandleResponse handles the Update response.
func (client *AutoScaleVCoresClient) updateHandleResponse(resp *http.Response) (AutoScaleVCoresClientUpdateResponse, error) {
	result := AutoScaleVCoresClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AutoScaleVCore); err != nil {
		return AutoScaleVCoresClientUpdateResponse{}, err
	}
	return result, nil
}
