//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicessiterecovery

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type A2AAddDisksInput.
func (a A2AAddDisksInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AAddDisksInput.
func (a *A2AAddDisksInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AApplyRecoveryPointInput.
func (a A2AApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AApplyRecoveryPointInput.
func (a *A2AApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AContainerCreationInput.
func (a A2AContainerCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AContainerCreationInput.
func (a *A2AContainerCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AContainerMappingInput.
func (a A2AContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AContainerMappingInput.
func (a *A2AContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACreateProtectionIntentInput.
func (a A2ACreateProtectionIntentInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "autoProtectionOfDataDisk", a.AutoProtectionOfDataDisk)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmGroupId", a.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", a.MultiVMGroupName)
	populate(objectMap, "primaryLocation", a.PrimaryLocation)
	populate(objectMap, "primaryStagingStorageAccountCustomInput", a.PrimaryStagingStorageAccountCustomInput)
	populate(objectMap, "protectionProfileCustomInput", a.ProtectionProfileCustomInput)
	populate(objectMap, "recoveryAvailabilitySetCustomInput", a.RecoveryAvailabilitySetCustomInput)
	populate(objectMap, "recoveryAvailabilityType", a.RecoveryAvailabilityType)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryBootDiagStorageAccount", a.RecoveryBootDiagStorageAccount)
	populate(objectMap, "recoveryLocation", a.RecoveryLocation)
	populate(objectMap, "recoveryProximityPlacementGroupCustomInput", a.RecoveryProximityPlacementGroupCustomInput)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoverySubscriptionId", a.RecoverySubscriptionID)
	populate(objectMap, "recoveryVirtualNetworkCustomInput", a.RecoveryVirtualNetworkCustomInput)
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACreateProtectionIntentInput.
func (a *A2ACreateProtectionIntentInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "autoProtectionOfDataDisk":
			err = unpopulate(val, "AutoProtectionOfDataDisk", &a.AutoProtectionOfDataDisk)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "primaryLocation":
			err = unpopulate(val, "PrimaryLocation", &a.PrimaryLocation)
			delete(rawMsg, key)
		case "primaryStagingStorageAccountCustomInput":
			a.PrimaryStagingStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "protectionProfileCustomInput":
			a.ProtectionProfileCustomInput, err = unmarshalProtectionProfileCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetCustomInput":
			a.RecoveryAvailabilitySetCustomInput, err = unmarshalRecoveryAvailabilitySetCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilityType":
			err = unpopulate(val, "RecoveryAvailabilityType", &a.RecoveryAvailabilityType)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccount":
			a.RecoveryBootDiagStorageAccount, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryLocation":
			err = unpopulate(val, "RecoveryLocation", &a.RecoveryLocation)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupCustomInput":
			a.RecoveryProximityPlacementGroupCustomInput, err = unmarshalRecoveryProximityPlacementGroupCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoverySubscriptionId":
			err = unpopulate(val, "RecoverySubscriptionID", &a.RecoverySubscriptionID)
			delete(rawMsg, key)
		case "recoveryVirtualNetworkCustomInput":
			a.RecoveryVirtualNetworkCustomInput, err = unmarshalRecoveryVirtualNetworkCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationApplyRecoveryPointInput.
func (a A2ACrossClusterMigrationApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationApplyRecoveryPointInput.
func (a *A2ACrossClusterMigrationApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationContainerCreationInput.
func (a A2ACrossClusterMigrationContainerCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationContainerCreationInput.
func (a *A2ACrossClusterMigrationContainerCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationEnableProtectionInput.
func (a A2ACrossClusterMigrationEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationEnableProtectionInput.
func (a *A2ACrossClusterMigrationEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ACrossClusterMigrationPolicyCreationInput.
func (a A2ACrossClusterMigrationPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2ACrossClusterMigration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationPolicyCreationInput.
func (a *A2ACrossClusterMigrationPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ACrossClusterMigrationReplicationDetails.
func (a *A2ACrossClusterMigrationReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "lifecycleId":
			err = unpopulate(val, "LifecycleID", &a.LifecycleID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "primaryFabricLocation":
			err = unpopulate(val, "PrimaryFabricLocation", &a.PrimaryFabricLocation)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &a.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &a.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AEnableProtectionInput.
func (a A2AEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "fabricObjectId", a.FabricObjectID)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmGroupId", a.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", a.MultiVMGroupName)
	populate(objectMap, "recoveryAvailabilitySetId", a.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryAzureNetworkId", a.RecoveryAzureNetworkID)
	populate(objectMap, "recoveryBootDiagStorageAccountId", a.RecoveryBootDiagStorageAccountID)
	populate(objectMap, "recoveryCapacityReservationGroupId", a.RecoveryCapacityReservationGroupID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	populate(objectMap, "recoveryExtendedLocation", a.RecoveryExtendedLocation)
	populate(objectMap, "recoveryProximityPlacementGroupId", a.RecoveryProximityPlacementGroupID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoverySubnetName", a.RecoverySubnetName)
	populate(objectMap, "recoveryVirtualMachineScaleSetId", a.RecoveryVirtualMachineScaleSetID)
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AEnableProtectionInput.
func (a *A2AEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &a.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryAzureNetworkId":
			err = unpopulate(val, "RecoveryAzureNetworkID", &a.RecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &a.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoverySubnetName":
			err = unpopulate(val, "RecoverySubnetName", &a.RecoverySubnetName)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AEventDetails.
func (a *A2AEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricLocation":
			err = unpopulate(val, "FabricLocation", &a.FabricLocation)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &a.FabricName)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "protectedItemName":
			err = unpopulate(val, "ProtectedItemName", &a.ProtectedItemName)
			delete(rawMsg, key)
		case "remoteFabricLocation":
			err = unpopulate(val, "RemoteFabricLocation", &a.RemoteFabricLocation)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &a.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2APolicyCreationInput.
func (a A2APolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appConsistentFrequencyInMinutes", a.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", a.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmSyncStatus", a.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", a.RecoveryPointHistory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2APolicyCreationInput.
func (a *A2APolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &a.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &a.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &a.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &a.RecoveryPointHistory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2APolicyDetails.
func (a *A2APolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &a.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &a.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &a.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &a.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &a.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectionContainerMappingDetails.
func (a *A2AProtectionContainerMappingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "jobScheduleName":
			err = unpopulate(val, "JobScheduleName", &a.JobScheduleName)
			delete(rawMsg, key)
		case "scheduleName":
			err = unpopulate(val, "ScheduleName", &a.ScheduleName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AProtectionIntentDiskInputDetails.
func (a A2AProtectionIntentDiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskUri", a.DiskURI)
	populate(objectMap, "primaryStagingStorageAccountCustomInput", a.PrimaryStagingStorageAccountCustomInput)
	populate(objectMap, "recoveryAzureStorageAccountCustomInput", a.RecoveryAzureStorageAccountCustomInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectionIntentDiskInputDetails.
func (a *A2AProtectionIntentDiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskUri":
			err = unpopulate(val, "DiskURI", &a.DiskURI)
			delete(rawMsg, key)
		case "primaryStagingStorageAccountCustomInput":
			a.PrimaryStagingStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccountCustomInput":
			a.RecoveryAzureStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AProtectionIntentManagedDiskInputDetails.
func (a A2AProtectionIntentManagedDiskInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	populate(objectMap, "diskId", a.DiskID)
	populate(objectMap, "primaryStagingStorageAccountCustomInput", a.PrimaryStagingStorageAccountCustomInput)
	populate(objectMap, "recoveryDiskEncryptionSetId", a.RecoveryDiskEncryptionSetID)
	populate(objectMap, "recoveryReplicaDiskAccountType", a.RecoveryReplicaDiskAccountType)
	populate(objectMap, "recoveryResourceGroupCustomInput", a.RecoveryResourceGroupCustomInput)
	populate(objectMap, "recoveryTargetDiskAccountType", a.RecoveryTargetDiskAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AProtectionIntentManagedDiskInputDetails.
func (a *A2AProtectionIntentManagedDiskInputDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &a.DiskID)
			delete(rawMsg, key)
		case "primaryStagingStorageAccountCustomInput":
			a.PrimaryStagingStorageAccountCustomInput, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryDiskEncryptionSetId":
			err = unpopulate(val, "RecoveryDiskEncryptionSetID", &a.RecoveryDiskEncryptionSetID)
			delete(rawMsg, key)
		case "recoveryReplicaDiskAccountType":
			err = unpopulate(val, "RecoveryReplicaDiskAccountType", &a.RecoveryReplicaDiskAccountType)
			delete(rawMsg, key)
		case "recoveryResourceGroupCustomInput":
			a.RecoveryResourceGroupCustomInput, err = unmarshalRecoveryResourceGroupCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryTargetDiskAccountType":
			err = unpopulate(val, "RecoveryTargetDiskAccountType", &a.RecoveryTargetDiskAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ARecoveryPointDetails.
func (a *A2ARecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disks":
			err = unpopulate(val, "Disks", &a.Disks)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointSyncType":
			err = unpopulate(val, "RecoveryPointSyncType", &a.RecoveryPointSyncType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ARemoveDisksInput.
func (a A2ARemoveDisksInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "vmDisksUris", a.VMDisksUris)
	populate(objectMap, "vmManagedDisksIds", a.VMManagedDisksIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ARemoveDisksInput.
func (a *A2ARemoveDisksInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "vmDisksUris":
			err = unpopulate(val, "VMDisksUris", &a.VMDisksUris)
			delete(rawMsg, key)
		case "vmManagedDisksIds":
			err = unpopulate(val, "VMManagedDisksIDs", &a.VMManagedDisksIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AReplicationDetails.
func (a *A2AReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentCertificateExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentCertificateExpiryDate", &a.AgentCertificateExpiryDate)
			delete(rawMsg, key)
		case "agentExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentExpiryDate", &a.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &a.AgentVersion)
			delete(rawMsg, key)
		case "autoProtectionOfDataDisk":
			err = unpopulate(val, "AutoProtectionOfDataDisk", &a.AutoProtectionOfDataDisk)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "initialPrimaryExtendedLocation":
			err = unpopulate(val, "InitialPrimaryExtendedLocation", &a.InitialPrimaryExtendedLocation)
			delete(rawMsg, key)
		case "initialPrimaryFabricLocation":
			err = unpopulate(val, "InitialPrimaryFabricLocation", &a.InitialPrimaryFabricLocation)
			delete(rawMsg, key)
		case "initialPrimaryZone":
			err = unpopulate(val, "InitialPrimaryZone", &a.InitialPrimaryZone)
			delete(rawMsg, key)
		case "initialRecoveryExtendedLocation":
			err = unpopulate(val, "InitialRecoveryExtendedLocation", &a.InitialRecoveryExtendedLocation)
			delete(rawMsg, key)
		case "initialRecoveryFabricLocation":
			err = unpopulate(val, "InitialRecoveryFabricLocation", &a.InitialRecoveryFabricLocation)
			delete(rawMsg, key)
		case "initialRecoveryZone":
			err = unpopulate(val, "InitialRecoveryZone", &a.InitialRecoveryZone)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "isReplicationAgentCertificateUpdateRequired":
			err = unpopulate(val, "IsReplicationAgentCertificateUpdateRequired", &a.IsReplicationAgentCertificateUpdateRequired)
			delete(rawMsg, key)
		case "isReplicationAgentUpdateRequired":
			err = unpopulate(val, "IsReplicationAgentUpdateRequired", &a.IsReplicationAgentUpdateRequired)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateTimeRFC3339(val, "LastHeartbeat", &a.LastHeartbeat)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateTimeRFC3339(val, "LastRpoCalculatedTime", &a.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lifecycleId":
			err = unpopulate(val, "LifecycleID", &a.LifecycleID)
			delete(rawMsg, key)
		case "managementId":
			err = unpopulate(val, "ManagementID", &a.ManagementID)
			delete(rawMsg, key)
		case "monitoringJobType":
			err = unpopulate(val, "MonitoringJobType", &a.MonitoringJobType)
			delete(rawMsg, key)
		case "monitoringPercentageCompletion":
			err = unpopulate(val, "MonitoringPercentageCompletion", &a.MonitoringPercentageCompletion)
			delete(rawMsg, key)
		case "multiVmGroupCreateOption":
			err = unpopulate(val, "MultiVMGroupCreateOption", &a.MultiVMGroupCreateOption)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "primaryAvailabilityZone":
			err = unpopulate(val, "PrimaryAvailabilityZone", &a.PrimaryAvailabilityZone)
			delete(rawMsg, key)
		case "primaryExtendedLocation":
			err = unpopulate(val, "PrimaryExtendedLocation", &a.PrimaryExtendedLocation)
			delete(rawMsg, key)
		case "primaryFabricLocation":
			err = unpopulate(val, "PrimaryFabricLocation", &a.PrimaryFabricLocation)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &a.ProtectedDisks)
			delete(rawMsg, key)
		case "protectedManagedDisks":
			err = unpopulate(val, "ProtectedManagedDisks", &a.ProtectedManagedDisks)
			delete(rawMsg, key)
		case "recoveryAvailabilitySet":
			err = unpopulate(val, "RecoveryAvailabilitySet", &a.RecoveryAvailabilitySet)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryAzureGeneration":
			err = unpopulate(val, "RecoveryAzureGeneration", &a.RecoveryAzureGeneration)
			delete(rawMsg, key)
		case "recoveryAzureResourceGroupId":
			err = unpopulate(val, "RecoveryAzureResourceGroupID", &a.RecoveryAzureResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureVMName":
			err = unpopulate(val, "RecoveryAzureVMName", &a.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &a.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudService":
			err = unpopulate(val, "RecoveryCloudService", &a.RecoveryCloudService)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &a.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryFabricLocation":
			err = unpopulate(val, "RecoveryFabricLocation", &a.RecoveryFabricLocation)
			delete(rawMsg, key)
		case "recoveryFabricObjectId":
			err = unpopulate(val, "RecoveryFabricObjectID", &a.RecoveryFabricObjectID)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &a.RpoInSeconds)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &a.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedTfoAzureNetworkId":
			err = unpopulate(val, "SelectedTfoAzureNetworkID", &a.SelectedTfoAzureNetworkID)
			delete(rawMsg, key)
		case "testFailoverRecoveryFabricObjectId":
			err = unpopulate(val, "TestFailoverRecoveryFabricObjectID", &a.TestFailoverRecoveryFabricObjectID)
			delete(rawMsg, key)
		case "tfoAzureVMName":
			err = unpopulate(val, "TfoAzureVMName", &a.TfoAzureVMName)
			delete(rawMsg, key)
		case "unprotectedDisks":
			err = unpopulate(val, "UnprotectedDisks", &a.UnprotectedDisks)
			delete(rawMsg, key)
		case "vmEncryptionType":
			err = unpopulate(val, "VMEncryptionType", &a.VMEncryptionType)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &a.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &a.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &a.VMProtectionStateDescription)
			delete(rawMsg, key)
		case "vmSyncedConfigDetails":
			err = unpopulate(val, "VMSyncedConfigDetails", &a.VMSyncedConfigDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AReplicationIntentDetails.
func (a *A2AReplicationIntentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "autoProtectionOfDataDisk":
			err = unpopulate(val, "AutoProtectionOfDataDisk", &a.AutoProtectionOfDataDisk)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &a.FabricObjectID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &a.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &a.MultiVMGroupName)
			delete(rawMsg, key)
		case "primaryLocation":
			err = unpopulate(val, "PrimaryLocation", &a.PrimaryLocation)
			delete(rawMsg, key)
		case "primaryStagingStorageAccount":
			a.PrimaryStagingStorageAccount, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "protectionProfile":
			a.ProtectionProfile, err = unmarshalProtectionProfileCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilitySet":
			a.RecoveryAvailabilitySet, err = unmarshalRecoveryAvailabilitySetCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilityType":
			err = unpopulate(val, "RecoveryAvailabilityType", &a.RecoveryAvailabilityType)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccount":
			a.RecoveryBootDiagStorageAccount, err = unmarshalStorageAccountCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryLocation":
			err = unpopulate(val, "RecoveryLocation", &a.RecoveryLocation)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroup":
			a.RecoveryProximityPlacementGroup, err = unmarshalRecoveryProximityPlacementGroupCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoverySubscriptionId":
			err = unpopulate(val, "RecoverySubscriptionID", &a.RecoverySubscriptionID)
			delete(rawMsg, key)
		case "recoveryVirtualNetwork":
			a.RecoveryVirtualNetwork, err = unmarshalRecoveryVirtualNetworkCustomDetailsClassification(val)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AReprotectInput.
func (a A2AReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "recoveryAvailabilitySetId", a.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "vmDisks", a.VMDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AReprotectInput.
func (a *A2AReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &a.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ASwitchProtectionInput.
func (a A2ASwitchProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "policyId", a.PolicyID)
	populate(objectMap, "recoveryAvailabilitySetId", a.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAvailabilityZone", a.RecoveryAvailabilityZone)
	populate(objectMap, "recoveryBootDiagStorageAccountId", a.RecoveryBootDiagStorageAccountID)
	populate(objectMap, "recoveryCapacityReservationGroupId", a.RecoveryCapacityReservationGroupID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryContainerId", a.RecoveryContainerID)
	populate(objectMap, "recoveryProximityPlacementGroupId", a.RecoveryProximityPlacementGroupID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoveryVirtualMachineScaleSetId", a.RecoveryVirtualMachineScaleSetID)
	populate(objectMap, "vmDisks", a.VMDisks)
	populate(objectMap, "vmManagedDisks", a.VMManagedDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ASwitchProtectionInput.
func (a *A2ASwitchProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &a.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAvailabilityZone":
			err = unpopulate(val, "RecoveryAvailabilityZone", &a.RecoveryAvailabilityZone)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &a.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &a.VMDisks)
			delete(rawMsg, key)
		case "vmManagedDisks":
			err = unpopulate(val, "VMManagedDisks", &a.VMManagedDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2ATestFailoverInput.
func (a A2ATestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudServiceCreationOption", a.CloudServiceCreationOption)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2ATestFailoverInput.
func (a *A2ATestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudServiceCreationOption":
			err = unpopulate(val, "CloudServiceCreationOption", &a.CloudServiceCreationOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AUnplannedFailoverInput.
func (a A2AUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudServiceCreationOption", a.CloudServiceCreationOption)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AUnplannedFailoverInput.
func (a *A2AUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudServiceCreationOption":
			err = unpopulate(val, "CloudServiceCreationOption", &a.CloudServiceCreationOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AUpdateContainerMappingInput.
func (a A2AUpdateContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentAutoUpdateStatus", a.AgentAutoUpdateStatus)
	populate(objectMap, "automationAccountArmId", a.AutomationAccountArmID)
	populate(objectMap, "automationAccountAuthenticationType", a.AutomationAccountAuthenticationType)
	objectMap["instanceType"] = "A2A"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AUpdateContainerMappingInput.
func (a *A2AUpdateContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentAutoUpdateStatus":
			err = unpopulate(val, "AgentAutoUpdateStatus", &a.AgentAutoUpdateStatus)
			delete(rawMsg, key)
		case "automationAccountArmId":
			err = unpopulate(val, "AutomationAccountArmID", &a.AutomationAccountArmID)
			delete(rawMsg, key)
		case "automationAccountAuthenticationType":
			err = unpopulate(val, "AutomationAccountAuthenticationType", &a.AutomationAccountAuthenticationType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type A2AUpdateReplicationProtectedItemInput.
func (a A2AUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskEncryptionInfo", a.DiskEncryptionInfo)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "managedDiskUpdateDetails", a.ManagedDiskUpdateDetails)
	populate(objectMap, "recoveryBootDiagStorageAccountId", a.RecoveryBootDiagStorageAccountID)
	populate(objectMap, "recoveryCapacityReservationGroupId", a.RecoveryCapacityReservationGroupID)
	populate(objectMap, "recoveryCloudServiceId", a.RecoveryCloudServiceID)
	populate(objectMap, "recoveryProximityPlacementGroupId", a.RecoveryProximityPlacementGroupID)
	populate(objectMap, "recoveryResourceGroupId", a.RecoveryResourceGroupID)
	populate(objectMap, "recoveryVirtualMachineScaleSetId", a.RecoveryVirtualMachineScaleSetID)
	populate(objectMap, "tfoAzureVMName", a.TfoAzureVMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type A2AUpdateReplicationProtectedItemInput.
func (a *A2AUpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionInfo":
			err = unpopulate(val, "DiskEncryptionInfo", &a.DiskEncryptionInfo)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "managedDiskUpdateDetails":
			err = unpopulate(val, "ManagedDiskUpdateDetails", &a.ManagedDiskUpdateDetails)
			delete(rawMsg, key)
		case "recoveryBootDiagStorageAccountId":
			err = unpopulate(val, "RecoveryBootDiagStorageAccountID", &a.RecoveryBootDiagStorageAccountID)
			delete(rawMsg, key)
		case "recoveryCapacityReservationGroupId":
			err = unpopulate(val, "RecoveryCapacityReservationGroupID", &a.RecoveryCapacityReservationGroupID)
			delete(rawMsg, key)
		case "recoveryCloudServiceId":
			err = unpopulate(val, "RecoveryCloudServiceID", &a.RecoveryCloudServiceID)
			delete(rawMsg, key)
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &a.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &a.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "recoveryVirtualMachineScaleSetId":
			err = unpopulate(val, "RecoveryVirtualMachineScaleSetID", &a.RecoveryVirtualMachineScaleSetID)
			delete(rawMsg, key)
		case "tfoAzureVMName":
			err = unpopulate(val, "TfoAzureVMName", &a.TfoAzureVMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ASRTask.
func (a *ASRTask) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedActions":
			err = unpopulate(val, "AllowedActions", &a.AllowedActions)
			delete(rawMsg, key)
		case "customDetails":
			a.CustomDetails, err = unmarshalTaskTypeDetailsClassification(val)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &a.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &a.Errors)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &a.FriendlyName)
			delete(rawMsg, key)
		case "groupTaskCustomDetails":
			a.GroupTaskCustomDetails, err = unmarshalGroupTaskDetailsClassification(val)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &a.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "stateDescription":
			err = unpopulate(val, "StateDescription", &a.StateDescription)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &a.TaskID)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &a.TaskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddDisksInputProperties.
func (a AddDisksInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", a.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddDisksInputProperties.
func (a *AddDisksInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			a.ProviderSpecificDetails, err = unmarshalAddDisksProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplyRecoveryPointInputProperties.
func (a ApplyRecoveryPointInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", a.ProviderSpecificDetails)
	populate(objectMap, "recoveryPointId", a.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplyRecoveryPointInputProperties.
func (a *ApplyRecoveryPointInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			a.ProviderSpecificDetails, err = unmarshalApplyRecoveryPointProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &a.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsrJobDetails.
func (a *AsrJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &a.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutomationRunbookTaskDetails.
func (a *AutomationRunbookTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "cloudServiceName":
			err = unpopulate(val, "CloudServiceName", &a.CloudServiceName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "isPrimarySideScript":
			err = unpopulate(val, "IsPrimarySideScript", &a.IsPrimarySideScript)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "jobOutput":
			err = unpopulate(val, "JobOutput", &a.JobOutput)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "runbookId":
			err = unpopulate(val, "RunbookID", &a.RunbookID)
			delete(rawMsg, key)
		case "runbookName":
			err = unpopulate(val, "RunbookName", &a.RunbookName)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFabricCreationInput.
func (a AzureFabricCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "Azure"
	populate(objectMap, "location", a.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFabricCreationInput.
func (a *AzureFabricCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFabricSpecificDetails.
func (a *AzureFabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerIds":
			err = unpopulate(val, "ContainerIDs", &a.ContainerIDs)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &a.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureToAzureCreateNetworkMappingInput.
func (a AzureToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "AzureToAzure"
	populate(objectMap, "primaryNetworkId", a.PrimaryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureToAzureCreateNetworkMappingInput.
func (a *AzureToAzureCreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "primaryNetworkId":
			err = unpopulate(val, "PrimaryNetworkID", &a.PrimaryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureToAzureNetworkMappingSettings.
func (a *AzureToAzureNetworkMappingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "primaryFabricLocation":
			err = unpopulate(val, "PrimaryFabricLocation", &a.PrimaryFabricLocation)
			delete(rawMsg, key)
		case "recoveryFabricLocation":
			err = unpopulate(val, "RecoveryFabricLocation", &a.RecoveryFabricLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureToAzureUpdateNetworkMappingInput.
func (a AzureToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "AzureToAzure"
	populate(objectMap, "primaryNetworkId", a.PrimaryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureToAzureUpdateNetworkMappingInput.
func (a *AzureToAzureUpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "primaryNetworkId":
			err = unpopulate(val, "PrimaryNetworkID", &a.PrimaryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigureAlertRequestProperties.
func (c ConfigureAlertRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customEmailAddresses", c.CustomEmailAddresses)
	populate(objectMap, "locale", c.Locale)
	populate(objectMap, "sendToOwners", c.SendToOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConsistencyCheckTaskDetails.
func (c *ConsistencyCheckTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &c.InstanceType)
			delete(rawMsg, key)
		case "vmDetails":
			err = unpopulate(val, "VMDetails", &c.VMDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateNetworkMappingInputProperties.
func (c CreateNetworkMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fabricSpecificDetails", c.FabricSpecificDetails)
	populate(objectMap, "recoveryFabricName", c.RecoveryFabricName)
	populate(objectMap, "recoveryNetworkId", c.RecoveryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateNetworkMappingInputProperties.
func (c *CreateNetworkMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricSpecificDetails":
			c.FabricSpecificDetails, err = unmarshalFabricSpecificCreateNetworkMappingInputClassification(val)
			delete(rawMsg, key)
		case "recoveryFabricName":
			err = unpopulate(val, "RecoveryFabricName", &c.RecoveryFabricName)
			delete(rawMsg, key)
		case "recoveryNetworkId":
			err = unpopulate(val, "RecoveryNetworkID", &c.RecoveryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreatePolicyInputProperties.
func (c CreatePolicyInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreatePolicyInputProperties.
func (c *CreatePolicyInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalPolicyProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionContainerInputProperties.
func (c CreateProtectionContainerInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionContainerInputProperties.
func (c *CreateProtectionContainerInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalReplicationProviderSpecificContainerCreationInputClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionContainerMappingInputProperties.
func (c CreateProtectionContainerMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "policyId", c.PolicyID)
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	populate(objectMap, "targetProtectionContainerId", c.TargetProtectionContainerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionContainerMappingInputProperties.
func (c *CreateProtectionContainerMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyId":
			err = unpopulate(val, "PolicyID", &c.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalReplicationProviderSpecificContainerMappingInputClassification(val)
			delete(rawMsg, key)
		case "targetProtectionContainerId":
			err = unpopulate(val, "TargetProtectionContainerID", &c.TargetProtectionContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateProtectionIntentProperties.
func (c CreateProtectionIntentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", c.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateProtectionIntentProperties.
func (c *CreateProtectionIntentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			c.ProviderSpecificDetails, err = unmarshalCreateProtectionIntentProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateRecoveryPlanInputProperties.
func (c CreateRecoveryPlanInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDeploymentModel", c.FailoverDeploymentModel)
	populate(objectMap, "groups", c.Groups)
	populate(objectMap, "primaryFabricId", c.PrimaryFabricID)
	populate(objectMap, "providerSpecificInput", c.ProviderSpecificInput)
	populate(objectMap, "recoveryFabricId", c.RecoveryFabricID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateRecoveryPlanInputProperties.
func (c *CreateRecoveryPlanInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDeploymentModel":
			err = unpopulate(val, "FailoverDeploymentModel", &c.FailoverDeploymentModel)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &c.Groups)
			delete(rawMsg, key)
		case "primaryFabricId":
			err = unpopulate(val, "PrimaryFabricID", &c.PrimaryFabricID)
			delete(rawMsg, key)
		case "providerSpecificInput":
			c.ProviderSpecificInput, err = unmarshalRecoveryPlanProviderSpecificInputClassificationArray(val)
			delete(rawMsg, key)
		case "recoveryFabricId":
			err = unpopulate(val, "RecoveryFabricID", &c.RecoveryFabricID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CurrentJobDetails.
func (c *CurrentJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &c.JobID)
			delete(rawMsg, key)
		case "jobName":
			err = unpopulate(val, "JobName", &c.JobName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CurrentScenarioDetails.
func (c *CurrentScenarioDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &c.JobID)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &c.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DisableProtectionInputProperties.
func (d DisableProtectionInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableProtectionReason", d.DisableProtectionReason)
	populate(objectMap, "replicationProviderInput", d.ReplicationProviderInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DisableProtectionInputProperties.
func (d *DisableProtectionInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableProtectionReason":
			err = unpopulate(val, "DisableProtectionReason", &d.DisableProtectionReason)
			delete(rawMsg, key)
		case "replicationProviderInput":
			d.ReplicationProviderInput, err = unmarshalDisableProtectionProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DraDetails.
func (d *DraDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &d.BiosID)
			delete(rawMsg, key)
		case "forwardProtectedItemCount":
			err = unpopulate(val, "ForwardProtectedItemCount", &d.ForwardProtectedItemCount)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &d.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &d.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &d.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "reverseProtectedItemCount":
			err = unpopulate(val, "ReverseProtectedItemCount", &d.ReverseProtectedItemCount)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableMigrationInputProperties.
func (e EnableMigrationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "policyId", e.PolicyID)
	populate(objectMap, "providerSpecificDetails", e.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableMigrationInputProperties.
func (e *EnableMigrationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyId":
			err = unpopulate(val, "PolicyID", &e.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			e.ProviderSpecificDetails, err = unmarshalEnableMigrationProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnableProtectionInputProperties.
func (e EnableProtectionInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "policyId", e.PolicyID)
	populate(objectMap, "protectableItemId", e.ProtectableItemID)
	populate(objectMap, "providerSpecificDetails", e.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnableProtectionInputProperties.
func (e *EnableProtectionInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyId":
			err = unpopulate(val, "PolicyID", &e.PolicyID)
			delete(rawMsg, key)
		case "protectableItemId":
			err = unpopulate(val, "ProtectableItemID", &e.ProtectableItemID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			e.ProviderSpecificDetails, err = unmarshalEnableProtectionProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionDetails.
func (e *EncryptionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kekCertExpiryDate":
			err = unpopulateTimeRFC3339(val, "KekCertExpiryDate", &e.KekCertExpiryDate)
			delete(rawMsg, key)
		case "kekCertThumbprint":
			err = unpopulate(val, "KekCertThumbprint", &e.KekCertThumbprint)
			delete(rawMsg, key)
		case "kekState":
			err = unpopulate(val, "KekState", &e.KekState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventProperties.
func (e *EventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectCorrelationId":
			err = unpopulate(val, "AffectedObjectCorrelationID", &e.AffectedObjectCorrelationID)
			delete(rawMsg, key)
		case "affectedObjectFriendlyName":
			err = unpopulate(val, "AffectedObjectFriendlyName", &e.AffectedObjectFriendlyName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "eventCode":
			err = unpopulate(val, "EventCode", &e.EventCode)
			delete(rawMsg, key)
		case "eventSpecificDetails":
			e.EventSpecificDetails, err = unmarshalEventSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "fabricId":
			err = unpopulate(val, "FabricID", &e.FabricID)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &e.HealthErrors)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			e.ProviderSpecificDetails, err = unmarshalEventProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &e.Severity)
			delete(rawMsg, key)
		case "timeOfOccurrence":
			err = unpopulateTimeRFC3339(val, "TimeOfOccurrence", &e.TimeOfOccurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventQueryParameter.
func (e *EventQueryParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectCorrelationId":
			err = unpopulate(val, "AffectedObjectCorrelationID", &e.AffectedObjectCorrelationID)
			delete(rawMsg, key)
		case "affectedObjectFriendlyName":
			err = unpopulate(val, "AffectedObjectFriendlyName", &e.AffectedObjectFriendlyName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &e.EndTime)
			delete(rawMsg, key)
		case "eventCode":
			err = unpopulate(val, "EventCode", &e.EventCode)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &e.FabricName)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &e.Severity)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &e.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingProtectionProfile.
func (e ExistingProtectionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "protectionProfileId", e.ProtectionProfileID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingProtectionProfile.
func (e *ExistingProtectionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "protectionProfileId":
			err = unpopulate(val, "ProtectionProfileID", &e.ProtectionProfileID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryAvailabilitySet.
func (e ExistingRecoveryAvailabilitySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recoveryAvailabilitySetId", e.RecoveryAvailabilitySetID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryAvailabilitySet.
func (e *ExistingRecoveryAvailabilitySet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &e.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryProximityPlacementGroup.
func (e ExistingRecoveryProximityPlacementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recoveryProximityPlacementGroupId", e.RecoveryProximityPlacementGroupID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryProximityPlacementGroup.
func (e *ExistingRecoveryProximityPlacementGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryProximityPlacementGroupId":
			err = unpopulate(val, "RecoveryProximityPlacementGroupID", &e.RecoveryProximityPlacementGroupID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryResourceGroup.
func (e ExistingRecoveryResourceGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recoveryResourceGroupId", e.RecoveryResourceGroupID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryResourceGroup.
func (e *ExistingRecoveryResourceGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryResourceGroupId":
			err = unpopulate(val, "RecoveryResourceGroupID", &e.RecoveryResourceGroupID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingRecoveryVirtualNetwork.
func (e ExistingRecoveryVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recoverySubnetName", e.RecoverySubnetName)
	populate(objectMap, "recoveryVirtualNetworkId", e.RecoveryVirtualNetworkID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingRecoveryVirtualNetwork.
func (e *ExistingRecoveryVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoverySubnetName":
			err = unpopulate(val, "RecoverySubnetName", &e.RecoverySubnetName)
			delete(rawMsg, key)
		case "recoveryVirtualNetworkId":
			err = unpopulate(val, "RecoveryVirtualNetworkID", &e.RecoveryVirtualNetworkID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExistingStorageAccount.
func (e ExistingStorageAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureStorageAccountId", e.AzureStorageAccountID)
	objectMap["resourceType"] = "Existing"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExistingStorageAccount.
func (e *ExistingStorageAccount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureStorageAccountId":
			err = unpopulate(val, "AzureStorageAccountID", &e.AzureStorageAccountID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportJobDetails.
func (e *ExportJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &e.AffectedObjectDetails)
			delete(rawMsg, key)
		case "blobUri":
			err = unpopulate(val, "BlobURI", &e.BlobURI)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &e.InstanceType)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &e.SasToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricCreationInputProperties.
func (f FabricCreationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customDetails", f.CustomDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricCreationInputProperties.
func (f *FabricCreationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDetails":
			f.CustomDetails, err = unmarshalFabricSpecificCreationInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricProperties.
func (f *FabricProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bcdrState":
			err = unpopulate(val, "BcdrState", &f.BcdrState)
			delete(rawMsg, key)
		case "customDetails":
			f.CustomDetails, err = unmarshalFabricSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "encryptionDetails":
			err = unpopulate(val, "EncryptionDetails", &f.EncryptionDetails)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &f.FriendlyName)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &f.Health)
			delete(rawMsg, key)
		case "healthErrorDetails":
			err = unpopulate(val, "HealthErrorDetails", &f.HealthErrorDetails)
			delete(rawMsg, key)
		case "internalIdentifier":
			err = unpopulate(val, "InternalIdentifier", &f.InternalIdentifier)
			delete(rawMsg, key)
		case "rolloverEncryptionDetails":
			err = unpopulate(val, "RolloverEncryptionDetails", &f.RolloverEncryptionDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricReplicationGroupTaskDetails.
func (f *FabricReplicationGroupTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		case "jobTask":
			err = unpopulate(val, "JobTask", &f.JobTask)
			delete(rawMsg, key)
		case "skippedReason":
			err = unpopulate(val, "SkippedReason", &f.SkippedReason)
			delete(rawMsg, key)
		case "skippedReasonString":
			err = unpopulate(val, "SkippedReasonString", &f.SkippedReasonString)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverJobDetails.
func (f *FailoverJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &f.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		case "protectedItemDetails":
			err = unpopulate(val, "ProtectedItemDetails", &f.ProtectedItemDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverProcessServerRequestProperties.
func (f FailoverProcessServerRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "containerName", f.ContainerName)
	populate(objectMap, "sourceProcessServerId", f.SourceProcessServerID)
	populate(objectMap, "targetProcessServerId", f.TargetProcessServerID)
	populate(objectMap, "updateType", f.UpdateType)
	populate(objectMap, "vmsToMigrate", f.VMsToMigrate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverReplicationProtectedItemDetails.
func (f *FailoverReplicationProtectedItemDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &f.FriendlyName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "networkConnectionStatus":
			err = unpopulate(val, "NetworkConnectionStatus", &f.NetworkConnectionStatus)
			delete(rawMsg, key)
		case "networkFriendlyName":
			err = unpopulate(val, "NetworkFriendlyName", &f.NetworkFriendlyName)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &f.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &f.RecoveryPointTime)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &f.Subnet)
			delete(rawMsg, key)
		case "testVmFriendlyName":
			err = unpopulate(val, "TestVMFriendlyName", &f.TestVMFriendlyName)
			delete(rawMsg, key)
		case "testVmName":
			err = unpopulate(val, "TestVMName", &f.TestVMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthError.
func (h *HealthError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTimeUtc":
			err = unpopulateTimeRFC3339(val, "CreationTimeUTC", &h.CreationTimeUTC)
			delete(rawMsg, key)
		case "customerResolvability":
			err = unpopulate(val, "CustomerResolvability", &h.CustomerResolvability)
			delete(rawMsg, key)
		case "entityId":
			err = unpopulate(val, "EntityID", &h.EntityID)
			delete(rawMsg, key)
		case "errorCategory":
			err = unpopulate(val, "ErrorCategory", &h.ErrorCategory)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &h.ErrorCode)
			delete(rawMsg, key)
		case "errorId":
			err = unpopulate(val, "ErrorID", &h.ErrorID)
			delete(rawMsg, key)
		case "errorLevel":
			err = unpopulate(val, "ErrorLevel", &h.ErrorLevel)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &h.ErrorMessage)
			delete(rawMsg, key)
		case "errorSource":
			err = unpopulate(val, "ErrorSource", &h.ErrorSource)
			delete(rawMsg, key)
		case "errorType":
			err = unpopulate(val, "ErrorType", &h.ErrorType)
			delete(rawMsg, key)
		case "innerHealthErrors":
			err = unpopulate(val, "InnerHealthErrors", &h.InnerHealthErrors)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &h.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &h.RecommendedAction)
			delete(rawMsg, key)
		case "recoveryProviderErrorMessage":
			err = unpopulate(val, "RecoveryProviderErrorMessage", &h.RecoveryProviderErrorMessage)
			delete(rawMsg, key)
		case "summaryMessage":
			err = unpopulate(val, "SummaryMessage", &h.SummaryMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplica2012EventDetails.
func (h *HyperVReplica2012EventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &h.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplica2012R2EventDetails.
func (h *HyperVReplica2012R2EventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &h.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureApplyRecoveryPointInput.
func (h HyperVReplicaAzureApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureApplyRecoveryPointInput.
func (h *HyperVReplicaAzureApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureEnableProtectionInput.
func (h HyperVReplicaAzureEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskEncryptionSetId", h.DiskEncryptionSetID)
	populate(objectMap, "diskType", h.DiskType)
	populate(objectMap, "disksToInclude", h.DisksToInclude)
	populate(objectMap, "disksToIncludeForManagedDisks", h.DisksToIncludeForManagedDisks)
	populate(objectMap, "enableRdpOnTargetOption", h.EnableRdpOnTargetOption)
	populate(objectMap, "hvHostVmId", h.HvHostVMID)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "licenseType", h.LicenseType)
	populate(objectMap, "logStorageAccountId", h.LogStorageAccountID)
	populate(objectMap, "osType", h.OSType)
	populate(objectMap, "sqlServerLicenseType", h.SQLServerLicenseType)
	populate(objectMap, "seedManagedDiskTags", h.SeedManagedDiskTags)
	populate(objectMap, "targetAvailabilitySetId", h.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", h.TargetAvailabilityZone)
	populate(objectMap, "targetAzureNetworkId", h.TargetAzureNetworkID)
	populate(objectMap, "targetAzureSubnetId", h.TargetAzureSubnetID)
	populate(objectMap, "targetAzureV1ResourceGroupId", h.TargetAzureV1ResourceGroupID)
	populate(objectMap, "targetAzureV2ResourceGroupId", h.TargetAzureV2ResourceGroupID)
	populate(objectMap, "targetAzureVmName", h.TargetAzureVMName)
	populate(objectMap, "targetManagedDiskTags", h.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", h.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", h.TargetProximityPlacementGroupID)
	populate(objectMap, "targetStorageAccountId", h.TargetStorageAccountID)
	populate(objectMap, "targetVmSize", h.TargetVMSize)
	populate(objectMap, "targetVmTags", h.TargetVMTags)
	populate(objectMap, "useManagedDisks", h.UseManagedDisks)
	populate(objectMap, "useManagedDisksForReplication", h.UseManagedDisksForReplication)
	populate(objectMap, "vmName", h.VMName)
	populate(objectMap, "vhdId", h.VhdID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureEnableProtectionInput.
func (h *HyperVReplicaAzureEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &h.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &h.DiskType)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &h.DisksToInclude)
			delete(rawMsg, key)
		case "disksToIncludeForManagedDisks":
			err = unpopulate(val, "DisksToIncludeForManagedDisks", &h.DisksToIncludeForManagedDisks)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &h.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "hvHostVmId":
			err = unpopulate(val, "HvHostVMID", &h.HvHostVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &h.LicenseType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &h.LogStorageAccountID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &h.OSType)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &h.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &h.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &h.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &h.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetAzureNetworkId":
			err = unpopulate(val, "TargetAzureNetworkID", &h.TargetAzureNetworkID)
			delete(rawMsg, key)
		case "targetAzureSubnetId":
			err = unpopulate(val, "TargetAzureSubnetID", &h.TargetAzureSubnetID)
			delete(rawMsg, key)
		case "targetAzureV1ResourceGroupId":
			err = unpopulate(val, "TargetAzureV1ResourceGroupID", &h.TargetAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureV2ResourceGroupId":
			err = unpopulate(val, "TargetAzureV2ResourceGroupID", &h.TargetAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureVmName":
			err = unpopulate(val, "TargetAzureVMName", &h.TargetAzureVMName)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &h.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &h.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &h.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetStorageAccountId":
			err = unpopulate(val, "TargetStorageAccountID", &h.TargetStorageAccountID)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &h.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &h.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &h.UseManagedDisks)
			delete(rawMsg, key)
		case "useManagedDisksForReplication":
			err = unpopulate(val, "UseManagedDisksForReplication", &h.UseManagedDisksForReplication)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &h.VMName)
			delete(rawMsg, key)
		case "vhdId":
			err = unpopulate(val, "VhdID", &h.VhdID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureEventDetails.
func (h *HyperVReplicaAzureEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureFailbackProviderInput.
func (h HyperVReplicaAzureFailbackProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataSyncOption", h.DataSyncOption)
	objectMap["instanceType"] = "HyperVReplicaAzureFailback"
	populate(objectMap, "providerIdForAlternateRecovery", h.ProviderIDForAlternateRecovery)
	populate(objectMap, "recoveryVmCreationOption", h.RecoveryVMCreationOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureFailbackProviderInput.
func (h *HyperVReplicaAzureFailbackProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSyncOption":
			err = unpopulate(val, "DataSyncOption", &h.DataSyncOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "providerIdForAlternateRecovery":
			err = unpopulate(val, "ProviderIDForAlternateRecovery", &h.ProviderIDForAlternateRecovery)
			delete(rawMsg, key)
		case "recoveryVmCreationOption":
			err = unpopulate(val, "RecoveryVMCreationOption", &h.RecoveryVMCreationOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzurePlannedFailoverProviderInput.
func (h HyperVReplicaAzurePlannedFailoverProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointId", h.RecoveryPointID)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzurePlannedFailoverProviderInput.
func (h *HyperVReplicaAzurePlannedFailoverProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &h.RecoveryPointID)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzurePolicyDetails.
func (h *HyperVReplicaAzurePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeStorageAccountId":
			err = unpopulate(val, "ActiveStorageAccountID", &h.ActiveStorageAccountID)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &h.Encryption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPointHistoryDurationInHours":
			err = unpopulate(val, "RecoveryPointHistoryDurationInHours", &h.RecoveryPointHistoryDurationInHours)
			delete(rawMsg, key)
		case "replicationInterval":
			err = unpopulate(val, "ReplicationInterval", &h.ReplicationInterval)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzurePolicyInput.
func (h HyperVReplicaAzurePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPointHistoryDuration", h.RecoveryPointHistoryDuration)
	populate(objectMap, "replicationInterval", h.ReplicationInterval)
	populate(objectMap, "storageAccounts", h.StorageAccounts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzurePolicyInput.
func (h *HyperVReplicaAzurePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPointHistoryDuration":
			err = unpopulate(val, "RecoveryPointHistoryDuration", &h.RecoveryPointHistoryDuration)
			delete(rawMsg, key)
		case "replicationInterval":
			err = unpopulate(val, "ReplicationInterval", &h.ReplicationInterval)
			delete(rawMsg, key)
		case "storageAccounts":
			err = unpopulate(val, "StorageAccounts", &h.StorageAccounts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureReplicationDetails.
func (h *HyperVReplicaAzureReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureVmDiskDetails":
			err = unpopulate(val, "AzureVMDiskDetails", &h.AzureVMDiskDetails)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &h.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &h.Encryption)
			delete(rawMsg, key)
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPointReceived", &h.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateTimeRFC3339(val, "LastRpoCalculatedTime", &h.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &h.LicenseType)
			delete(rawMsg, key)
		case "oSDetails":
			err = unpopulate(val, "OSDetails", &h.OSDetails)
			delete(rawMsg, key)
		case "protectedManagedDisks":
			err = unpopulate(val, "ProtectedManagedDisks", &h.ProtectedManagedDisks)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &h.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAzureLogStorageAccountId":
			err = unpopulate(val, "RecoveryAzureLogStorageAccountID", &h.RecoveryAzureLogStorageAccountID)
			delete(rawMsg, key)
		case "recoveryAzureResourceGroupId":
			err = unpopulate(val, "RecoveryAzureResourceGroupID", &h.RecoveryAzureResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccount":
			err = unpopulate(val, "RecoveryAzureStorageAccount", &h.RecoveryAzureStorageAccount)
			delete(rawMsg, key)
		case "recoveryAzureVmName":
			err = unpopulate(val, "RecoveryAzureVMName", &h.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &h.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &h.RpoInSeconds)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &h.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &h.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &h.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedSourceNicId":
			err = unpopulate(val, "SelectedSourceNicID", &h.SelectedSourceNicID)
			delete(rawMsg, key)
		case "sourceVmCpuCount":
			err = unpopulate(val, "SourceVMCPUCount", &h.SourceVMCPUCount)
			delete(rawMsg, key)
		case "sourceVmRamSizeInMB":
			err = unpopulate(val, "SourceVMRAMSizeInMB", &h.SourceVMRAMSizeInMB)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &h.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &h.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &h.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &h.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &h.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &h.UseManagedDisks)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureReprotectInput.
func (h HyperVReplicaAzureReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hvHostVmId", h.HvHostVMID)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "logStorageAccountId", h.LogStorageAccountID)
	populate(objectMap, "osType", h.OSType)
	populate(objectMap, "storageAccountId", h.StorageAccountID)
	populate(objectMap, "vHDId", h.VHDID)
	populate(objectMap, "vmName", h.VMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureReprotectInput.
func (h *HyperVReplicaAzureReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hvHostVmId":
			err = unpopulate(val, "HvHostVMID", &h.HvHostVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &h.LogStorageAccountID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &h.OSType)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &h.StorageAccountID)
			delete(rawMsg, key)
		case "vHDId":
			err = unpopulate(val, "VHDID", &h.VHDID)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &h.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureTestFailoverInput.
func (h HyperVReplicaAzureTestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointId", h.RecoveryPointID)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureTestFailoverInput.
func (h *HyperVReplicaAzureTestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &h.RecoveryPointID)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureUnplannedFailoverInput.
func (h HyperVReplicaAzureUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", h.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointId", h.RecoveryPointID)
	populate(objectMap, "secondaryKekCertificatePfx", h.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureUnplannedFailoverInput.
func (h *HyperVReplicaAzureUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &h.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &h.RecoveryPointID)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &h.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (h HyperVReplicaAzureUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskIdToDiskEncryptionMap", h.DiskIDToDiskEncryptionMap)
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "recoveryAzureV1ResourceGroupId", h.RecoveryAzureV1ResourceGroupID)
	populate(objectMap, "recoveryAzureV2ResourceGroupId", h.RecoveryAzureV2ResourceGroupID)
	populate(objectMap, "sqlServerLicenseType", h.SQLServerLicenseType)
	populate(objectMap, "targetAvailabilityZone", h.TargetAvailabilityZone)
	populate(objectMap, "targetManagedDiskTags", h.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", h.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", h.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmTags", h.TargetVMTags)
	populate(objectMap, "useManagedDisks", h.UseManagedDisks)
	populate(objectMap, "vmDisks", h.VMDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (h *HyperVReplicaAzureUpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskIdToDiskEncryptionMap":
			err = unpopulate(val, "DiskIDToDiskEncryptionMap", &h.DiskIDToDiskEncryptionMap)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "recoveryAzureV1ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV1ResourceGroupID", &h.RecoveryAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureV2ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV2ResourceGroupID", &h.RecoveryAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &h.SQLServerLicenseType)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &h.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &h.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &h.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &h.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &h.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &h.UseManagedDisks)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &h.VMDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBaseEventDetails.
func (h *HyperVReplicaBaseEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerName":
			err = unpopulate(val, "ContainerName", &h.ContainerName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &h.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "remoteContainerName":
			err = unpopulate(val, "RemoteContainerName", &h.RemoteContainerName)
			delete(rawMsg, key)
		case "remoteFabricName":
			err = unpopulate(val, "RemoteFabricName", &h.RemoteFabricName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBasePolicyDetails.
func (h *HyperVReplicaBasePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletionOption":
			err = unpopulate(val, "ReplicaDeletionOption", &h.ReplicaDeletionOption)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBaseReplicationDetails.
func (h *HyperVReplicaBaseReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "vMDiskDetails":
			err = unpopulate(val, "VMDiskDetails", &h.VMDiskDetails)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBluePolicyDetails.
func (h *HyperVReplicaBluePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletionOption":
			err = unpopulate(val, "ReplicaDeletionOption", &h.ReplicaDeletionOption)
			delete(rawMsg, key)
		case "replicationFrequencyInSeconds":
			err = unpopulate(val, "ReplicationFrequencyInSeconds", &h.ReplicationFrequencyInSeconds)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaBluePolicyInput.
func (h HyperVReplicaBluePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedAuthenticationType", h.AllowedAuthenticationType)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "initialReplicationMethod", h.InitialReplicationMethod)
	objectMap["instanceType"] = "HyperVReplica2012R2"
	populate(objectMap, "offlineReplicationExportPath", h.OfflineReplicationExportPath)
	populate(objectMap, "offlineReplicationImportPath", h.OfflineReplicationImportPath)
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPoints", h.RecoveryPoints)
	populate(objectMap, "replicaDeletion", h.ReplicaDeletion)
	populate(objectMap, "replicationFrequencyInSeconds", h.ReplicationFrequencyInSeconds)
	populate(objectMap, "replicationPort", h.ReplicationPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBluePolicyInput.
func (h *HyperVReplicaBluePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletion":
			err = unpopulate(val, "ReplicaDeletion", &h.ReplicaDeletion)
			delete(rawMsg, key)
		case "replicationFrequencyInSeconds":
			err = unpopulate(val, "ReplicationFrequencyInSeconds", &h.ReplicationFrequencyInSeconds)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaBlueReplicationDetails.
func (h *HyperVReplicaBlueReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "vMDiskDetails":
			err = unpopulate(val, "VMDiskDetails", &h.VMDiskDetails)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaPolicyDetails.
func (h *HyperVReplicaPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletionOption":
			err = unpopulate(val, "ReplicaDeletionOption", &h.ReplicaDeletionOption)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVReplicaPolicyInput.
func (h HyperVReplicaPolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allowedAuthenticationType", h.AllowedAuthenticationType)
	populate(objectMap, "applicationConsistentSnapshotFrequencyInHours", h.ApplicationConsistentSnapshotFrequencyInHours)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "initialReplicationMethod", h.InitialReplicationMethod)
	objectMap["instanceType"] = "HyperVReplica2012"
	populate(objectMap, "offlineReplicationExportPath", h.OfflineReplicationExportPath)
	populate(objectMap, "offlineReplicationImportPath", h.OfflineReplicationImportPath)
	populate(objectMap, "onlineReplicationStartTime", h.OnlineReplicationStartTime)
	populate(objectMap, "recoveryPoints", h.RecoveryPoints)
	populate(objectMap, "replicaDeletion", h.ReplicaDeletion)
	populate(objectMap, "replicationPort", h.ReplicationPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaPolicyInput.
func (h *HyperVReplicaPolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedAuthenticationType":
			err = unpopulate(val, "AllowedAuthenticationType", &h.AllowedAuthenticationType)
			delete(rawMsg, key)
		case "applicationConsistentSnapshotFrequencyInHours":
			err = unpopulate(val, "ApplicationConsistentSnapshotFrequencyInHours", &h.ApplicationConsistentSnapshotFrequencyInHours)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "initialReplicationMethod":
			err = unpopulate(val, "InitialReplicationMethod", &h.InitialReplicationMethod)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "offlineReplicationExportPath":
			err = unpopulate(val, "OfflineReplicationExportPath", &h.OfflineReplicationExportPath)
			delete(rawMsg, key)
		case "offlineReplicationImportPath":
			err = unpopulate(val, "OfflineReplicationImportPath", &h.OfflineReplicationImportPath)
			delete(rawMsg, key)
		case "onlineReplicationStartTime":
			err = unpopulate(val, "OnlineReplicationStartTime", &h.OnlineReplicationStartTime)
			delete(rawMsg, key)
		case "recoveryPoints":
			err = unpopulate(val, "RecoveryPoints", &h.RecoveryPoints)
			delete(rawMsg, key)
		case "replicaDeletion":
			err = unpopulate(val, "ReplicaDeletion", &h.ReplicaDeletion)
			delete(rawMsg, key)
		case "replicationPort":
			err = unpopulate(val, "ReplicationPort", &h.ReplicationPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVReplicaReplicationDetails.
func (h *HyperVReplicaReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "initialReplicationDetails":
			err = unpopulate(val, "InitialReplicationDetails", &h.InitialReplicationDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "lastReplicatedTime":
			err = unpopulateTimeRFC3339(val, "LastReplicatedTime", &h.LastReplicatedTime)
			delete(rawMsg, key)
		case "vMDiskDetails":
			err = unpopulate(val, "VMDiskDetails", &h.VMDiskDetails)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &h.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &h.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &h.VMProtectionStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVSiteDetails.
func (h *HyperVSiteDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hyperVHosts":
			err = unpopulate(val, "HyperVHosts", &h.HyperVHosts)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVVirtualMachineDetails.
func (h *HyperVVirtualMachineDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskDetails":
			err = unpopulate(val, "DiskDetails", &h.DiskDetails)
			delete(rawMsg, key)
		case "generation":
			err = unpopulate(val, "Generation", &h.Generation)
			delete(rawMsg, key)
		case "hasFibreChannelAdapter":
			err = unpopulate(val, "HasFibreChannelAdapter", &h.HasFibreChannelAdapter)
			delete(rawMsg, key)
		case "hasPhysicalDisk":
			err = unpopulate(val, "HasPhysicalDisk", &h.HasPhysicalDisk)
			delete(rawMsg, key)
		case "hasSharedVhd":
			err = unpopulate(val, "HasSharedVhd", &h.HasSharedVhd)
			delete(rawMsg, key)
		case "hyperVHostId":
			err = unpopulate(val, "HyperVHostID", &h.HyperVHostID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "osDetails":
			err = unpopulate(val, "OSDetails", &h.OSDetails)
			delete(rawMsg, key)
		case "sourceItemId":
			err = unpopulate(val, "SourceItemID", &h.SourceItemID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPConfigInputDetails.
func (i IPConfigInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "ipConfigName", i.IPConfigName)
	populate(objectMap, "isPrimary", i.IsPrimary)
	populate(objectMap, "isSeletedForFailover", i.IsSeletedForFailover)
	populate(objectMap, "recoveryLBBackendAddressPoolIds", i.RecoveryLBBackendAddressPoolIDs)
	populate(objectMap, "recoveryPublicIPAddressId", i.RecoveryPublicIPAddressID)
	populate(objectMap, "recoveryStaticIPAddress", i.RecoveryStaticIPAddress)
	populate(objectMap, "recoverySubnetName", i.RecoverySubnetName)
	populate(objectMap, "tfoLBBackendAddressPoolIds", i.TfoLBBackendAddressPoolIDs)
	populate(objectMap, "tfoPublicIPAddressId", i.TfoPublicIPAddressID)
	populate(objectMap, "tfoStaticIPAddress", i.TfoStaticIPAddress)
	populate(objectMap, "tfoSubnetName", i.TfoSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAgentDetails.
func (i *InMageAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentExpiryDate", &i.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentUpdateStatus":
			err = unpopulate(val, "AgentUpdateStatus", &i.AgentUpdateStatus)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &i.AgentVersion)
			delete(rawMsg, key)
		case "postUpdateRebootStatus":
			err = unpopulate(val, "PostUpdateRebootStatus", &i.PostUpdateRebootStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2ApplyRecoveryPointInput.
func (i InMageAzureV2ApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageAzureV2"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ApplyRecoveryPointInput.
func (i *InMageAzureV2ApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2EnableProtectionInput.
func (i InMageAzureV2EnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskEncryptionSetId", i.DiskEncryptionSetID)
	populate(objectMap, "diskType", i.DiskType)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	populate(objectMap, "enableRdpOnTargetOption", i.EnableRdpOnTargetOption)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "multiVmGroupId", i.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "sqlServerLicenseType", i.SQLServerLicenseType)
	populate(objectMap, "seedManagedDiskTags", i.SeedManagedDiskTags)
	populate(objectMap, "storageAccountId", i.StorageAccountID)
	populate(objectMap, "targetAvailabilitySetId", i.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetAzureNetworkId", i.TargetAzureNetworkID)
	populate(objectMap, "targetAzureSubnetId", i.TargetAzureSubnetID)
	populate(objectMap, "targetAzureV1ResourceGroupId", i.TargetAzureV1ResourceGroupID)
	populate(objectMap, "targetAzureV2ResourceGroupId", i.TargetAzureV2ResourceGroupID)
	populate(objectMap, "targetAzureVmName", i.TargetAzureVMName)
	populate(objectMap, "targetManagedDiskTags", i.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", i.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmSize", i.TargetVMSize)
	populate(objectMap, "targetVmTags", i.TargetVMTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2EnableProtectionInput.
func (i *InMageAzureV2EnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskEncryptionSetId":
			err = unpopulate(val, "DiskEncryptionSetID", &i.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &i.DiskType)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &i.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &i.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &i.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &i.StorageAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetAzureNetworkId":
			err = unpopulate(val, "TargetAzureNetworkID", &i.TargetAzureNetworkID)
			delete(rawMsg, key)
		case "targetAzureSubnetId":
			err = unpopulate(val, "TargetAzureSubnetID", &i.TargetAzureSubnetID)
			delete(rawMsg, key)
		case "targetAzureV1ResourceGroupId":
			err = unpopulate(val, "TargetAzureV1ResourceGroupID", &i.TargetAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureV2ResourceGroupId":
			err = unpopulate(val, "TargetAzureV2ResourceGroupID", &i.TargetAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "targetAzureVmName":
			err = unpopulate(val, "TargetAzureVMName", &i.TargetAzureVMName)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &i.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &i.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &i.TargetVMTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2EventDetails.
func (i *InMageAzureV2EventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "component":
			err = unpopulate(val, "Component", &i.Component)
			delete(rawMsg, key)
		case "correctiveAction":
			err = unpopulate(val, "CorrectiveAction", &i.CorrectiveAction)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &i.Details)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &i.EventType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "siteName":
			err = unpopulate(val, "SiteName", &i.SiteName)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &i.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2PolicyDetails.
func (i *InMageAzureV2PolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2PolicyInput.
func (i InMageAzureV2PolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", i.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", i.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2PolicyInput.
func (i *InMageAzureV2PolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ProtectedDiskDetails.
func (i *InMageAzureV2ProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskCapacityInBytes":
			err = unpopulate(val, "DiskCapacityInBytes", &i.DiskCapacityInBytes)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "fileSystemCapacityInBytes":
			err = unpopulate(val, "FileSystemCapacityInBytes", &i.FileSystemCapacityInBytes)
			delete(rawMsg, key)
		case "healthErrorCode":
			err = unpopulate(val, "HealthErrorCode", &i.HealthErrorCode)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "progressHealth":
			err = unpopulate(val, "ProgressHealth", &i.ProgressHealth)
			delete(rawMsg, key)
		case "progressStatus":
			err = unpopulate(val, "ProgressStatus", &i.ProgressStatus)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "psDataInMegaBytes":
			err = unpopulate(val, "PsDataInMegaBytes", &i.PsDataInMegaBytes)
			delete(rawMsg, key)
		case "resyncDurationInSeconds":
			err = unpopulate(val, "ResyncDurationInSeconds", &i.ResyncDurationInSeconds)
			delete(rawMsg, key)
		case "resyncLast15MinutesTransferredBytes":
			err = unpopulate(val, "ResyncLast15MinutesTransferredBytes", &i.ResyncLast15MinutesTransferredBytes)
			delete(rawMsg, key)
		case "resyncLastDataTransferTimeUTC":
			err = unpopulateTimeRFC3339(val, "ResyncLastDataTransferTimeUTC", &i.ResyncLastDataTransferTimeUTC)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncStartTime":
			err = unpopulateTimeRFC3339(val, "ResyncStartTime", &i.ResyncStartTime)
			delete(rawMsg, key)
		case "resyncTotalTransferredBytes":
			err = unpopulate(val, "ResyncTotalTransferredBytes", &i.ResyncTotalTransferredBytes)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "secondsToTakeSwitchProvider":
			err = unpopulate(val, "SecondsToTakeSwitchProvider", &i.SecondsToTakeSwitchProvider)
			delete(rawMsg, key)
		case "sourceDataInMegaBytes":
			err = unpopulate(val, "SourceDataInMegaBytes", &i.SourceDataInMegaBytes)
			delete(rawMsg, key)
		case "targetDataInMegaBytes":
			err = unpopulate(val, "TargetDataInMegaBytes", &i.TargetDataInMegaBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2RecoveryPointDetails.
func (i *InMageAzureV2RecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isMultiVmSyncPoint":
			err = unpopulate(val, "IsMultiVMSyncPoint", &i.IsMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ReplicationDetails.
func (i *InMageAzureV2ReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentExpiryDate", &i.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &i.AgentVersion)
			delete(rawMsg, key)
		case "azureVMDiskDetails":
			err = unpopulate(val, "AzureVMDiskDetails", &i.AzureVMDiskDetails)
			delete(rawMsg, key)
		case "azureVmGeneration":
			err = unpopulate(val, "AzureVMGeneration", &i.AzureVMGeneration)
			delete(rawMsg, key)
		case "compressedDataRateInMB":
			err = unpopulate(val, "CompressedDataRateInMB", &i.CompressedDataRateInMB)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &i.DiscoveryType)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &i.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &i.FirmwareType)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		case "infrastructureVmId":
			err = unpopulate(val, "InfrastructureVMID", &i.InfrastructureVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isAdditionalStatsAvailable":
			err = unpopulate(val, "IsAdditionalStatsAvailable", &i.IsAdditionalStatsAvailable)
			delete(rawMsg, key)
		case "isAgentUpdateRequired":
			err = unpopulate(val, "IsAgentUpdateRequired", &i.IsAgentUpdateRequired)
			delete(rawMsg, key)
		case "isRebootAfterUpdateRequired":
			err = unpopulate(val, "IsRebootAfterUpdateRequired", &i.IsRebootAfterUpdateRequired)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateTimeRFC3339(val, "LastHeartbeat", &i.LastHeartbeat)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPointReceived", &i.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lastUpdateReceivedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdateReceivedTime", &i.LastUpdateReceivedTime)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "osDiskId":
			err = unpopulate(val, "OSDiskID", &i.OSDiskID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &i.OSVersion)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "processServerName":
			err = unpopulate(val, "ProcessServerName", &i.ProcessServerName)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "protectedManagedDisks":
			err = unpopulate(val, "ProtectedManagedDisks", &i.ProtectedManagedDisks)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &i.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAzureLogStorageAccountId":
			err = unpopulate(val, "RecoveryAzureLogStorageAccountID", &i.RecoveryAzureLogStorageAccountID)
			delete(rawMsg, key)
		case "recoveryAzureResourceGroupId":
			err = unpopulate(val, "RecoveryAzureResourceGroupID", &i.RecoveryAzureResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureStorageAccount":
			err = unpopulate(val, "RecoveryAzureStorageAccount", &i.RecoveryAzureStorageAccount)
			delete(rawMsg, key)
		case "recoveryAzureVMName":
			err = unpopulate(val, "RecoveryAzureVMName", &i.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &i.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "replicaId":
			err = unpopulate(val, "ReplicaID", &i.ReplicaID)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &i.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedManagedDiskTags":
			err = unpopulate(val, "SeedManagedDiskTags", &i.SeedManagedDiskTags)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &i.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedSourceNicId":
			err = unpopulate(val, "SelectedSourceNicID", &i.SelectedSourceNicID)
			delete(rawMsg, key)
		case "selectedTfoAzureNetworkId":
			err = unpopulate(val, "SelectedTfoAzureNetworkID", &i.SelectedTfoAzureNetworkID)
			delete(rawMsg, key)
		case "sourceVmCpuCount":
			err = unpopulate(val, "SourceVMCPUCount", &i.SourceVMCPUCount)
			delete(rawMsg, key)
		case "sourceVmRamSizeInMB":
			err = unpopulate(val, "SourceVMRAMSizeInMB", &i.SourceVMRAMSizeInMB)
			delete(rawMsg, key)
		case "switchProviderBlockingErrorDetails":
			err = unpopulate(val, "SwitchProviderBlockingErrorDetails", &i.SwitchProviderBlockingErrorDetails)
			delete(rawMsg, key)
		case "switchProviderDetails":
			err = unpopulate(val, "SwitchProviderDetails", &i.SwitchProviderDetails)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &i.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &i.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmId":
			err = unpopulate(val, "TargetVMID", &i.TargetVMID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &i.TargetVMTags)
			delete(rawMsg, key)
		case "totalDataTransferred":
			err = unpopulate(val, "TotalDataTransferred", &i.TotalDataTransferred)
			delete(rawMsg, key)
		case "totalProgressHealth":
			err = unpopulate(val, "TotalProgressHealth", &i.TotalProgressHealth)
			delete(rawMsg, key)
		case "uncompressedDataRateInMB":
			err = unpopulate(val, "UncompressedDataRateInMB", &i.UncompressedDataRateInMB)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &i.UseManagedDisks)
			delete(rawMsg, key)
		case "vCenterInfrastructureId":
			err = unpopulate(val, "VCenterInfrastructureID", &i.VCenterInfrastructureID)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &i.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &i.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &i.VMProtectionStateDescription)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &i.ValidationErrors)
			delete(rawMsg, key)
		case "vhdName":
			err = unpopulate(val, "VhdName", &i.VhdName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2ReprotectInput.
func (i InMageAzureV2ReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "policyId", i.PolicyID)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "storageAccountId", i.StorageAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2ReprotectInput.
func (i *InMageAzureV2ReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &i.PolicyID)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &i.StorageAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2SwitchProviderInput.
func (i InMageAzureV2SwitchProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "targetApplianceID", i.TargetApplianceID)
	populate(objectMap, "targetFabricID", i.TargetFabricID)
	populate(objectMap, "targetVaultID", i.TargetVaultID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2SwitchProviderInput.
func (i *InMageAzureV2SwitchProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "targetApplianceID":
			err = unpopulate(val, "TargetApplianceID", &i.TargetApplianceID)
			delete(rawMsg, key)
		case "targetFabricID":
			err = unpopulate(val, "TargetFabricID", &i.TargetFabricID)
			delete(rawMsg, key)
		case "targetVaultID":
			err = unpopulate(val, "TargetVaultID", &i.TargetVaultID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2TestFailoverInput.
func (i InMageAzureV2TestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2TestFailoverInput.
func (i *InMageAzureV2TestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2UnplannedFailoverInput.
func (i InMageAzureV2UnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2UnplannedFailoverInput.
func (i *InMageAzureV2UnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageAzureV2UpdateReplicationProtectedItemInput.
func (i InMageAzureV2UpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "recoveryAzureV1ResourceGroupId", i.RecoveryAzureV1ResourceGroupID)
	populate(objectMap, "recoveryAzureV2ResourceGroupId", i.RecoveryAzureV2ResourceGroupID)
	populate(objectMap, "sqlServerLicenseType", i.SQLServerLicenseType)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetManagedDiskTags", i.TargetManagedDiskTags)
	populate(objectMap, "targetNicTags", i.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetVmTags", i.TargetVMTags)
	populate(objectMap, "useManagedDisks", i.UseManagedDisks)
	populate(objectMap, "vmDisks", i.VMDisks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageAzureV2UpdateReplicationProtectedItemInput.
func (i *InMageAzureV2UpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryAzureV1ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV1ResourceGroupID", &i.RecoveryAzureV1ResourceGroupID)
			delete(rawMsg, key)
		case "recoveryAzureV2ResourceGroupId":
			err = unpopulate(val, "RecoveryAzureV2ResourceGroupID", &i.RecoveryAzureV2ResourceGroupID)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &i.SQLServerLicenseType)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetManagedDiskTags":
			err = unpopulate(val, "TargetManagedDiskTags", &i.TargetManagedDiskTags)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &i.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &i.TargetVMTags)
			delete(rawMsg, key)
		case "useManagedDisks":
			err = unpopulate(val, "UseManagedDisks", &i.UseManagedDisks)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &i.VMDisks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageBasePolicyDetails.
func (i *InMageBasePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageDisableProtectionProviderSpecificInput.
func (i InMageDisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "replicaVmDeletionStatus", i.ReplicaVMDeletionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageDisableProtectionProviderSpecificInput.
func (i *InMageDisableProtectionProviderSpecificInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "replicaVmDeletionStatus":
			err = unpopulate(val, "ReplicaVMDeletionStatus", &i.ReplicaVMDeletionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageDiskExclusionInput.
func (i InMageDiskExclusionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "diskSignatureOptions", i.DiskSignatureOptions)
	populate(objectMap, "volumeOptions", i.VolumeOptions)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type InMageEnableProtectionInput.
func (i InMageEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datastoreName", i.DatastoreName)
	populate(objectMap, "diskExclusionInput", i.DiskExclusionInput)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "multiVmGroupId", i.MultiVMGroupID)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "retentionDrive", i.RetentionDrive)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "vmFriendlyName", i.VMFriendlyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageEnableProtectionInput.
func (i *InMageEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreName":
			err = unpopulate(val, "DatastoreName", &i.DatastoreName)
			delete(rawMsg, key)
		case "diskExclusionInput":
			err = unpopulate(val, "DiskExclusionInput", &i.DiskExclusionInput)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "retentionDrive":
			err = unpopulate(val, "RetentionDrive", &i.RetentionDrive)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "vmFriendlyName":
			err = unpopulate(val, "VMFriendlyName", &i.VMFriendlyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMagePolicyDetails.
func (i *InMagePolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMagePolicyInput.
func (i InMagePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "multiVmSyncStatus", i.MultiVMSyncStatus)
	populate(objectMap, "recoveryPointHistory", i.RecoveryPointHistory)
	populate(objectMap, "recoveryPointThresholdInMinutes", i.RecoveryPointThresholdInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMagePolicyInput.
func (i *InMagePolicyInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &i.RecoveryPointHistory)
			delete(rawMsg, key)
		case "recoveryPointThresholdInMinutes":
			err = unpopulate(val, "RecoveryPointThresholdInMinutes", &i.RecoveryPointThresholdInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageProtectedDiskDetails.
func (i *InMageProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskCapacityInBytes":
			err = unpopulate(val, "DiskCapacityInBytes", &i.DiskCapacityInBytes)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "fileSystemCapacityInBytes":
			err = unpopulate(val, "FileSystemCapacityInBytes", &i.FileSystemCapacityInBytes)
			delete(rawMsg, key)
		case "healthErrorCode":
			err = unpopulate(val, "HealthErrorCode", &i.HealthErrorCode)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "progressHealth":
			err = unpopulate(val, "ProgressHealth", &i.ProgressHealth)
			delete(rawMsg, key)
		case "progressStatus":
			err = unpopulate(val, "ProgressStatus", &i.ProgressStatus)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "psDataInMB":
			err = unpopulate(val, "PsDataInMB", &i.PsDataInMB)
			delete(rawMsg, key)
		case "resyncDurationInSeconds":
			err = unpopulate(val, "ResyncDurationInSeconds", &i.ResyncDurationInSeconds)
			delete(rawMsg, key)
		case "resyncLast15MinutesTransferredBytes":
			err = unpopulate(val, "ResyncLast15MinutesTransferredBytes", &i.ResyncLast15MinutesTransferredBytes)
			delete(rawMsg, key)
		case "resyncLastDataTransferTimeUTC":
			err = unpopulateTimeRFC3339(val, "ResyncLastDataTransferTimeUTC", &i.ResyncLastDataTransferTimeUTC)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncStartTime":
			err = unpopulateTimeRFC3339(val, "ResyncStartTime", &i.ResyncStartTime)
			delete(rawMsg, key)
		case "resyncTotalTransferredBytes":
			err = unpopulate(val, "ResyncTotalTransferredBytes", &i.ResyncTotalTransferredBytes)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "sourceDataInMB":
			err = unpopulate(val, "SourceDataInMB", &i.SourceDataInMB)
			delete(rawMsg, key)
		case "targetDataInMB":
			err = unpopulate(val, "TargetDataInMB", &i.TargetDataInMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmApplianceSpecificDetails.
func (i *InMageRcmApplianceSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliances":
			err = unpopulate(val, "Appliances", &i.Appliances)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmApplyRecoveryPointInput.
func (i InMageRcmApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmApplyRecoveryPointInput.
func (i *InMageRcmApplyRecoveryPointInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmDiscoveredProtectedVMDetails.
func (i *InMageRcmDiscoveredProtectedVMDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &i.CreatedTimestamp)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &i.IPAddresses)
			delete(rawMsg, key)
		case "isDeleted":
			err = unpopulate(val, "IsDeleted", &i.IsDeleted)
			delete(rawMsg, key)
		case "lastDiscoveryTimeInUtc":
			err = unpopulateTimeRFC3339(val, "LastDiscoveryTimeInUTC", &i.LastDiscoveryTimeInUTC)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &i.OSName)
			delete(rawMsg, key)
		case "powerStatus":
			err = unpopulate(val, "PowerStatus", &i.PowerStatus)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateTimeRFC3339(val, "UpdatedTimestamp", &i.UpdatedTimestamp)
			delete(rawMsg, key)
		case "vCenterFqdn":
			err = unpopulate(val, "VCenterFqdn", &i.VCenterFqdn)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &i.VCenterID)
			delete(rawMsg, key)
		case "vmFqdn":
			err = unpopulate(val, "VMFqdn", &i.VMFqdn)
			delete(rawMsg, key)
		case "vmwareToolsStatus":
			err = unpopulate(val, "VmwareToolsStatus", &i.VmwareToolsStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmEnableProtectionInput.
func (i InMageRcmEnableProtectionInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disksDefault", i.DisksDefault)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	populate(objectMap, "fabricDiscoveryMachineId", i.FabricDiscoveryMachineID)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "multiVmGroupName", i.MultiVMGroupName)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	populate(objectMap, "targetAvailabilitySetId", i.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", i.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetNetworkId", i.TargetNetworkID)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", i.TargetResourceGroupID)
	populate(objectMap, "targetSubnetName", i.TargetSubnetName)
	populate(objectMap, "targetVmName", i.TargetVMName)
	populate(objectMap, "targetVmSize", i.TargetVMSize)
	populate(objectMap, "testNetworkId", i.TestNetworkID)
	populate(objectMap, "testSubnetName", i.TestSubnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmEnableProtectionInput.
func (i *InMageRcmEnableProtectionInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disksDefault":
			err = unpopulate(val, "DisksDefault", &i.DisksDefault)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "fabricDiscoveryMachineId":
			err = unpopulate(val, "FabricDiscoveryMachineID", &i.FabricDiscoveryMachineID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &i.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &i.TargetNetworkID)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &i.TargetSubnetName)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &i.TestNetworkID)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &i.TestSubnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmEventDetails.
func (i *InMageRcmEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applianceName":
			err = unpopulate(val, "ApplianceName", &i.ApplianceName)
			delete(rawMsg, key)
		case "componentDisplayName":
			err = unpopulate(val, "ComponentDisplayName", &i.ComponentDisplayName)
			delete(rawMsg, key)
		case "fabricName":
			err = unpopulate(val, "FabricName", &i.FabricName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &i.JobID)
			delete(rawMsg, key)
		case "latestAgentVersion":
			err = unpopulate(val, "LatestAgentVersion", &i.LatestAgentVersion)
			delete(rawMsg, key)
		case "protectedItemName":
			err = unpopulate(val, "ProtectedItemName", &i.ProtectedItemName)
			delete(rawMsg, key)
		case "serverType":
			err = unpopulate(val, "ServerType", &i.ServerType)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &i.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFabricCreationInput.
func (i InMageRcmFabricCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "physicalSiteId", i.PhysicalSiteID)
	populate(objectMap, "sourceAgentIdentity", i.SourceAgentIdentity)
	populate(objectMap, "vmwareSiteId", i.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFabricCreationInput.
func (i *InMageRcmFabricCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &i.PhysicalSiteID)
			delete(rawMsg, key)
		case "sourceAgentIdentity":
			err = unpopulate(val, "SourceAgentIdentity", &i.SourceAgentIdentity)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &i.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFabricSpecificDetails.
func (i *InMageRcmFabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentDetails":
			err = unpopulate(val, "AgentDetails", &i.AgentDetails)
			delete(rawMsg, key)
		case "controlPlaneUri":
			err = unpopulate(val, "ControlPlaneURI", &i.ControlPlaneURI)
			delete(rawMsg, key)
		case "dataPlaneUri":
			err = unpopulate(val, "DataPlaneURI", &i.DataPlaneURI)
			delete(rawMsg, key)
		case "dras":
			err = unpopulate(val, "Dras", &i.Dras)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "marsAgents":
			err = unpopulate(val, "MarsAgents", &i.MarsAgents)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &i.PhysicalSiteID)
			delete(rawMsg, key)
		case "processServers":
			err = unpopulate(val, "ProcessServers", &i.ProcessServers)
			delete(rawMsg, key)
		case "pushInstallers":
			err = unpopulate(val, "PushInstallers", &i.PushInstallers)
			delete(rawMsg, key)
		case "rcmProxies":
			err = unpopulate(val, "RcmProxies", &i.RcmProxies)
			delete(rawMsg, key)
		case "replicationAgents":
			err = unpopulate(val, "ReplicationAgents", &i.ReplicationAgents)
			delete(rawMsg, key)
		case "reprotectAgents":
			err = unpopulate(val, "ReprotectAgents", &i.ReprotectAgents)
			delete(rawMsg, key)
		case "serviceContainerId":
			err = unpopulate(val, "ServiceContainerID", &i.ServiceContainerID)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &i.ServiceEndpoint)
			delete(rawMsg, key)
		case "serviceResourceId":
			err = unpopulate(val, "ServiceResourceID", &i.ServiceResourceID)
			delete(rawMsg, key)
		case "sourceAgentIdentityDetails":
			err = unpopulate(val, "SourceAgentIdentityDetails", &i.SourceAgentIdentityDetails)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &i.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackDiscoveredProtectedVMDetails.
func (i *InMageRcmFailbackDiscoveredProtectedVMDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &i.CreatedTimestamp)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &i.IPAddresses)
			delete(rawMsg, key)
		case "isDeleted":
			err = unpopulate(val, "IsDeleted", &i.IsDeleted)
			delete(rawMsg, key)
		case "lastDiscoveryTimeInUtc":
			err = unpopulateTimeRFC3339(val, "LastDiscoveryTimeInUTC", &i.LastDiscoveryTimeInUTC)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &i.OSName)
			delete(rawMsg, key)
		case "powerStatus":
			err = unpopulate(val, "PowerStatus", &i.PowerStatus)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateTimeRFC3339(val, "UpdatedTimestamp", &i.UpdatedTimestamp)
			delete(rawMsg, key)
		case "vCenterFqdn":
			err = unpopulate(val, "VCenterFqdn", &i.VCenterFqdn)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &i.VCenterID)
			delete(rawMsg, key)
		case "vmFqdn":
			err = unpopulate(val, "VMFqdn", &i.VMFqdn)
			delete(rawMsg, key)
		case "vmwareToolsStatus":
			err = unpopulate(val, "VmwareToolsStatus", &i.VmwareToolsStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackEventDetails.
func (i *InMageRcmFailbackEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applianceName":
			err = unpopulate(val, "ApplianceName", &i.ApplianceName)
			delete(rawMsg, key)
		case "componentDisplayName":
			err = unpopulate(val, "ComponentDisplayName", &i.ComponentDisplayName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "protectedItemName":
			err = unpopulate(val, "ProtectedItemName", &i.ProtectedItemName)
			delete(rawMsg, key)
		case "serverType":
			err = unpopulate(val, "ServerType", &i.ServerType)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &i.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackMobilityAgentDetails.
func (i *InMageRcmFailbackMobilityAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersionExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentVersionExpiryDate", &i.AgentVersionExpiryDate)
			delete(rawMsg, key)
		case "driverVersion":
			err = unpopulate(val, "DriverVersion", &i.DriverVersion)
			delete(rawMsg, key)
		case "driverVersionExpiryDate":
			err = unpopulateTimeRFC3339(val, "DriverVersionExpiryDate", &i.DriverVersionExpiryDate)
			delete(rawMsg, key)
		case "isUpgradeable":
			err = unpopulate(val, "IsUpgradeable", &i.IsUpgradeable)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &i.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "latestUpgradableVersionWithoutReboot":
			err = unpopulate(val, "LatestUpgradableVersionWithoutReboot", &i.LatestUpgradableVersionWithoutReboot)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &i.LatestVersion)
			delete(rawMsg, key)
		case "reasonsBlockingUpgrade":
			err = unpopulate(val, "ReasonsBlockingUpgrade", &i.ReasonsBlockingUpgrade)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackPlannedFailoverProviderInput.
func (i InMageRcmFailbackPlannedFailoverProviderInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "recoveryPointType", i.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackPlannedFailoverProviderInput.
func (i *InMageRcmFailbackPlannedFailoverProviderInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &i.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackPolicyCreationInput.
func (i InMageRcmFailbackPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "InMageRcmFailback"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackPolicyCreationInput.
func (i *InMageRcmFailbackPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackPolicyDetails.
func (i *InMageRcmFailbackPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackProtectedDiskDetails.
func (i *InMageRcmFailbackProtectedDiskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &i.CapacityInBytes)
			delete(rawMsg, key)
		case "dataPendingAtSourceAgentInMB":
			err = unpopulate(val, "DataPendingAtSourceAgentInMB", &i.DataPendingAtSourceAgentInMB)
			delete(rawMsg, key)
		case "dataPendingInLogDataStoreInMB":
			err = unpopulate(val, "DataPendingInLogDataStoreInMB", &i.DataPendingInLogDataStoreInMB)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &i.DiskID)
			delete(rawMsg, key)
		case "diskName":
			err = unpopulate(val, "DiskName", &i.DiskName)
			delete(rawMsg, key)
		case "diskUuid":
			err = unpopulate(val, "DiskUUID", &i.DiskUUID)
			delete(rawMsg, key)
		case "irDetails":
			err = unpopulate(val, "IrDetails", &i.IrDetails)
			delete(rawMsg, key)
		case "isInitialReplicationComplete":
			err = unpopulate(val, "IsInitialReplicationComplete", &i.IsInitialReplicationComplete)
			delete(rawMsg, key)
		case "isOSDisk":
			err = unpopulate(val, "IsOSDisk", &i.IsOSDisk)
			delete(rawMsg, key)
		case "lastSyncTime":
			err = unpopulateTimeRFC3339(val, "LastSyncTime", &i.LastSyncTime)
			delete(rawMsg, key)
		case "resyncDetails":
			err = unpopulate(val, "ResyncDetails", &i.ResyncDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackReplicationDetails.
func (i *InMageRcmFailbackReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureVirtualMachineId":
			err = unpopulate(val, "AzureVirtualMachineID", &i.AzureVirtualMachineID)
			delete(rawMsg, key)
		case "discoveredVmDetails":
			err = unpopulate(val, "DiscoveredVMDetails", &i.DiscoveredVMDetails)
			delete(rawMsg, key)
		case "initialReplicationProcessedBytes":
			err = unpopulate(val, "InitialReplicationProcessedBytes", &i.InitialReplicationProcessedBytes)
			delete(rawMsg, key)
		case "initialReplicationProgressHealth":
			err = unpopulate(val, "InitialReplicationProgressHealth", &i.InitialReplicationProgressHealth)
			delete(rawMsg, key)
		case "initialReplicationProgressPercentage":
			err = unpopulate(val, "InitialReplicationProgressPercentage", &i.InitialReplicationProgressPercentage)
			delete(rawMsg, key)
		case "initialReplicationTransferredBytes":
			err = unpopulate(val, "InitialReplicationTransferredBytes", &i.InitialReplicationTransferredBytes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "internalIdentifier":
			err = unpopulate(val, "InternalIdentifier", &i.InternalIdentifier)
			delete(rawMsg, key)
		case "isAgentRegistrationSuccessfulAfterFailover":
			err = unpopulate(val, "IsAgentRegistrationSuccessfulAfterFailover", &i.IsAgentRegistrationSuccessfulAfterFailover)
			delete(rawMsg, key)
		case "lastPlannedFailoverStartTime":
			err = unpopulateTimeRFC3339(val, "LastPlannedFailoverStartTime", &i.LastPlannedFailoverStartTime)
			delete(rawMsg, key)
		case "lastPlannedFailoverStatus":
			err = unpopulate(val, "LastPlannedFailoverStatus", &i.LastPlannedFailoverStatus)
			delete(rawMsg, key)
		case "lastUsedPolicyFriendlyName":
			err = unpopulate(val, "LastUsedPolicyFriendlyName", &i.LastUsedPolicyFriendlyName)
			delete(rawMsg, key)
		case "lastUsedPolicyId":
			err = unpopulate(val, "LastUsedPolicyID", &i.LastUsedPolicyID)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "mobilityAgentDetails":
			err = unpopulate(val, "MobilityAgentDetails", &i.MobilityAgentDetails)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "reprotectAgentId":
			err = unpopulate(val, "ReprotectAgentID", &i.ReprotectAgentID)
			delete(rawMsg, key)
		case "reprotectAgentName":
			err = unpopulate(val, "ReprotectAgentName", &i.ReprotectAgentName)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressHealth":
			err = unpopulate(val, "ResyncProgressHealth", &i.ResyncProgressHealth)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncState":
			err = unpopulate(val, "ResyncState", &i.ResyncState)
			delete(rawMsg, key)
		case "resyncTransferredBytes":
			err = unpopulate(val, "ResyncTransferredBytes", &i.ResyncTransferredBytes)
			delete(rawMsg, key)
		case "targetDataStoreName":
			err = unpopulate(val, "TargetDataStoreName", &i.TargetDataStoreName)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetvCenterId":
			err = unpopulate(val, "TargetvCenterID", &i.TargetvCenterID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmFailbackReprotectInput.
func (i InMageRcmFailbackReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "policyId", i.PolicyID)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmFailbackReprotectInput.
func (i *InMageRcmFailbackReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &i.PolicyID)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmMobilityAgentDetails.
func (i *InMageRcmMobilityAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersionExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentVersionExpiryDate", &i.AgentVersionExpiryDate)
			delete(rawMsg, key)
		case "driverVersion":
			err = unpopulate(val, "DriverVersion", &i.DriverVersion)
			delete(rawMsg, key)
		case "driverVersionExpiryDate":
			err = unpopulateTimeRFC3339(val, "DriverVersionExpiryDate", &i.DriverVersionExpiryDate)
			delete(rawMsg, key)
		case "isUpgradeable":
			err = unpopulate(val, "IsUpgradeable", &i.IsUpgradeable)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &i.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "latestAgentReleaseDate":
			err = unpopulate(val, "LatestAgentReleaseDate", &i.LatestAgentReleaseDate)
			delete(rawMsg, key)
		case "latestUpgradableVersionWithoutReboot":
			err = unpopulate(val, "LatestUpgradableVersionWithoutReboot", &i.LatestUpgradableVersionWithoutReboot)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &i.LatestVersion)
			delete(rawMsg, key)
		case "reasonsBlockingUpgrade":
			err = unpopulate(val, "ReasonsBlockingUpgrade", &i.ReasonsBlockingUpgrade)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmPolicyCreationInput.
func (i InMageRcmPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appConsistentFrequencyInMinutes", i.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", i.CrashConsistentFrequencyInMinutes)
	populate(objectMap, "enableMultiVmSync", i.EnableMultiVMSync)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "recoveryPointHistoryInMinutes", i.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmPolicyCreationInput.
func (i *InMageRcmPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "enableMultiVmSync":
			err = unpopulate(val, "EnableMultiVMSync", &i.EnableMultiVMSync)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &i.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmPolicyDetails.
func (i *InMageRcmPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &i.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &i.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "enableMultiVmSync":
			err = unpopulate(val, "EnableMultiVMSync", &i.EnableMultiVMSync)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &i.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmProtectionContainerMappingDetails.
func (i *InMageRcmProtectionContainerMappingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableAgentAutoUpgrade":
			err = unpopulate(val, "EnableAgentAutoUpgrade", &i.EnableAgentAutoUpgrade)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmRecoveryPointDetails.
func (i *InMageRcmRecoveryPointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isMultiVmSyncPoint":
			err = unpopulate(val, "IsMultiVMSyncPoint", &i.IsMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmReplicationDetails.
func (i *InMageRcmReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentUpgradeAttemptToVersion":
			err = unpopulate(val, "AgentUpgradeAttemptToVersion", &i.AgentUpgradeAttemptToVersion)
			delete(rawMsg, key)
		case "agentUpgradeBlockingErrorDetails":
			err = unpopulate(val, "AgentUpgradeBlockingErrorDetails", &i.AgentUpgradeBlockingErrorDetails)
			delete(rawMsg, key)
		case "agentUpgradeJobId":
			err = unpopulate(val, "AgentUpgradeJobID", &i.AgentUpgradeJobID)
			delete(rawMsg, key)
		case "agentUpgradeState":
			err = unpopulate(val, "AgentUpgradeState", &i.AgentUpgradeState)
			delete(rawMsg, key)
		case "allocatedMemoryInMB":
			err = unpopulate(val, "AllocatedMemoryInMB", &i.AllocatedMemoryInMB)
			delete(rawMsg, key)
		case "discoveredVmDetails":
			err = unpopulate(val, "DiscoveredVMDetails", &i.DiscoveredVMDetails)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &i.DiscoveryType)
			delete(rawMsg, key)
		case "fabricDiscoveryMachineId":
			err = unpopulate(val, "FabricDiscoveryMachineID", &i.FabricDiscoveryMachineID)
			delete(rawMsg, key)
		case "failoverRecoveryPointId":
			err = unpopulate(val, "FailoverRecoveryPointID", &i.FailoverRecoveryPointID)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &i.FirmwareType)
			delete(rawMsg, key)
		case "initialReplicationProcessedBytes":
			err = unpopulate(val, "InitialReplicationProcessedBytes", &i.InitialReplicationProcessedBytes)
			delete(rawMsg, key)
		case "initialReplicationProgressHealth":
			err = unpopulate(val, "InitialReplicationProgressHealth", &i.InitialReplicationProgressHealth)
			delete(rawMsg, key)
		case "initialReplicationProgressPercentage":
			err = unpopulate(val, "InitialReplicationProgressPercentage", &i.InitialReplicationProgressPercentage)
			delete(rawMsg, key)
		case "initialReplicationTransferredBytes":
			err = unpopulate(val, "InitialReplicationTransferredBytes", &i.InitialReplicationTransferredBytes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "internalIdentifier":
			err = unpopulate(val, "InternalIdentifier", &i.InternalIdentifier)
			delete(rawMsg, key)
		case "isAgentRegistrationSuccessfulAfterFailover":
			err = unpopulate(val, "IsAgentRegistrationSuccessfulAfterFailover", &i.IsAgentRegistrationSuccessfulAfterFailover)
			delete(rawMsg, key)
		case "isLastUpgradeSuccessful":
			err = unpopulate(val, "IsLastUpgradeSuccessful", &i.IsLastUpgradeSuccessful)
			delete(rawMsg, key)
		case "lastAgentUpgradeErrorDetails":
			err = unpopulate(val, "LastAgentUpgradeErrorDetails", &i.LastAgentUpgradeErrorDetails)
			delete(rawMsg, key)
		case "lastAgentUpgradeType":
			err = unpopulate(val, "LastAgentUpgradeType", &i.LastAgentUpgradeType)
			delete(rawMsg, key)
		case "lastRecoveryPointId":
			err = unpopulate(val, "LastRecoveryPointID", &i.LastRecoveryPointID)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPointReceived", &i.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lastRpoInSeconds":
			err = unpopulate(val, "LastRpoInSeconds", &i.LastRpoInSeconds)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "mobilityAgentDetails":
			err = unpopulate(val, "MobilityAgentDetails", &i.MobilityAgentDetails)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &i.OSType)
			delete(rawMsg, key)
		case "primaryNicIpAddress":
			err = unpopulate(val, "PrimaryNicIPAddress", &i.PrimaryNicIPAddress)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "processServerName":
			err = unpopulate(val, "ProcessServerName", &i.ProcessServerName)
			delete(rawMsg, key)
		case "processorCoreCount":
			err = unpopulate(val, "ProcessorCoreCount", &i.ProcessorCoreCount)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "resyncProcessedBytes":
			err = unpopulate(val, "ResyncProcessedBytes", &i.ResyncProcessedBytes)
			delete(rawMsg, key)
		case "resyncProgressHealth":
			err = unpopulate(val, "ResyncProgressHealth", &i.ResyncProgressHealth)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &i.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &i.ResyncRequired)
			delete(rawMsg, key)
		case "resyncState":
			err = unpopulate(val, "ResyncState", &i.ResyncState)
			delete(rawMsg, key)
		case "resyncTransferredBytes":
			err = unpopulate(val, "ResyncTransferredBytes", &i.ResyncTransferredBytes)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &i.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetGeneration":
			err = unpopulate(val, "TargetGeneration", &i.TargetGeneration)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &i.TargetLocation)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &i.TargetNetworkID)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &i.TestNetworkID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmReprotectInput.
func (i InMageRcmReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datastoreName", i.DatastoreName)
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "logStorageAccountId", i.LogStorageAccountID)
	populate(objectMap, "policyId", i.PolicyID)
	populate(objectMap, "reprotectAgentId", i.ReprotectAgentID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmReprotectInput.
func (i *InMageRcmReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreName":
			err = unpopulate(val, "DatastoreName", &i.DatastoreName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "logStorageAccountId":
			err = unpopulate(val, "LogStorageAccountID", &i.LogStorageAccountID)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &i.PolicyID)
			delete(rawMsg, key)
		case "reprotectAgentId":
			err = unpopulate(val, "ReprotectAgentID", &i.ReprotectAgentID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmTestFailoverInput.
func (i InMageRcmTestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "networkId", i.NetworkID)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmTestFailoverInput.
func (i *InMageRcmTestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &i.NetworkID)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUnplannedFailoverInput.
func (i InMageRcmUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "performShutdown", i.PerformShutdown)
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUnplannedFailoverInput.
func (i *InMageRcmUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "performShutdown":
			err = unpopulate(val, "PerformShutdown", &i.PerformShutdown)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUpdateApplianceForReplicationProtectedItemInput.
func (i InMageRcmUpdateApplianceForReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUpdateApplianceForReplicationProtectedItemInput.
func (i *InMageRcmUpdateApplianceForReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUpdateContainerMappingInput.
func (i InMageRcmUpdateContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enableAgentAutoUpgrade", i.EnableAgentAutoUpgrade)
	objectMap["instanceType"] = "InMageRcm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUpdateContainerMappingInput.
func (i *InMageRcmUpdateContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableAgentAutoUpgrade":
			err = unpopulate(val, "EnableAgentAutoUpgrade", &i.EnableAgentAutoUpgrade)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageRcmUpdateReplicationProtectedItemInput.
func (i InMageRcmUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "targetAvailabilitySetId", i.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", i.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", i.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetNetworkId", i.TargetNetworkID)
	populate(objectMap, "targetProximityPlacementGroupId", i.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", i.TargetResourceGroupID)
	populate(objectMap, "targetVmName", i.TargetVMName)
	populate(objectMap, "targetVmSize", i.TargetVMSize)
	populate(objectMap, "testNetworkId", i.TestNetworkID)
	populate(objectMap, "vmNics", i.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageRcmUpdateReplicationProtectedItemInput.
func (i *InMageRcmUpdateReplicationProtectedItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &i.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &i.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &i.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &i.TargetNetworkID)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &i.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &i.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &i.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &i.TargetVMSize)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &i.TestNetworkID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageReplicationDetails.
func (i *InMageReplicationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeSiteType":
			err = unpopulate(val, "ActiveSiteType", &i.ActiveSiteType)
			delete(rawMsg, key)
		case "agentDetails":
			err = unpopulate(val, "AgentDetails", &i.AgentDetails)
			delete(rawMsg, key)
		case "azureStorageAccountId":
			err = unpopulate(val, "AzureStorageAccountID", &i.AzureStorageAccountID)
			delete(rawMsg, key)
		case "compressedDataRateInMB":
			err = unpopulate(val, "CompressedDataRateInMB", &i.CompressedDataRateInMB)
			delete(rawMsg, key)
		case "consistencyPoints":
			err = unpopulate(val, "ConsistencyPoints", &i.ConsistencyPoints)
			delete(rawMsg, key)
		case "datastores":
			err = unpopulate(val, "Datastores", &i.Datastores)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &i.DiscoveryType)
			delete(rawMsg, key)
		case "diskResized":
			err = unpopulate(val, "DiskResized", &i.DiskResized)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		case "infrastructureVmId":
			err = unpopulate(val, "InfrastructureVMID", &i.InfrastructureVMID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "isAdditionalStatsAvailable":
			err = unpopulate(val, "IsAdditionalStatsAvailable", &i.IsAdditionalStatsAvailable)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateTimeRFC3339(val, "LastHeartbeat", &i.LastHeartbeat)
			delete(rawMsg, key)
		case "lastRpoCalculatedTime":
			err = unpopulateTimeRFC3339(val, "LastRpoCalculatedTime", &i.LastRpoCalculatedTime)
			delete(rawMsg, key)
		case "lastUpdateReceivedTime":
			err = unpopulateTimeRFC3339(val, "LastUpdateReceivedTime", &i.LastUpdateReceivedTime)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "multiVmGroupId":
			err = unpopulate(val, "MultiVMGroupID", &i.MultiVMGroupID)
			delete(rawMsg, key)
		case "multiVmGroupName":
			err = unpopulate(val, "MultiVMGroupName", &i.MultiVMGroupName)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &i.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "osDetails":
			err = unpopulate(val, "OSDetails", &i.OSDetails)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &i.OSVersion)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &i.ProtectedDisks)
			delete(rawMsg, key)
		case "protectionStage":
			err = unpopulate(val, "ProtectionStage", &i.ProtectionStage)
			delete(rawMsg, key)
		case "rebootAfterUpdateStatus":
			err = unpopulate(val, "RebootAfterUpdateStatus", &i.RebootAfterUpdateStatus)
			delete(rawMsg, key)
		case "replicaId":
			err = unpopulate(val, "ReplicaID", &i.ReplicaID)
			delete(rawMsg, key)
		case "resyncDetails":
			err = unpopulate(val, "ResyncDetails", &i.ResyncDetails)
			delete(rawMsg, key)
		case "retentionWindowEnd":
			err = unpopulateTimeRFC3339(val, "RetentionWindowEnd", &i.RetentionWindowEnd)
			delete(rawMsg, key)
		case "retentionWindowStart":
			err = unpopulateTimeRFC3339(val, "RetentionWindowStart", &i.RetentionWindowStart)
			delete(rawMsg, key)
		case "rpoInSeconds":
			err = unpopulate(val, "RpoInSeconds", &i.RpoInSeconds)
			delete(rawMsg, key)
		case "sourceVmCpuCount":
			err = unpopulate(val, "SourceVMCPUCount", &i.SourceVMCPUCount)
			delete(rawMsg, key)
		case "sourceVmRamSizeInMB":
			err = unpopulate(val, "SourceVMRAMSizeInMB", &i.SourceVMRAMSizeInMB)
			delete(rawMsg, key)
		case "totalDataTransferred":
			err = unpopulate(val, "TotalDataTransferred", &i.TotalDataTransferred)
			delete(rawMsg, key)
		case "totalProgressHealth":
			err = unpopulate(val, "TotalProgressHealth", &i.TotalProgressHealth)
			delete(rawMsg, key)
		case "uncompressedDataRateInMB":
			err = unpopulate(val, "UncompressedDataRateInMB", &i.UncompressedDataRateInMB)
			delete(rawMsg, key)
		case "vCenterInfrastructureId":
			err = unpopulate(val, "VCenterInfrastructureID", &i.VCenterInfrastructureID)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &i.VMID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &i.VMNics)
			delete(rawMsg, key)
		case "vmProtectionState":
			err = unpopulate(val, "VMProtectionState", &i.VMProtectionState)
			delete(rawMsg, key)
		case "vmProtectionStateDescription":
			err = unpopulate(val, "VMProtectionStateDescription", &i.VMProtectionStateDescription)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &i.ValidationErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageReprotectInput.
func (i InMageReprotectInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "datastoreName", i.DatastoreName)
	populate(objectMap, "diskExclusionInput", i.DiskExclusionInput)
	populate(objectMap, "disksToInclude", i.DisksToInclude)
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "masterTargetId", i.MasterTargetID)
	populate(objectMap, "processServerId", i.ProcessServerID)
	populate(objectMap, "profileId", i.ProfileID)
	populate(objectMap, "retentionDrive", i.RetentionDrive)
	populate(objectMap, "runAsAccountId", i.RunAsAccountID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageReprotectInput.
func (i *InMageReprotectInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreName":
			err = unpopulate(val, "DatastoreName", &i.DatastoreName)
			delete(rawMsg, key)
		case "diskExclusionInput":
			err = unpopulate(val, "DiskExclusionInput", &i.DiskExclusionInput)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &i.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "masterTargetId":
			err = unpopulate(val, "MasterTargetID", &i.MasterTargetID)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &i.ProcessServerID)
			delete(rawMsg, key)
		case "profileId":
			err = unpopulate(val, "ProfileID", &i.ProfileID)
			delete(rawMsg, key)
		case "retentionDrive":
			err = unpopulate(val, "RetentionDrive", &i.RetentionDrive)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &i.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageTestFailoverInput.
func (i InMageTestFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	populate(objectMap, "recoveryPointType", i.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageTestFailoverInput.
func (i *InMageTestFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &i.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InMageUnplannedFailoverInput.
func (i InMageUnplannedFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "recoveryPointId", i.RecoveryPointID)
	populate(objectMap, "recoveryPointType", i.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InMageUnplannedFailoverInput.
func (i *InMageUnplannedFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &i.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &i.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InlineWorkflowTaskDetails.
func (i *InlineWorkflowTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childTasks":
			err = unpopulate(val, "ChildTasks", &i.ChildTasks)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &i.InstanceType)
			delete(rawMsg, key)
		case "workflowIds":
			err = unpopulate(val, "WorkflowIDs", &i.WorkflowIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerHealthError.
func (i *InnerHealthError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTimeUtc":
			err = unpopulateTimeRFC3339(val, "CreationTimeUTC", &i.CreationTimeUTC)
			delete(rawMsg, key)
		case "customerResolvability":
			err = unpopulate(val, "CustomerResolvability", &i.CustomerResolvability)
			delete(rawMsg, key)
		case "entityId":
			err = unpopulate(val, "EntityID", &i.EntityID)
			delete(rawMsg, key)
		case "errorCategory":
			err = unpopulate(val, "ErrorCategory", &i.ErrorCategory)
			delete(rawMsg, key)
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &i.ErrorCode)
			delete(rawMsg, key)
		case "errorId":
			err = unpopulate(val, "ErrorID", &i.ErrorID)
			delete(rawMsg, key)
		case "errorLevel":
			err = unpopulate(val, "ErrorLevel", &i.ErrorLevel)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &i.ErrorMessage)
			delete(rawMsg, key)
		case "errorSource":
			err = unpopulate(val, "ErrorSource", &i.ErrorSource)
			delete(rawMsg, key)
		case "errorType":
			err = unpopulate(val, "ErrorType", &i.ErrorType)
			delete(rawMsg, key)
		case "possibleCauses":
			err = unpopulate(val, "PossibleCauses", &i.PossibleCauses)
			delete(rawMsg, key)
		case "recommendedAction":
			err = unpopulate(val, "RecommendedAction", &i.RecommendedAction)
			delete(rawMsg, key)
		case "recoveryProviderErrorMessage":
			err = unpopulate(val, "RecoveryProviderErrorMessage", &i.RecoveryProviderErrorMessage)
			delete(rawMsg, key)
		case "summaryMessage":
			err = unpopulate(val, "SummaryMessage", &i.SummaryMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobErrorDetails.
func (j *JobErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &j.CreationTime)
			delete(rawMsg, key)
		case "errorLevel":
			err = unpopulate(val, "ErrorLevel", &j.ErrorLevel)
			delete(rawMsg, key)
		case "providerErrorDetails":
			err = unpopulate(val, "ProviderErrorDetails", &j.ProviderErrorDetails)
			delete(rawMsg, key)
		case "serviceErrorDetails":
			err = unpopulate(val, "ServiceErrorDetails", &j.ServiceErrorDetails)
			delete(rawMsg, key)
		case "taskId":
			err = unpopulate(val, "TaskID", &j.TaskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobProperties.
func (j *JobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &j.ActivityID)
			delete(rawMsg, key)
		case "allowedActions":
			err = unpopulate(val, "AllowedActions", &j.AllowedActions)
			delete(rawMsg, key)
		case "customDetails":
			j.CustomDetails, err = unmarshalJobDetailsClassification(val)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &j.Errors)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &j.FriendlyName)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &j.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		case "stateDescription":
			err = unpopulate(val, "StateDescription", &j.StateDescription)
			delete(rawMsg, key)
		case "targetInstanceType":
			err = unpopulate(val, "TargetInstanceType", &j.TargetInstanceType)
			delete(rawMsg, key)
		case "targetObjectId":
			err = unpopulate(val, "TargetObjectID", &j.TargetObjectID)
			delete(rawMsg, key)
		case "targetObjectName":
			err = unpopulate(val, "TargetObjectName", &j.TargetObjectName)
			delete(rawMsg, key)
		case "tasks":
			err = unpopulate(val, "Tasks", &j.Tasks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobStatusEventDetails.
func (j *JobStatusEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectType":
			err = unpopulate(val, "AffectedObjectType", &j.AffectedObjectType)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &j.InstanceType)
			delete(rawMsg, key)
		case "jobFriendlyName":
			err = unpopulate(val, "JobFriendlyName", &j.JobFriendlyName)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &j.JobID)
			delete(rawMsg, key)
		case "jobStatus":
			err = unpopulate(val, "JobStatus", &j.JobStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobTaskDetails.
func (j *JobTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &j.InstanceType)
			delete(rawMsg, key)
		case "jobTask":
			err = unpopulate(val, "JobTask", &j.JobTask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManualActionTaskDetails.
func (m *ManualActionTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &m.InstanceType)
			delete(rawMsg, key)
		case "instructions":
			err = unpopulate(val, "Instructions", &m.Instructions)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "observation":
			err = unpopulate(val, "Observation", &m.Observation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MarsAgentDetails.
func (m *MarsAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &m.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &m.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &m.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &m.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &m.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &m.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &m.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MasterTargetServer.
func (m *MasterTargetServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentExpiryDate", &m.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &m.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionDetails":
			err = unpopulate(val, "AgentVersionDetails", &m.AgentVersionDetails)
			delete(rawMsg, key)
		case "dataStores":
			err = unpopulate(val, "DataStores", &m.DataStores)
			delete(rawMsg, key)
		case "diskCount":
			err = unpopulate(val, "DiskCount", &m.DiskCount)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &m.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &m.IPAddress)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateTimeRFC3339(val, "LastHeartbeat", &m.LastHeartbeat)
			delete(rawMsg, key)
		case "marsAgentExpiryDate":
			err = unpopulateTimeRFC3339(val, "MarsAgentExpiryDate", &m.MarsAgentExpiryDate)
			delete(rawMsg, key)
		case "marsAgentVersion":
			err = unpopulate(val, "MarsAgentVersion", &m.MarsAgentVersion)
			delete(rawMsg, key)
		case "marsAgentVersionDetails":
			err = unpopulate(val, "MarsAgentVersionDetails", &m.MarsAgentVersionDetails)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &m.OSVersion)
			delete(rawMsg, key)
		case "retentionVolumes":
			err = unpopulate(val, "RetentionVolumes", &m.RetentionVolumes)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &m.ValidationErrors)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &m.VersionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MigrateInputProperties.
func (m MigrateInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", m.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrateInputProperties.
func (m *MigrateInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			m.ProviderSpecificDetails, err = unmarshalMigrateProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationItemProperties.
func (m *MigrationItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedOperations":
			err = unpopulate(val, "AllowedOperations", &m.AllowedOperations)
			delete(rawMsg, key)
		case "currentJob":
			err = unpopulate(val, "CurrentJob", &m.CurrentJob)
			delete(rawMsg, key)
		case "eventCorrelationId":
			err = unpopulate(val, "EventCorrelationID", &m.EventCorrelationID)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &m.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &m.HealthErrors)
			delete(rawMsg, key)
		case "lastTestMigrationStatus":
			err = unpopulate(val, "LastTestMigrationStatus", &m.LastTestMigrationStatus)
			delete(rawMsg, key)
		case "lastTestMigrationTime":
			err = unpopulateTimeRFC3339(val, "LastTestMigrationTime", &m.LastTestMigrationTime)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &m.MachineName)
			delete(rawMsg, key)
		case "migrationState":
			err = unpopulate(val, "MigrationState", &m.MigrationState)
			delete(rawMsg, key)
		case "migrationStateDescription":
			err = unpopulate(val, "MigrationStateDescription", &m.MigrationStateDescription)
			delete(rawMsg, key)
		case "policyFriendlyName":
			err = unpopulate(val, "PolicyFriendlyName", &m.PolicyFriendlyName)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &m.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			m.ProviderSpecificDetails, err = unmarshalMigrationProviderSpecificSettingsClassification(val)
			delete(rawMsg, key)
		case "testMigrateState":
			err = unpopulate(val, "TestMigrateState", &m.TestMigrateState)
			delete(rawMsg, key)
		case "testMigrateStateDescription":
			err = unpopulate(val, "TestMigrateStateDescription", &m.TestMigrateStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MigrationRecoveryPointProperties.
func (m *MigrationRecoveryPointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &m.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &m.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkMappingProperties.
func (n *NetworkMappingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricSpecificSettings":
			n.FabricSpecificSettings, err = unmarshalNetworkMappingFabricSpecificSettingsClassification(val)
			delete(rawMsg, key)
		case "primaryFabricFriendlyName":
			err = unpopulate(val, "PrimaryFabricFriendlyName", &n.PrimaryFabricFriendlyName)
			delete(rawMsg, key)
		case "primaryNetworkFriendlyName":
			err = unpopulate(val, "PrimaryNetworkFriendlyName", &n.PrimaryNetworkFriendlyName)
			delete(rawMsg, key)
		case "primaryNetworkId":
			err = unpopulate(val, "PrimaryNetworkID", &n.PrimaryNetworkID)
			delete(rawMsg, key)
		case "recoveryFabricArmId":
			err = unpopulate(val, "RecoveryFabricArmID", &n.RecoveryFabricArmID)
			delete(rawMsg, key)
		case "recoveryFabricFriendlyName":
			err = unpopulate(val, "RecoveryFabricFriendlyName", &n.RecoveryFabricFriendlyName)
			delete(rawMsg, key)
		case "recoveryNetworkFriendlyName":
			err = unpopulate(val, "RecoveryNetworkFriendlyName", &n.RecoveryNetworkFriendlyName)
			delete(rawMsg, key)
		case "recoveryNetworkId":
			err = unpopulate(val, "RecoveryNetworkID", &n.RecoveryNetworkID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &n.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NewProtectionProfile.
func (n NewProtectionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appConsistentFrequencyInMinutes", n.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", n.CrashConsistentFrequencyInMinutes)
	populate(objectMap, "multiVmSyncStatus", n.MultiVMSyncStatus)
	populate(objectMap, "policyName", n.PolicyName)
	populate(objectMap, "recoveryPointHistory", n.RecoveryPointHistory)
	objectMap["resourceType"] = "New"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NewProtectionProfile.
func (n *NewProtectionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &n.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &n.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "multiVmSyncStatus":
			err = unpopulate(val, "MultiVMSyncStatus", &n.MultiVMSyncStatus)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &n.PolicyName)
			delete(rawMsg, key)
		case "recoveryPointHistory":
			err = unpopulate(val, "RecoveryPointHistory", &n.RecoveryPointHistory)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &n.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NewRecoveryVirtualNetwork.
func (n NewRecoveryVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "recoveryVirtualNetworkName", n.RecoveryVirtualNetworkName)
	populate(objectMap, "recoveryVirtualNetworkResourceGroupName", n.RecoveryVirtualNetworkResourceGroupName)
	objectMap["resourceType"] = "New"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NewRecoveryVirtualNetwork.
func (n *NewRecoveryVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recoveryVirtualNetworkName":
			err = unpopulate(val, "RecoveryVirtualNetworkName", &n.RecoveryVirtualNetworkName)
			delete(rawMsg, key)
		case "recoveryVirtualNetworkResourceGroupName":
			err = unpopulate(val, "RecoveryVirtualNetworkResourceGroupName", &n.RecoveryVirtualNetworkResourceGroupName)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &n.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlannedFailoverInputProperties.
func (p PlannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDirection", p.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", p.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlannedFailoverInputProperties.
func (p *PlannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &p.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			p.ProviderSpecificDetails, err = unmarshalPlannedFailoverProviderSpecificFailoverInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProperties.
func (p *PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			p.ProviderSpecificDetails, err = unmarshalPolicyProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessServer.
func (p *ProcessServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentExpiryDate", &p.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &p.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionDetails":
			err = unpopulate(val, "AgentVersionDetails", &p.AgentVersionDetails)
			delete(rawMsg, key)
		case "availableMemoryInBytes":
			err = unpopulate(val, "AvailableMemoryInBytes", &p.AvailableMemoryInBytes)
			delete(rawMsg, key)
		case "availableSpaceInBytes":
			err = unpopulate(val, "AvailableSpaceInBytes", &p.AvailableSpaceInBytes)
			delete(rawMsg, key)
		case "cpuLoad":
			err = unpopulate(val, "CPULoad", &p.CPULoad)
			delete(rawMsg, key)
		case "cpuLoadStatus":
			err = unpopulate(val, "CPULoadStatus", &p.CPULoadStatus)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &p.HealthErrors)
			delete(rawMsg, key)
		case "hostId":
			err = unpopulate(val, "HostID", &p.HostID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &p.IPAddress)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateTimeRFC3339(val, "LastHeartbeat", &p.LastHeartbeat)
			delete(rawMsg, key)
		case "machineCount":
			err = unpopulate(val, "MachineCount", &p.MachineCount)
			delete(rawMsg, key)
		case "marsCommunicationStatus":
			err = unpopulate(val, "MarsCommunicationStatus", &p.MarsCommunicationStatus)
			delete(rawMsg, key)
		case "marsRegistrationStatus":
			err = unpopulate(val, "MarsRegistrationStatus", &p.MarsRegistrationStatus)
			delete(rawMsg, key)
		case "memoryUsageStatus":
			err = unpopulate(val, "MemoryUsageStatus", &p.MemoryUsageStatus)
			delete(rawMsg, key)
		case "mobilityServiceUpdates":
			err = unpopulate(val, "MobilityServiceUpdates", &p.MobilityServiceUpdates)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &p.OSType)
			delete(rawMsg, key)
		case "osVersion":
			err = unpopulate(val, "OSVersion", &p.OSVersion)
			delete(rawMsg, key)
		case "psServiceStatus":
			err = unpopulate(val, "PsServiceStatus", &p.PsServiceStatus)
			delete(rawMsg, key)
		case "psStatsRefreshTime":
			err = unpopulateTimeRFC3339(val, "PsStatsRefreshTime", &p.PsStatsRefreshTime)
			delete(rawMsg, key)
		case "replicationPairCount":
			err = unpopulate(val, "ReplicationPairCount", &p.ReplicationPairCount)
			delete(rawMsg, key)
		case "sslCertExpiryDate":
			err = unpopulateTimeRFC3339(val, "SSLCertExpiryDate", &p.SSLCertExpiryDate)
			delete(rawMsg, key)
		case "sslCertExpiryRemainingDays":
			err = unpopulate(val, "SSLCertExpiryRemainingDays", &p.SSLCertExpiryRemainingDays)
			delete(rawMsg, key)
		case "spaceUsageStatus":
			err = unpopulate(val, "SpaceUsageStatus", &p.SpaceUsageStatus)
			delete(rawMsg, key)
		case "systemLoad":
			err = unpopulate(val, "SystemLoad", &p.SystemLoad)
			delete(rawMsg, key)
		case "systemLoadStatus":
			err = unpopulate(val, "SystemLoadStatus", &p.SystemLoadStatus)
			delete(rawMsg, key)
		case "throughputInBytes":
			err = unpopulate(val, "ThroughputInBytes", &p.ThroughputInBytes)
			delete(rawMsg, key)
		case "throughputInMBps":
			err = unpopulate(val, "ThroughputInMBps", &p.ThroughputInMBps)
			delete(rawMsg, key)
		case "throughputStatus":
			err = unpopulate(val, "ThroughputStatus", &p.ThroughputStatus)
			delete(rawMsg, key)
		case "throughputUploadPendingDataInBytes":
			err = unpopulate(val, "ThroughputUploadPendingDataInBytes", &p.ThroughputUploadPendingDataInBytes)
			delete(rawMsg, key)
		case "totalMemoryInBytes":
			err = unpopulate(val, "TotalMemoryInBytes", &p.TotalMemoryInBytes)
			delete(rawMsg, key)
		case "totalSpaceInBytes":
			err = unpopulate(val, "TotalSpaceInBytes", &p.TotalSpaceInBytes)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &p.VersionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProcessServerDetails.
func (p *ProcessServerDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableMemoryInBytes":
			err = unpopulate(val, "AvailableMemoryInBytes", &p.AvailableMemoryInBytes)
			delete(rawMsg, key)
		case "availableSpaceInBytes":
			err = unpopulate(val, "AvailableSpaceInBytes", &p.AvailableSpaceInBytes)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &p.BiosID)
			delete(rawMsg, key)
		case "diskUsageStatus":
			err = unpopulate(val, "DiskUsageStatus", &p.DiskUsageStatus)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &p.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &p.Fqdn)
			delete(rawMsg, key)
		case "freeSpacePercentage":
			err = unpopulate(val, "FreeSpacePercentage", &p.FreeSpacePercentage)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &p.HealthErrors)
			delete(rawMsg, key)
		case "historicHealth":
			err = unpopulate(val, "HistoricHealth", &p.HistoricHealth)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &p.IPAddresses)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &p.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "memoryUsagePercentage":
			err = unpopulate(val, "MemoryUsagePercentage", &p.MemoryUsagePercentage)
			delete(rawMsg, key)
		case "memoryUsageStatus":
			err = unpopulate(val, "MemoryUsageStatus", &p.MemoryUsageStatus)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "processorUsagePercentage":
			err = unpopulate(val, "ProcessorUsagePercentage", &p.ProcessorUsagePercentage)
			delete(rawMsg, key)
		case "processorUsageStatus":
			err = unpopulate(val, "ProcessorUsageStatus", &p.ProcessorUsageStatus)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &p.ProtectedItemCount)
			delete(rawMsg, key)
		case "systemLoad":
			err = unpopulate(val, "SystemLoad", &p.SystemLoad)
			delete(rawMsg, key)
		case "systemLoadStatus":
			err = unpopulate(val, "SystemLoadStatus", &p.SystemLoadStatus)
			delete(rawMsg, key)
		case "throughputInBytes":
			err = unpopulate(val, "ThroughputInBytes", &p.ThroughputInBytes)
			delete(rawMsg, key)
		case "throughputStatus":
			err = unpopulate(val, "ThroughputStatus", &p.ThroughputStatus)
			delete(rawMsg, key)
		case "throughputUploadPendingDataInBytes":
			err = unpopulate(val, "ThroughputUploadPendingDataInBytes", &p.ThroughputUploadPendingDataInBytes)
			delete(rawMsg, key)
		case "totalMemoryInBytes":
			err = unpopulate(val, "TotalMemoryInBytes", &p.TotalMemoryInBytes)
			delete(rawMsg, key)
		case "totalSpaceInBytes":
			err = unpopulate(val, "TotalSpaceInBytes", &p.TotalSpaceInBytes)
			delete(rawMsg, key)
		case "usedMemoryInBytes":
			err = unpopulate(val, "UsedMemoryInBytes", &p.UsedMemoryInBytes)
			delete(rawMsg, key)
		case "usedSpaceInBytes":
			err = unpopulate(val, "UsedSpaceInBytes", &p.UsedSpaceInBytes)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectableItemProperties.
func (p *ProtectableItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customDetails":
			p.CustomDetails, err = unmarshalConfigurationSettingsClassification(val)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &p.FriendlyName)
			delete(rawMsg, key)
		case "protectionReadinessErrors":
			err = unpopulate(val, "ProtectionReadinessErrors", &p.ProtectionReadinessErrors)
			delete(rawMsg, key)
		case "protectionStatus":
			err = unpopulate(val, "ProtectionStatus", &p.ProtectionStatus)
			delete(rawMsg, key)
		case "recoveryServicesProviderId":
			err = unpopulate(val, "RecoveryServicesProviderID", &p.RecoveryServicesProviderID)
			delete(rawMsg, key)
		case "replicationProtectedItemId":
			err = unpopulate(val, "ReplicationProtectedItemID", &p.ReplicationProtectedItemID)
			delete(rawMsg, key)
		case "supportedReplicationProviders":
			err = unpopulate(val, "SupportedReplicationProviders", &p.SupportedReplicationProviders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectionContainerMappingProperties.
func (p *ProtectionContainerMappingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrorDetails":
			err = unpopulate(val, "HealthErrorDetails", &p.HealthErrorDetails)
			delete(rawMsg, key)
		case "policyFriendlyName":
			err = unpopulate(val, "PolicyFriendlyName", &p.PolicyFriendlyName)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &p.PolicyID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			p.ProviderSpecificDetails, err = unmarshalProtectionContainerMappingProviderSpecificDetailsClassification(val)
			delete(rawMsg, key)
		case "sourceFabricFriendlyName":
			err = unpopulate(val, "SourceFabricFriendlyName", &p.SourceFabricFriendlyName)
			delete(rawMsg, key)
		case "sourceProtectionContainerFriendlyName":
			err = unpopulate(val, "SourceProtectionContainerFriendlyName", &p.SourceProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		case "targetFabricFriendlyName":
			err = unpopulate(val, "TargetFabricFriendlyName", &p.TargetFabricFriendlyName)
			delete(rawMsg, key)
		case "targetProtectionContainerFriendlyName":
			err = unpopulate(val, "TargetProtectionContainerFriendlyName", &p.TargetProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "targetProtectionContainerId":
			err = unpopulate(val, "TargetProtectionContainerID", &p.TargetProtectionContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PushInstallerDetails.
func (p *PushInstallerDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &p.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &p.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &p.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &p.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &p.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &p.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RcmProxyDetails.
func (r *RcmProxyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "clientAuthenticationType":
			err = unpopulate(val, "ClientAuthenticationType", &r.ClientAuthenticationType)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &r.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &r.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &r.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &r.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanA2ADetails.
func (r *RecoveryPlanA2ADetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "primaryZone":
			err = unpopulate(val, "PrimaryZone", &r.PrimaryZone)
			delete(rawMsg, key)
		case "recoveryZone":
			err = unpopulate(val, "RecoveryZone", &r.RecoveryZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanA2AFailoverInput.
func (r RecoveryPlanA2AFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cloudServiceCreationOption", r.CloudServiceCreationOption)
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "multiVmSyncPointOption", r.MultiVMSyncPointOption)
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanA2AFailoverInput.
func (r *RecoveryPlanA2AFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudServiceCreationOption":
			err = unpopulate(val, "CloudServiceCreationOption", &r.CloudServiceCreationOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "multiVmSyncPointOption":
			err = unpopulate(val, "MultiVMSyncPointOption", &r.MultiVMSyncPointOption)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanA2AInput.
func (r RecoveryPlanA2AInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "A2A"
	populate(objectMap, "primaryExtendedLocation", r.PrimaryExtendedLocation)
	populate(objectMap, "primaryZone", r.PrimaryZone)
	populate(objectMap, "recoveryExtendedLocation", r.RecoveryExtendedLocation)
	populate(objectMap, "recoveryZone", r.RecoveryZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanA2AInput.
func (r *RecoveryPlanA2AInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "primaryExtendedLocation":
			err = unpopulate(val, "PrimaryExtendedLocation", &r.PrimaryExtendedLocation)
			delete(rawMsg, key)
		case "primaryZone":
			err = unpopulate(val, "PrimaryZone", &r.PrimaryZone)
			delete(rawMsg, key)
		case "recoveryExtendedLocation":
			err = unpopulate(val, "RecoveryExtendedLocation", &r.RecoveryExtendedLocation)
			delete(rawMsg, key)
		case "recoveryZone":
			err = unpopulate(val, "RecoveryZone", &r.RecoveryZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanAction.
func (r RecoveryPlanAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actionName", r.ActionName)
	populate(objectMap, "customDetails", r.CustomDetails)
	populate(objectMap, "failoverDirections", r.FailoverDirections)
	populate(objectMap, "failoverTypes", r.FailoverTypes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanAction.
func (r *RecoveryPlanAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionName":
			err = unpopulate(val, "ActionName", &r.ActionName)
			delete(rawMsg, key)
		case "customDetails":
			r.CustomDetails, err = unmarshalRecoveryPlanActionDetailsClassification(val)
			delete(rawMsg, key)
		case "failoverDirections":
			err = unpopulate(val, "FailoverDirections", &r.FailoverDirections)
			delete(rawMsg, key)
		case "failoverTypes":
			err = unpopulate(val, "FailoverTypes", &r.FailoverTypes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanAutomationRunbookActionDetails.
func (r RecoveryPlanAutomationRunbookActionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fabricLocation", r.FabricLocation)
	objectMap["instanceType"] = "AutomationRunbookActionDetails"
	populate(objectMap, "runbookId", r.RunbookID)
	populate(objectMap, "timeout", r.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanAutomationRunbookActionDetails.
func (r *RecoveryPlanAutomationRunbookActionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricLocation":
			err = unpopulate(val, "FabricLocation", &r.FabricLocation)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "runbookId":
			err = unpopulate(val, "RunbookID", &r.RunbookID)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &r.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanGroup.
func (r RecoveryPlanGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endGroupActions", r.EndGroupActions)
	populate(objectMap, "groupType", r.GroupType)
	populate(objectMap, "replicationProtectedItems", r.ReplicationProtectedItems)
	populate(objectMap, "startGroupActions", r.StartGroupActions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanGroupTaskDetails.
func (r *RecoveryPlanGroupTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childTasks":
			err = unpopulate(val, "ChildTasks", &r.ChildTasks)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &r.GroupID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "rpGroupType":
			err = unpopulate(val, "RpGroupType", &r.RpGroupType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanHyperVReplicaAzureFailbackInput.
func (r RecoveryPlanHyperVReplicaAzureFailbackInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataSyncOption", r.DataSyncOption)
	objectMap["instanceType"] = "HyperVReplicaAzureFailback"
	populate(objectMap, "recoveryVmCreationOption", r.RecoveryVMCreationOption)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanHyperVReplicaAzureFailbackInput.
func (r *RecoveryPlanHyperVReplicaAzureFailbackInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSyncOption":
			err = unpopulate(val, "DataSyncOption", &r.DataSyncOption)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryVmCreationOption":
			err = unpopulate(val, "RecoveryVMCreationOption", &r.RecoveryVMCreationOption)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanHyperVReplicaAzureFailoverInput.
func (r RecoveryPlanHyperVReplicaAzureFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "HyperVReplicaAzure"
	populate(objectMap, "primaryKekCertificatePfx", r.PrimaryKekCertificatePfx)
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "secondaryKekCertificatePfx", r.SecondaryKekCertificatePfx)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanHyperVReplicaAzureFailoverInput.
func (r *RecoveryPlanHyperVReplicaAzureFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "primaryKekCertificatePfx":
			err = unpopulate(val, "PrimaryKekCertificatePfx", &r.PrimaryKekCertificatePfx)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "secondaryKekCertificatePfx":
			err = unpopulate(val, "SecondaryKekCertificatePfx", &r.SecondaryKekCertificatePfx)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageAzureV2FailoverInput.
func (r RecoveryPlanInMageAzureV2FailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageAzureV2"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "useMultiVmSyncPoint", r.UseMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageAzureV2FailoverInput.
func (r *RecoveryPlanInMageAzureV2FailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "useMultiVmSyncPoint":
			err = unpopulate(val, "UseMultiVMSyncPoint", &r.UseMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageFailoverInput.
func (r RecoveryPlanInMageFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMage"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageFailoverInput.
func (r *RecoveryPlanInMageFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageRcmFailbackFailoverInput.
func (r RecoveryPlanInMageRcmFailbackFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcmFailback"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "useMultiVmSyncPoint", r.UseMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageRcmFailbackFailoverInput.
func (r *RecoveryPlanInMageRcmFailbackFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "useMultiVmSyncPoint":
			err = unpopulate(val, "UseMultiVMSyncPoint", &r.UseMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanInMageRcmFailoverInput.
func (r RecoveryPlanInMageRcmFailoverInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "InMageRcm"
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	populate(objectMap, "useMultiVmSyncPoint", r.UseMultiVMSyncPoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanInMageRcmFailoverInput.
func (r *RecoveryPlanInMageRcmFailoverInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		case "useMultiVmSyncPoint":
			err = unpopulate(val, "UseMultiVMSyncPoint", &r.UseMultiVMSyncPoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanManualActionDetails.
func (r RecoveryPlanManualActionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", r.Description)
	objectMap["instanceType"] = "ManualActionDetails"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanManualActionDetails.
func (r *RecoveryPlanManualActionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanPlannedFailoverInputProperties.
func (r RecoveryPlanPlannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanPlannedFailoverInputProperties.
func (r *RecoveryPlanPlannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificFailoverInputClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanProperties.
func (r *RecoveryPlanProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedOperations":
			err = unpopulate(val, "AllowedOperations", &r.AllowedOperations)
			delete(rawMsg, key)
		case "currentScenario":
			err = unpopulate(val, "CurrentScenario", &r.CurrentScenario)
			delete(rawMsg, key)
		case "currentScenarioStatus":
			err = unpopulate(val, "CurrentScenarioStatus", &r.CurrentScenarioStatus)
			delete(rawMsg, key)
		case "currentScenarioStatusDescription":
			err = unpopulate(val, "CurrentScenarioStatusDescription", &r.CurrentScenarioStatusDescription)
			delete(rawMsg, key)
		case "failoverDeploymentModel":
			err = unpopulate(val, "FailoverDeploymentModel", &r.FailoverDeploymentModel)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &r.Groups)
			delete(rawMsg, key)
		case "lastPlannedFailoverTime":
			err = unpopulateTimeRFC3339(val, "LastPlannedFailoverTime", &r.LastPlannedFailoverTime)
			delete(rawMsg, key)
		case "lastTestFailoverTime":
			err = unpopulateTimeRFC3339(val, "LastTestFailoverTime", &r.LastTestFailoverTime)
			delete(rawMsg, key)
		case "lastUnplannedFailoverTime":
			err = unpopulateTimeRFC3339(val, "LastUnplannedFailoverTime", &r.LastUnplannedFailoverTime)
			delete(rawMsg, key)
		case "primaryFabricFriendlyName":
			err = unpopulate(val, "PrimaryFabricFriendlyName", &r.PrimaryFabricFriendlyName)
			delete(rawMsg, key)
		case "primaryFabricId":
			err = unpopulate(val, "PrimaryFabricID", &r.PrimaryFabricID)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificDetailsClassificationArray(val)
			delete(rawMsg, key)
		case "recoveryFabricFriendlyName":
			err = unpopulate(val, "RecoveryFabricFriendlyName", &r.RecoveryFabricFriendlyName)
			delete(rawMsg, key)
		case "recoveryFabricId":
			err = unpopulate(val, "RecoveryFabricID", &r.RecoveryFabricID)
			delete(rawMsg, key)
		case "replicationProviders":
			err = unpopulate(val, "ReplicationProviders", &r.ReplicationProviders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanScriptActionDetails.
func (r RecoveryPlanScriptActionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fabricLocation", r.FabricLocation)
	objectMap["instanceType"] = "ScriptActionDetails"
	populate(objectMap, "path", r.Path)
	populate(objectMap, "timeout", r.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanScriptActionDetails.
func (r *RecoveryPlanScriptActionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricLocation":
			err = unpopulate(val, "FabricLocation", &r.FabricLocation)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &r.Path)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &r.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanShutdownGroupTaskDetails.
func (r *RecoveryPlanShutdownGroupTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childTasks":
			err = unpopulate(val, "ChildTasks", &r.ChildTasks)
			delete(rawMsg, key)
		case "groupId":
			err = unpopulate(val, "GroupID", &r.GroupID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "rpGroupType":
			err = unpopulate(val, "RpGroupType", &r.RpGroupType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanTestFailoverInputProperties.
func (r RecoveryPlanTestFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "networkId", r.NetworkID)
	populate(objectMap, "networkType", r.NetworkType)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanTestFailoverInputProperties.
func (r *RecoveryPlanTestFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &r.NetworkID)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &r.NetworkType)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificFailoverInputClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPlanUnplannedFailoverInputProperties.
func (r RecoveryPlanUnplannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	populate(objectMap, "sourceSiteOperations", r.SourceSiteOperations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPlanUnplannedFailoverInputProperties.
func (r *RecoveryPlanUnplannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRecoveryPlanProviderSpecificFailoverInputClassificationArray(val)
			delete(rawMsg, key)
		case "sourceSiteOperations":
			err = unpopulate(val, "SourceSiteOperations", &r.SourceSiteOperations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointProperties.
func (r *RecoveryPointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalProviderSpecificRecoveryPointDetailsClassification(val)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateTimeRFC3339(val, "RecoveryPointTime", &r.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryServicesProviderProperties.
func (r *RecoveryServicesProviderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedScenarios":
			err = unpopulate(val, "AllowedScenarios", &r.AllowedScenarios)
			delete(rawMsg, key)
		case "authenticationIdentityDetails":
			err = unpopulate(val, "AuthenticationIdentityDetails", &r.AuthenticationIdentityDetails)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &r.ConnectionStatus)
			delete(rawMsg, key)
		case "dataPlaneAuthenticationIdentityDetails":
			err = unpopulate(val, "DataPlaneAuthenticationIdentityDetails", &r.DataPlaneAuthenticationIdentityDetails)
			delete(rawMsg, key)
		case "draIdentifier":
			err = unpopulate(val, "DraIdentifier", &r.DraIdentifier)
			delete(rawMsg, key)
		case "fabricFriendlyName":
			err = unpopulate(val, "FabricFriendlyName", &r.FabricFriendlyName)
			delete(rawMsg, key)
		case "fabricType":
			err = unpopulate(val, "FabricType", &r.FabricType)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "healthErrorDetails":
			err = unpopulate(val, "HealthErrorDetails", &r.HealthErrorDetails)
			delete(rawMsg, key)
		case "lastHeartBeat":
			err = unpopulateTimeRFC3339(val, "LastHeartBeat", &r.LastHeartBeat)
			delete(rawMsg, key)
		case "machineId":
			err = unpopulate(val, "MachineID", &r.MachineID)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &r.MachineName)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &r.ProtectedItemCount)
			delete(rawMsg, key)
		case "providerVersion":
			err = unpopulate(val, "ProviderVersion", &r.ProviderVersion)
			delete(rawMsg, key)
		case "providerVersionDetails":
			err = unpopulate(val, "ProviderVersionDetails", &r.ProviderVersionDetails)
			delete(rawMsg, key)
		case "providerVersionExpiryDate":
			err = unpopulateTimeRFC3339(val, "ProviderVersionExpiryDate", &r.ProviderVersionExpiryDate)
			delete(rawMsg, key)
		case "providerVersionState":
			err = unpopulate(val, "ProviderVersionState", &r.ProviderVersionState)
			delete(rawMsg, key)
		case "resourceAccessIdentityDetails":
			err = unpopulate(val, "ResourceAccessIdentityDetails", &r.ResourceAccessIdentityDetails)
			delete(rawMsg, key)
		case "serverVersion":
			err = unpopulate(val, "ServerVersion", &r.ServerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RemoveDisksInputProperties.
func (r RemoveDisksInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RemoveDisksInputProperties.
func (r *RemoveDisksInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalRemoveDisksProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationAgentDetails.
func (r *ReplicationAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &r.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &r.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &r.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &r.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationApplianceProperties.
func (r *ReplicationApplianceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalApplianceSpecificDetailsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationGroupDetails.
func (r *ReplicationGroupDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectedItemProperties.
func (r *ReplicationProtectedItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeLocation":
			err = unpopulate(val, "ActiveLocation", &r.ActiveLocation)
			delete(rawMsg, key)
		case "allowedOperations":
			err = unpopulate(val, "AllowedOperations", &r.AllowedOperations)
			delete(rawMsg, key)
		case "currentScenario":
			err = unpopulate(val, "CurrentScenario", &r.CurrentScenario)
			delete(rawMsg, key)
		case "eventCorrelationId":
			err = unpopulate(val, "EventCorrelationID", &r.EventCorrelationID)
			delete(rawMsg, key)
		case "failoverHealth":
			err = unpopulate(val, "FailoverHealth", &r.FailoverHealth)
			delete(rawMsg, key)
		case "failoverRecoveryPointId":
			err = unpopulate(val, "FailoverRecoveryPointID", &r.FailoverRecoveryPointID)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "lastSuccessfulFailoverTime":
			err = unpopulateTimeRFC3339(val, "LastSuccessfulFailoverTime", &r.LastSuccessfulFailoverTime)
			delete(rawMsg, key)
		case "lastSuccessfulTestFailoverTime":
			err = unpopulateTimeRFC3339(val, "LastSuccessfulTestFailoverTime", &r.LastSuccessfulTestFailoverTime)
			delete(rawMsg, key)
		case "policyFriendlyName":
			err = unpopulate(val, "PolicyFriendlyName", &r.PolicyFriendlyName)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &r.PolicyID)
			delete(rawMsg, key)
		case "primaryFabricFriendlyName":
			err = unpopulate(val, "PrimaryFabricFriendlyName", &r.PrimaryFabricFriendlyName)
			delete(rawMsg, key)
		case "primaryFabricProvider":
			err = unpopulate(val, "PrimaryFabricProvider", &r.PrimaryFabricProvider)
			delete(rawMsg, key)
		case "primaryProtectionContainerFriendlyName":
			err = unpopulate(val, "PrimaryProtectionContainerFriendlyName", &r.PrimaryProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "protectableItemId":
			err = unpopulate(val, "ProtectableItemID", &r.ProtectableItemID)
			delete(rawMsg, key)
		case "protectedItemType":
			err = unpopulate(val, "ProtectedItemType", &r.ProtectedItemType)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &r.ProtectionState)
			delete(rawMsg, key)
		case "protectionStateDescription":
			err = unpopulate(val, "ProtectionStateDescription", &r.ProtectionStateDescription)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalReplicationProviderSpecificSettingsClassification(val)
			delete(rawMsg, key)
		case "recoveryContainerId":
			err = unpopulate(val, "RecoveryContainerID", &r.RecoveryContainerID)
			delete(rawMsg, key)
		case "recoveryFabricFriendlyName":
			err = unpopulate(val, "RecoveryFabricFriendlyName", &r.RecoveryFabricFriendlyName)
			delete(rawMsg, key)
		case "recoveryFabricId":
			err = unpopulate(val, "RecoveryFabricID", &r.RecoveryFabricID)
			delete(rawMsg, key)
		case "recoveryProtectionContainerFriendlyName":
			err = unpopulate(val, "RecoveryProtectionContainerFriendlyName", &r.RecoveryProtectionContainerFriendlyName)
			delete(rawMsg, key)
		case "recoveryServicesProviderId":
			err = unpopulate(val, "RecoveryServicesProviderID", &r.RecoveryServicesProviderID)
			delete(rawMsg, key)
		case "replicationHealth":
			err = unpopulate(val, "ReplicationHealth", &r.ReplicationHealth)
			delete(rawMsg, key)
		case "switchProviderState":
			err = unpopulate(val, "SwitchProviderState", &r.SwitchProviderState)
			delete(rawMsg, key)
		case "switchProviderStateDescription":
			err = unpopulate(val, "SwitchProviderStateDescription", &r.SwitchProviderStateDescription)
			delete(rawMsg, key)
		case "testFailoverState":
			err = unpopulate(val, "TestFailoverState", &r.TestFailoverState)
			delete(rawMsg, key)
		case "testFailoverStateDescription":
			err = unpopulate(val, "TestFailoverStateDescription", &r.TestFailoverStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationProtectionIntentProperties.
func (r *ReplicationProtectionIntentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationTimeUTC":
			err = unpopulate(val, "CreationTimeUTC", &r.CreationTimeUTC)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &r.FriendlyName)
			delete(rawMsg, key)
		case "isActive":
			err = unpopulate(val, "IsActive", &r.IsActive)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &r.JobID)
			delete(rawMsg, key)
		case "jobState":
			err = unpopulate(val, "JobState", &r.JobState)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalReplicationProtectionIntentProviderSpecificSettingsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReprotectAgentDetails.
func (r *ReprotectAgentDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessibleDatastores":
			err = unpopulate(val, "AccessibleDatastores", &r.AccessibleDatastores)
			delete(rawMsg, key)
		case "biosId":
			err = unpopulate(val, "BiosID", &r.BiosID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &r.FabricObjectID)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &r.Fqdn)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &r.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &r.HealthErrors)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "lastDiscoveryInUtc":
			err = unpopulateTimeRFC3339(val, "LastDiscoveryInUTC", &r.LastDiscoveryInUTC)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &r.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "protectedItemCount":
			err = unpopulate(val, "ProtectedItemCount", &r.ProtectedItemCount)
			delete(rawMsg, key)
		case "vcenterId":
			err = unpopulate(val, "VcenterID", &r.VcenterID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &r.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResolveHealthInputProperties.
func (r ResolveHealthInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "healthErrors", r.HealthErrors)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ResyncInputProperties.
func (r ResyncInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResyncInputProperties.
func (r *ResyncInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalResyncProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReverseReplicationInputProperties.
func (r ReverseReplicationInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDirection", r.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", r.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReverseReplicationInputProperties.
func (r *ReverseReplicationInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &r.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			r.ProviderSpecificDetails, err = unmarshalReverseReplicationProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptActionTaskDetails.
func (s *ScriptActionTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &s.InstanceType)
			delete(rawMsg, key)
		case "isPrimarySideScript":
			err = unpopulate(val, "IsPrimarySideScript", &s.IsPrimarySideScript)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &s.Output)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProtectionInputProperties.
func (s SwitchProtectionInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", s.ProviderSpecificDetails)
	populate(objectMap, "replicationProtectedItemName", s.ReplicationProtectedItemName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProtectionInputProperties.
func (s *SwitchProtectionInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			s.ProviderSpecificDetails, err = unmarshalSwitchProtectionProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "replicationProtectedItemName":
			err = unpopulate(val, "ReplicationProtectedItemName", &s.ReplicationProtectedItemName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProtectionJobDetails.
func (s *SwitchProtectionJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &s.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &s.InstanceType)
			delete(rawMsg, key)
		case "newReplicationProtectedItemId":
			err = unpopulate(val, "NewReplicationProtectedItemID", &s.NewReplicationProtectedItemID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SwitchProviderInputProperties.
func (s SwitchProviderInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", s.ProviderSpecificDetails)
	populate(objectMap, "targetInstanceType", s.TargetInstanceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SwitchProviderInputProperties.
func (s *SwitchProviderInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			s.ProviderSpecificDetails, err = unmarshalSwitchProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "targetInstanceType":
			err = unpopulate(val, "TargetInstanceType", &s.TargetInstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverInputProperties.
func (t TestFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDirection", t.FailoverDirection)
	populate(objectMap, "networkId", t.NetworkID)
	populate(objectMap, "networkType", t.NetworkType)
	populate(objectMap, "providerSpecificDetails", t.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverInputProperties.
func (t *TestFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &t.FailoverDirection)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &t.NetworkID)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &t.NetworkType)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			t.ProviderSpecificDetails, err = unmarshalTestFailoverProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverJobDetails.
func (t *TestFailoverJobDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &t.AffectedObjectDetails)
			delete(rawMsg, key)
		case "comments":
			err = unpopulate(val, "Comments", &t.Comments)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		case "networkFriendlyName":
			err = unpopulate(val, "NetworkFriendlyName", &t.NetworkFriendlyName)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &t.NetworkName)
			delete(rawMsg, key)
		case "networkType":
			err = unpopulate(val, "NetworkType", &t.NetworkType)
			delete(rawMsg, key)
		case "protectedItemDetails":
			err = unpopulate(val, "ProtectedItemDetails", &t.ProtectedItemDetails)
			delete(rawMsg, key)
		case "testFailoverStatus":
			err = unpopulate(val, "TestFailoverStatus", &t.TestFailoverStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestMigrateInputProperties.
func (t TestMigrateInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", t.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestMigrateInputProperties.
func (t *TestMigrateInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			t.ProviderSpecificDetails, err = unmarshalTestMigrateProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UnplannedFailoverInputProperties.
func (u UnplannedFailoverInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "failoverDirection", u.FailoverDirection)
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	populate(objectMap, "sourceSiteOperations", u.SourceSiteOperations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UnplannedFailoverInputProperties.
func (u *UnplannedFailoverInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failoverDirection":
			err = unpopulate(val, "FailoverDirection", &u.FailoverDirection)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUnplannedFailoverProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "sourceSiteOperations":
			err = unpopulate(val, "SourceSiteOperations", &u.SourceSiteOperations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateApplianceForReplicationProtectedItemInputProperties.
func (u UpdateApplianceForReplicationProtectedItemInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	populate(objectMap, "targetApplianceId", u.TargetApplianceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateApplianceForReplicationProtectedItemInputProperties.
func (u *UpdateApplianceForReplicationProtectedItemInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUpdateApplianceForReplicationProtectedItemProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		case "targetApplianceId":
			err = unpopulate(val, "TargetApplianceID", &u.TargetApplianceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMigrationItemInput.
func (u UpdateMigrationItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateMigrationItemInputProperties.
func (u UpdateMigrationItemInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateMigrationItemInputProperties.
func (u *UpdateMigrationItemInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUpdateMigrationItemProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateNetworkMappingInput.
func (u UpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateNetworkMappingInputProperties.
func (u UpdateNetworkMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "fabricSpecificDetails", u.FabricSpecificDetails)
	populate(objectMap, "recoveryFabricName", u.RecoveryFabricName)
	populate(objectMap, "recoveryNetworkId", u.RecoveryNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateNetworkMappingInputProperties.
func (u *UpdateNetworkMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricSpecificDetails":
			u.FabricSpecificDetails, err = unmarshalFabricSpecificUpdateNetworkMappingInputClassification(val)
			delete(rawMsg, key)
		case "recoveryFabricName":
			err = unpopulate(val, "RecoveryFabricName", &u.RecoveryFabricName)
			delete(rawMsg, key)
		case "recoveryNetworkId":
			err = unpopulate(val, "RecoveryNetworkID", &u.RecoveryNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdatePolicyInput.
func (u UpdatePolicyInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdatePolicyInputProperties.
func (u UpdatePolicyInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "replicationProviderSettings", u.ReplicationProviderSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdatePolicyInputProperties.
func (u *UpdatePolicyInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "replicationProviderSettings":
			u.ReplicationProviderSettings, err = unmarshalPolicyProviderSpecificInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateProtectionContainerMappingInput.
func (u UpdateProtectionContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateProtectionContainerMappingInputProperties.
func (u UpdateProtectionContainerMappingInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "providerSpecificInput", u.ProviderSpecificInput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateProtectionContainerMappingInputProperties.
func (u *UpdateProtectionContainerMappingInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "providerSpecificInput":
			u.ProviderSpecificInput, err = unmarshalReplicationProviderSpecificUpdateContainerMappingInputClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateRecoveryPlanInput.
func (u UpdateRecoveryPlanInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateRecoveryPlanInputProperties.
func (u UpdateRecoveryPlanInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groups", u.Groups)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateReplicationProtectedItemInput.
func (u UpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateReplicationProtectedItemInputProperties.
func (u UpdateReplicationProtectedItemInputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enableRdpOnTargetOption", u.EnableRdpOnTargetOption)
	populate(objectMap, "licenseType", u.LicenseType)
	populate(objectMap, "providerSpecificDetails", u.ProviderSpecificDetails)
	populate(objectMap, "recoveryAvailabilitySetId", u.RecoveryAvailabilitySetID)
	populate(objectMap, "recoveryAzureVMName", u.RecoveryAzureVMName)
	populate(objectMap, "recoveryAzureVMSize", u.RecoveryAzureVMSize)
	populate(objectMap, "selectedRecoveryAzureNetworkId", u.SelectedRecoveryAzureNetworkID)
	populate(objectMap, "selectedSourceNicId", u.SelectedSourceNicID)
	populate(objectMap, "selectedTfoAzureNetworkId", u.SelectedTfoAzureNetworkID)
	populate(objectMap, "vmNics", u.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateReplicationProtectedItemInputProperties.
func (u *UpdateReplicationProtectedItemInputProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableRdpOnTargetOption":
			err = unpopulate(val, "EnableRdpOnTargetOption", &u.EnableRdpOnTargetOption)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &u.LicenseType)
			delete(rawMsg, key)
		case "providerSpecificDetails":
			u.ProviderSpecificDetails, err = unmarshalUpdateReplicationProtectedItemProviderInputClassification(val)
			delete(rawMsg, key)
		case "recoveryAvailabilitySetId":
			err = unpopulate(val, "RecoveryAvailabilitySetID", &u.RecoveryAvailabilitySetID)
			delete(rawMsg, key)
		case "recoveryAzureVMName":
			err = unpopulate(val, "RecoveryAzureVMName", &u.RecoveryAzureVMName)
			delete(rawMsg, key)
		case "recoveryAzureVMSize":
			err = unpopulate(val, "RecoveryAzureVMSize", &u.RecoveryAzureVMSize)
			delete(rawMsg, key)
		case "selectedRecoveryAzureNetworkId":
			err = unpopulate(val, "SelectedRecoveryAzureNetworkID", &u.SelectedRecoveryAzureNetworkID)
			delete(rawMsg, key)
		case "selectedSourceNicId":
			err = unpopulate(val, "SelectedSourceNicID", &u.SelectedSourceNicID)
			delete(rawMsg, key)
		case "selectedTfoAzureNetworkId":
			err = unpopulate(val, "SelectedTfoAzureNetworkID", &u.SelectedTfoAzureNetworkID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &u.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateVCenterRequest.
func (u UpdateVCenterRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VCenterProperties.
func (v *VCenterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "discoveryStatus":
			err = unpopulate(val, "DiscoveryStatus", &v.DiscoveryStatus)
			delete(rawMsg, key)
		case "fabricArmResourceName":
			err = unpopulate(val, "FabricArmResourceName", &v.FabricArmResourceName)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &v.FriendlyName)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &v.HealthErrors)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &v.IPAddress)
			delete(rawMsg, key)
		case "infrastructureId":
			err = unpopulate(val, "InfrastructureID", &v.InfrastructureID)
			delete(rawMsg, key)
		case "internalId":
			err = unpopulate(val, "InternalID", &v.InternalID)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateTimeRFC3339(val, "LastHeartbeat", &v.LastHeartbeat)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &v.Port)
			delete(rawMsg, key)
		case "processServerId":
			err = unpopulate(val, "ProcessServerID", &v.ProcessServerID)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &v.RunAsAccountID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMNicInputDetails.
func (v VMNicInputDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "enableAcceleratedNetworkingOnRecovery", v.EnableAcceleratedNetworkingOnRecovery)
	populate(objectMap, "enableAcceleratedNetworkingOnTfo", v.EnableAcceleratedNetworkingOnTfo)
	populate(objectMap, "ipConfigs", v.IPConfigs)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "recoveryNetworkSecurityGroupId", v.RecoveryNetworkSecurityGroupID)
	populate(objectMap, "recoveryNicName", v.RecoveryNicName)
	populate(objectMap, "recoveryNicResourceGroupName", v.RecoveryNicResourceGroupName)
	populate(objectMap, "reuseExistingNic", v.ReuseExistingNic)
	populate(objectMap, "selectionType", v.SelectionType)
	populate(objectMap, "targetNicName", v.TargetNicName)
	populate(objectMap, "tfoNetworkSecurityGroupId", v.TfoNetworkSecurityGroupID)
	populate(objectMap, "tfoNicName", v.TfoNicName)
	populate(objectMap, "tfoNicResourceGroupName", v.TfoNicResourceGroupName)
	populate(objectMap, "tfoReuseExistingNic", v.TfoReuseExistingNic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMNicUpdatesTaskDetails.
func (v *VMNicUpdatesTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtContainerCreationInput.
func (v VMwareCbtContainerCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VMwareCbt"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtContainerCreationInput.
func (v *VMwareCbtContainerCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtContainerMappingInput.
func (v VMwareCbtContainerMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "keyVaultId", v.KeyVaultID)
	populate(objectMap, "keyVaultUri", v.KeyVaultURI)
	populate(objectMap, "serviceBusConnectionStringSecretName", v.ServiceBusConnectionStringSecretName)
	populate(objectMap, "storageAccountId", v.StorageAccountID)
	populate(objectMap, "storageAccountSasSecretName", v.StorageAccountSasSecretName)
	populate(objectMap, "targetLocation", v.TargetLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtContainerMappingInput.
func (v *VMwareCbtContainerMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &v.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultUri":
			err = unpopulate(val, "KeyVaultURI", &v.KeyVaultURI)
			delete(rawMsg, key)
		case "serviceBusConnectionStringSecretName":
			err = unpopulate(val, "ServiceBusConnectionStringSecretName", &v.ServiceBusConnectionStringSecretName)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &v.StorageAccountID)
			delete(rawMsg, key)
		case "storageAccountSasSecretName":
			err = unpopulate(val, "StorageAccountSasSecretName", &v.StorageAccountSasSecretName)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &v.TargetLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtEnableMigrationInput.
func (v VMwareCbtEnableMigrationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataMoverRunAsAccountId", v.DataMoverRunAsAccountID)
	populate(objectMap, "disksToInclude", v.DisksToInclude)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "performAutoResync", v.PerformAutoResync)
	populate(objectMap, "sqlServerLicenseType", v.SQLServerLicenseType)
	populate(objectMap, "seedDiskTags", v.SeedDiskTags)
	populate(objectMap, "snapshotRunAsAccountId", v.SnapshotRunAsAccountID)
	populate(objectMap, "targetAvailabilitySetId", v.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", v.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", v.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetDiskTags", v.TargetDiskTags)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "targetNicTags", v.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", v.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", v.TargetResourceGroupID)
	populate(objectMap, "targetSubnetName", v.TargetSubnetName)
	populate(objectMap, "targetVmName", v.TargetVMName)
	populate(objectMap, "targetVmSize", v.TargetVMSize)
	populate(objectMap, "targetVmTags", v.TargetVMTags)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	populate(objectMap, "testSubnetName", v.TestSubnetName)
	populate(objectMap, "vmwareMachineId", v.VmwareMachineID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtEnableMigrationInput.
func (v *VMwareCbtEnableMigrationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataMoverRunAsAccountId":
			err = unpopulate(val, "DataMoverRunAsAccountID", &v.DataMoverRunAsAccountID)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &v.DisksToInclude)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "performAutoResync":
			err = unpopulate(val, "PerformAutoResync", &v.PerformAutoResync)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &v.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedDiskTags":
			err = unpopulate(val, "SeedDiskTags", &v.SeedDiskTags)
			delete(rawMsg, key)
		case "snapshotRunAsAccountId":
			err = unpopulate(val, "SnapshotRunAsAccountID", &v.SnapshotRunAsAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &v.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &v.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &v.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetDiskTags":
			err = unpopulate(val, "TargetDiskTags", &v.TargetDiskTags)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &v.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &v.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &v.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetSubnetName":
			err = unpopulate(val, "TargetSubnetName", &v.TargetSubnetName)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &v.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &v.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &v.TargetVMTags)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		case "testSubnetName":
			err = unpopulate(val, "TestSubnetName", &v.TestSubnetName)
			delete(rawMsg, key)
		case "vmwareMachineId":
			err = unpopulate(val, "VmwareMachineID", &v.VmwareMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtEventDetails.
func (v *VMwareCbtEventDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "migrationItemName":
			err = unpopulate(val, "MigrationItemName", &v.MigrationItemName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtMigrateInput.
func (v VMwareCbtMigrateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "performShutdown", v.PerformShutdown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtMigrateInput.
func (v *VMwareCbtMigrateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "performShutdown":
			err = unpopulate(val, "PerformShutdown", &v.PerformShutdown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtMigrationDetails.
func (v *VMwareCbtMigrationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataMoverRunAsAccountId":
			err = unpopulate(val, "DataMoverRunAsAccountID", &v.DataMoverRunAsAccountID)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &v.FirmwareType)
			delete(rawMsg, key)
		case "initialSeedingProgressPercentage":
			err = unpopulate(val, "InitialSeedingProgressPercentage", &v.InitialSeedingProgressPercentage)
			delete(rawMsg, key)
		case "initialSeedingRetryCount":
			err = unpopulate(val, "InitialSeedingRetryCount", &v.InitialSeedingRetryCount)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "lastRecoveryPointId":
			err = unpopulate(val, "LastRecoveryPointID", &v.LastRecoveryPointID)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateTimeRFC3339(val, "LastRecoveryPointReceived", &v.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "migrationProgressPercentage":
			err = unpopulate(val, "MigrationProgressPercentage", &v.MigrationProgressPercentage)
			delete(rawMsg, key)
		case "migrationRecoveryPointId":
			err = unpopulate(val, "MigrationRecoveryPointID", &v.MigrationRecoveryPointID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "performAutoResync":
			err = unpopulate(val, "PerformAutoResync", &v.PerformAutoResync)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &v.ProtectedDisks)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &v.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &v.ResyncRequired)
			delete(rawMsg, key)
		case "resyncRetryCount":
			err = unpopulate(val, "ResyncRetryCount", &v.ResyncRetryCount)
			delete(rawMsg, key)
		case "resyncState":
			err = unpopulate(val, "ResyncState", &v.ResyncState)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &v.SQLServerLicenseType)
			delete(rawMsg, key)
		case "seedDiskTags":
			err = unpopulate(val, "SeedDiskTags", &v.SeedDiskTags)
			delete(rawMsg, key)
		case "snapshotRunAsAccountId":
			err = unpopulate(val, "SnapshotRunAsAccountID", &v.SnapshotRunAsAccountID)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &v.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &v.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &v.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetDiskTags":
			err = unpopulate(val, "TargetDiskTags", &v.TargetDiskTags)
			delete(rawMsg, key)
		case "targetGeneration":
			err = unpopulate(val, "TargetGeneration", &v.TargetGeneration)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &v.TargetLocation)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &v.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &v.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &v.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &v.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &v.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &v.TargetVMTags)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &v.VMNics)
			delete(rawMsg, key)
		case "vmwareMachineId":
			err = unpopulate(val, "VmwareMachineID", &v.VmwareMachineID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtPolicyCreationInput.
func (v VMwareCbtPolicyCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appConsistentFrequencyInMinutes", v.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", v.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "recoveryPointHistoryInMinutes", v.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtPolicyCreationInput.
func (v *VMwareCbtPolicyCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &v.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &v.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &v.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtProtectionContainerMappingDetails.
func (v *VMwareCbtProtectionContainerMappingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &v.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultUri":
			err = unpopulate(val, "KeyVaultURI", &v.KeyVaultURI)
			delete(rawMsg, key)
		case "serviceBusConnectionStringSecretName":
			err = unpopulate(val, "ServiceBusConnectionStringSecretName", &v.ServiceBusConnectionStringSecretName)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &v.StorageAccountID)
			delete(rawMsg, key)
		case "storageAccountSasSecretName":
			err = unpopulate(val, "StorageAccountSasSecretName", &v.StorageAccountSasSecretName)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &v.TargetLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtResyncInput.
func (v VMwareCbtResyncInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "skipCbtReset", v.SkipCbtReset)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtResyncInput.
func (v *VMwareCbtResyncInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "skipCbtReset":
			err = unpopulate(val, "SkipCbtReset", &v.SkipCbtReset)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtTestMigrateInput.
func (v VMwareCbtTestMigrateInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "networkId", v.NetworkID)
	populate(objectMap, "recoveryPointId", v.RecoveryPointID)
	populate(objectMap, "vmNics", v.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtTestMigrateInput.
func (v *VMwareCbtTestMigrateInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &v.NetworkID)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &v.RecoveryPointID)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &v.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCbtUpdateMigrationItemInput.
func (v VMwareCbtUpdateMigrationItemInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VMwareCbt"
	populate(objectMap, "licenseType", v.LicenseType)
	populate(objectMap, "performAutoResync", v.PerformAutoResync)
	populate(objectMap, "sqlServerLicenseType", v.SQLServerLicenseType)
	populate(objectMap, "targetAvailabilitySetId", v.TargetAvailabilitySetID)
	populate(objectMap, "targetAvailabilityZone", v.TargetAvailabilityZone)
	populate(objectMap, "targetBootDiagnosticsStorageAccountId", v.TargetBootDiagnosticsStorageAccountID)
	populate(objectMap, "targetDiskTags", v.TargetDiskTags)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "targetNicTags", v.TargetNicTags)
	populate(objectMap, "targetProximityPlacementGroupId", v.TargetProximityPlacementGroupID)
	populate(objectMap, "targetResourceGroupId", v.TargetResourceGroupID)
	populate(objectMap, "targetVmName", v.TargetVMName)
	populate(objectMap, "targetVmSize", v.TargetVMSize)
	populate(objectMap, "targetVmTags", v.TargetVMTags)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	populate(objectMap, "vmDisks", v.VMDisks)
	populate(objectMap, "vmNics", v.VMNics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCbtUpdateMigrationItemInput.
func (v *VMwareCbtUpdateMigrationItemInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &v.LicenseType)
			delete(rawMsg, key)
		case "performAutoResync":
			err = unpopulate(val, "PerformAutoResync", &v.PerformAutoResync)
			delete(rawMsg, key)
		case "sqlServerLicenseType":
			err = unpopulate(val, "SQLServerLicenseType", &v.SQLServerLicenseType)
			delete(rawMsg, key)
		case "targetAvailabilitySetId":
			err = unpopulate(val, "TargetAvailabilitySetID", &v.TargetAvailabilitySetID)
			delete(rawMsg, key)
		case "targetAvailabilityZone":
			err = unpopulate(val, "TargetAvailabilityZone", &v.TargetAvailabilityZone)
			delete(rawMsg, key)
		case "targetBootDiagnosticsStorageAccountId":
			err = unpopulate(val, "TargetBootDiagnosticsStorageAccountID", &v.TargetBootDiagnosticsStorageAccountID)
			delete(rawMsg, key)
		case "targetDiskTags":
			err = unpopulate(val, "TargetDiskTags", &v.TargetDiskTags)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "targetNicTags":
			err = unpopulate(val, "TargetNicTags", &v.TargetNicTags)
			delete(rawMsg, key)
		case "targetProximityPlacementGroupId":
			err = unpopulate(val, "TargetProximityPlacementGroupID", &v.TargetProximityPlacementGroupID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &v.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &v.TargetVMName)
			delete(rawMsg, key)
		case "targetVmSize":
			err = unpopulate(val, "TargetVMSize", &v.TargetVMSize)
			delete(rawMsg, key)
		case "targetVmTags":
			err = unpopulate(val, "TargetVMTags", &v.TargetVMTags)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		case "vmDisks":
			err = unpopulate(val, "VMDisks", &v.VMDisks)
			delete(rawMsg, key)
		case "vmNics":
			err = unpopulate(val, "VMNics", &v.VMNics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareDetails.
func (v *VMwareDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentCount":
			err = unpopulate(val, "AgentCount", &v.AgentCount)
			delete(rawMsg, key)
		case "agentExpiryDate":
			err = unpopulateTimeRFC3339(val, "AgentExpiryDate", &v.AgentExpiryDate)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &v.AgentVersion)
			delete(rawMsg, key)
		case "agentVersionDetails":
			err = unpopulate(val, "AgentVersionDetails", &v.AgentVersionDetails)
			delete(rawMsg, key)
		case "availableMemoryInBytes":
			err = unpopulate(val, "AvailableMemoryInBytes", &v.AvailableMemoryInBytes)
			delete(rawMsg, key)
		case "availableSpaceInBytes":
			err = unpopulate(val, "AvailableSpaceInBytes", &v.AvailableSpaceInBytes)
			delete(rawMsg, key)
		case "cpuLoad":
			err = unpopulate(val, "CPULoad", &v.CPULoad)
			delete(rawMsg, key)
		case "cpuLoadStatus":
			err = unpopulate(val, "CPULoadStatus", &v.CPULoadStatus)
			delete(rawMsg, key)
		case "csServiceStatus":
			err = unpopulate(val, "CsServiceStatus", &v.CsServiceStatus)
			delete(rawMsg, key)
		case "databaseServerLoad":
			err = unpopulate(val, "DatabaseServerLoad", &v.DatabaseServerLoad)
			delete(rawMsg, key)
		case "databaseServerLoadStatus":
			err = unpopulate(val, "DatabaseServerLoadStatus", &v.DatabaseServerLoadStatus)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &v.HostName)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &v.IPAddress)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateTimeRFC3339(val, "LastHeartbeat", &v.LastHeartbeat)
			delete(rawMsg, key)
		case "masterTargetServers":
			err = unpopulate(val, "MasterTargetServers", &v.MasterTargetServers)
			delete(rawMsg, key)
		case "memoryUsageStatus":
			err = unpopulate(val, "MemoryUsageStatus", &v.MemoryUsageStatus)
			delete(rawMsg, key)
		case "processServerCount":
			err = unpopulate(val, "ProcessServerCount", &v.ProcessServerCount)
			delete(rawMsg, key)
		case "processServers":
			err = unpopulate(val, "ProcessServers", &v.ProcessServers)
			delete(rawMsg, key)
		case "protectedServers":
			err = unpopulate(val, "ProtectedServers", &v.ProtectedServers)
			delete(rawMsg, key)
		case "psTemplateVersion":
			err = unpopulate(val, "PsTemplateVersion", &v.PsTemplateVersion)
			delete(rawMsg, key)
		case "replicationPairCount":
			err = unpopulate(val, "ReplicationPairCount", &v.ReplicationPairCount)
			delete(rawMsg, key)
		case "runAsAccounts":
			err = unpopulate(val, "RunAsAccounts", &v.RunAsAccounts)
			delete(rawMsg, key)
		case "sslCertExpiryDate":
			err = unpopulateTimeRFC3339(val, "SSLCertExpiryDate", &v.SSLCertExpiryDate)
			delete(rawMsg, key)
		case "sslCertExpiryRemainingDays":
			err = unpopulate(val, "SSLCertExpiryRemainingDays", &v.SSLCertExpiryRemainingDays)
			delete(rawMsg, key)
		case "spaceUsageStatus":
			err = unpopulate(val, "SpaceUsageStatus", &v.SpaceUsageStatus)
			delete(rawMsg, key)
		case "switchProviderBlockingErrorDetails":
			err = unpopulate(val, "SwitchProviderBlockingErrorDetails", &v.SwitchProviderBlockingErrorDetails)
			delete(rawMsg, key)
		case "systemLoad":
			err = unpopulate(val, "SystemLoad", &v.SystemLoad)
			delete(rawMsg, key)
		case "systemLoadStatus":
			err = unpopulate(val, "SystemLoadStatus", &v.SystemLoadStatus)
			delete(rawMsg, key)
		case "totalMemoryInBytes":
			err = unpopulate(val, "TotalMemoryInBytes", &v.TotalMemoryInBytes)
			delete(rawMsg, key)
		case "totalSpaceInBytes":
			err = unpopulate(val, "TotalSpaceInBytes", &v.TotalSpaceInBytes)
			delete(rawMsg, key)
		case "versionStatus":
			err = unpopulate(val, "VersionStatus", &v.VersionStatus)
			delete(rawMsg, key)
		case "webLoad":
			err = unpopulate(val, "WebLoad", &v.WebLoad)
			delete(rawMsg, key)
		case "webLoadStatus":
			err = unpopulate(val, "WebLoadStatus", &v.WebLoadStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareV2FabricCreationInput.
func (v VMwareV2FabricCreationInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VMwareV2"
	populate(objectMap, "migrationSolutionId", v.MigrationSolutionID)
	populate(objectMap, "physicalSiteId", v.PhysicalSiteID)
	populate(objectMap, "vmwareSiteId", v.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareV2FabricCreationInput.
func (v *VMwareV2FabricCreationInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &v.MigrationSolutionID)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &v.PhysicalSiteID)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &v.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareV2FabricSpecificDetails.
func (v *VMwareV2FabricSpecificDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &v.MigrationSolutionID)
			delete(rawMsg, key)
		case "physicalSiteId":
			err = unpopulate(val, "PhysicalSiteID", &v.PhysicalSiteID)
			delete(rawMsg, key)
		case "processServers":
			err = unpopulate(val, "ProcessServers", &v.ProcessServers)
			delete(rawMsg, key)
		case "serviceContainerId":
			err = unpopulate(val, "ServiceContainerID", &v.ServiceContainerID)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &v.ServiceEndpoint)
			delete(rawMsg, key)
		case "serviceResourceId":
			err = unpopulate(val, "ServiceResourceID", &v.ServiceResourceID)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &v.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareVirtualMachineDetails.
func (v *VMwareVirtualMachineDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentGeneratedId":
			err = unpopulate(val, "AgentGeneratedID", &v.AgentGeneratedID)
			delete(rawMsg, key)
		case "agentInstalled":
			err = unpopulate(val, "AgentInstalled", &v.AgentInstalled)
			delete(rawMsg, key)
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &v.AgentVersion)
			delete(rawMsg, key)
		case "discoveryType":
			err = unpopulate(val, "DiscoveryType", &v.DiscoveryType)
			delete(rawMsg, key)
		case "diskDetails":
			err = unpopulate(val, "DiskDetails", &v.DiskDetails)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &v.IPAddress)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "poweredOn":
			err = unpopulate(val, "PoweredOn", &v.PoweredOn)
			delete(rawMsg, key)
		case "vCenterInfrastructureId":
			err = unpopulate(val, "VCenterInfrastructureID", &v.VCenterInfrastructureID)
			delete(rawMsg, key)
		case "validationErrors":
			err = unpopulate(val, "ValidationErrors", &v.ValidationErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VersionDetails.
func (v *VersionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiryDate":
			err = unpopulateTimeRFC3339(val, "ExpiryDate", &v.ExpiryDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTaskDetails.
func (v *VirtualMachineTaskDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "jobTask":
			err = unpopulate(val, "JobTask", &v.JobTask)
			delete(rawMsg, key)
		case "skippedReason":
			err = unpopulate(val, "SkippedReason", &v.SkippedReason)
			delete(rawMsg, key)
		case "skippedReasonString":
			err = unpopulate(val, "SkippedReasonString", &v.SkippedReasonString)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmDetails.
func (v *VmmDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToAzureCreateNetworkMappingInput.
func (v VmmToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VmmToAzure"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToAzureCreateNetworkMappingInput.
func (v *VmmToAzureCreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToAzureNetworkMappingSettings.
func (v *VmmToAzureNetworkMappingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToAzureUpdateNetworkMappingInput.
func (v VmmToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VmmToAzure"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToAzureUpdateNetworkMappingInput.
func (v *VmmToAzureUpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToVmmCreateNetworkMappingInput.
func (v VmmToVmmCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VmmToVmm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToVmmCreateNetworkMappingInput.
func (v *VmmToVmmCreateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToVmmNetworkMappingSettings.
func (v *VmmToVmmNetworkMappingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VmmToVmmUpdateNetworkMappingInput.
func (v VmmToVmmUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["instanceType"] = "VmmToVmm"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmToVmmUpdateNetworkMappingInput.
func (v *VmmToVmmUpdateNetworkMappingInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmmVirtualMachineDetails.
func (v *VmmVirtualMachineDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskDetails":
			err = unpopulate(val, "DiskDetails", &v.DiskDetails)
			delete(rawMsg, key)
		case "generation":
			err = unpopulate(val, "Generation", &v.Generation)
			delete(rawMsg, key)
		case "hasFibreChannelAdapter":
			err = unpopulate(val, "HasFibreChannelAdapter", &v.HasFibreChannelAdapter)
			delete(rawMsg, key)
		case "hasPhysicalDisk":
			err = unpopulate(val, "HasPhysicalDisk", &v.HasPhysicalDisk)
			delete(rawMsg, key)
		case "hasSharedVhd":
			err = unpopulate(val, "HasSharedVhd", &v.HasSharedVhd)
			delete(rawMsg, key)
		case "hyperVHostId":
			err = unpopulate(val, "HyperVHostID", &v.HyperVHostID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "osDetails":
			err = unpopulate(val, "OSDetails", &v.OSDetails)
			delete(rawMsg, key)
		case "sourceItemId":
			err = unpopulate(val, "SourceItemID", &v.SourceItemID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VmwareCbtPolicyDetails.
func (v *VmwareCbtPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &v.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &v.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &v.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
