//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AzureReservationAPIClient contains the methods for the AzureReservationAPI group.
// Don't use this type directly, use NewAzureReservationAPIClient() instead.
type AzureReservationAPIClient struct {
	host string
	pl   runtime.Pipeline
}

// NewAzureReservationAPIClient creates a new instance of AzureReservationAPIClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAzureReservationAPIClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AzureReservationAPIClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AzureReservationAPIClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// GetAppliedReservationList - Get applicable Reservations that are applied to this subscription or a resource group under
// this subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// subscriptionID - Id of the subscription
// options - AzureReservationAPIClientGetAppliedReservationListOptions contains the optional parameters for the AzureReservationAPIClient.GetAppliedReservationList
// method.
func (client *AzureReservationAPIClient) GetAppliedReservationList(ctx context.Context, subscriptionID string, options *AzureReservationAPIClientGetAppliedReservationListOptions) (AzureReservationAPIClientGetAppliedReservationListResponse, error) {
	req, err := client.getAppliedReservationListCreateRequest(ctx, subscriptionID, options)
	if err != nil {
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAppliedReservationListHandleResponse(resp)
}

// getAppliedReservationListCreateRequest creates the GetAppliedReservationList request.
func (client *AzureReservationAPIClient) getAppliedReservationListCreateRequest(ctx context.Context, subscriptionID string, options *AzureReservationAPIClientGetAppliedReservationListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/appliedReservations"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAppliedReservationListHandleResponse handles the GetAppliedReservationList response.
func (client *AzureReservationAPIClient) getAppliedReservationListHandleResponse(resp *http.Response) (AzureReservationAPIClientGetAppliedReservationListResponse, error) {
	result := AzureReservationAPIClientGetAppliedReservationListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AppliedReservations); err != nil {
		return AzureReservationAPIClientGetAppliedReservationListResponse{}, err
	}
	return result, nil
}

// GetCatalog - Get the regions and skus that are available for RI purchase for the specified Azure subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-03-01
// subscriptionID - Id of the subscription
// options - AzureReservationAPIClientGetCatalogOptions contains the optional parameters for the AzureReservationAPIClient.GetCatalog
// method.
func (client *AzureReservationAPIClient) GetCatalog(ctx context.Context, subscriptionID string, options *AzureReservationAPIClientGetCatalogOptions) (AzureReservationAPIClientGetCatalogResponse, error) {
	req, err := client.getCatalogCreateRequest(ctx, subscriptionID, options)
	if err != nil {
		return AzureReservationAPIClientGetCatalogResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AzureReservationAPIClientGetCatalogResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AzureReservationAPIClientGetCatalogResponse{}, runtime.NewResponseError(resp)
	}
	return client.getCatalogHandleResponse(resp)
}

// getCatalogCreateRequest creates the GetCatalog request.
func (client *AzureReservationAPIClient) getCatalogCreateRequest(ctx context.Context, subscriptionID string, options *AzureReservationAPIClientGetCatalogOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/catalogs"
	if subscriptionID == "" {
		return nil, errors.New("parameter subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-03-01")
	if options != nil && options.ReservedResourceType != nil {
		reqQP.Set("reservedResourceType", *options.ReservedResourceType)
	}
	if options != nil && options.Location != nil {
		reqQP.Set("location", *options.Location)
	}
	if options != nil && options.PublisherID != nil {
		reqQP.Set("publisherId", *options.PublisherID)
	}
	if options != nil && options.OfferID != nil {
		reqQP.Set("offerId", *options.OfferID)
	}
	if options != nil && options.PlanID != nil {
		reqQP.Set("planId", *options.PlanID)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCatalogHandleResponse handles the GetCatalog response.
func (client *AzureReservationAPIClient) getCatalogHandleResponse(resp *http.Response) (AzureReservationAPIClientGetCatalogResponse, error) {
	result := AzureReservationAPIClientGetCatalogResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CatalogArray); err != nil {
		return AzureReservationAPIClientGetCatalogResponse{}, err
	}
	return result, nil
}
