//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armchanges

const (
	moduleName    = "armchanges"
	moduleVersion = "v1.0.0"
)

// ChangeCategory - The entity that made the change
type ChangeCategory string

const (
	// ChangeCategoryUser - User initiated change
	ChangeCategoryUser ChangeCategory = "User"
	// ChangeCategorySystem - System initiated change
	ChangeCategorySystem ChangeCategory = "System"
)

// PossibleChangeCategoryValues returns the possible values for the ChangeCategory const type.
func PossibleChangeCategoryValues() []ChangeCategory {
	return []ChangeCategory{
		ChangeCategoryUser,
		ChangeCategorySystem,
	}
}

// ChangeType - The type of change that was captured in the resource
type ChangeType string

const (
	// ChangeTypeUpdate - An existing resource underwent a change
	ChangeTypeUpdate ChangeType = "Update"
	// ChangeTypeDelete - An existing resource was deleted
	ChangeTypeDelete ChangeType = "Delete"
	// ChangeTypeCreate - A newly created resource
	ChangeTypeCreate ChangeType = "Create"
)

// PossibleChangeTypeValues returns the possible values for the ChangeType const type.
func PossibleChangeTypeValues() []ChangeType {
	return []ChangeType{
		ChangeTypeUpdate,
		ChangeTypeDelete,
		ChangeTypeCreate,
	}
}

// PropertyChangeType - The type of change that occurred
type PropertyChangeType string

const (
	// PropertyChangeTypeUpdate - An existing property underwent a change
	PropertyChangeTypeUpdate PropertyChangeType = "Update"
	// PropertyChangeTypeInsert - A property was newly created
	PropertyChangeTypeInsert PropertyChangeType = "Insert"
	// PropertyChangeTypeRemove - An existing property was deleted
	PropertyChangeTypeRemove PropertyChangeType = "Remove"
)

// PossiblePropertyChangeTypeValues returns the possible values for the PropertyChangeType const type.
func PossiblePropertyChangeTypeValues() []PropertyChangeType {
	return []PropertyChangeType{
		PropertyChangeTypeUpdate,
		PropertyChangeTypeInsert,
		PropertyChangeTypeRemove,
	}
}
