// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Finds a place by its unique ID. A PlaceId is returned by other search
// operations.
//
// A PlaceId is valid only if all of the following are the same in the original
// search request and the call to GetPlace .
//
//   - Customer Amazon Web Services account
//
//   - Amazon Web Services Region
//
//   - Data provider specified in the place index resource
func (c *Client) GetPlace(ctx context.Context, params *GetPlaceInput, optFns ...func(*Options)) (*GetPlaceOutput, error) {
	if params == nil {
		params = &GetPlaceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPlace", params, optFns, c.addOperationGetPlaceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPlaceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPlaceInput struct {

	// The name of the place index resource that you want to use for the search.
	//
	// This member is required.
	IndexName *string

	// The identifier of the place to find.
	//
	// While you can use PlaceID in subsequent requests, PlaceID is not intended to be
	// a permanent identifier and the ID can change between consecutive API calls.
	// Please see the following PlaceID behaviour for each data provider:
	//
	//   - Esri: Place IDs will change every quarter at a minimum. The typical time
	//   period for these changes would be March, June, September, and December. Place
	//   IDs might also change between the typical quarterly change but that will be much
	//   less frequent.
	//
	//   - HERE: We recommend that you cache data for no longer than a week to keep
	//   your data data fresh. You can assume that less than 1% ID shifts will release
	//   over release which is approximately 1 - 2 times per week.
	//
	//   - Grab: Place IDs can expire or become invalid in the following situations.
	//
	//   - Data operations: The POI may be removed from Grab POI database by Grab Map
	//   Ops based on the ground-truth, such as being closed in the real world, being
	//   detected as a duplicate POI, or having incorrect information. Grab will
	//   synchronize data to the Waypoint environment on weekly basis.
	//
	//   - Interpolated POI: Interpolated POI is a temporary POI generated in real
	//   time when serving a request, and it will be marked as derived in the
	//   place.result_type field in the response. The information of interpolated POIs
	//   will be retained for at least 30 days, which means that within 30 days, you are
	//   able to obtain POI details by Place ID from Place Details API. After 30 days,
	//   the interpolated POIs(both Place ID and details) may expire and inaccessible
	//   from the Places Details API.
	//
	// This member is required.
	PlaceId *string

	// The optional [API key] to authorize the request.
	//
	// [API key]: https://docs.aws.amazon.com/location/latest/developerguide/using-apikeys.html
	Key *string

	// The preferred language used to return results. The value must be a valid [BCP 47]
	// language tag, for example, en for English.
	//
	// This setting affects the languages used in the results, but not the results
	// themselves. If no language is specified, or not supported for a particular
	// result, the partner automatically chooses a language for the result.
	//
	// For an example, we'll use the Greek language. You search for a location around
	// Athens, Greece, with the language parameter set to en . The city in the results
	// will most likely be returned as Athens .
	//
	// If you set the language parameter to el , for Greek, then the city in the
	// results will more likely be returned as Αθήνα .
	//
	// If the data provider does not have a value for Greek, the result will be in a
	// language that the provider does support.
	//
	// [BCP 47]: https://tools.ietf.org/search/bcp47
	Language *string

	noSmithyDocumentSerde
}

type GetPlaceOutput struct {

	// Details about the result, such as its address and position.
	//
	// This member is required.
	Place *types.Place

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPlaceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetPlace{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetPlace{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPlace"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opGetPlaceMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetPlaceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPlace(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opGetPlaceMiddleware struct {
}

func (*endpointPrefix_opGetPlaceMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opGetPlaceMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "places." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opGetPlaceMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opGetPlaceMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opGetPlace(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPlace",
	}
}
