// Code generated by smithy-go-codegen DO NOT EDIT.

package supplychain

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// CreateBillOfMaterialsImportJob creates an import job for the Product Bill Of
// Materials (BOM) entity. For information on the product_bom entity, see the AWS
// Supply Chain User Guide.
//
// The CSV file must be located in an Amazon S3 location accessible to AWS Supply
// Chain. It is recommended to use the same Amazon S3 bucket created during your
// AWS Supply Chain instance creation.
func (c *Client) CreateBillOfMaterialsImportJob(ctx context.Context, params *CreateBillOfMaterialsImportJobInput, optFns ...func(*Options)) (*CreateBillOfMaterialsImportJobOutput, error) {
	if params == nil {
		params = &CreateBillOfMaterialsImportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateBillOfMaterialsImportJob", params, optFns, c.addOperationCreateBillOfMaterialsImportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateBillOfMaterialsImportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters for CreateBillOfMaterialsImportJob.
type CreateBillOfMaterialsImportJobInput struct {

	// The AWS Supply Chain instance identifier.
	//
	// This member is required.
	InstanceId *string

	// The S3 URI of the CSV file to be imported. The bucket must grant permissions
	// for AWS Supply Chain to read the file.
	//
	// This member is required.
	S3uri *string

	// An idempotency token.
	ClientToken *string

	noSmithyDocumentSerde
}

// The response parameters of CreateBillOfMaterialsImportJob.
type CreateBillOfMaterialsImportJobOutput struct {

	// The new BillOfMaterialsImportJob identifier.
	//
	// This member is required.
	JobId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateBillOfMaterialsImportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateBillOfMaterialsImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateBillOfMaterialsImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateBillOfMaterialsImportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateBillOfMaterialsImportJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateBillOfMaterialsImportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateBillOfMaterialsImportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateBillOfMaterialsImportJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateBillOfMaterialsImportJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateBillOfMaterialsImportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateBillOfMaterialsImportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateBillOfMaterialsImportJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateBillOfMaterialsImportJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateBillOfMaterialsImportJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateBillOfMaterialsImportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateBillOfMaterialsImportJob",
	}
}
