require 'spec_helper'

describe 'collectd::plugin::syslog', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end
      let :pre_condition do
        'include collectd'
      end

      options = os_specific_options(facts)

      context 'all options set' do
        let :params do
          {
            log_level: 'debug',
            notify_level: 'FAILURE'
          }
        end

        content = <<EOS
# Generated by Puppet
<LoadPlugin syslog>
  Globals false
</LoadPlugin>

<Plugin syslog>
  LogLevel debug
  NotifyLevel FAILURE
</Plugin>

EOS

        it { is_expected.to compile.with_all_deps }

        it "Will create #{options[:plugin_conf_dir]}/05-syslog.conf" do
          is_expected.to contain_file('syslog.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/05-syslog.conf",
            content: content
          )
        end
      end

      context ':ensure => absent' do
        let :params do
          { ensure: 'absent' }
        end

        it "Will not create #{options[:plugin_conf_dir]}/05-syslog.conf" do
          is_expected.to contain_file('syslog.load').with(
            ensure: 'absent',
            path: "#{options[:plugin_conf_dir]}/05-syslog.conf"
          )
        end
      end

      context 'notify_level invalid' do
        let :params do
          { notify_level: 'notexist' }
        end

        it 'Will raise an error about :notify_level being Enum' do
          is_expected.to compile.and_raise_error(%r{Enum})
        end
      end
    end
  end
end
