% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formats.R
\name{currency}
\alias{currency}
\alias{currency.default}
\alias{currency.character}
\title{Numeric vector with currency format}
\usage{
currency(x, symbol, digits, format = "f", big.mark = ",", ...)

\method{currency}{default}(
  x,
  symbol = "$",
  digits = 2L,
  format = "f",
  big.mark = ",",
  ...,
  sep = ""
)

\method{currency}{character}(
  x,
  symbol = get_currency_symbol(x),
  digits = max(get_digits(x)),
  format = "f",
  big.mark = ",",
  ...
)
}
\arguments{
\item{x}{a numeric vector.}

\item{symbol}{currency symbol}

\item{digits}{an integer to indicate the number of digits of the percentage string.}

\item{format}{format type passed to \code{\link{formatC}}.}

\item{big.mark}{thousands separator}

\item{...}{additional parameters passed to \code{formattable}.}

\item{sep}{separator between symbol and value}
}
\description{
Numeric vector with currency format
}
\examples{
currency(200000)
currency(200000, "\U20AC")
currency(1200000, "USD", sep = " ")
currency(1200000, "USD", format = "d", sep = " ")
currency("$ 120,250.50")
currency("HK$ 120,250.50", symbol = "HK$")
currency("HK$ 120, 250.50")
}
