/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "model.h"
#include "ddlog.h"

//主题图标排序函数
bool iconSort(const IconStruct &icon1, const IconStruct &icon2) {
    QCollator qc;
    return qc.compare(icon1.Id, icon2.Id) < 0;
}

Model *Model::Instance()
{
    qCDebug(app) << "Getting Model instance";
    static Model * instance = new Model;
    return instance;
}

/*******************************************************************************
 1. @函数:    currentIcon
 2. @作者:
 3. @日期:    2020-12-10
 4. @说明:    获取当前主题图标数据，如果有返回找到的数据，反之，返回空的数据
*******************************************************************************/
IconStruct Model::currentIcon()
{
    qCDebug(app) << "Getting current icon";
    for (const IconStruct &tmp : m_iconList) {
        if (tmp.Id == m_currentIcon) {
            return tmp;
        }
    }

    qCDebug(app) << "Current icon not found, returning empty struct";
    return IconStruct();
}

/*******************************************************************************
 1. @函数:    addIcon
 2. @作者:
 3. @日期:    2020-12-10
 4. @说明:    添加图标槽
*******************************************************************************/
void Model::addIcon(const IconStruct &icon)
{
    qCDebug(app) << "Adding icon:" << icon.Id;
    if (m_iconList.contains(icon)) {
        qCDebug(app) << "Icon already exists, skipping";
        return;
    }

    //添加到list
    qCDebug(app) << "Adding icon to list:" << icon.Id;
    m_iconList << icon;

    //排序
    qCDebug(app) << "Sorting icon list";
    std::sort(m_iconList.begin(), m_iconList.end(), iconSort);
    qCDebug(app) << "Icon list sorted";

    qCDebug(app) << "Icon added successfully";
    emit iconAdded(icon);

    if (icon.Id == m_currentIcon) {
        emit iconChanged(icon);
    }
}

/*******************************************************************************
 1. @函数:    removeIcon
 2. @作者:
 3. @日期:    2020-12-15
 4. @说明:    删除图标槽函数
*******************************************************************************/
void Model::removeIcon(const IconStruct &icon)
{
    qCDebug(app) << "Removing icon:" << icon.Id;
    Q_ASSERT(m_iconList.contains(icon));

    qCDebug(app) << "Removing icon from list:" << icon.Id;
    m_iconList.removeOne(icon);
    qCDebug(app) << "Current icon count:" << m_iconList.size();

    emit iconRemoved(icon);
}

/*******************************************************************************
 1. @函数:    setCurrentIcon
 2. @作者:
 3. @日期:    2020-12-15
 4. @说明:    设置当前图标名
*******************************************************************************/
void Model::setCurrentIcon(const QString &icon)
{
    qCDebug(app) << "Setting current icon to:" << icon;
    if (icon == m_currentIcon) {
        qCDebug(app) << "Icon already set, skipping";
        return;
    }

    qCDebug(app) << "Setting current icon:" << icon;
    m_currentIcon = icon;
    qCDebug(app) << "Current icon set to:" << m_currentIcon;

    for (const IconStruct &tmp : m_iconList) {
        if (tmp.Id == icon) {
            qCDebug(app) << "Current icon changed to:" << icon;
            emit iconChanged(tmp);
        }
    }
}

Model::Model(QObject *parent)
    : QObject(parent)
{

}

/*******************************************************************************
 1. @函数:    setDesktopMode
 2. @作者:
 3. @日期:    2020-12-15
 4. @说明:    设置桌面样式类型
*******************************************************************************/
void Model::setDesktopMode(DesktopMode desktopMode)
{
    qCDebug(app) << "Setting desktop mode to:" << desktopMode;
    if (m_desktopMode == desktopMode) {
        qCDebug(app) << "Desktop mode already set, skipping";
        return;
    }

    qCDebug(app) << "Setting desktop mode:" << desktopMode;
    m_desktopMode = desktopMode;
    qCDebug(app) << "Desktop mode set to:" << m_desktopMode;

    emit desktopModeChanged(desktopMode);
}

/*******************************************************************************
 1. @函数:    setWmType
 2. @作者:
 3. @日期:    2020-12-15
 4. @说明:    设置运行模式类型
*******************************************************************************/
void Model::setWmType(WMType wmType)
{
    qCDebug(app) << "Setting WM type to:" << wmType;
    if (m_wmType == wmType) {
        qCDebug(app) << "WM type already set, skipping";
        return;
    }

    qCDebug(app) << "Setting WM type:" << wmType;
    m_wmType = wmType;
    qCDebug(app) << "WM type set to:" << m_wmType;

    emit wmTypeChanged(wmType);
}
