/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "indexdotswidget.h"
#include "ddlog.h"

#include <QPainter>

#define DIAMETER 8
#define SPACING 12
#define SELECT_COLOR     0, 129, 255, int(0.75 * 255)
#define DEFAULT_COLOR    0, 129, 255, int(0.15 * 255)

IndexDotsWidget::IndexDotsWidget(const int &num, QWidget *parent)
    : DFrame (parent)
    , m_num(num)
    , m_index(0)
{
    int width = num * DIAMETER + (num - 1) * SPACING;
    setFixedSize(width, DIAMETER);
    qCDebug(app) << "IndexDotsWidget initialized with size:" << size();
}

void IndexDotsWidget::setCurrentIndex(const int &index)
{
    qCDebug(app) << "Setting current index from" << m_index << "to" << index;

    m_index = index;
    update();
}

void IndexDotsWidget::paintEvent(QPaintEvent *event)
{
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);

    int offest = 0;
    painter.setPen(Qt::NoPen);
    for (int i = 0; i < m_num; i++) {
        QRectF rectangle(offest, 0, DIAMETER, DIAMETER);
        if (i == m_index)
            painter.setBrush(QBrush(QColor(SELECT_COLOR)));
        else
            painter.setBrush(QBrush(QColor(DEFAULT_COLOR)));
        painter.drawEllipse(rectangle);
        offest += DIAMETER + SPACING;
    }
}
