# Desktop Environment|dde|

## Overview

UnionTech OS (UnionTech operating system) is a beautiful, easy-to-use and reliable Linux desktop operating system. It is equipped with a series of original applications such as File Manager, System Monitor and etc, which not only offers you abundant entertainment experience but also meet your daily needs of learning and working. With continual improvement, UnionTech OS is becoming one of the most popular open-source operating systems in China.

![1|desk](fig/eu_desk.png)

### Getting Started

Once login, you are experiencing UnionTech OS Desktop Environment, which is comprised of Desktop, Dock, Launcher, Control Center and so on. 

## Desktop

Desktop is the main screen you see after logging in. On the desktop, you can create a new file/folder, sort files, open in terminal, set wallpaper and screensaver and etc. You can also add shortcuts for applications  on desktop by using "Send to desktop" function, see [Set App Shortcut](#Set App Shortcut).

![0|contextmenu](fig/contextmenu.png)

### Create New Folder/Document

Just as in File Manager, you can create a new folder/document on the desktop, or do some operations for the files on it.

   - Right-click the desktop, select **New folder** and enter the name for it.
   - Right-click the desktop, select **New document**, select the type and enter its name.

Right-click a file or folder on the desktop, and use the features of File Manager as below:

| Function         | Description                                                  |
| ---------------- | ------------------------------------------------------------ |
| Open with        | Select an app to open it.                                    |
| Cut              | Move it to another location.                                 |
| Copy             | Copy it to another location.                                 |
| Rename           | Change its name.                                             |
| Delete           | Delete and move it to the trash.                             |
| Create link      | Create a shortcut of the file or folder.                     |
| Tag information  | Add a tag.                                                   |
| Compress/Extract | Compress the file or folder, or extract the compressed file. |
| Properties       | View the basic info, share it or change the permission.      |



>![notes](../common/notes.svg) Notes: Press **Alt** + **M** on the keyboard to open right-click menu. 

### Sort Files

Sort the files on your desktop to make it organized and fit your needs.

1. Right-click the desktop.
2. Click **Sort by**, you can:

   - Click **Name** to display files in the name sequence.
   - Click **Size** to display files in the size sequence.
   - Click **Type** to display files in type.
   - Click **Time modified** to display files in the order of last modified date.


>![tips](../common/tips.svg) Tips: Check **Auto arrange**, icons on the desktop will be listed in order automatically, and if an icon is removed, another one will fill in the blank.



### Adjust Icon Size

1. Right-click the desktop.
2. Click **Icon size**, and choose a proper size.

>![tips](../common/tips.svg) Tips: Press **Ctrl** + ![=](../common/=.svg)/![-](../common/-.svg) /scrolling mouse wheel to adjust icon size on the desktop and in Launcher.

### Set Display

You can set display scaling, screen resolution, brightness and so on from the desktop.

1. Right-click the desktop.
2. Click **Display Settings** to open the settings in Control Center.

>![notes](../common/notes.svg) Notes: For specific operations, please refer to [Display](#Display).

### Change Wallpaper

Select some elegant and fashionable wallpapers to beautify your desktop and make it distinctive.

1. Right-click the desktop.
2. Click **Wallpaper and Screensaver** to preview all the wallpapers.
3. Click your favorite one and it will apply in your desktop and screen lock.
4. You can also choose **Only desktop** or **Only lock screen**.

![1|wallpaper](fig/wallpaper.png)

>![tips](../common/tips.svg) Tips: You can set your favorite picture as wallpaper in Image Viewer.

### Set Screensaver

The screensaver was used to protect the kinescope before, but now it is mainly for protecting personal privacy from peering.

1. Right-click the desktop.
2. Click **Wallpaper and Screensaver**, and select **Screensaver** to preview all the screensavers.
3. Select one and click **Apply**, and set the **Wait**(waiting time) for the screensaver to start.
4. You can also check the box of **Require a password on wakeup** for a better privacy protection.
5. After that idle time, the screensaver will start.

![1|screensaver](fig/screensaver.png)

### Clipboard

All the texts, pictures and documents cut and copied by the current user after login are displayed in the clipboard, which can be copied quickly by double-clicking the clipboard. The clipboard is cleared automatically after logout and shutdown.

1. Use the shortcuts **Ctrl**+**Alt**+ **V** to wake up the clipboard.

2. Double-click in the clipboard to copy the current content quickly and the corresponding block will be moved to the top of the clipboard.

3.  Select the target destination to paste it.

4. Click ![close](../common/close_normal.svg) to delete the current content and click **Clear All** to clear the clipboard.

   ![1|clipboard](fig/clipboard.png)

## Dock

Dock is at the bottom of the desktop by default to help you quickly open frequently-used applications, which includes Launcher, applications, system tray, and plugins. In the dock, you can open launcher, show the desktop, enter the workspaces, open and exit apps, set input methods, adjust the volume, connect to network, view the calendar and enter the shutdown interface, and so on.

### Icons on Dock 

In the Dock, there are icons of Launcher, applications, system tray, and plugins.

You can send application icons from Launcher to Dock so as to open it quickly.

![1|fashion](fig/eu_efficient.png)

| Icon | Description |
| ---- | ---- |
| ![launcher](../common/deepin-launcher.svg) | Launcher - click to view all the installed applications. |
| ![deepin-toggle-desktop](../common/deepin-toggle-desktop.svg) | Click to show the desktop. |
| ![dde-file-manager](../common/dde-file-manager.svg) | File Manager - click to view files and folders on the disk. |
| ![uosbrowser](../common/org.deepin.browser.svg) | Browser- click to open webpages. |
| ![dde-calendar](../common/dde-calendar.svg) | Calendar -  view dates and create new schedules. |
| ![controlcenter](../common/controlcenter.svg) |   Control Center - click to check or change system settings.   |
| ![notification](../common/notification.svg) | Notification Center - show all notifications from the system and applications. |
| ![onboard](../common/onboard.svg) | Onboard virtual keyboard. |
| ![shutdown](../common/system-shutdown.svg) | Click to enter the shutdown interface. |
| ![trash](../common/trash_icon.svg) | Trash. |

>![tips](../common/tips.svg) Tips: In Efficient Mode, you can click the right side of Dock to show the desktop. Move the cursor to the running app in the Dock and you will see its preview window.

### Switch Display Mode

There are two display modes of Dock: fashion mode and efficient mode, icon sizes and the window look are different in them.

![1|fashion](fig/eu_fashion.png)

![1|efficient](fig/eu_efficient.png)

You can switch the display modes by the following operations:

1. Right-click the Dock and select **Mode**.
2. Select the display mode.

### Change Dock Location

You can place Dock on any direction of your desktop.

1. Right-click the Dock and select **Location**.
2. Select a location.

### Change Dock Height

Drag the top edge to increase or decrease the height.

### Show/Hide Dock

You can hide the Dock in order to maximize the expansion of the desktop operating area. 

1. Right-click the Dock and select **Status**.
2. On the submenu, you can select:
   - **Keep Shown** - display Dock all the time.
   - **Keep Hidden** - hide Dock and display it only when hovering on the dock area.
   - **Smart Hide** -  hide Dock automatically if the dock area is used.

### Show/Hide Plugins

1. Right-click the Dock and select **Plugins**.
2. On the submenu, you can check or uncheck **Trash, Power, Show Desktop, Onboard, Notification Center, Datetime** and so on to show or hide the corresponding icon in the Dock.

### View Notifications

When there are system or application notifications, they will be shown in the middle of the screen. If there are buttons in the message, click buttons to do the actions; if there are not, click the message to close it.

![notification](fig/notification.png)

Click ![notification](../common/notification.svg) in Dock to view all the notifications.

### View Date and Time

   - Hover the cursor over the Time icon in Dock to view the current time, date and day of the week.
   - Click the Time icon to open Calendar.

### Enter Shutdown Interface

You can either click ![shutdown](../common/system-shutdown.svg) in Dock or click ![poweroff_normal](../common/poweroff_normal.svg) at the bottom right corner of Launcher mini mode to enter shutdown interface.

| Function                                                     | Description                                                  |
| ------------------------------------------------------------ | ------------------------------------------------------------ |
| Shut down ![poweroff_normal](../common/poweroff_normal.svg)  | Shut down the computer.                                      |
| Reboot ![reboot_normal](../common/reboot_normal.svg)         | Restart the computer.                                        |
| Lock ![lock_normal](../common/lock_normal.svg)               | Lock the computer, or press **Super** + **L** to lock it.    |
| Switch user ![userswitch_normal](../common/userswitch_normal.svg) | Log in with another user account.                            |
| Log out ![logout_normal](../common/logout_normal.svg)        | Click it to clear up all information about the current account. |
| Start system monitor![deepin-system-monitor](../common/deepin-system-monitor.svg) | Click it to open System Monitor quickly.         |

>![notes](../common/notes.svg) Notes: ![userswitch_normal](../common/userswitch_normal.svg) will be shown if there are multiple accounts in the system.

### Trash

You can find all temporarily deleted files in the trash, and also restore or empty them.

#### Restore Files

You can restore temporarily deleted files in Trash or press **Ctrl** + **Z** to restore the recently deleted files.

1. Select the file in the trash.
2. Right-click the file and select **Restore**.
3. The file will be in its original path.

>![attention](../common/attention.svg) Attention: If the original folder of the file has been deleted, the deleted file will be restored to a new folder automatically created.

#### Delete Files

You can delete any one file in Trash.

1. Select the file to be deleted in the trash.
2. Right-click and select **Delete**.

#### Empty Trash

In the trash, click **Empty** to permanently delete all the files in the trash.

## Launcher

Launcher ![launcher](../common/deepin-launcher.svg) helps you manage all the installed applications, where you can quickly find an application by category navigation or by a search.

You can view newly installed applications in Launcher. The newly-installed ones are followed by a blue dot.

### Switch Launcher Modes

There are two display modes of Launcher: fullscreen mode and mini mode. Click the icon at the upper right corner to switch modes.

Both modes support searching applications and sending them to the desktop or Dock.

The mini mode also supports opening File Manager, Control Center and shutdown interface directly.

![1|fullscreen](fig/e_fullscreen.png)
![1|mini](fig/eu_mini.png)

### Sort Applications

In fullscreen mode, all applications in Launcher are listed by the installation time by default. You can sort the application icons as the ways below:

   - Hover the cursor over an application icon, hold down the left key of mouse, drag and drop the application icon to arrange it freely.
   - Click the category icon ![category](../common/category_icon.svg) on the upper left in Launcher to arrange the icons by category.

![1|sortapp](fig/e_sortapp.png)

In mini mode,  applications are displayed according to using frequency by default.

### Find Applications

In Launcher, you can scroll up and down to find an application, or locate it with the category navigation.

If you already know the application name, just input keywords in searching box to locate it quickly.

### Set App Shortcut

The shortcut offers a method to run applications easily and quickly.

#### Create App Shortcut

Send the application icon to the desktop or Dock to facilitate the follow-up operations.

In Launcher, right-click an app icon and you can:

   - Select **Send to desktop** to create a shortcut on the desktop.
   - Select **Send to dock** to fix the application icon in Dock.

![0|sendto](fig/sendto.png)

>![notes](../common/notes.svg) Notes: You can drag the application icon from Launcher to Dock. But you cannot drag and drop the application while it is running. Then you can right-click the application icon in Dock and select **Dock** to fix it in order to open it quickly for the next time.

#### Delete Shortcut

Delete a shortcut from the desktop directly, or remove it from Dock or Launcher.

**Remove the shortcut from Dock**

   - Hold down the left key of mouse, drag and drop the icon away from Dock. 
   - You cannot drag and drop the application icon while it is running. Then you can right-click the application icon in Dock and select **Undock** to remove it from Dock.

**Remove the shortcut from Launcher**

In Launcher, right-click the icon and you can:
   - Select **Remove from desktop** to delete the shortcut from the desktop.
   - Select **Remove from dock** to remove the application icon from Dock.

>![notes](../common/notes.svg) Notes: The above operations only delete the shortcut rather than uninstall the applications.

### Run Applications

For the applications whose shortcuts have been created on the desktop or Dock, you can open them in the following ways:

   - Double-click the desktop icon or right-click it and select **Open**.
   - Click the application icon in Dock or right-click it and select **Open**.

To open the application only shown in Launcher, click the icon or right-click it and select **Open**.

>![tips](../common/tips.svg) Tips: For the frequently-used applications, right-click the app icon and select **Add to startup** to run it when the computer boots.

### Uninstall Applications

Uninstall the applications you no longer use to save disk space.

1. In Launcher, right-click the application icon.
2. Click **Uninstall**.

>![tips](../common/tips.svg) Tips: In **Fashion mode**, drag the application icon in Launcher fullscreen mode to ![trash](../common/trash_icon.svg) in the Dock to uninstall the application.


## Control Center

You can manage the system settings in Control Center, including account management, network settings, date and time, personalization, display settings, system update, etc. After entering the desktop environment, click ![controlcenter](../common/controlcenter.svg) to open Control Center.

### Homepage Introduction

The homepage of Control Center provides several setting modules and click one to enter the detailed settings. 

![0|dcchomepage](fig/e_dcc.png)

Once you open a setting module in Control Center, the navigation appears on the left. Click the left navigation to quickly switch to other settings.

![0|ccnavigation](fig/e_ccnavigation.png)

#### Title Bar

The title bar contains the back button, search box, main menu and the window buttons.

   - Back button: Click ![back](../common/back.svg) to go back to the homepage.
   - Search box: Input a keyword and search the related settings.
   - Main menu: Click ![menu](../common/icon_menu.svg) to enter the main menu where you can set the window theme, view the manual and exit.

### Accounts

You have already created an account when installing the system. Here you can modify account settings or create a new one.

![0|account](fig/e_account.png)

#### Create New Account

1. On the homepage of Control Center, click ![account_normal](../common/account_normal.svg).
2. Click ![add](../common/add.svg).
3. Input a username and a password twice.
4. Click **Create**.
5. Input the password of  the current user account in the authentication dialog box, and the new account will be added to the account list.


#### Change Account Avatar

1. On the homepage of Control Center, click ![account_normal](../common/account_normal.svg).
2. Click an existing account in the list.
3. Click the user avatar, select a avatar or upload a local avatar.

#### Set Full Name

The account full name is shown in account list and system login interface and you can set it as needed.

1. On the homepage of Control Center, click ![account_normal](../common/account_normal.svg).
2. Click an existing account in the list.
3. Click ![edit](../common/edit.svg) after **Full Name**, and input a name.

#### Change Password

1. On the homepage of Control Center, click ![account_normal](../common/account_normal.svg).
2. Click the current account.
3. Click **Change Password**.
4. Input the current password, the new password, and repeat the new one, click **Save**.

#### Auto Login

If "Auto Login" is enabled, you can log into the system directly, without inputting a password when the computer reboots or starts next time. But you still have to enter the password after locking or logging out of  the computer.

1. On the homepage of Control Center, click ![account_normal](../common/account_normal.svg).
2. Click the current account.
3. Switch on **Auto Login**. Input the password of the current account and confirm in the pop-up authorization window. 

#### Set password validity period

1. On the homepage of Control Center, click ![account_normal](../common/account_normal.svg).
2. Click the current account.
3. Set the validity period of the password. You can set a particular number or select "Always". 

>![notes](../common/notes.svg) Notes: the validity period starts to take effect from the day you modify the password.   

For example, you modify the password on September 1st, and set the validity period as 30 days. Then the new password could be normally used from September 1st to September 30th. 


#### Delete Account

1. On the homepage of Control Center, click ![account_normal](../common/account_normal.svg).
2. Click the other account.
3. Click **Delete Account**.
4. In the confirm dialog, click **Delete**.

>![attention](../common/attention.svg) Attention: The logged in account cannot be deleted.

#### Privilege

Adding administrator, common account and customized account is supported.

##### Group setting

When you add or modify accounts, you can select a group existing in the system.

### Display

Set screen resolution, brightness, and direction properly to have the best visual effect.

![0|display](fig/e_display.png)


#### Single Screen Settings

When there is only one screen, you can adjust the brightness, resolution, refresh rate and display direction.

##### Adjust Brightness

1. On the homepage of Control Center, click ![display_normal](../common/display_normal.svg).

2. In "Brightness" area, you can drag the slider to adjust the brightness.
   
##### Adjust Color Temperature

1. On the homepage of Control Center, click ![display_normal](../common/display_normal.svg).

2. In "Color Temperature" area, you can:

   - Switch on **Night Shift**, the screen hue will be auto-adjusted according to your location.
   - Switch on **Change Color Temperature** is switched on, you can adjust the monitor brightness as you wish. 

>![notes](../common/notes.svg) Notes: When **Night Shift** is switched on, **Change Color Temperature** becomes unavailable automatically, and vice versa.

##### Set Display Scaling

Set a proper display scale to have a normal display.

1. On the homepage of Control Center, click ![display_normal](../common/display_normal.svg).
2. Click **Display Scaling**.
3. Change the display scaling, log out and log in again to see the changes.

>![notes](../common/notes.svg) Notes: 
>   - When a HiDPI screen is detected, the display scaling will be automatically adjusted.
>   - For the applications that do not support scaling, right-click it in Launcher and select **Disable display scaling** to get a better display.

##### Change Resolution

1. On the homepage of Control Center, click ![display_normal](../common/display_normal.svg).
2. Select a proper resolution parameter from the drop-down list in "Resolution" area.
3. Click **Save**.

##### Change Refresh Rate

1. On the homepage of Control Center, click ![display_normal](../common/display_normal.svg).
2. Click **Refresh Rate**.
3. Select a proper one, and click **Save**.

##### Change Display Direction

1. On the homepage of Control Center, click ![display_normal](../common/display_normal.svg).
2. Select a proper direction parameter from the drop-down list in "Rotation" area.
3. Click **Save**.

#### Multiple Screen Settings

Expand your desktop by multiple screens! Use VGA/HDMI/EDP cable to connect your computer to other display devices such as monitor, projector and so on. When the computer is connected to another display device, **Multiple Displays** will appear.

1. On the homepage of Control Center, click ![display_normal](../common/display_normal.svg).
2. In **Multiple Displays**, select a display mode:
- **Duplicate**: display the same image on other screens.
- **Extend**: expand the desktop across the screens.
- **Only on xxxx**: only display on one screen.

In multiple displays, press **Super** + **P** to show its OSD. 

Operations are as follows:

1. Hold **Super** and press **P** or click to select the options. 
2. Release the keys, the selected mode will take into effect.

>![notes](../common/notes.svg) Notes: in extend mode,
>
>- In multiple display mode, the sub-screens also support desktop icon display, right-click menu operation and other functions.
>- "multiple displays" is displayed in right-click menu of the Dock, including "only on main screen" and "on screen where the cursor is".



### Touch Screen

If your computer has a touch screen, you can set your screen and adjust it.

1. On the homepage of Control Center, click ![display_normal](../common/touchScreen.svg) to set your screen.
2. Click **Confirm**. 



### Default Applications

If you have installed several applications with similar functions, such as text editor, choose one of them to be the Default Applications to open that type of file.

![0|default](fig/e_ccnavigation.png)

#### Set Default Applications

1. Right-click the file, choose **Open with** > **Set default program**.
2. Select one application, **Set as default** is checked by default, and click **Confirm**.
3. The application will automatically be added to the Default Applications list in Control Center.

#### Change Default Applications

1. On the homepage of Control Center, click ![default_applications_normal](../common/default_applications_normal.svg).
2. Select a file type.
3. Select another one in the list as the Default Applications.

#### Add Default Applications

1. On the homepage of Control Center, click ![default_applications_normal](../common/default_applications_normal.svg).
2. Select a file type.
3. Click ![add](../common/add.svg) below to add a desktop file (usually at /usr/share/applications) or a specified binary file as the Default Applications.
4. The application will be added to the list and set as Default Applications automatically. 

#### Delete Default Applications

In the Default Applications list, you can only delete the applications you added. To remove other applications from the list,  the only way is to uninstall them. Once uninstalled, they will automatically be deleted from the list.

To delete the Default Applicationss you have added, do as below:

1. On the homepage of Control Center, click ![default_applications_normal](../common/default_applications_normal.svg).
2. Select a file type.
3. Click ![close](../common/close_normal.svg) after the application name to delete it.


### Personalization Settings

You can set theme, accent color, font, change the appearance of the desktop and windows to your favorite style. 

![0|personalise](fig/e_personalise.png)

#### Set Window Theme

1. On the homepage of Control Center, click ![personalization_normal](../common/personalization_normal.svg).
2. Click **General**.
3. Select one window theme, which will be used as system theme.

>![notes](../common/notes.svg) Notes: "Auto" means changing window theme automatically according to the sunset and sunrise time. After sunrise, it is light theme; after sunset, it is dark theme.

#### Change Accent Color

Accent color refers to the color used when you select one option or file in the system.

1. On the homepage of Control Center, click ![personalization_normal](../common/personalization_normal.svg).
2. Click **General**.
3. Pick a color under **Accent Color** and view its effects.

#### Set Icon Theme

1. On the homepage of Control Center, click ![personalization_normal](../common/personalization_normal.svg).
2. Click **Icon Theme** and select an icon style.


#### Set Cursor Theme

1. On the homepage of Control Center, click ![personalization_normal](../common/personalization_normal.svg).
2. Click **Cursor Theme** and select a set of cursors.

#### Change Font

1. On the homepage of Control Center, click ![personalization_normal](../common/personalization_normal.svg).
2. Click **Font**.
3. Set the font and font size for the system.


### Network Settings

After login, you need to connect to a network first and then surf the Internet! 

>![tips](../common/tips.svg) Tips: Check your network status by clicking the network icon in Dock.

![0|network](fig/e_network.png)

#### Wired Network

Wired network is secure and stable, which makes it the most common way to connect to the Internet. After your router is set, connect both ends of the network cable to the computer and router to connect to a wired network. 

1. Plug the cable into the network slot of a computer.
2. Plug another end of the cable into the router or network port.
3. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
4. Click **Wired Network** to enter the setting page of wired network.
5. Switch on **Wired Network Adapter** to enable wired network.
6. If it is successfully connected to the network, there will be a prompt "Wired Connection connected".

You can also edit and add a new wired network in the setting page.

#### Wireless Network

Wireless network helps you surf the network without cables, which is more flexible and supports more devices.

##### Connect to WLAN Network

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **Wireless Network** to enter the setting page of wireless network.
3. Switch on **Wireless Network Adapter** to enable the wireless network.
4. The computer will auto search the nearby wireless network available .
5. Select the correct wireless network to connect.
   - If the network is open, it will auto connect to the network.
   - If the network is encrypted, please enter the password and click **Connect**.

##### Connect to Hidden Network

To prevent others from scanning your network and cracking your password, you can hide the wireless network in the router settings. After that, you will have to connect to it manually.

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **Wireless Network** to enter the setting page of wireless network.
3. Switch on **Wireless Network Adapter** to enable the wireless network.
4. Click **Connect to Hidden Network**.
5. Enter the name, SSID, and other required info.
6. Click **Save**.

#### Hotspot

Hotspot changes the connected network signal to WLAN hotspot, so that other devices nearby can connect to the hotspot and surf the Internet. To enable hotspot, your computer must connect to a network and have a wireless network adapter that supports hotspot.

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **Personal Hotspot**.
3. Switch on **Hotspot** and do the settings.
4. Click **Save**. 


#### Mobile Network

If you are at a place without network, mobile network adapter is a useful tool to help you connect to the Internet as long as the place is covered by telephone signals.

1. Plug the mobile network adapter into your computer USB port.
2. Your computer will auto connect to the network.
3. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
4. Click **Mobile Network** to view the detailed network info.

#### DSL/PPPoE Connections

DSL is a dial-up connection using a standard phone line and analog modem to access the Internet. Configure the modem, after connecting the modem's network port and the computer's network port via a network cable, create a broadband dial-up connection, and enter the user name and password provided by the operator to dial up the Internet.

##### Create a PPPoE Connection

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **DSL**.
3. Click ![add](../common/add.svg).
4. Enter the name, your account and password the operator provides.
5. Click **Save**. The connection will automatically start.


#### VPN

VPN is a virtual private network. Its main function is to establish a private network on the public network for encrypted communication. Whether you are on a business trip or working at home, you can use VPN to access intranet resources as long as you can access the Internet. You can also use VPN to speed up access to websites in other countries.

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **VPN**, and click ![add](../common/add.svg) or ![import](../common/import.svg).
3. Select the VPN protocol type, and enter the name, gateway, account, password and other information. (Importing VPN will automatically fill in information)
4. Click **Save**,  the system will try to connect VPN network automatically.
5. You can export the VPN settings to backup or share with other users. 

>![notes](../common/notes.svg) Notes: If you don't want to use the VPN as the default routing, but only want it to take effect on specific network resources, switch on **Only applied in corresponding resources**.

#### System Proxy

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **System Proxy**.
3. Switch on **System Proxy**. For **Proxy Type**, you can:
   - Select **Manual** and input the address and port of proxy servers.
   - Select **Auto** and input a URL to configure the proxy info.
4. Click **Save**. 


#### Application Proxy

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **Application Proxy**.
3. Do the necessary settings.
4. Click **Save**.

>![notes](../common/notes.svg) Notes: After being configured, run Launcher, right-click any application's icon and check **Use a proxy**.

#### Network Info

You can view MAC, IP address, gateway and other network info in network details. 

1. On the homepage of Control Center, click ![network_normal](../common/network_normal.svg).
2. Click **Network Details**.
3. View the network info of the current wired or wireless network.



### Notification Settings

You can set "Do Not Disturb" to system notifications, and also switch on or off the notification hints of some applications.

![noticenter](fig/e_noticenter.png)

#### System Notification Settings

You can set "Do Not Disturb" to system notifications and whether to show icon on Dock here.

1. On the homepage of Control Center, click ![nav_notifi_42px](../common/dcc_nav_notification_36px.svg).

2. Click **System Notification**.

   - Switch on/off **Do Not Disturb**.
   After switching on this button, you can set the starting and ending time; also, you can check **When the screen is locked**. Under this mode, all notification are muted, but you can view all notifications in Notification Center. 
   - Switch on/off **Show icon on Dock**.

#### App Notification Settings

You can custom notification hints for all applications.

1. On the homepage of Control Center, click ![nav_notifi_42px](../common/dcc_nav_notification_36px.svg).
2. Under **App Notifications**, select an application, and in the window on the right, you can choose to check:
   - Play a sound
   - Show messages on lockscreen
   - Show only in notification center
   - Show message preview



### Sound Settings

Set your speaker and microphone properly to make you hear more comfortable and make clearer recordings.

![0|sound](fig/e_sound.png)

#### Output

1. On the homepage of Control Center, click ![sound_normal](../common/sound_normal.svg).
2. Click **Output** to:
   - Drag the slider to adjust output volume and left/right balance.
   - Switch on **Volume Boost**, the volume could be adjustable from 0~150% (the former range is 0~100%).
   - Select output device type from the drop-down list after **Output Device**.

#### Input

1. On the homepage of Control Center, click ![sound_normal](../common/sound_normal.svg).
2. Click **Input** to:

   - Adjust input volume by dragging the slider.
   - You can enable **Automatic Noise Suppression**. 
   - Select input device type from the drop-down list after **Input Device**.

>![tips](../common/tips.svg) Tips: Usually, you need to turn up the input volume to make sure that you can hear the sound of the sound source, but the volume should not be too high, because it will cause distortion of the sound. Here is how to set input volume: Speak to your microphone at a normal volume and view "Input Level". If the indicator changes obviously according to the volume, then the input volume is at a proper level. 

#### System Sound Effects

1. On the homepage of Control Center, click ![sound_normal](../common/sound_normal.svg).
2. Click **Sound Effects**, check the options you want to switch on the sound when the corresponding event occurs.

>![tips](../common/tips.svg) Tips: Click to listen to the sound effect.

#### Devices

1. On the homepage of Control Center, click ![sound_normal](../common/sound_normal.svg).
2. Click **Devices** to enable/disable the input devices and output devices.


### Bluetooth Settings

Bluetooth helps you make a short-distance wireless communication between Bluetooth devices without cable or network. The common Bluetooth devices are Bluetooth keyboard, Bluetooth mouse, Bluetooth earphones, Bluetooth speakers, etc.

![0|bluetooth](fig/eu_bluetooth.png)

>![notes](../common/notes.svg) Notes: If your computers does not have Bluetooth, you can purchase one Bluetooth adapter and plug it into your computer to enable the function.

#### Change Bluetooth Name

1. On the homepage of Control Center, click ![bluetooth_normal](../common/bluetooth_normal.svg).
2. Click ![edit](../common/edit.svg) after the Bluetooth name, and enter a new name for your computer.

>![notes](../common/notes.svg) Notes: Your computer's new name will be broadcasted automatically, and other devices should rescan to find it.

#### Connect to a Bluetooth Device

1. On the homepage of Control Center, click ![bluetooth_normal](../common/bluetooth_normal.svg).
2. Switch on **Bluetooth**. The system will scan the nearby devices automatically and list them in **Other Devices**.
3. Click the device you want to connect, and input the PIN code if required. After pairing successfully, the device will be connected automatically. 
4. After that, the Bluetooth device will be added to **My Device** list.
5. In the list, click the device, you can **Disconnect** the device, or change its name.

#### Transfer/Receive files via Bluetooth

Files could be transferred / received via Bluetooth between UnionTech OS PC and non UnionTech OS PC or between UnionTech OS PC and mobile device (mobile phone / tablet).

Prerequisite: the Bluetooth devices of both the sender and the receiver have been paired and connected successfully.

**Transfer files from Bluetooth of UnionTech OS PC**

Usage scenario: sender (UnionTech OS PC) transfers files via Bluetooth to receiver(non UnionTech OS PC / mobile phone / tablet)

1. On the homepage of Control Center, click ![bluetooth_normal](../common/bluetooth_normal.svg).
2. Switch on **Bluetooth**. The system will scan Bluetooth devices nearby automatically.
3. Select a paired and connected Bluetooth device in "My Devices". Click **Send Files** (this button will only appear on PC / mobile phone / tablet Bluetooth devices). Select a file to be sent from the popped-up File Manager interface, click **Open**.  
4. Click **Send** in the interface pops up to send a request. 

**Transfer files from Bluetooth of a mobile phone**

Usage scenario: sender (taking android phones as an example) transfers files via Bluetooth to receiver(UnionTech OS PC)

1. Switch on Bluetooth. The system will scan Bluetooth devices nearby automatically.
2. Select a paired and connected Bluetooth device.
3. Select a file to be sent in the phone, click **Send** to send it via Bluetooth.

**Receive files via Bluetooth**

When the sender sends a file, a prompt window pops up in the receiver's device, and the receiver can **Agree** or **Refuse** the file transfer.

   - If the receiver agrees with the request, then the sender starts to transfer the file and Bluetooth file transfer window is displayed; after the file transfer is completed, a prompt message will pop up at the the receiver, and the user can view the file content.
   - If the receiver is in the following situation, part of the file transfer fails, which will be displayed in the transmission failure list.
      - The file transfer request is refused by the receiver, then the transfer terminates, and "File Transfer Failed" window pops up.
      - The receiver times out or the transferring distance is beyond transmission range, and "File Transfer Failed" window pops up(Bluetooth device connection failed).
      - The receiver does not operate for 1 minute, then the transfer terminates by default,  and "File Transfer Failed" window pops up.


### Date and Time

Set your timezone properly to have correct date and time. You can also change them manually.

![0|time](fig/e_time.png)

#### Change Timezone

You have selected the timezone during system installation and do as follows to change it.

1. On the homepage of Control Center, click ![time](../common/time.svg).
2. Click **Timezone List**.
3. Click **Change System Timezone** and select a timezone by searching or clicking on the map.
4. Click **Confirm**.

#### Add Timezone

Add another timezone to see the date and time there.

1. On the homepage of Control Center, click ![time](../common/time.svg).
2. Click **Timezone List**.
3. Click ![add](../common/add.svg), select a timezone by searching or clicking on the map.
4. Click **Add**.

#### Delete Timezone

1. On the homepage of Control Center, click ![time](../common/time.svg).
2. Click **Timezone List**.
3. Click **Edit** after "Timezone List".
4. Click ![delete](../common/delete.svg) to remove the timezone.

#### Change Date and Time

Note that the auto-sync function will be disabled after changing date and time manually.

1. On the homepage of Control Center, click ![time](../common/time.svg).
2. Click **Time Settings**.
   - Switch on/off **Auto Sync**.
   - Enter the correct date and time.
5. Click **Confirm**.

> ![notes](../common/notes.svg) Notes: You can also switch on **Auto Sync**, and set the server sync parameters.

#### Set Time Format

Setting the format of time and date is supported.

1. On the homepage of Control Center, click ![time](../common/time.svg).
2. Click **Time Format** to set the first day of week, long date, short date, long time, and short time.

### Power Management

Power management turns the system to a low-power state when inactive, thus making a long battery endurance for laptop users, and protects system security.

![0|power](fig/e_power.png)

####  Time to Turn Off Monitor

1. On the homepage of Control Center, click ![power_normal](../common/power_normal.svg).
2. Click **Plugged In** or **On Battery**.
3. Set the time to turn off the monitor.

>![notes](../common/notes.svg) Notes: Laptop users can set different time for the same setting item under "Plugged In" and "On Battery".

#### Time to Lock Screen

1. On the homepage of Control Center, click ![power_normal](../common/power_normal.svg).
2. Click **Plugged In** and **On Battery**.
3. Set the time to lock screen.

#### Set "When the lid is closed"

1. On the homepage of Control Center, click ![power_normal](../common/power_normal.svg).
2. Click **Plugged In** and **On Battery**.
3. You can select **Turn off the monitor** and **Do nothing** from the drop-down list after **When the lid is closed**.  
>![notes](../common/notes.svg) Notes: This function is only available for laptops.

#### Power button settings

1. On the homepage of Control Center, click ![power_normal](../common/power_normal.svg).
2. Click **Plugged In** and **On Battery**.
3. You can select **Shut down, Turn off the monitor, Do nothing** from the drop-down list after **When pressing the power button**.

Any operation done here will take effect immediately. At the same time, the system will notify the user that the power button setting is changed. 

#### Set "Low Battery Notification"

1. On the homepage of Control Center, click ![power_normal](../common/power_normal.svg).
2. Click **Plugged In**.
3. Switch on **Low Battery Notification**. The system issues a low battery notification when the remaining battery power is below a set threshold (for example, 20%).

You can adjust the threshold of low battery level by dragging the slider below "Low battery level".  

>![notes](../common/notes.svg) Notes: This function is only available for laptops.

### Mouse and Touchpad

Mouse is a common computer input device. Using the mouse, you can make the operation easier and faster. 

![0|mouse](fig/e_mouse.png)

#### General Settings

1. On the homepage of Control Center, click ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg).
2. Click **General**.
3. Switch on **Left Hand**, and adjust **Scrolling Speed**, **Double-click Speed** for both mouse and touchpad.

>![notes](../common/notes.svg) Notes: If "Left Hand" is enabled, left-click and right-click of the mouse and touchpad exchange.

#### Mouse

After inserting or connecting the mouse, make relevant settings in the Control Center to make it more in line with your usage habits. 

>![notes](../common/notes.svg) Notes: If there is no touchpad, “Disable touchpad when a mouse is connected” will not be shown.

1. On the homepage of Control Center, click ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg).
2. Click **Mouse**.
3. Adjust **Pointer Speed**, which helps you to control the speed at which the pointer moves as the mouse moves.
4. Switch on **Natural Scrolling**/**Mouse Acceleration** if you want.

>![notes](../common/notes.svg) Notes: 
>   - Turn on the mouse acceleration to improve the accuracy of the pointer. The moving distance of the mouse pointer on the screen will increase according to the acceleration of the moving speed. It can be turned on or off according to the usage.
>   - If Natural Scrolling is enabled, when you scroll down, the page will scroll down, when you scroll up, the page will scroll up as well. 


#### Touchpad

![0|touchpad](fig/e_touchpad.png)

If you are using a laptop,  in order to avoid mis-operation on the touchpad, you can switch on **Disable touchpad while typing** in **Mouse > General** interface, and switch on **Disable touchpad when a mouse is connected** in **Mouse > Mouse** interface.  

You can also change **Pointer Speed**, and switch on **Natural Scrolling** for the touchpad.

#### TrackPoint

TrackPoint, also called pointing stick, is a small joystick used as a pointing device, typically mounted centrally in a laptop keyboard and used to control pointer movements on the screen.

1. On the homepage of Control Center, click ![mouse_touchpad_normal](../common/mouse_touchpad_normal.svg).
2. Click **TrackPoint**.
3. Adjust **Pointer Speed** to a proper level.



### Drawing Tablet

Drawing tablet, also called graphics tablet and pen tablet, is a computer input device that enables a user to hand draw images, animations and graphics with a special pen-like stylus. 

After connecting to the computer, you can set the pressure sensing force of the drawing tablet, that is, the pressure sensing value of the pen tip and eraser.

>![notes](../common/notes.svg)Notes: This part will be shown only if a drawing tablet is connected.

![0|graphicstablet](fig/e_graphicstablet.png)

### Keyboard and Language

Set keyboard properties and select your keyboard layout to keep your typing habit. You can also adjust the keyboard layout according to the country and language, change system language, and customize shortcuts here.

![0|keyboard](fig/e_keyboard.png)

#### Keyboard Properties

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **General**.
3. Adjust **Repeat Delay**/**Repeat Rate**.
4. Click **Test here** and hold down a key to test the repeat rate.
5. Switch on **Numeric Keypad** and **Caps Lock Prompt** if you want.

#### Keyboard Layout

Set the keyboard layout to customize the keyboard for the current language. When you press a key on the keyboard, the keyboard layout controls which characters are displayed on the screen. After changing the keyboard layout, the characters on the screen may not match the characters on the keyboard keys.

Usually, keyboard layout is set up during system installation, but you can add more for other purposes. 

![layout](fig/e_layout.png)

##### Add Keyboard Layout

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Keyboard Layout**.
3. Click ![add](../common/add.svg). Click a keyboard layout to add it.

##### Delete Keyboard Layout

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Keyboard Layout**.
3. Click **Edit**.
4. Click ![delete](../common/delete.svg) to delete keyboard layout.

#### Input Methods

Setting the input method can provide more input methods for the system. In the input method interface, you can add multiple input methods and set the shortcut keys for input method switching, so that users can choose the input method that conforms to their personal typing habits.

##### Add Input Method

You can add multiple input methods to the input method management list to switch input methods.

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Input Methods**.
3. Click ![add](../common/add.svg) to select an input method to add it to the list in "Add Input Method" page.

>![notes](../common/notes.svg) Notes: In "Input Methods" page, click **Edit**, click ![delete](../common/delete.svg) button to remove an input method. You can add the removed (but not uninstalled) input method in "Add Input Method" page.

##### Sort Input Method

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Input Methods**.
3. In "Manage input methods" area, drag the input method up and down or click the up and down arrows after the input method to sort them.

##### Configure Input Method

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Input Methods**.
3. In "Manage input methods" area, click ![set1](../common/set1.svg) button after each input method to set up configurations.

##### Set Shortcut Key for Switching Input Methods

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Input Methods**.
3. In "Shortcuts" area, select the shortcut key for switching input methods from the drop-down box.

>![notes](../common/notes.svg) Notes: Once the shortcut key is set successfully, when the input method is switched, it will automatically switch to the keyboard layout corresponding to the input method. Select **Applies to** to apply the switched keyboard layout to the whole system or current application.

#### System Language

The system language is the language you selected when you installed the system by default, which can be changed at any time.

##### Add System Language

Add multiple languages into the list to change language conveniently.

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **System Language**.
3. Click ![add](../common/add.svg) to enter the language list.
4. Select the language you want, and it will be added into system language list automatically.

##### Change System Language

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **System Language**.
3. Select the language you want to switch to, and the language package will be installed automatically.
4. After being successfully installed, log out and log in again to view the changes.

>![attention](../common/attention.svg) Attention: The keyboard layout may also be changed in the process of switching the system language. Please make sure that you select a correct keyboard layout to enter the login password.

#### Shortcuts

The shortcut list includes all shortcuts in the system. View, modify and customize the shortcuts here as you want.

![0|shortcut](fig/e_shortcut.png)

##### View Shortcuts

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Shortcuts**.
3. You can search or view the default shortcuts for system, window and workspace.


##### Modify Shortcuts

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Shortcuts**.
3. Click the shortcut you want to modify.
4. Press new shortcut to change it.

>![tips](../common/tips.svg) Tips: To disable a shortcut, please press ![Backspace](../common/Backspace.svg) on the keyboard. To cancel modifying, press **Esc** or click Restore Defaults at the bottom.

##### Customize Shortcuts

1. On the homepage of Control Center, click ![keyboard_normal](../common/keyboard_normal.svg).
2. Click **Shortcuts**.
3. Click ![add](../common/add.svg).
4. Enter the name, command and shortcut.
5. Click **Add**.
6. After being successfully added, click **Edit**.
7. Click ![delete](../common/delete.svg) to delete the custom shortcut.

>![tips](../common/tips.svg) Tips: To change the shortcut, click it and press a new shortcut to change it directly. To edit the name and command of the custom shortcut, click **Edit** >![edit](../common/edit.svg) near the shortcut name to enter the shortcut settings.

### Update Settings

When there are system updates, it will be notified on the home page of Control Center. Click ![update](../common/update.svg) to enter "check for updates" page. After checking is done, you can download and install system and application updates. You can also set to download the updates automatically. 

>![tips](../common/tips.svg) Tips: If you do not want to get the updates prompt, switch off "Updates Notification" in Update Settings.

![0|update](fig/e_update.png)

#### Update and Upgrade

1. On the homepage of Control Center, click ![update](../common/update.svg).
2. Click **Update** to check if there is an update.
   - If there is no update, you will see "Your system is up to date".
   - If there is an update, you will see **Download and install updates** button, change log and other messages.
3. Click **Download and install updates** to download and install updates.
4. After updating finishes, a hint appears telling you the system is updated successfully, 

>![notes](../common/notes.svg) Notes: You can click the button to pause and resume the downloading process. After updating finishes, a dialogue box pops up to remind you to **Reboot** or **Shut down** your computer to make the updates come into effect.

#### Auto Download Updates

1. On the homepage of Control Center, click ![update](../common/update.svg).
2. Click **Update Settings**.
3. Switch on **Auto Download Updates**.
4. When there are system updates, they will be automatically downloaded.

>![tips](../common/tips.svg) Tips:  Switch on **Auto Clear Package Cache** to remove the downloaded package caches regularly. 


### System Info

You can view system version, authorization info, hardware info, and the agreements here.

![0|info](fig/e_info.png)

#### About This PC

1. On the homepage of Control Center, click ![system_info_normal](../common/system_info_normal.svg).
2. Under **About This PC**, you can view system version, authorization and hardware information.
3. If the system has not been activated, click **Activate** to activate the system.

#### Edition License

1. On the homepage of Control Center, click ![system_info_normal](../common/system_info_normal.svg).
2. View the system edition license under **Edition License**.

#### End User License Agreement

1. On the homepage of Control Center, click ![system_info_normal](../common/system_info_normal.svg).
2. View the End User License Agreement under **End User License Agreement**.

#### Privacy Policy

1. On the homepage of Control Center, click ![system_info_normal](../common/system_info_normal.svg).
2. View the Privacy Policy under **Privacy Policy**.

### Authorization Management

Authorization management is a pre-installed system tool to help you activate the system.  Here mainly introduces the inactive interface, activation method, activation success and activation failure interfaces.

#### Unactivated Interface

1. There are two ways to run the authorization management tool:

   - Click ![uos1](../common/uos1.svg) on the tray in the lower right corner to enter the interface.

   - Open the **Control Center** to select the **System Info** and click **About This PC** to view the edition authorization column. Click **Activate** to enter the interface.
2. The inactive status includes being unactivated and being unactivated after expiration.
   - Unactivated: info in the interface includes name, edition, and authorization status.
   - Unactivated after expiration: the system is not activated within expiration date, info in the interface includes name, edition, authorization status, authorization object and expiration date. 
3. Choose the proper way to activate the system.

>![notes](../common/notes.svg) Notes: If the system is not activated, the authorization management icon ![uos1](../common/uos1.svg) will be docked on the tray in the lower right corner and displayed immediately upon startup.

#### Activation Method

The activation methods of authorization management can be divided into online activation and offline activation, while the online activation methods include "Try Full Version", "Input Serial Number" and "Import License File".

>![attention](../common/attention.svg) Attention: Only systems in the trial period or the ones activated successfully can all the functions of UnionTech OS be used normally, otherwise some functions will be limited. 


##### On-line Activation

The on-line activation is available only when the network is connected normally.

###### Try Full Version

Under both online/offline mode, the system is activated automatically. There is only one chance of **Try Full Version** for each device and the valid period is 180 days calculated from the activation date. All the system functions are available in the trial period.

1. Click ![uos1](../common/uos1.svg) on the tray in the lower right corner to enter the interface.

   ![0|probation1](fig/e_probation1.png)

2. Click **Try Full Version** and goto to the activation interface.

3. Click **Activate Now** and pops up the confirmation dialogue once again. Click **Confirm** to successfully activate the interface and the icon in the dock is changed to ![uos2](../common/uos2.svg).

4. It is available to view the information such as expiration date and so on. The system could also be activated by serial number and license files.

   ![0|probation3](fig/e_probation3.png)

###### Input Serial Number

1. Click ![uos1](../common/uos1.svg) on the tray in the lower right corner to enter the interface.
2. Click **Input Serial Number** to input the correct activation code and click **Activate Now**.

![0|activationcode1](fig/p_activationcode1.png)

3. Click **Confirm** in the pop-up confirmation dialogue box and pops up the activation success interface.



###### Import License File

1. Click ![uos1](../common/uos1.svg) on the tray in the lower right corner to enter the interface.
   
2. Click **Import License File**, select the correct license file in .key format in the File Manager and click **Activate Now**.  
   
3. Click **Confirm** in the secondary confirming dialogue box and pops up the activation success interface.


##### Off-line Activation

The off-line activation can be adopted when the network connection is abnormal.    

1. It will jump to the off-line activation interface when abnormal network connection is detected by the system in the process of activating the system by inputing the serial number or  importing the authorization file.

   ![0|activateoffline1](fig/p_activateoffline1.png)

2. Scan the QR code with your mobile phone  and the current device ID as well as activation code are displayed in the pop-up activation interface.

   ![0|activateoffline2](fig/p_activateoffline2.png) 

3. Click **Activate Now** and click **Confirm** in the pop-up confirmation dialogue. 

4. The device ID, activation code and off-line activation code are displayed in the activation success interface.

5. Input manually in the input box in PC the off-line activation code in the your mobile phone.

6. Click **Activate Offline** to jump to the activation success interface.

#### Activation Success

1. The major information shown in this page includes:
   - Product Name:  operation system name
   - Version: operation system version
   - Activation Status: including unactivated, expired and unactivated, and activated.
   - Authorization Status: including unauthorized, expired and authorized. 
   - Activation Method: it displays your actual activation method.
   - Expiration Date: From the 10th day to expiration date, the system will remind you that the authorization is about to expire.
   ![0|activationcode3](fig/e_activationcode3.png)
2. After the system is activated successfully, the authorization management icon is no longer displayed in the tray area in the lower right corner. You can view the authorization management tool through Control Center.


##### Change Serial Number

When the system is activated successfully, the serial number needs to be changed for some reasons.

If and only if the following conditions are met, the serial number can be changed.

   - Changing serial number is supported only when the authorization status is activated.

   - Only when the authorization mode is OPEN, the serial number can be changed.

Operation steps are as follows:

1. In the "View details" page, click **Change serial number**.
2. A prompt box pops up, click **Change**.
3. Enter the new serial number.
4. Click **Activate Now** to change the serial number.

>![notes](../common/notes.svg) Notes: the system supports changing serial number by executing the command **uos-activator-cmd -c/-C**, but it can only be changed for 3 times.

#### Activation Failure

The activation failure interface will pop up if the activation file has been used or expired.

#### Server Activation Setting

If the current server crashes, it is available to customize a new activation server by clicking the **Settings** in the main menu ![menu](../common/icon_menu.svg) of the authorization management tool.

### Backup and Restore

In order to avoid data loss or damage caused by software defects, hardware damage, improper human operation, hacker attacks, computer viruses, natural disasters and other factors, the application data or system data can be backed up and restored to ensure the normal operation of the system.

![0|backuprecovery](fig/e_backuprestore.png)

#### Backup

UnionTech OS provides backup by initialization and backup through Control Center.

##### Backup by initialization

If "Full Disk" is selected during system installation, a recovery partition would be created automatically at first, and the boot partition and root partition would be backup after that.

##### Backup through control center

You can backup data through either **Full Backup** or **System Backup** from Control Center.

1. On the homepage of Control Center, click ![system_info_normal](../common/system_info_normal.svg).

2. Select **Backup and Restore** > **Backup** to set the backup type and save the path of files backed up.
   - Backup Type: Full Backup and System Backup
      + Full Backup: to back up system files and user files of the whole disk
      + System Backup: When the user data is not reserved, the files of the root partition and the boot partition are backed up; when the user data is reserved, the files of the root partition, boot partition, opt partition and home partition are backed up.
   - Saving Method: New Backup and System Incremental Backup

   
>![notes](../common/notes.svg) Notes:  The function **Full Backup** can only back up files in other storage media instead of files on its own disk.

3. Click **Back Up**, the password input box pops up, please input the password to authorize the backup file until the file backup is completed.

>![attention](../common/attention.svg) Attention: In the process of file backup, please do not unplug the power supply or forcibly shut down to prevent data loss or damage.



#### Restore

UnionTech OS supports "restore from grub" and "restore from control center".

##### Restore from Grub

During system startup, in the system selection interface, click **UnionTech OS Restore**, you can choose "Reset to factory settings" to read initial backup during installation, or select "restore from backup files" to open the file directory and select the backup to be restored.

##### Restore from Control Center

You can either restore all settings or manually restore the previous backup data.

1. On the homepage of Control Center, click ![system_info_normal](../common/system_info_normal.svg).
2. Click **Backup and Restore** > **Restore** to select:
   - Restore to factory settings
      1. You can choose to check **Keep personal files and apps** and click **Restore Now**. Click **Confirm** in the dialogue box pops up. 
      2. Please input the password to authorize the data restoring.
   - Restore from backup files
      1. After selecting restoring directory, click ![three_dots](fig/three_dots.png) to select the files you want to restore.
      2. Click **Restore Now** to start system restoring.
   - Restore from a restore point


### General Settings

![general](fig/e_general.png)

#### Boot Menu

Boot menu is the grub menu for users to select an operating system to start. After selecting and confirming the boot option, your computer will load the system.

> ![notes](../common/notes.svg) Notes: arm architecture does not support startup menu setting for now; mips architecture does not support grub authentication or changing boot menu background picture for now.

##### Startup Delay

When there are multiple systems in the computer, Startup Delay will be switched on by default, and the grub menu will keep 5 seconds for users to select.

When there is only one system in the computer, Startup Delay will be switched off by default, and the grub menu will keep only 1 second.

##### Default Boot Entry

1. On the homepage of Control Center, click ![general](../common/general.svg).
2. Click **Boot Menu**.
3. Click the option in the preview window to set it as the default one.

##### Boot Menu Theme

1. On the homepage of Control Center, click ![general](../common/general.svg).
2. Click **Boot Menu**.
3. Switch on **Theme** to use it as the theme of boot menu.

>![tips](../common/tips.svg) Tips: You can drag and drop an image to the preview window to change the background of boot menu.

