// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef BACKENDMETAOBJECT_H
#define BACKENDMETAOBJECT_H

#include "global_header.h"

#include <QString>
#include <QSharedPointer>
#include <QMap>
#include <QVariant>

GLOBAL_BEGIN_NAMESPACE

class InferencePlugin;
class BackendMetaObjectPrivate;
class BackendMetaObject
{
    friend class BackendMetaObjectPrivate;
    friend class BackendLoader;
public:
    QString fileName() const;
    QString iid() const;
    QString name() const;
    QString version() const;
    QStringList suportedArchitectures() const;
    QStringList suportedFormats() const;
    void setExtra(const QString &key, const QVariant &value);
    QVariant extra(const QString &key, const QVariant &defaultValue = QVariant()) const;
protected:
    explicit BackendMetaObject();
private:
    BackendMetaObjectPrivate *d;
};

using BackendMetaObjectPointer = QSharedPointer<BackendMetaObject>;
GLOBAL_END_NAMESPACE

#endif // BACKENDMETAOBJECT_H
