// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef INFERENCEPLUGIN_H
#define INFERENCEPLUGIN_H

#include "global_header.h"

#include <QObject>

GLOBAL_BEGIN_NAMESPACE

#define InferencePlugin_Meta_IID "org.deepin.plugin.modelhub.inference-backend"
class ModelProxy;
class ModelInfo;
class InferencePlugin
{
public:
    explicit InferencePlugin() {}
    virtual ~InferencePlugin() {}
    virtual bool initialize(const QVariantHash &params) = 0;
    virtual ModelProxy* loadModel(const QString &name, const QString &imgDir, const QVariantHash &params) = 0;
signals:

public slots:

};

GLOBAL_END_NAMESPACE

Q_DECLARE_INTERFACE(GLOBAL_NAMESPACE::InferencePlugin, InferencePlugin_Meta_IID)

#endif // INFERENCEPLUGIN_H
