// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated with protocol_gen.go -- do not edit this file.
//   go run scripts/protocol_gen/protocol_gen.go
//
// DAP version 1.46.0

#include "dap/protocol.h"

namespace dap {

DAP_IMPLEMENT_STRUCT_TYPEINFO(Checksum,
                              "",
                              DAP_FIELD(algorithm, "algorithm"),
                              DAP_FIELD(checksum, "checksum"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(Source,
                              "",
                              DAP_FIELD(adapterData, "adapterData"),
                              DAP_FIELD(checksums, "checksums"),
                              DAP_FIELD(name, "name"),
                              DAP_FIELD(origin, "origin"),
                              DAP_FIELD(path, "path"),
                              DAP_FIELD(presentationHint, "presentationHint"),
                              DAP_FIELD(sourceReference, "sourceReference"),
                              DAP_FIELD(sources, "sources"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(Breakpoint,
                              "",
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(endColumn, "endColumn"),
                              DAP_FIELD(endLine, "endLine"),
                              DAP_FIELD(id, "id"),
                              DAP_FIELD(instructionReference,
                                        "instructionReference"),
                              DAP_FIELD(line, "line"),
                              DAP_FIELD(message, "message"),
                              DAP_FIELD(offset, "offset"),
                              DAP_FIELD(source, "source"),
                              DAP_FIELD(verified, "verified"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(BreakpointLocation,
                              "",
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(endColumn, "endColumn"),
                              DAP_FIELD(endLine, "endLine"),
                              DAP_FIELD(line, "line"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ColumnDescriptor,
                              "",
                              DAP_FIELD(attributeName, "attributeName"),
                              DAP_FIELD(format, "format"),
                              DAP_FIELD(label, "label"),
                              DAP_FIELD(type, "type"),
                              DAP_FIELD(width, "width"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ExceptionBreakpointsFilter,
                              "",
                              DAP_FIELD(conditionDescription,
                                        "conditionDescription"),
                              DAP_FIELD(def, "default"),
                              DAP_FIELD(description, "description"),
                              DAP_FIELD(filter, "filter"),
                              DAP_FIELD(label, "label"),
                              DAP_FIELD(supportsCondition,
                                        "supportsCondition"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(
    Capabilities,
    "",
    DAP_FIELD(additionalModuleColumns, "additionalModuleColumns"),
    DAP_FIELD(completionTriggerCharacters, "completionTriggerCharacters"),
    DAP_FIELD(exceptionBreakpointFilters, "exceptionBreakpointFilters"),
    DAP_FIELD(supportTerminateDebuggee, "supportTerminateDebuggee"),
    DAP_FIELD(supportedChecksumAlgorithms, "supportedChecksumAlgorithms"),
    DAP_FIELD(supportsBreakpointLocationsRequest,
              "supportsBreakpointLocationsRequest"),
    DAP_FIELD(supportsCancelRequest, "supportsCancelRequest"),
    DAP_FIELD(supportsClipboardContext, "supportsClipboardContext"),
    DAP_FIELD(supportsCompletionsRequest, "supportsCompletionsRequest"),
    DAP_FIELD(supportsConditionalBreakpoints, "supportsConditionalBreakpoints"),
    DAP_FIELD(supportsConfigurationDoneRequest,
              "supportsConfigurationDoneRequest"),
    DAP_FIELD(supportsDataBreakpoints, "supportsDataBreakpoints"),
    DAP_FIELD(supportsDelayedStackTraceLoading,
              "supportsDelayedStackTraceLoading"),
    DAP_FIELD(supportsDisassembleRequest, "supportsDisassembleRequest"),
    DAP_FIELD(supportsEvaluateForHovers, "supportsEvaluateForHovers"),
    DAP_FIELD(supportsExceptionFilterOptions, "supportsExceptionFilterOptions"),
    DAP_FIELD(supportsExceptionInfoRequest, "supportsExceptionInfoRequest"),
    DAP_FIELD(supportsExceptionOptions, "supportsExceptionOptions"),
    DAP_FIELD(supportsFunctionBreakpoints, "supportsFunctionBreakpoints"),
    DAP_FIELD(supportsGotoTargetsRequest, "supportsGotoTargetsRequest"),
    DAP_FIELD(supportsHitConditionalBreakpoints,
              "supportsHitConditionalBreakpoints"),
    DAP_FIELD(supportsInstructionBreakpoints, "supportsInstructionBreakpoints"),
    DAP_FIELD(supportsLoadedSourcesRequest, "supportsLoadedSourcesRequest"),
    DAP_FIELD(supportsLogPoints, "supportsLogPoints"),
    DAP_FIELD(supportsModulesRequest, "supportsModulesRequest"),
    DAP_FIELD(supportsReadMemoryRequest, "supportsReadMemoryRequest"),
    DAP_FIELD(supportsRestartFrame, "supportsRestartFrame"),
    DAP_FIELD(supportsRestartRequest, "supportsRestartRequest"),
    DAP_FIELD(supportsSetExpression, "supportsSetExpression"),
    DAP_FIELD(supportsSetVariable, "supportsSetVariable"),
    DAP_FIELD(supportsStepBack, "supportsStepBack"),
    DAP_FIELD(supportsStepInTargetsRequest, "supportsStepInTargetsRequest"),
    DAP_FIELD(supportsSteppingGranularity, "supportsSteppingGranularity"),
    DAP_FIELD(supportsTerminateRequest, "supportsTerminateRequest"),
    DAP_FIELD(supportsTerminateThreadsRequest,
              "supportsTerminateThreadsRequest"),
    DAP_FIELD(supportsValueFormattingOptions,
              "supportsValueFormattingOptions"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(CompletionItem,
                              "",
                              DAP_FIELD(label, "label"),
                              DAP_FIELD(length, "length"),
                              DAP_FIELD(selectionLength, "selectionLength"),
                              DAP_FIELD(selectionStart, "selectionStart"),
                              DAP_FIELD(sortText, "sortText"),
                              DAP_FIELD(start, "start"),
                              DAP_FIELD(text, "text"),
                              DAP_FIELD(type, "type"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(DisassembledInstruction,
                              "",
                              DAP_FIELD(address, "address"),
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(endColumn, "endColumn"),
                              DAP_FIELD(endLine, "endLine"),
                              DAP_FIELD(instruction, "instruction"),
                              DAP_FIELD(instructionBytes, "instructionBytes"),
                              DAP_FIELD(line, "line"),
                              DAP_FIELD(location, "location"),
                              DAP_FIELD(symbol, "symbol"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(Message,
                              "",
                              DAP_FIELD(format, "format"),
                              DAP_FIELD(id, "id"),
                              DAP_FIELD(sendTelemetry, "sendTelemetry"),
                              DAP_FIELD(showUser, "showUser"),
                              DAP_FIELD(url, "url"),
                              DAP_FIELD(urlLabel, "urlLabel"),
                              DAP_FIELD(variables, "variables"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(VariablePresentationHint,
                              "",
                              DAP_FIELD(attributes, "attributes"),
                              DAP_FIELD(kind, "kind"),
                              DAP_FIELD(visibility, "visibility"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ValueFormat, "", DAP_FIELD(hex, "hex"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ExceptionDetails,
                              "",
                              DAP_FIELD(evaluateName, "evaluateName"),
                              DAP_FIELD(fullTypeName, "fullTypeName"),
                              DAP_FIELD(innerException, "innerException"),
                              DAP_FIELD(message, "message"),
                              DAP_FIELD(stackTrace, "stackTrace"),
                              DAP_FIELD(typeName, "typeName"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(GotoTarget,
                              "",
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(endColumn, "endColumn"),
                              DAP_FIELD(endLine, "endLine"),
                              DAP_FIELD(id, "id"),
                              DAP_FIELD(instructionPointerReference,
                                        "instructionPointerReference"),
                              DAP_FIELD(label, "label"),
                              DAP_FIELD(line, "line"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(Module,
                              "",
                              DAP_FIELD(addressRange, "addressRange"),
                              DAP_FIELD(dateTimeStamp, "dateTimeStamp"),
                              DAP_FIELD(id, "id"),
                              DAP_FIELD(isOptimized, "isOptimized"),
                              DAP_FIELD(isUserCode, "isUserCode"),
                              DAP_FIELD(name, "name"),
                              DAP_FIELD(path, "path"),
                              DAP_FIELD(symbolFilePath, "symbolFilePath"),
                              DAP_FIELD(symbolStatus, "symbolStatus"),
                              DAP_FIELD(version, "version"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(Scope,
                              "",
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(endColumn, "endColumn"),
                              DAP_FIELD(endLine, "endLine"),
                              DAP_FIELD(expensive, "expensive"),
                              DAP_FIELD(indexedVariables, "indexedVariables"),
                              DAP_FIELD(line, "line"),
                              DAP_FIELD(name, "name"),
                              DAP_FIELD(namedVariables, "namedVariables"),
                              DAP_FIELD(presentationHint, "presentationHint"),
                              DAP_FIELD(source, "source"),
                              DAP_FIELD(variablesReference,
                                        "variablesReference"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(SourceBreakpoint,
                              "",
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(condition, "condition"),
                              DAP_FIELD(hitCondition, "hitCondition"),
                              DAP_FIELD(line, "line"),
                              DAP_FIELD(logMessage, "logMessage"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(DataBreakpoint,
                              "",
                              DAP_FIELD(accessType, "accessType"),
                              DAP_FIELD(condition, "condition"),
                              DAP_FIELD(dataId, "dataId"),
                              DAP_FIELD(hitCondition, "hitCondition"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ExceptionPathSegment,
                              "",
                              DAP_FIELD(names, "names"),
                              DAP_FIELD(negate, "negate"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ExceptionOptions,
                              "",
                              DAP_FIELD(breakMode, "breakMode"),
                              DAP_FIELD(path, "path"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(ExceptionFilterOptions,
                              "",
                              DAP_FIELD(condition, "condition"),
                              DAP_FIELD(filterId, "filterId"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(FunctionBreakpoint,
                              "",
                              DAP_FIELD(condition, "condition"),
                              DAP_FIELD(hitCondition, "hitCondition"),
                              DAP_FIELD(name, "name"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(InstructionBreakpoint,
                              "",
                              DAP_FIELD(condition, "condition"),
                              DAP_FIELD(hitCondition, "hitCondition"),
                              DAP_FIELD(instructionReference,
                                        "instructionReference"),
                              DAP_FIELD(offset, "offset"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(StackFrame,
                              "",
                              DAP_FIELD(canRestart, "canRestart"),
                              DAP_FIELD(column, "column"),
                              DAP_FIELD(endColumn, "endColumn"),
                              DAP_FIELD(endLine, "endLine"),
                              DAP_FIELD(id, "id"),
                              DAP_FIELD(instructionPointerReference,
                                        "instructionPointerReference"),
                              DAP_FIELD(line, "line"),
                              DAP_FIELD(moduleId, "moduleId"),
                              DAP_FIELD(name, "name"),
                              DAP_FIELD(presentationHint, "presentationHint"),
                              DAP_FIELD(source, "source"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(StackFrameFormat,
                              "",
                              DAP_FIELD(includeAll, "includeAll"),
                              DAP_FIELD(line, "line"),
                              DAP_FIELD(module, "module"),
                              DAP_FIELD(parameterNames, "parameterNames"),
                              DAP_FIELD(parameterTypes, "parameterTypes"),
                              DAP_FIELD(parameterValues, "parameterValues"),
                              DAP_FIELD(parameters, "parameters"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(StepInTarget,
                              "",
                              DAP_FIELD(id, "id"),
                              DAP_FIELD(label, "label"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(Thread,
                              "",
                              DAP_FIELD(id, "id"),
                              DAP_FIELD(name, "name"));

DAP_IMPLEMENT_STRUCT_TYPEINFO(Variable,
                              "",
                              DAP_FIELD(evaluateName, "evaluateName"),
                              DAP_FIELD(indexedVariables, "indexedVariables"),
                              DAP_FIELD(memoryReference, "memoryReference"),
                              DAP_FIELD(name, "name"),
                              DAP_FIELD(namedVariables, "namedVariables"),
                              DAP_FIELD(presentationHint, "presentationHint"),
                              DAP_FIELD(type, "type"),
                              DAP_FIELD(value, "value"),
                              DAP_FIELD(variablesReference,
                                        "variablesReference"));

}  // namespace dap
