/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "wayland_dnd.h"
#include "dde_security_interface.h"
#include "log.h"

#include <wayland-client.h>

static void handle_global(void *data,
                          struct wl_registry *wl_registry,
                          uint32_t name,
                          const char *interface,
                          uint32_t version)
{
    handle_dde_security(data, wl_registry, name, interface, version);
}

static void handle_global_remove(void *data,
                                  struct wl_registry *wl_registry,
                                  uint32_t name)
{
    // Who cares?
}

static const struct wl_registry_listener registry_listener = {
    .global = handle_global,
    .global_remove = handle_global_remove,
};

static void *wayland_dispatch(void *arg)
{
    WaylandDndBackendPtr pWayland = (WaylandDndBackend*)arg;
    if (!pWayland )
        return NULL;

    if (!pWayland->display)
        return NULL;

    while (pWayland->lock) {
        wl_display_dispatch(pWayland->display);
        pthread_testcancel();
    }

    // void *retval = NULL;
    // pthread_exit(retval);

    return NULL;
}

int initWaylandDnd()
{
    if (!pDndSec) {
        log_error("need init dtkdisplay content");
        return -1;
    }

    WaylandDndBackendPtr pWayland = (WaylandDndBackendPtr)malloc(sizeof(WaylandDndBackend));
    memset(pWayland, 0, sizeof(WaylandDndBackend));

    if (!pWayland) {
        log_error("malloc dnd security wayland backend failed \n");
        return -1;
    }
    pDndSec->backend = pWayland;
    pWayland->lock = true;

    pWayland->display = wl_display_connect(NULL);
    if (pWayland->display == NULL) {
        log_error("failed to create display");
        return -1;
    }

    struct wl_registry *registry = wl_display_get_registry(pWayland->display);
    wl_registry_add_listener(registry, &registry_listener, pDndSec);
    wl_display_roundtrip(pWayland->display);

    pthread_mutex_init(&pWayland->cond_lock, NULL);
    pthread_create(&pWayland->dispatch, NULL, wayland_dispatch, pWayland);

    return 0;
}

void destoryWaylandDnd()
{
    if (!pDndSec->backend) {
        log_error("wayland backend has been destroyed \n");
        return;
    }

    WaylandDndBackendPtr pWayland = ((WaylandDndBackend*)pDndSec->backend);

    pthread_mutex_lock(&pWayland->cond_lock);
    pWayland->lock = false;
    pthread_mutex_unlock(&pWayland->cond_lock);

    //cancel pthread
    void *retval = NULL;
    pthread_cancel(pWayland->dispatch);//cancel
    pthread_join(pWayland->dispatch, &retval);

    // security destory
    destory_dde_security(pWayland->dde_security);

    // client manager destory
    // not use
    //destory_client_management(pWayland->client_management);

    // display disconnect
    wl_display_disconnect(pWayland->display);

    free(pDndSec->backend);
}

int wGetSecuritySession(SessionType types)
{
    return get_security_session(types);
}

int wDestroySecuritySession(int session)
{
    return destroy_security_session(session);
}

void wReportSecurityVerified(int session, Permission result)
{
    report_security_verified(session, result);
}

struct dtk_array* wGetSecurityClients()
{
    return get_security_clients();
}
