--- dwarves-dfsg-1.20.orig/btf_encoder.c
+++ dwarves-dfsg-1.20/btf_encoder.c
@@ -691,7 +691,7 @@ int cu__encode_btf(struct cu *cu, int ve
 			printf("File %s:\n", btfe->filename);
 	}
 
-	type_id_off = btf__get_nr_types(btfe->btf);
+	type_id_off = btf__type_cnt(btfe->btf) - 1;
 
 	if (!has_index_type) {
 		/* cu__find_base_type_by_name() takes "type_id_t *id" */
--- dwarves-dfsg-1.20.orig/btf_loader.c
+++ dwarves-dfsg-1.20/btf_loader.c
@@ -395,7 +395,7 @@ static int btf_elf__load_types(struct bt
 	uint32_t type_index;
 	int err;
 
-	for (type_index = 1; type_index <= btf__get_nr_types(btfe->btf); type_index++) {
+	for (type_index = 1; type_index <= btf__type_cnt(btfe->btf) - 1; type_index++) {
 		const struct btf_type *type_ptr = btf__type_by_id(btfe->btf, type_index);
 		uint32_t type = btf_kind(type_ptr);
 
--- dwarves-dfsg-1.20.orig/lib/bpf/src/btf.h
+++ dwarves-dfsg-1.20/lib/bpf/src/btf.h
@@ -32,6 +32,7 @@ enum btf_endianness {
 
 LIBBPF_API void btf__free(struct btf *btf);
 
+LIBBPF_API __u32 btf__type_cnt(const struct btf *btf);
 LIBBPF_API struct btf *btf__new(const void *data, __u32 size);
 LIBBPF_API struct btf *btf__new_split(const void *data, __u32 size, struct btf *base_btf);
 LIBBPF_API struct btf *btf__new_empty(void);
--- dwarves-dfsg-1.20.orig/libbtf.c
+++ dwarves-dfsg-1.20/libbtf.c
@@ -262,7 +262,7 @@ __attribute ((format (printf, 5, 6)))
 static void btf_elf__log_err(const struct btf_elf *btfe, int kind, const char *name,
 			     bool output_cr, const char *fmt, ...)
 {
-	fprintf(stderr, "[%u] %s %s", btf__get_nr_types(btfe->btf) + 1,
+	fprintf(stderr, "[%u] %s %s", btf__type_cnt(btfe->btf),
 		btf_kind_str[kind], name ?: "(anon)");
 
 	if (fmt && *fmt) {
@@ -292,7 +292,7 @@ static void btf_elf__log_type(const stru
 	out = err ? stderr : stdout;
 
 	fprintf(out, "[%u] %s %s",
-		btf__get_nr_types(btfe->btf), btf_kind_str[kind],
+		btf__type_cnt(btfe->btf) - 1, btf_kind_str[kind],
 		btf_elf__printable_name(btfe, t->name_off));
 
 	if (fmt && *fmt) {
@@ -482,10 +482,10 @@ int btf_elf__add_member(struct btf_elf *
 	int err;
 
 	err = btf__add_field(btf, name, type, offset, bitfield_size);
-	t = btf__type_by_id(btf, btf__get_nr_types(btf));
+	t = btf__type_by_id(btf, btf__type_cnt(btf) - 1);
 	if (err) {
 		fprintf(stderr, "[%u] %s %s's field '%s' offset=%u bit_size=%u type=%u Error emitting field\n",
-			btf__get_nr_types(btf), btf_kind_str[btf_kind(t)],
+			btf__type_cnt(btf) - 1, btf_kind_str[btf_kind(t)],
 			btf_elf__printable_name(btfe, t->name_off),
 			name, offset, bitfield_size, type);
 	} else {
@@ -827,7 +827,7 @@ int btf_elf__encode(struct btf_elf *btfe
 	struct btf *btf = btfe->btf;
 
 	/* Empty file, nothing to do, so... done! */
-	if (btf__get_nr_types(btf) == 0)
+	if (btf__type_cnt(btf) == 1)
 		return 0;
 
 	if (btf__dedup(btf, NULL, NULL)) {
