// Code generated by "./generator ./system/org.freedesktop.modemmanager1"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package modemmanager1

import (
	"fmt"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-dbus-factory/object_manager"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
	"github.com/stretchr/testify/mock"
)

type MockManager struct {
	object_manager.MockInterfaceObjectManager // interface org.freedesktop.DBus.ObjectManager
	MockInterfaceManager                      // interface org.freedesktop.ModemManager1
	proxy.MockObject
}

type MockInterfaceManager struct {
	mock.Mock
}

// method ScanDevices

func (v *MockInterfaceManager) GoScanDevices(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) ScanDevices(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method SetLogging

func (v *MockInterfaceManager) GoSetLogging(flags dbus.Flags, ch chan *dbus.Call, level string) *dbus.Call {
	mockArgs := v.Called(flags, ch, level)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceManager) SetLogging(flags dbus.Flags, level string) error {
	mockArgs := v.Called(flags, level)

	return mockArgs.Error(0)
}

type MockModem struct {
	MockInterfaceModem          // interface org.freedesktop.ModemManager1.Modem
	MockInterfaceModemFirmware  // interface org.freedesktop.ModemManager1.Modem.Firmware
	MockInterfaceModemLocation  // interface org.freedesktop.ModemManager1.Modem.Location
	MockInterfaceModemMessaging // interface org.freedesktop.ModemManager1.Modem.Messaging
	MockInterfaceModem3gppUssd  // interface org.freedesktop.ModemManager1.Modem.Modem3gpp.Ussd
	MockInterfaceModem3gpp      // interface org.freedesktop.ModemManager1.Modem.Modem3gpp
	MockInterfaceModemCdma      // interface org.freedesktop.ModemManager1.Modem.ModemCdma
	MockInterfaceModemOma       // interface org.freedesktop.ModemManager1.Modem.Oma
	MockInterfaceModemSignal    // interface org.freedesktop.ModemManager1.Modem.Signal
	MockInterfaceModemSimple    // interface org.freedesktop.ModemManager1.Modem.Simple
	MockInterfaceModemTime      // interface org.freedesktop.ModemManager1.Modem.Time
	MockInterfaceModemVoice     // interface org.freedesktop.ModemManager1.Modem.Voice
	proxy.MockObject
}

type MockInterfaceModem struct {
	mock.Mock
}

// method Enable

func (v *MockInterfaceModem) GoEnable(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, enable)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) Enable(flags dbus.Flags, enable bool) error {
	mockArgs := v.Called(flags, enable)

	return mockArgs.Error(0)
}

// method ListBearers

func (v *MockInterfaceModem) GoListBearers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) ListBearers(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method CreateBearer

func (v *MockInterfaceModem) GoCreateBearer(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) CreateBearer(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, properties)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method DeleteBearer

func (v *MockInterfaceModem) GoDeleteBearer(flags dbus.Flags, ch chan *dbus.Call, bearer dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, bearer)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) DeleteBearer(flags dbus.Flags, bearer dbus.ObjectPath) error {
	mockArgs := v.Called(flags, bearer)

	return mockArgs.Error(0)
}

// method Reset

func (v *MockInterfaceModem) GoReset(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) Reset(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// method FactoryReset

func (v *MockInterfaceModem) GoFactoryReset(flags dbus.Flags, ch chan *dbus.Call, code string) *dbus.Call {
	mockArgs := v.Called(flags, ch, code)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) FactoryReset(flags dbus.Flags, code string) error {
	mockArgs := v.Called(flags, code)

	return mockArgs.Error(0)
}

// method SetPowerState

func (v *MockInterfaceModem) GoSetPowerState(flags dbus.Flags, ch chan *dbus.Call, state uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, state)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) SetPowerState(flags dbus.Flags, state uint32) error {
	mockArgs := v.Called(flags, state)

	return mockArgs.Error(0)
}

// method SetCurrentCapabilities

func (v *MockInterfaceModem) GoSetCurrentCapabilities(flags dbus.Flags, ch chan *dbus.Call, capabilities uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, capabilities)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) SetCurrentCapabilities(flags dbus.Flags, capabilities uint32) error {
	mockArgs := v.Called(flags, capabilities)

	return mockArgs.Error(0)
}

// method SetCurrentModes

func (v *MockInterfaceModem) GoSetCurrentModes(flags dbus.Flags, ch chan *dbus.Call, modes ModemModes) *dbus.Call {
	mockArgs := v.Called(flags, ch, modes)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) SetCurrentModes(flags dbus.Flags, modes ModemModes) error {
	mockArgs := v.Called(flags, modes)

	return mockArgs.Error(0)
}

// method SetCurrentBands

func (v *MockInterfaceModem) GoSetCurrentBands(flags dbus.Flags, ch chan *dbus.Call, bands []uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, bands)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) SetCurrentBands(flags dbus.Flags, bands []uint32) error {
	mockArgs := v.Called(flags, bands)

	return mockArgs.Error(0)
}

// method Command

func (v *MockInterfaceModem) GoCommand(flags dbus.Flags, ch chan *dbus.Call, cmd string, timeout uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, cmd, timeout)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem) Command(flags dbus.Flags, cmd string, timeout uint32) (string, error) {
	mockArgs := v.Called(flags, cmd, timeout)

	return mockArgs.String(0), mockArgs.Error(1)
}

// signal StateChanged

func (v *MockInterfaceModem) ConnectStateChanged(cb func(old int32, new int32, reason uint32)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property Sim o

func (v *MockInterfaceModem) Sim() proxy.PropObjectPath {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Bearers ao

func (v *MockInterfaceModem) Bearers() proxy.PropObjectPathArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropObjectPathArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SupportedCapabilities au

func (v *MockInterfaceModem) SupportedCapabilities() proxy.PropUint32Array {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32Array)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property CurrentCapabilities u

func (v *MockInterfaceModem) CurrentCapabilities() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property MaxBearers u

func (v *MockInterfaceModem) MaxBearers() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property MaxActiveBearers u

func (v *MockInterfaceModem) MaxActiveBearers() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Manufacturer s

func (v *MockInterfaceModem) Manufacturer() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Model s

func (v *MockInterfaceModem) Model() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Revision s

func (v *MockInterfaceModem) Revision() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property DeviceIdentifier s

func (v *MockInterfaceModem) DeviceIdentifier() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Device s

func (v *MockInterfaceModem) Device() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Drivers as

func (v *MockInterfaceModem) Drivers() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Plugin s

func (v *MockInterfaceModem) Plugin() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PrimaryPort s

func (v *MockInterfaceModem) PrimaryPort() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropModemPorts struct {
	mock.Mock
}

func (p MockPropModemPorts) Get(flags dbus.Flags) (value []ModemPort, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).([]ModemPort)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropModemPorts) Set(flags dbus.Flags, value []ModemPort) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropModemPorts) ConnectChanged(cb func(hasValue bool, value []ModemPort)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property Ports a(su)

func (v *MockInterfaceModem) Ports() PropModemPorts {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropModemPorts)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property EquipmentIdentifier s

func (v *MockInterfaceModem) EquipmentIdentifier() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property UnlockRequired u

func (v *MockInterfaceModem) UnlockRequired() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropModemUnlockRetries struct {
	mock.Mock
}

func (p MockPropModemUnlockRetries) Get(flags dbus.Flags) (value map[uint32]uint32, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(map[uint32]uint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropModemUnlockRetries) Set(flags dbus.Flags, value map[uint32]uint32) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropModemUnlockRetries) ConnectChanged(cb func(hasValue bool, value map[uint32]uint32)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property UnlockRetries a{uu}

func (v *MockInterfaceModem) UnlockRetries() PropModemUnlockRetries {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropModemUnlockRetries)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property State i

func (v *MockInterfaceModem) State() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property StateFailedReason u

func (v *MockInterfaceModem) StateFailedReason() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property AccessTechnologies u

func (v *MockInterfaceModem) AccessTechnologies() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropModemSignalQuality struct {
	mock.Mock
}

func (p MockPropModemSignalQuality) Get(flags dbus.Flags) (value ModemSignalQuality, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(ModemSignalQuality)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropModemSignalQuality) Set(flags dbus.Flags, value ModemSignalQuality) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropModemSignalQuality) ConnectChanged(cb func(hasValue bool, value ModemSignalQuality)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property SignalQuality (ub)

func (v *MockInterfaceModem) SignalQuality() PropModemSignalQuality {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropModemSignalQuality)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property OwnNumbers as

func (v *MockInterfaceModem) OwnNumbers() proxy.PropStringArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropStringArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property PowerState u

func (v *MockInterfaceModem) PowerState() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropModemSupportedModes struct {
	mock.Mock
}

func (p MockPropModemSupportedModes) Get(flags dbus.Flags) (value []ModemModes, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).([]ModemModes)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropModemSupportedModes) Set(flags dbus.Flags, value []ModemModes) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropModemSupportedModes) ConnectChanged(cb func(hasValue bool, value []ModemModes)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property SupportedModes a(uu)

func (v *MockInterfaceModem) SupportedModes() PropModemSupportedModes {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropModemSupportedModes)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropModemCurrentModes struct {
	mock.Mock
}

func (p MockPropModemCurrentModes) Get(flags dbus.Flags) (value ModemModes, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(ModemModes)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropModemCurrentModes) Set(flags dbus.Flags, value ModemModes) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropModemCurrentModes) ConnectChanged(cb func(hasValue bool, value ModemModes)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property CurrentModes (uu)

func (v *MockInterfaceModem) CurrentModes() PropModemCurrentModes {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropModemCurrentModes)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SupportedBands au

func (v *MockInterfaceModem) SupportedBands() proxy.PropUint32Array {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32Array)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property CurrentBands au

func (v *MockInterfaceModem) CurrentBands() proxy.PropUint32Array {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32Array)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SupportedIpFamilies u

func (v *MockInterfaceModem) SupportedIpFamilies() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModemFirmware struct {
	mock.Mock
}

// method List

func (v *MockInterfaceModemFirmware) GoList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemFirmware) List(flags dbus.Flags) (string, []map[string]dbus.Variant, error) {
	mockArgs := v.Called(flags)

	ret1, ok := mockArgs.Get(1).([]map[string]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 1, mockArgs.Get(1)))
	}

	return mockArgs.String(0), ret1, mockArgs.Error(2)
}

// method Select

func (v *MockInterfaceModemFirmware) GoSelect(flags dbus.Flags, ch chan *dbus.Call, uniqueid string) *dbus.Call {
	mockArgs := v.Called(flags, ch, uniqueid)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemFirmware) Select(flags dbus.Flags, uniqueid string) error {
	mockArgs := v.Called(flags, uniqueid)

	return mockArgs.Error(0)
}

type MockInterfaceModemLocation struct {
	mock.Mock
}

// method Setup

func (v *MockInterfaceModemLocation) GoSetup(flags dbus.Flags, ch chan *dbus.Call, sources uint32, signal_location bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, sources, signal_location)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemLocation) Setup(flags dbus.Flags, sources uint32, signal_location bool) error {
	mockArgs := v.Called(flags, sources, signal_location)

	return mockArgs.Error(0)
}

// method GetLocation

func (v *MockInterfaceModemLocation) GoGetLocation(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemLocation) GetLocation(flags dbus.Flags) (map[uint32]dbus.Variant, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).(map[uint32]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method SetSuplServer

func (v *MockInterfaceModemLocation) GoSetSuplServer(flags dbus.Flags, ch chan *dbus.Call, supl string) *dbus.Call {
	mockArgs := v.Called(flags, ch, supl)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemLocation) SetSuplServer(flags dbus.Flags, supl string) error {
	mockArgs := v.Called(flags, supl)

	return mockArgs.Error(0)
}

// method SetGpsRefreshRate

func (v *MockInterfaceModemLocation) GoSetGpsRefreshRate(flags dbus.Flags, ch chan *dbus.Call, rate uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, rate)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemLocation) SetGpsRefreshRate(flags dbus.Flags, rate uint32) error {
	mockArgs := v.Called(flags, rate)

	return mockArgs.Error(0)
}

// property Capabilities u

func (v *MockInterfaceModemLocation) Capabilities() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Enabled u

func (v *MockInterfaceModemLocation) Enabled() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SignalsLocation b

func (v *MockInterfaceModemLocation) SignalsLocation() proxy.PropBool {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropBool)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropModemLocation struct {
	mock.Mock
}

func (p MockPropModemLocation) Get(flags dbus.Flags) (value map[uint32]dbus.Variant, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(map[uint32]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropModemLocation) Set(flags dbus.Flags, value map[uint32]dbus.Variant) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropModemLocation) ConnectChanged(cb func(hasValue bool, value map[uint32]dbus.Variant)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property Location a{uv}

func (v *MockInterfaceModemLocation) Location() PropModemLocation {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropModemLocation)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SuplServer s

func (v *MockInterfaceModemLocation) SuplServer() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property GpsRefreshRate u

func (v *MockInterfaceModemLocation) GpsRefreshRate() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModemMessaging struct {
	mock.Mock
}

// method List

func (v *MockInterfaceModemMessaging) GoList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemMessaging) List(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method Delete

func (v *MockInterfaceModemMessaging) GoDelete(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, path)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemMessaging) Delete(flags dbus.Flags, path dbus.ObjectPath) error {
	mockArgs := v.Called(flags, path)

	return mockArgs.Error(0)
}

// method Create

func (v *MockInterfaceModemMessaging) GoCreate(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemMessaging) Create(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, properties)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal Added

func (v *MockInterfaceModemMessaging) ConnectAdded(cb func(path dbus.ObjectPath, received bool)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal Deleted

func (v *MockInterfaceModemMessaging) ConnectDeleted(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property Messages ao

func (v *MockInterfaceModemMessaging) Messages() proxy.PropObjectPathArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropObjectPathArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SupportedStorages au

func (v *MockInterfaceModemMessaging) SupportedStorages() proxy.PropUint32Array {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32Array)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property DefaultStorage u

func (v *MockInterfaceModemMessaging) DefaultStorage() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModem3gppUssd struct {
	mock.Mock
}

// method Initiate

func (v *MockInterfaceModem3gppUssd) GoInitiate(flags dbus.Flags, ch chan *dbus.Call, command string) *dbus.Call {
	mockArgs := v.Called(flags, ch, command)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem3gppUssd) Initiate(flags dbus.Flags, command string) (string, error) {
	mockArgs := v.Called(flags, command)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method Respond

func (v *MockInterfaceModem3gppUssd) GoRespond(flags dbus.Flags, ch chan *dbus.Call, response string) *dbus.Call {
	mockArgs := v.Called(flags, ch, response)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem3gppUssd) Respond(flags dbus.Flags, response string) (string, error) {
	mockArgs := v.Called(flags, response)

	return mockArgs.String(0), mockArgs.Error(1)
}

// method Cancel

func (v *MockInterfaceModem3gppUssd) GoCancel(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem3gppUssd) Cancel(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// property State u

func (v *MockInterfaceModem3gppUssd) State() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property NetworkNotification s

func (v *MockInterfaceModem3gppUssd) NetworkNotification() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property NetworkRequest s

func (v *MockInterfaceModem3gppUssd) NetworkRequest() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModem3gpp struct {
	mock.Mock
}

// method Register

func (v *MockInterfaceModem3gpp) GoRegister(flags dbus.Flags, ch chan *dbus.Call, operator_id string) *dbus.Call {
	mockArgs := v.Called(flags, ch, operator_id)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem3gpp) Register(flags dbus.Flags, operator_id string) error {
	mockArgs := v.Called(flags, operator_id)

	return mockArgs.Error(0)
}

// method Scan

func (v *MockInterfaceModem3gpp) GoScan(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModem3gpp) Scan(flags dbus.Flags) ([]map[string]dbus.Variant, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]map[string]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property Imei s

func (v *MockInterfaceModem3gpp) Imei() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property RegistrationState u

func (v *MockInterfaceModem3gpp) RegistrationState() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property OperatorCode s

func (v *MockInterfaceModem3gpp) OperatorCode() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property OperatorName s

func (v *MockInterfaceModem3gpp) OperatorName() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property EnabledFacilityLocks u

func (v *MockInterfaceModem3gpp) EnabledFacilityLocks() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SubscriptionState u

func (v *MockInterfaceModem3gpp) SubscriptionState() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModemCdma struct {
	mock.Mock
}

// method Activate

func (v *MockInterfaceModemCdma) GoActivate(flags dbus.Flags, ch chan *dbus.Call, carrier_code string) *dbus.Call {
	mockArgs := v.Called(flags, ch, carrier_code)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemCdma) Activate(flags dbus.Flags, carrier_code string) error {
	mockArgs := v.Called(flags, carrier_code)

	return mockArgs.Error(0)
}

// method ActivateManual

func (v *MockInterfaceModemCdma) GoActivateManual(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemCdma) ActivateManual(flags dbus.Flags, properties map[string]dbus.Variant) error {
	mockArgs := v.Called(flags, properties)

	return mockArgs.Error(0)
}

// signal ActivationStateChanged

func (v *MockInterfaceModemCdma) ConnectActivationStateChanged(cb func(activation_state uint32, activation_error uint32, status_changes map[string]dbus.Variant)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property ActivationState u

func (v *MockInterfaceModemCdma) ActivationState() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Meid s

func (v *MockInterfaceModemCdma) Meid() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Esn s

func (v *MockInterfaceModemCdma) Esn() proxy.PropString {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropString)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Sid u

func (v *MockInterfaceModemCdma) Sid() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Nid u

func (v *MockInterfaceModemCdma) Nid() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Cdma1xRegistrationState u

func (v *MockInterfaceModemCdma) Cdma1xRegistrationState() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property EvdoRegistrationState u

func (v *MockInterfaceModemCdma) EvdoRegistrationState() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModemOma struct {
	mock.Mock
}

// method Setup

func (v *MockInterfaceModemOma) GoSetup(flags dbus.Flags, ch chan *dbus.Call, features uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, features)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemOma) Setup(flags dbus.Flags, features uint32) error {
	mockArgs := v.Called(flags, features)

	return mockArgs.Error(0)
}

// method StartClientInitiatedSession

func (v *MockInterfaceModemOma) GoStartClientInitiatedSession(flags dbus.Flags, ch chan *dbus.Call, session_type uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, session_type)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemOma) StartClientInitiatedSession(flags dbus.Flags, session_type uint32) error {
	mockArgs := v.Called(flags, session_type)

	return mockArgs.Error(0)
}

// method AcceptNetworkInitiatedSession

func (v *MockInterfaceModemOma) GoAcceptNetworkInitiatedSession(flags dbus.Flags, ch chan *dbus.Call, session_id uint32, accept bool) *dbus.Call {
	mockArgs := v.Called(flags, ch, session_id, accept)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemOma) AcceptNetworkInitiatedSession(flags dbus.Flags, session_id uint32, accept bool) error {
	mockArgs := v.Called(flags, session_id, accept)

	return mockArgs.Error(0)
}

// method CancelSession

func (v *MockInterfaceModemOma) GoCancelSession(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemOma) CancelSession(flags dbus.Flags) error {
	mockArgs := v.Called(flags)

	return mockArgs.Error(0)
}

// signal SessionStateChanged

func (v *MockInterfaceModemOma) ConnectSessionStateChanged(cb func(old_session_state int32, new_session_state int32, session_state_failed_reason uint32)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property Features u

func (v *MockInterfaceModemOma) Features() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropModemOmaPendingNetworkInitiatedSessions struct {
	mock.Mock
}

func (p MockPropModemOmaPendingNetworkInitiatedSessions) Get(flags dbus.Flags) (value []OmaSession, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).([]OmaSession)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropModemOmaPendingNetworkInitiatedSessions) Set(flags dbus.Flags, value []OmaSession) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropModemOmaPendingNetworkInitiatedSessions) ConnectChanged(cb func(hasValue bool, value []OmaSession)) error {
	args := p.Called(cb)

	return args.Error(0)
}

// property PendingNetworkInitiatedSessions a(uu)

func (v *MockInterfaceModemOma) PendingNetworkInitiatedSessions() PropModemOmaPendingNetworkInitiatedSessions {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropModemOmaPendingNetworkInitiatedSessions)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SessionType u

func (v *MockInterfaceModemOma) SessionType() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property SessionState i

func (v *MockInterfaceModemOma) SessionState() proxy.PropInt32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropInt32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModemSignal struct {
	mock.Mock
}

// method Setup

func (v *MockInterfaceModemSignal) GoSetup(flags dbus.Flags, ch chan *dbus.Call, rate uint32) *dbus.Call {
	mockArgs := v.Called(flags, ch, rate)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemSignal) Setup(flags dbus.Flags, rate uint32) error {
	mockArgs := v.Called(flags, rate)

	return mockArgs.Error(0)
}

// property Rate u

func (v *MockInterfaceModemSignal) Rate() proxy.PropUint32 {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropUint32)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Cdma a{sv}

func (v *MockInterfaceModemSignal) Cdma() PropMapStringVariant {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropMapStringVariant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Evdo a{sv}

func (v *MockInterfaceModemSignal) Evdo() PropMapStringVariant {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropMapStringVariant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Gsm a{sv}

func (v *MockInterfaceModemSignal) Gsm() PropMapStringVariant {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropMapStringVariant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Umts a{sv}

func (v *MockInterfaceModemSignal) Umts() PropMapStringVariant {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropMapStringVariant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

// property Lte a{sv}

func (v *MockInterfaceModemSignal) Lte() PropMapStringVariant {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropMapStringVariant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModemSimple struct {
	mock.Mock
}

// method Connect

func (v *MockInterfaceModemSimple) GoConnect(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemSimple) Connect(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, properties)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method Disconnect

func (v *MockInterfaceModemSimple) GoDisconnect(flags dbus.Flags, ch chan *dbus.Call, bearer dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, bearer)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemSimple) Disconnect(flags dbus.Flags, bearer dbus.ObjectPath) error {
	mockArgs := v.Called(flags, bearer)

	return mockArgs.Error(0)
}

// method GetStatus

func (v *MockInterfaceModemSimple) GoGetStatus(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemSimple) GetStatus(flags dbus.Flags) (map[string]dbus.Variant, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).(map[string]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

type MockInterfaceModemTime struct {
	mock.Mock
}

// method GetNetworkTime

func (v *MockInterfaceModemTime) GoGetNetworkTime(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemTime) GetNetworkTime(flags dbus.Flags) (string, error) {
	mockArgs := v.Called(flags)

	return mockArgs.String(0), mockArgs.Error(1)
}

// signal NetworkTimeChanged

func (v *MockInterfaceModemTime) ConnectNetworkTimeChanged(cb func(time string)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property NetworkTimezone a{sv}

func (v *MockInterfaceModemTime) NetworkTimezone() PropMapStringVariant {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*MockPropMapStringVariant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockInterfaceModemVoice struct {
	mock.Mock
}

// method ListCalls

func (v *MockInterfaceModemVoice) GoListCalls(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	mockArgs := v.Called(flags, ch)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemVoice) ListCalls(flags dbus.Flags) ([]dbus.ObjectPath, error) {
	mockArgs := v.Called(flags)

	ret0, ok := mockArgs.Get(0).([]dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// method DeleteCall

func (v *MockInterfaceModemVoice) GoDeleteCall(flags dbus.Flags, ch chan *dbus.Call, path dbus.ObjectPath) *dbus.Call {
	mockArgs := v.Called(flags, ch, path)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemVoice) DeleteCall(flags dbus.Flags, path dbus.ObjectPath) error {
	mockArgs := v.Called(flags, path)

	return mockArgs.Error(0)
}

// method CreateCall

func (v *MockInterfaceModemVoice) GoCreateCall(flags dbus.Flags, ch chan *dbus.Call, properties map[string]dbus.Variant) *dbus.Call {
	mockArgs := v.Called(flags, ch, properties)

	ret, ok := mockArgs.Get(0).(*dbus.Call)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: 0 failed because object wasn't correct type: %v", mockArgs.Get(0)))
	}

	return ret
}

func (v *MockInterfaceModemVoice) CreateCall(flags dbus.Flags, properties map[string]dbus.Variant) (dbus.ObjectPath, error) {
	mockArgs := v.Called(flags, properties)

	ret0, ok := mockArgs.Get(0).(dbus.ObjectPath)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal CallAdded

func (v *MockInterfaceModemVoice) ConnectCallAdded(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// signal CallDeleted

func (v *MockInterfaceModemVoice) ConnectCallDeleted(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	mockArgs := v.Called(cb)

	ret0, ok := mockArgs.Get(0).(dbusutil.SignalHandlerId)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0, mockArgs.Error(1)
}

// property Calls ao

func (v *MockInterfaceModemVoice) Calls() proxy.PropObjectPathArray {
	mockArgs := v.Called()

	ret0, ok := mockArgs.Get(0).(*proxy.MockPropObjectPathArray)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, mockArgs.Get(0)))
	}

	return ret0
}

type MockPropMapStringVariant struct {
	mock.Mock
}

func (p MockPropMapStringVariant) Get(flags dbus.Flags) (value map[string]dbus.Variant, err error) {
	args := p.Called(flags)

	var ok bool
	value, ok = args.Get(0).(map[string]dbus.Variant)
	if !ok {
		panic(fmt.Sprintf("assert: arguments: %d failed because object wasn't correct type: %v", 0, args.Get(0)))
	}

	err = args.Error(1)

	return
}

func (p MockPropMapStringVariant) Set(flags dbus.Flags, value map[string]dbus.Variant) error {
	args := p.Called(flags, value)

	return args.Error(0)
}

func (p MockPropMapStringVariant) ConnectChanged(cb func(hasValue bool, value map[string]dbus.Variant)) error {
	args := p.Called(cb)

	return args.Error(0)
}
