#ifndef DEFAULTAGENT_H
#define DEFAULTAGENT_H

#include "agentrequesthandler.h"

namespace uos_ai {

class DefaultAgent : public AgentRequestHandler
{
    Q_OBJECT
public:
    explicit DefaultAgent(QObject *parent = nullptr);

    /**
     * 获取智能体的MCPServer类
     * @returns {MCPServer} MCPServer对象
     */
    QSharedPointer<MCPServer> mcpServer() const override;

    /**
     * 获取显示名称
     * @returns {QString} 显示名称
     */
    QString displayName() const;
    
    /**
     * 获取图标
     * @returns {QString} 图标路径或名称
     */
    QString icon() const;
    
    /**
     * 获取系统提示词
     * @returns {QString} 系统提示词内容
     */
    QString systemPrompt() const override;
    
    /**
     * 创建智能体实例的工厂方法
     * @returns {QSharedPointer<AgentRequestHandler>} 智能体请求处理器实例
     */
    static QSharedPointer<AgentRequestHandler> create();
    
protected:
    /**
     * 初始化聊天记录
     * @param {QJsonObject} question - 当前请求内容
     * @param {QJsonArray} history - 历史消息记录
     * @returns {QJsonArray} 初始化后的消息数组
     */
    QJsonArray initChatMessages(const QJsonObject &question, const QJsonArray &history) const override;
    
protected:
    QString m_displayName;  ///< 显示名称
    QString m_icon;         ///< 图标路径或标识
};

}
#endif // DEFAULTAGENT_H
