//
// Created by uos on 2022/3/1.
//

#include "RecoveryServiceTest.h"

TEST_F(RecoveryServiceTest, listPartition)
{
    auto partition = m_service->ListPartition();
    EXPECT_FALSE(partition.isEmpty());

}

TEST_F(RecoveryServiceTest, getRootUUID)
{
    auto rootUUID = m_service->GetRootUUID();
    EXPECT_FALSE(rootUUID.isEmpty());
}

TEST_F(RecoveryServiceTest, SetBackupDeviceUUID)
{
    auto rootUUID = m_service->GetRootUUID();
    int errCode = m_service->SetBackupDeviceUUID(rootUUID);
    EXPECT_TRUE(0 == errCode);
}

TEST_F(RecoveryServiceTest, GetBackupDeviceUUID)
{
    auto rootUUID = m_service->GetRootUUID();
    QString  backupUuid = m_service->GetBackupDeviceUUID(rootUUID);
    EXPECT_FALSE(backupUuid.isEmpty());
}

TEST_F(RecoveryServiceTest, CheckBackupDiskSpaceInDiffPartition)
{
    auto rootUUID = m_service->GetRootUUID();
    QString  backupUuid = m_service->GetBackupDeviceUUID(rootUUID);
    QString jsonString = m_service->CheckBackupDiskSpace(rootUUID, backupUuid);
    EXPECT_FALSE(jsonString.isEmpty());
}

TEST_F(RecoveryServiceTest, CheckBackupDiskSpaceInSamePartition)
{
    auto rootUUID = m_service->GetRootUUID();
    QString jsonString = m_service->CheckBackupDiskSpace(rootUUID, rootUUID);
    EXPECT_FALSE(jsonString.isEmpty());
}

TEST_F(RecoveryServiceTest, listPartition2)
{
    // 本地测试时需要先把调用者认证的代码注释掉
    auto partition = m_service->ListPartition(true);
    EXPECT_FALSE(partition.isEmpty());
}