#ifndef UOS_RECOVERY_SINGLETON_H
#define UOS_RECOVERY_SINGLETON_H

// UOS Recovery Singleton
namespace URS {

template <typename T>
class Singleton {
public:
    static T *getInstance()
    {
        static T obj;
        return &obj;
    }

protected:
    Singleton() = default;
    virtual ~Singleton() = default;

private:
    Singleton(Singleton<T> &&) = delete;
    Singleton(const Singleton<T> &) = delete;
    Singleton<T>& operator=(const Singleton<T> &) = delete;
};

} // end of URS namespace

#endif
