/* Test fromfp.
   Copyright (C) 1997-2026 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "libm-test-driver.c"

static const struct test_fiu_f_data fromfp_test_data[] =
  {
    /* Infinity, NaN and values that are definitely out of range.  */
    TEST_fiu_f (fromfp, plus_infty, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_infty, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_infty, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, qnan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -qnan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, snan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -snan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_UPWARD, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_UPWARD, MAX_EXP + 1, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_UPWARD, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_DOWNWARD, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_DOWNWARD, MAX_EXP + 1, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_DOWNWARD, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TOWARDZERO, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TOWARDZERO, MAX_EXP + 1, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_TOWARDZERO, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP + 1, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEAREST, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEAREST, MAX_EXP + 1, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, max_value, FP_INT_TONEAREST, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_UPWARD, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_UPWARD, MAX_EXP + 1, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_UPWARD, UINT_MAX, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_DOWNWARD, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_DOWNWARD, MAX_EXP + 1, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_DOWNWARD, UINT_MAX, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TOWARDZERO, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TOWARDZERO, MAX_EXP + 1, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TOWARDZERO, UINT_MAX, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP + 1, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEAREST, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEAREST, MAX_EXP + 1, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -max_value, FP_INT_TONEAREST, UINT_MAX, -max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_UPWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_DOWNWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TOWARDZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1p64, FP_INT_TONEAREST, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_UPWARD, UINT_MAX, -0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_DOWNWARD, UINT_MAX, -0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TOWARDZERO, UINT_MAX, -0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1p64, FP_INT_TONEAREST, UINT_MAX, -0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_UPWARD, UINT_MAX, -0x1.000002p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_DOWNWARD, UINT_MAX, -0x1.000002p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TOWARDZERO, UINT_MAX, -0x1.000002p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x1.000002p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p63, FP_INT_TONEAREST, UINT_MAX, -0x1.000002p63, NO_INEXACT_EXCEPTION),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_UPWARD, UINT_MAX, -0x1.0000000000001p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, UINT_MAX, -0x1.0000000000001p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, UINT_MAX, -0x1.0000000000001p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x1.0000000000001p63, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, UINT_MAX, -0x1.0000000000001p63, NO_INEXACT_EXCEPTION),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_UPWARD, UINT_MAX, -0x8000000000000001p0, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, -0x8000000000000001p0, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, -0x8000000000000001p0, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x8000000000000001p0, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000001p0, FP_INT_TONEAREST, UINT_MAX, -0x8000000000000001p0, NO_INEXACT_EXCEPTION),
#endif

    /* Zero (OK unless the width specified is zero).  */
    TEST_fiu_f (fromfp, plus_zero, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_UPWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_UPWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_UPWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, plus_zero, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_DOWNWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_DOWNWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_DOWNWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, minus_zero, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    /* Tests below here are generated with gen-fromfp-tests.py.  */

    /* Integer inputs within range of uintmax_t.  */
    TEST_fiu_f (fromfp, 1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_DOWNWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TOWARDZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_UPWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_UPWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_UPWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_UPWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TOWARDZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TOWARDZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TOWARDZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TOWARDZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_UPWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_DOWNWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TOWARDZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEARESTFROMZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEAREST, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEAREST, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEAREST, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5, FP_INT_TONEAREST, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_UPWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_UPWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_UPWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_UPWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_DOWNWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_DOWNWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_DOWNWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_DOWNWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TOWARDZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TOWARDZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TOWARDZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TOWARDZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEARESTFROMZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEARESTFROMZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEARESTFROMZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEARESTFROMZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEAREST, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEAREST, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEAREST, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5, FP_INT_TONEAREST, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_UPWARD, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_DOWNWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_DOWNWARD, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_DOWNWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_DOWNWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TOWARDZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TOWARDZERO, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TOWARDZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TOWARDZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEARESTFROMZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEARESTFROMZERO, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEARESTFROMZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEAREST, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEAREST, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEAREST, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 6, FP_INT_TONEAREST, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_UPWARD, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_UPWARD, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_UPWARD, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_UPWARD, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_DOWNWARD, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_DOWNWARD, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_DOWNWARD, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_DOWNWARD, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TOWARDZERO, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TOWARDZERO, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TOWARDZERO, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TOWARDZERO, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEARESTFROMZERO, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEARESTFROMZERO, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEARESTFROMZERO, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEARESTFROMZERO, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEAREST, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEAREST, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEAREST, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -6, FP_INT_TONEAREST, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_UPWARD, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_UPWARD, 5, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_UPWARD, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_UPWARD, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_DOWNWARD, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_DOWNWARD, 5, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_DOWNWARD, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_DOWNWARD, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TOWARDZERO, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TOWARDZERO, 5, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TOWARDZERO, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TOWARDZERO, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEARESTFROMZERO, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEARESTFROMZERO, 5, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEARESTFROMZERO, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEARESTFROMZERO, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEAREST, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEAREST, 5, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEAREST, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 7, FP_INT_TONEAREST, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_UPWARD, 4, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_UPWARD, 5, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_UPWARD, 64, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_UPWARD, UINT_MAX, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_DOWNWARD, 4, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_DOWNWARD, 5, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_DOWNWARD, 64, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_DOWNWARD, UINT_MAX, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TOWARDZERO, 4, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TOWARDZERO, 5, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TOWARDZERO, 64, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TOWARDZERO, UINT_MAX, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEARESTFROMZERO, 4, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEARESTFROMZERO, 5, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEARESTFROMZERO, 64, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEARESTFROMZERO, UINT_MAX, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEAREST, 4, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEAREST, 5, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEAREST, 64, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -7, FP_INT_TONEAREST, UINT_MAX, -7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_UPWARD, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_UPWARD, 6, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_UPWARD, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_UPWARD, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_DOWNWARD, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_DOWNWARD, 6, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_DOWNWARD, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_DOWNWARD, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TOWARDZERO, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TOWARDZERO, 6, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TOWARDZERO, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TOWARDZERO, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEARESTFROMZERO, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEARESTFROMZERO, 6, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEARESTFROMZERO, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEARESTFROMZERO, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEAREST, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEAREST, 6, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEAREST, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 8, FP_INT_TONEAREST, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_UPWARD, 4, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_UPWARD, 5, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_UPWARD, 64, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_UPWARD, UINT_MAX, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_DOWNWARD, 4, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_DOWNWARD, 5, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_DOWNWARD, 64, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_DOWNWARD, UINT_MAX, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TOWARDZERO, 4, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TOWARDZERO, 5, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TOWARDZERO, 64, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TOWARDZERO, UINT_MAX, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEARESTFROMZERO, 4, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEARESTFROMZERO, 5, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEARESTFROMZERO, 64, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEARESTFROMZERO, UINT_MAX, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEAREST, 4, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEAREST, 5, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEAREST, 64, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -8, FP_INT_TONEAREST, UINT_MAX, -8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_UPWARD, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_UPWARD, 6, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_UPWARD, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_UPWARD, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_DOWNWARD, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_DOWNWARD, 6, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_DOWNWARD, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_DOWNWARD, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TOWARDZERO, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TOWARDZERO, 6, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TOWARDZERO, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TOWARDZERO, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEARESTFROMZERO, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEARESTFROMZERO, 6, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEARESTFROMZERO, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEARESTFROMZERO, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEAREST, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEAREST, 6, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEAREST, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 9, FP_INT_TONEAREST, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_UPWARD, 5, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_UPWARD, 6, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_UPWARD, 64, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_UPWARD, UINT_MAX, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_DOWNWARD, 5, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_DOWNWARD, 6, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_DOWNWARD, 64, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_DOWNWARD, UINT_MAX, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TOWARDZERO, 5, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TOWARDZERO, 6, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TOWARDZERO, 64, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TOWARDZERO, UINT_MAX, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEARESTFROMZERO, 5, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEARESTFROMZERO, 6, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEARESTFROMZERO, 64, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEARESTFROMZERO, UINT_MAX, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEAREST, 5, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEAREST, 6, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEAREST, 64, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -9, FP_INT_TONEAREST, UINT_MAX, -9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_UPWARD, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_UPWARD, 6, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_UPWARD, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_UPWARD, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_DOWNWARD, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_DOWNWARD, 6, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_DOWNWARD, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_DOWNWARD, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TOWARDZERO, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TOWARDZERO, 6, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TOWARDZERO, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TOWARDZERO, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEARESTFROMZERO, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEARESTFROMZERO, 6, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEARESTFROMZERO, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEARESTFROMZERO, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEAREST, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEAREST, 6, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEAREST, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 15, FP_INT_TONEAREST, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_UPWARD, 5, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_UPWARD, 6, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_UPWARD, 64, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_UPWARD, UINT_MAX, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_DOWNWARD, 5, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_DOWNWARD, 6, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_DOWNWARD, 64, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_DOWNWARD, UINT_MAX, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TOWARDZERO, 5, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TOWARDZERO, 6, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TOWARDZERO, 64, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TOWARDZERO, UINT_MAX, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEARESTFROMZERO, 5, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEARESTFROMZERO, 6, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEARESTFROMZERO, 64, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEARESTFROMZERO, UINT_MAX, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEAREST, 5, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEAREST, 6, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEAREST, 64, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -15, FP_INT_TONEAREST, UINT_MAX, -15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_UPWARD, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_UPWARD, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_UPWARD, 7, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_UPWARD, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_UPWARD, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_DOWNWARD, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_DOWNWARD, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_DOWNWARD, 7, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_DOWNWARD, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_DOWNWARD, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TOWARDZERO, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TOWARDZERO, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TOWARDZERO, 7, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TOWARDZERO, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TOWARDZERO, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEARESTFROMZERO, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEARESTFROMZERO, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEARESTFROMZERO, 7, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEARESTFROMZERO, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEARESTFROMZERO, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEAREST, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEAREST, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEAREST, 7, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEAREST, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 16, FP_INT_TONEAREST, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_UPWARD, 5, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_UPWARD, 6, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_UPWARD, 64, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_UPWARD, UINT_MAX, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_DOWNWARD, 5, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_DOWNWARD, 6, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_DOWNWARD, 64, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_DOWNWARD, UINT_MAX, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TOWARDZERO, 5, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TOWARDZERO, 6, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TOWARDZERO, 64, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TOWARDZERO, UINT_MAX, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEARESTFROMZERO, 5, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEARESTFROMZERO, 6, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEARESTFROMZERO, 64, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEARESTFROMZERO, UINT_MAX, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEAREST, 5, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEAREST, 6, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEAREST, 64, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -16, FP_INT_TONEAREST, UINT_MAX, -16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_UPWARD, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_UPWARD, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_UPWARD, 7, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_UPWARD, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_UPWARD, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_DOWNWARD, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_DOWNWARD, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_DOWNWARD, 7, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_DOWNWARD, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_DOWNWARD, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TOWARDZERO, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TOWARDZERO, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TOWARDZERO, 7, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TOWARDZERO, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TOWARDZERO, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEARESTFROMZERO, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEARESTFROMZERO, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEARESTFROMZERO, 7, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEARESTFROMZERO, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEARESTFROMZERO, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEAREST, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEAREST, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEAREST, 7, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEAREST, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 17, FP_INT_TONEAREST, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_UPWARD, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_UPWARD, 6, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_UPWARD, 7, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_UPWARD, 64, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_UPWARD, UINT_MAX, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_DOWNWARD, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_DOWNWARD, 6, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_DOWNWARD, 7, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_DOWNWARD, 64, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_DOWNWARD, UINT_MAX, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TOWARDZERO, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TOWARDZERO, 6, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TOWARDZERO, 7, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TOWARDZERO, 64, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TOWARDZERO, UINT_MAX, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEARESTFROMZERO, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEARESTFROMZERO, 6, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEARESTFROMZERO, 7, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEARESTFROMZERO, 64, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEARESTFROMZERO, UINT_MAX, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEAREST, 5, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEAREST, 6, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEAREST, 7, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEAREST, 64, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -17, FP_INT_TONEAREST, UINT_MAX, -17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_UPWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_UPWARD, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_UPWARD, 24, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_UPWARD, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_UPWARD, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_DOWNWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_DOWNWARD, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_DOWNWARD, 24, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_DOWNWARD, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_DOWNWARD, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TOWARDZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TOWARDZERO, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TOWARDZERO, 24, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TOWARDZERO, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 24, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEAREST, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEAREST, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEAREST, 24, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEAREST, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffff, FP_INT_TONEAREST, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_UPWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_UPWARD, 23, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_UPWARD, 24, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_UPWARD, 64, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_UPWARD, UINT_MAX, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_DOWNWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_DOWNWARD, 23, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_DOWNWARD, 24, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_DOWNWARD, 64, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_DOWNWARD, UINT_MAX, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TOWARDZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TOWARDZERO, 23, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TOWARDZERO, 24, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TOWARDZERO, 64, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TOWARDZERO, UINT_MAX, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEARESTFROMZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEARESTFROMZERO, 23, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEARESTFROMZERO, 24, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEARESTFROMZERO, 64, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEAREST, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEAREST, 23, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEAREST, 24, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEAREST, 64, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffff, FP_INT_TONEAREST, UINT_MAX, -0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_UPWARD, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_UPWARD, 25, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_UPWARD, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_UPWARD, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_DOWNWARD, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_DOWNWARD, 25, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_DOWNWARD, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_DOWNWARD, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TOWARDZERO, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TOWARDZERO, 25, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TOWARDZERO, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TOWARDZERO, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 25, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEAREST, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEAREST, 25, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEAREST, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400000, FP_INT_TONEAREST, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_UPWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_UPWARD, 23, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_UPWARD, 24, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_UPWARD, 64, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_UPWARD, UINT_MAX, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_DOWNWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_DOWNWARD, 23, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_DOWNWARD, 24, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_DOWNWARD, 64, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_DOWNWARD, UINT_MAX, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TOWARDZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TOWARDZERO, 23, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TOWARDZERO, 24, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TOWARDZERO, 64, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TOWARDZERO, UINT_MAX, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEARESTFROMZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEARESTFROMZERO, 23, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEARESTFROMZERO, 24, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEARESTFROMZERO, 64, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEAREST, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEAREST, 23, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEAREST, 24, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEAREST, 64, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400000, FP_INT_TONEAREST, UINT_MAX, -0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_UPWARD, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_UPWARD, 25, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_UPWARD, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_UPWARD, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_DOWNWARD, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_DOWNWARD, 25, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_DOWNWARD, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_DOWNWARD, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TOWARDZERO, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TOWARDZERO, 25, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TOWARDZERO, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TOWARDZERO, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 25, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEAREST, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEAREST, 25, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEAREST, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x400001, FP_INT_TONEAREST, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_UPWARD, 24, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_UPWARD, 25, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_UPWARD, 64, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_UPWARD, UINT_MAX, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_DOWNWARD, 24, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_DOWNWARD, 25, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_DOWNWARD, 64, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_DOWNWARD, UINT_MAX, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TOWARDZERO, 24, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TOWARDZERO, 25, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TOWARDZERO, 64, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TOWARDZERO, UINT_MAX, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEARESTFROMZERO, 24, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEARESTFROMZERO, 25, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEARESTFROMZERO, 64, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEAREST, 24, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEAREST, 25, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEAREST, 64, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x400001, FP_INT_TONEAREST, UINT_MAX, -0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_UPWARD, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_UPWARD, 25, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_UPWARD, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_UPWARD, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_DOWNWARD, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_DOWNWARD, 25, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_DOWNWARD, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_DOWNWARD, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TOWARDZERO, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TOWARDZERO, 25, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TOWARDZERO, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 25, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEAREST, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEAREST, 25, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEAREST, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff, FP_INT_TONEAREST, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_UPWARD, 24, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_UPWARD, 25, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_UPWARD, 64, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_UPWARD, UINT_MAX, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_DOWNWARD, 24, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_DOWNWARD, 25, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_DOWNWARD, 64, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_DOWNWARD, UINT_MAX, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TOWARDZERO, 24, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TOWARDZERO, 25, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TOWARDZERO, 64, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TOWARDZERO, UINT_MAX, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEARESTFROMZERO, 24, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEARESTFROMZERO, 25, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEARESTFROMZERO, 64, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEAREST, 24, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEAREST, 25, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEAREST, 64, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff, FP_INT_TONEAREST, UINT_MAX, -0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_UPWARD, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_UPWARD, 26, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_UPWARD, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_UPWARD, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_DOWNWARD, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_DOWNWARD, 26, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_DOWNWARD, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_DOWNWARD, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TOWARDZERO, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TOWARDZERO, 26, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TOWARDZERO, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TOWARDZERO, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 26, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEAREST, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEAREST, 26, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEAREST, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800000, FP_INT_TONEAREST, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_UPWARD, 24, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_UPWARD, 25, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_UPWARD, 64, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_UPWARD, UINT_MAX, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_DOWNWARD, 24, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_DOWNWARD, 25, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_DOWNWARD, 64, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_DOWNWARD, UINT_MAX, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TOWARDZERO, 24, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TOWARDZERO, 25, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TOWARDZERO, 64, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TOWARDZERO, UINT_MAX, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEARESTFROMZERO, 24, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEARESTFROMZERO, 25, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEARESTFROMZERO, 64, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEAREST, 24, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEAREST, 25, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEAREST, 64, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800000, FP_INT_TONEAREST, UINT_MAX, -0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_UPWARD, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_UPWARD, 26, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_UPWARD, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_UPWARD, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_DOWNWARD, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_DOWNWARD, 26, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_DOWNWARD, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_DOWNWARD, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TOWARDZERO, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TOWARDZERO, 26, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TOWARDZERO, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TOWARDZERO, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 26, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEAREST, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEAREST, 26, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEAREST, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x800001, FP_INT_TONEAREST, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_UPWARD, 25, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_UPWARD, 26, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_UPWARD, 64, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_UPWARD, UINT_MAX, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_DOWNWARD, 25, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_DOWNWARD, 26, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_DOWNWARD, 64, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_DOWNWARD, UINT_MAX, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TOWARDZERO, 25, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TOWARDZERO, 26, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TOWARDZERO, 64, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TOWARDZERO, UINT_MAX, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEARESTFROMZERO, 25, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEARESTFROMZERO, 26, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEARESTFROMZERO, 64, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEAREST, 25, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEAREST, 26, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEAREST, 64, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x800001, FP_INT_TONEAREST, UINT_MAX, -0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_UPWARD, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_UPWARD, 26, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_UPWARD, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_UPWARD, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_DOWNWARD, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_DOWNWARD, 26, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_DOWNWARD, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_DOWNWARD, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TOWARDZERO, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TOWARDZERO, 26, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TOWARDZERO, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TOWARDZERO, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 26, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEAREST, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEAREST, 26, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEAREST, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff, FP_INT_TONEAREST, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_UPWARD, 25, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_UPWARD, 26, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_UPWARD, 64, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_UPWARD, UINT_MAX, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_DOWNWARD, 25, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_DOWNWARD, 26, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_DOWNWARD, 64, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_DOWNWARD, UINT_MAX, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TOWARDZERO, 25, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TOWARDZERO, 26, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TOWARDZERO, 64, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TOWARDZERO, UINT_MAX, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEARESTFROMZERO, 25, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEARESTFROMZERO, 26, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEARESTFROMZERO, 64, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEAREST, 25, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEAREST, 26, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEAREST, 64, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xffffff, FP_INT_TONEAREST, UINT_MAX, -0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_UPWARD, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_UPWARD, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_UPWARD, 27, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_UPWARD, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_UPWARD, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_DOWNWARD, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_DOWNWARD, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_DOWNWARD, 27, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_DOWNWARD, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_DOWNWARD, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TOWARDZERO, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TOWARDZERO, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TOWARDZERO, 27, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TOWARDZERO, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TOWARDZERO, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 27, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEAREST, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEAREST, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEAREST, 27, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEAREST, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000000, FP_INT_TONEAREST, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_UPWARD, 25, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_UPWARD, 26, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_UPWARD, 64, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_UPWARD, UINT_MAX, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_DOWNWARD, 25, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_DOWNWARD, 26, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_DOWNWARD, 64, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_DOWNWARD, UINT_MAX, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TOWARDZERO, 25, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TOWARDZERO, 26, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TOWARDZERO, 64, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TOWARDZERO, UINT_MAX, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEARESTFROMZERO, 25, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEARESTFROMZERO, 26, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEARESTFROMZERO, 64, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEAREST, 25, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEAREST, 26, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEAREST, 64, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000000, FP_INT_TONEAREST, UINT_MAX, -0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_UPWARD, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_UPWARD, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_UPWARD, 27, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_UPWARD, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_UPWARD, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_DOWNWARD, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_DOWNWARD, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_DOWNWARD, 27, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_DOWNWARD, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_DOWNWARD, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TOWARDZERO, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TOWARDZERO, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TOWARDZERO, 27, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TOWARDZERO, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TOWARDZERO, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 27, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEAREST, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEAREST, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEAREST, 27, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEAREST, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1000001, FP_INT_TONEAREST, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_UPWARD, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_UPWARD, 26, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_UPWARD, 27, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_UPWARD, 64, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_UPWARD, UINT_MAX, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_DOWNWARD, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_DOWNWARD, 26, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_DOWNWARD, 27, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_DOWNWARD, 64, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_DOWNWARD, UINT_MAX, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TOWARDZERO, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TOWARDZERO, 26, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TOWARDZERO, 27, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TOWARDZERO, 64, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TOWARDZERO, UINT_MAX, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEARESTFROMZERO, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEARESTFROMZERO, 26, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEARESTFROMZERO, 27, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEARESTFROMZERO, 64, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEAREST, 25, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEAREST, 26, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEAREST, 27, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEAREST, 64, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1000001, FP_INT_TONEAREST, UINT_MAX, -0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 53, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 53, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 53, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 53, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_UPWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_UPWARD, 52, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_UPWARD, 53, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_UPWARD, 64, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_UPWARD, UINT_MAX, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_DOWNWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_DOWNWARD, 52, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_DOWNWARD, 53, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_DOWNWARD, 64, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TOWARDZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TOWARDZERO, 52, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TOWARDZERO, 53, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TOWARDZERO, 64, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEAREST, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEAREST, 52, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEAREST, 53, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEAREST, 64, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, -0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_UPWARD, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_UPWARD, 54, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_UPWARD, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 54, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 54, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 54, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEAREST, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEAREST, 54, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEAREST, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_UPWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_UPWARD, 52, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_UPWARD, 53, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_UPWARD, 64, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_UPWARD, UINT_MAX, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_DOWNWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_DOWNWARD, 52, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_DOWNWARD, 53, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_DOWNWARD, 64, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_DOWNWARD, UINT_MAX, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TOWARDZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TOWARDZERO, 52, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TOWARDZERO, 53, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TOWARDZERO, 64, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 52, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 53, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 64, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEAREST, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEAREST, 52, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEAREST, 53, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEAREST, 64, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000000LL, FP_INT_TONEAREST, UINT_MAX, -0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_UPWARD, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_UPWARD, 54, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_UPWARD, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 54, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 54, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 54, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEAREST, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEAREST, 54, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEAREST, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_UPWARD, 53, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_UPWARD, 54, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_UPWARD, 64, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_UPWARD, UINT_MAX, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_DOWNWARD, 53, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_DOWNWARD, 54, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_DOWNWARD, 64, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_DOWNWARD, UINT_MAX, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TOWARDZERO, 53, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TOWARDZERO, 54, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TOWARDZERO, 64, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 53, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 54, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 64, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEAREST, 53, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEAREST, 54, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEAREST, 64, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x8000000000001LL, FP_INT_TONEAREST, UINT_MAX, -0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 54, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 54, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 54, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 54, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 54, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_UPWARD, 53, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_UPWARD, 54, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_UPWARD, 64, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_UPWARD, UINT_MAX, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_DOWNWARD, 53, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_DOWNWARD, 54, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_DOWNWARD, 64, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TOWARDZERO, 53, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TOWARDZERO, 54, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TOWARDZERO, 64, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 54, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEAREST, 53, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEAREST, 54, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEAREST, 64, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0xfffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, -0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_UPWARD, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_UPWARD, 55, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_UPWARD, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 55, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 55, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 55, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEAREST, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEAREST, 55, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEAREST, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_UPWARD, 53, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_UPWARD, 54, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_UPWARD, 64, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_UPWARD, UINT_MAX, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_DOWNWARD, 53, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_DOWNWARD, 54, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_DOWNWARD, 64, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_DOWNWARD, UINT_MAX, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TOWARDZERO, 53, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TOWARDZERO, 54, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TOWARDZERO, 64, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 53, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 54, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 64, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEAREST, 53, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEAREST, 54, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEAREST, 64, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000000LL, FP_INT_TONEAREST, UINT_MAX, -0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_UPWARD, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_UPWARD, 55, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_UPWARD, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 55, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 55, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 55, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEAREST, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEAREST, 55, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEAREST, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x10000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_UPWARD, 54, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_UPWARD, 55, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_UPWARD, 64, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_UPWARD, UINT_MAX, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_DOWNWARD, 54, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_DOWNWARD, 55, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_DOWNWARD, 64, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_DOWNWARD, UINT_MAX, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TOWARDZERO, 54, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TOWARDZERO, 55, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TOWARDZERO, 64, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 54, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 55, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 64, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEAREST, 54, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEAREST, 55, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEAREST, 64, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x10000000000001LL, FP_INT_TONEAREST, UINT_MAX, -0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 55, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 55, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 55, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 55, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 55, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_UPWARD, 54, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_UPWARD, 55, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_UPWARD, 64, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_UPWARD, UINT_MAX, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_DOWNWARD, 54, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_DOWNWARD, 55, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_DOWNWARD, 64, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TOWARDZERO, 54, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TOWARDZERO, 55, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TOWARDZERO, 64, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 54, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 55, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEAREST, 54, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEAREST, 55, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEAREST, 64, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1fffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, -0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_UPWARD, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_UPWARD, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_UPWARD, 56, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_UPWARD, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 56, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 56, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 56, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEAREST, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEAREST, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEAREST, 56, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEAREST, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_UPWARD, 54, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_UPWARD, 55, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_UPWARD, 64, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_UPWARD, UINT_MAX, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_DOWNWARD, 54, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_DOWNWARD, 55, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_DOWNWARD, 64, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_DOWNWARD, UINT_MAX, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TOWARDZERO, 54, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TOWARDZERO, 55, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TOWARDZERO, 64, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 54, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 55, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 64, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEAREST, 54, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEAREST, 55, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEAREST, 64, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000000LL, FP_INT_TONEAREST, UINT_MAX, -0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_UPWARD, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_UPWARD, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_UPWARD, 56, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_UPWARD, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 56, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 56, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 56, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEAREST, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEAREST, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEAREST, 56, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEAREST, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x20000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_UPWARD, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_UPWARD, 55, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_UPWARD, 56, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_UPWARD, 64, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_UPWARD, UINT_MAX, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_DOWNWARD, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_DOWNWARD, 55, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_DOWNWARD, 56, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_DOWNWARD, 64, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_DOWNWARD, UINT_MAX, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TOWARDZERO, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TOWARDZERO, 55, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TOWARDZERO, 56, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TOWARDZERO, 64, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 55, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 56, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 64, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEAREST, 54, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEAREST, 55, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEAREST, 56, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEAREST, 64, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x20000000000001LL, FP_INT_TONEAREST, UINT_MAX, -0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_UPWARD, 63, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_UPWARD, 64, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_DOWNWARD, 63, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_DOWNWARD, 64, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 63, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 64, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEAREST, 63, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEAREST, 64, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, -0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_UPWARD, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_UPWARD, 65, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 65, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 65, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 65, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 65, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_UPWARD, 63, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_UPWARD, 64, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_UPWARD, UINT_MAX, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_DOWNWARD, 63, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_DOWNWARD, 64, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_DOWNWARD, UINT_MAX, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TOWARDZERO, 63, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TOWARDZERO, 64, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 63, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 64, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEAREST, 63, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEAREST, 64, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000000LL, FP_INT_TONEAREST, UINT_MAX, -0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_UPWARD, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_UPWARD, 65, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 65, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 65, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 65, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 65, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4000000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_UPWARD, 64, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_UPWARD, 65, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_UPWARD, UINT_MAX, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_DOWNWARD, 64, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_DOWNWARD, 65, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_DOWNWARD, UINT_MAX, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TOWARDZERO, 64, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TOWARDZERO, 65, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 64, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 65, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEAREST, 64, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEAREST, 65, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4000000000000001LL, FP_INT_TONEAREST, UINT_MAX, -0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 65, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 65, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 65, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 65, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 65, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_UPWARD, 64, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_UPWARD, 65, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_DOWNWARD, 64, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_DOWNWARD, 65, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 64, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 65, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 65, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEAREST, 64, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEAREST, 65, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, -0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 66, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 66, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 66, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 66, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 66, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_UPWARD, 64, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_UPWARD, 65, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_UPWARD, UINT_MAX, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_DOWNWARD, 64, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_DOWNWARD, 65, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_DOWNWARD, UINT_MAX, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TOWARDZERO, 64, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TOWARDZERO, 65, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TOWARDZERO, UINT_MAX, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEARESTFROMZERO, 64, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEARESTFROMZERO, 65, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEAREST, 64, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEAREST, 65, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -INT64_MAX-1, FP_INT_TONEAREST, UINT_MAX, -INT64_MAX-1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 66, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 66, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 66, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 66, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 66, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 66, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 66, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 66, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 66, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 66, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 65, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 65, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 65, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 65, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 65, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_UPWARD, 64, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_UPWARD, 65, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_UPWARD, UINT_MAX, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_DOWNWARD, 64, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_DOWNWARD, 65, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_DOWNWARD, UINT_MAX, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TOWARDZERO, 64, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TOWARDZERO, 65, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TOWARDZERO, UINT_MAX, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 64, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 65, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEAREST, 64, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEAREST, 65, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7fffff8000000000LL, FP_INT_TONEAREST, UINT_MAX, -0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 66, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_UPWARD, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 66, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 66, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 66, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 66, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 66, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 66, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 66, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 66, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 66, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 65, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 65, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 65, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 65, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 65, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_UPWARD, 64, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_UPWARD, 65, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_UPWARD, UINT_MAX, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 64, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 65, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_DOWNWARD, UINT_MAX, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 64, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 65, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, UINT_MAX, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 64, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 65, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEAREST, 64, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEAREST, 65, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7ffffffffffffc00LL, FP_INT_TONEAREST, UINT_MAX, -0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 66, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 66, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 66, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 66, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 66, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 66, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 66, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 66, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 66, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 66, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Inputs with absolute value between 0 and 1.  */
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_subnorm_value, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_subnorm_value, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_value, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_value, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_value, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, min_value, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_value, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_value, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -min_value, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.25, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.25, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.25, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.25, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.25, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.25, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.499, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.499, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.499, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.499, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.499, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.499, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.499, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.5, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.5, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.5, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.5, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.5, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.5, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (fromfp, 0.501, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.501, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.501, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.501, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.501, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.75, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.75, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.75, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.75, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0.9, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.9, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.9, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0.9, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Various non-integer inputs.  */
    TEST_fiu_f (fromfp, 1.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.25, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.25, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.25, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.25, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.5, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.5, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 1.75, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -1.75, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.25, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.25, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.5, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.5, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 2.75, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -2.75, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.25, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.25, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.5, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.5, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 3.75, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -3.75, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_UPWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_DOWNWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TOWARDZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.25, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_UPWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_UPWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_UPWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_UPWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_DOWNWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_DOWNWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_DOWNWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_DOWNWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TOWARDZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TOWARDZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TOWARDZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TOWARDZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.25, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_UPWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_DOWNWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TOWARDZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEARESTFROMZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.5, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_UPWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_UPWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_UPWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_UPWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_DOWNWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_DOWNWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_DOWNWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_DOWNWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TOWARDZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TOWARDZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TOWARDZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TOWARDZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEARESTFROMZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEARESTFROMZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEARESTFROMZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.5, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_UPWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_DOWNWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TOWARDZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEARESTFROMZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEAREST, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEAREST, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEAREST, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 4.75, FP_INT_TONEAREST, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_UPWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_UPWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_UPWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_UPWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_DOWNWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_DOWNWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_DOWNWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_DOWNWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TOWARDZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TOWARDZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TOWARDZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TOWARDZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEARESTFROMZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEARESTFROMZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEARESTFROMZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEAREST, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEAREST, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEAREST, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -4.75, FP_INT_TONEAREST, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_UPWARD, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_DOWNWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TOWARDZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEARESTFROMZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEAREST, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEAREST, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEAREST, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.25, FP_INT_TONEAREST, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_UPWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_UPWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_UPWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_UPWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_DOWNWARD, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_DOWNWARD, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_DOWNWARD, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_DOWNWARD, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TOWARDZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TOWARDZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TOWARDZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TOWARDZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEARESTFROMZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEARESTFROMZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEARESTFROMZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEAREST, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEAREST, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEAREST, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.25, FP_INT_TONEAREST, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_UPWARD, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_DOWNWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TOWARDZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEARESTFROMZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEARESTFROMZERO, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEARESTFROMZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEAREST, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEAREST, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEAREST, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.5, FP_INT_TONEAREST, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_UPWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_UPWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_UPWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_UPWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_DOWNWARD, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_DOWNWARD, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_DOWNWARD, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_DOWNWARD, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TOWARDZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TOWARDZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TOWARDZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TOWARDZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEARESTFROMZERO, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEARESTFROMZERO, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEARESTFROMZERO, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEAREST, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEAREST, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEAREST, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.5, FP_INT_TONEAREST, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_UPWARD, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_DOWNWARD, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TOWARDZERO, 5, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEARESTFROMZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEARESTFROMZERO, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEARESTFROMZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEAREST, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEAREST, 5, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEAREST, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 5.75, FP_INT_TONEAREST, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_UPWARD, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_UPWARD, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_UPWARD, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_UPWARD, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_DOWNWARD, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_DOWNWARD, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_DOWNWARD, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_DOWNWARD, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TOWARDZERO, 4, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TOWARDZERO, 5, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TOWARDZERO, 64, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TOWARDZERO, UINT_MAX, -5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEARESTFROMZERO, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEARESTFROMZERO, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEARESTFROMZERO, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEAREST, 4, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEAREST, 5, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEAREST, 64, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -5.75, FP_INT_TONEAREST, UINT_MAX, -6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    /* 1, 1.5, 2, 2.5, 3, 3.5 +/- 1ulp.  */
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffp1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffp1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000002p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000002p1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.000008p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.000008p-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffcp0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffcp0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.000004p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.000004p0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.000008p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.000008p-1, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.fffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000001p1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffep0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000002p0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffp1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000002p1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000004p0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.000000000000000000000000008p1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.00000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 5, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 4, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, -4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 3, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 1, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 2, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 64, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, -1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 4, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_UPWARD, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 3, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 4, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 64, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, UINT_MAX, -3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 2, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 3, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 64, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, -0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, UINT_MAX, -2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 4, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (fromfp, 0