//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class encapsulates a request to the pim storage service,
    ///  the code looks like
    ///  @code
    ///   Akonadi.Job job = new Akonadi.SomeJob( some parameter );
    ///   connect( job, SIGNAL("result( KJob )"),
    ///            this, SLOT("slotResult( KJob )") );
    ///  @endcode
    ///  The job is queued for execution as soon as the event loop is entered
    ///  again.
    ///  And the slotResult is usually at least:
    ///  @code
    ///   if ( job.Error() ) {
    ///     // handle error...
    ///   }
    ///  @endcode
    ///  With the synchronous interface the code looks like
    ///  @code
    ///    Akonadi.SomeJob job = new Akonadi.SomeJob( some parameter );
    ///    if ( !job.Exec() ) {
    ///      qDebug() << "Error:" << job.ErrorString();
    ///    } else {
    ///      // do something
    ///    }
    ///  @endcode
    ///  @warning Using the synchronous method is error prone, use this only
    ///           if the asynchronous access is not possible and none of the following
    ///           known issues apply:
    ///           - exec() must not be called directly from a result slot of another
    ///             job in the same Session. This will trigger a dead-lock since the
    ///             program won't return from the result slot and thus will never complete
    ///             the finishing of the current job, keeping it in the internal queue
    ///             and blocking the execution of any following job.
    ///           - exec() must not be called from within another event-loop that might
    ///             finish before the newly started inner sub-eventloop. This will crash!
    ///  Subclasses must reimplement doStart().
    ///  @note KJob-derived objects delete itself, it is thus not possible
    ///  to create job objects on the stack!
    ///  See <see cref="IJobSignals"></see> for signals emitted by Job
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>, Tobias Koenig <tokoe@kde.org>, Marc Mutz <mutz@kde.org>
    ///  </author>
    ///         <short> Base class for all actions in the Akonadi storage. </short>
    [SmokeClass("Akonadi::Job")]
    public abstract class Job : KCompositeJob {
        protected Job(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Job), this);
        }
        /// <remarks>
        ///  Describes the error codes that can be emitted by this class.
        ///  Subclasses can provide additional codes, starting from UserError
        ///  onwards
        ///      </remarks>        <short>    Describes the error codes that can be emitted by this class.</short>
        public enum Error {
            ConnectionFailed = UserDefinedError,
            ProtocolVersionMismatch = 0,
            UserCanceled = 1,
            Unknown = 2,
            UserError = UserDefinedError+42,
        }
        // Akonadi::Job* Job(Akonadi::JobPrivate* arg1,QObject* arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  Creates a new job.
        ///  If the parent object is a Job object, the new job will be a subjob of <code>parent.</code>
        ///  If the parent object is a Session object, it will be used for server communication
        ///  instead of the default session.
        /// <param> name="parent" The parent object, job or session.
        ///      </param></remarks>        <short>    Creates a new job.</short>
        public Job(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Job#", "Job(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public Job() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Job", "Job()", typeof(void));
        }
        /// <remarks>
        ///  Jobs are started automatically once entering the event loop again, no need
        ///  to explicitly call this.
        ///      </remarks>        <short>    Jobs are started automatically once entering the event loop again, no need  to explicitly call this.</short>
        [SmokeMethod("start()")]
        public override void Start() {
            interceptor.Invoke("start", "start()", typeof(void));
        }
        /// <remarks>
        ///  Returns the error string, if there has been an error, an empty
        ///  string otherwise.
        ///      </remarks>        <short>    Returns the error string, if there has been an error, an empty  string otherwise.</short>
        [SmokeMethod("errorString() const")]
        public override string ErrorString() {
            return (string) interceptor.Invoke("errorString", "errorString() const", typeof(string));
        }
        /// <remarks>
        ///  This method must be reimplemented in the concrete jobs. It will be called
        ///  after the job has been started and a connection to the Akonadi backend has
        ///  been established.
        ///      </remarks>        <short>    This method must be reimplemented in the concrete jobs.</short>
        [SmokeMethod("doStart()")]
        protected abstract void DoStart();
        /// <remarks>
        ///  This method should be reimplemented in the concrete jobs in case you want
        ///  to handle incoming data. It will be called on received data from the backend.
        ///  The default implementation does nothing.
        /// <param> name="tag" The tag of the corresponding command, empty if this is an untagged response.
        /// </param><param> name="data" The received data.
        ///      </param></remarks>        <short>    This method should be reimplemented in the concrete jobs in case you want  to handle incoming data.</short>
        [SmokeMethod("doHandleResponse(const QByteArray&, const QByteArray&)")]
        protected virtual void DoHandleResponse(QByteArray tag, QByteArray data) {
            interceptor.Invoke("doHandleResponse##", "doHandleResponse(const QByteArray&, const QByteArray&)", typeof(void), typeof(QByteArray), tag, typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Adds the given job as a subjob to this job. This method is automatically called
        ///  if you construct a job using another job as parent object.
        ///  The base implementation does the necessary setup to share the network connection
        ///  with the backend.
        /// <param> name="job" The new subjob.
        ///      </param></remarks>        <short>    Adds the given job as a subjob to this job.</short>
        [SmokeMethod("addSubjob(KJob*)")]
        protected override bool AddSubjob(KJob job) {
            return (bool) interceptor.Invoke("addSubjob#", "addSubjob(KJob*)", typeof(bool), typeof(KJob), job);
        }
        /// <remarks>
        ///  Removes the given subjob of this job.
        /// <param> name="job" The subjob to remove.
        ///      </param></remarks>        <short>    Removes the given subjob of this job.</short>
        [SmokeMethod("removeSubjob(KJob*)")]
        protected override bool RemoveSubjob(KJob job) {
            return (bool) interceptor.Invoke("removeSubjob#", "removeSubjob(KJob*)", typeof(bool), typeof(KJob), job);
        }
        /// <remarks>
        ///  Kills the execution of the job.
        ///      </remarks>        <short>    Kills the execution of the job.</short>
        [SmokeMethod("doKill()")]
        protected override bool DoKill() {
            return (bool) interceptor.Invoke("doKill", "doKill()", typeof(bool));
        }
        /// <remarks>
        ///  Call this method to indicate that this job will not call writeData() again.
        /// </remarks>        <short>    Call this method to indicate that this job will not call writeData() again.</short>
        ///         <see> writeFinished</see>
        protected void EmitWriteFinished() {
            interceptor.Invoke("emitWriteFinished", "emitWriteFinished()", typeof(void));
        }
        [Q_SLOT("void slotResult(KJob*)")]
        [SmokeMethod("slotResult(KJob*)")]
        protected override void SlotResult(KJob job) {
            interceptor.Invoke("slotResult#", "slotResult(KJob*)", typeof(void), typeof(KJob), job);
        }
        protected new IJobSignals Emit {
            get { return (IJobSignals) Q_EMIT; }
        }
    }

    public interface IJobSignals : IKCompositeJobSignals {
        /// <remarks>
        ///  This signal is emitted directly before the job will be started.
        /// <param> name="job" The started job.
        ///      </param></remarks>        <short>    This signal is emitted directly before the job will be started.</short>
        [Q_SIGNAL("void aboutToStart(Akonadi::Job*)")]
        void AboutToStart(Akonadi.Job job);
        /// <remarks>
        ///  This signal is emitted if the job has finished all write operations, ie.
        ///  if this signal is emitted, the job guarantees to not call writeData() again.
        ///  Do not emit this signal directly, call emitWriteFinished() instead.
        /// <param> name="job" This job.
        /// </param></remarks>        <short>    This signal is emitted if the job has finished all write operations, ie.</short>
        ///         <see> emitWriteFinished</see>
        [Q_SIGNAL("void writeFinished(Akonadi::Job*)")]
        void WriteFinished(Akonadi.Job job);
    }
}
