//Auto-generated by kalyptus. DO NOT EDIT.
namespace Phonon {
    using Phonon;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks> \class MediaObject mediaobject.h Phonon/MediaObject
    ///  \short Interface for media playback of a given URL.
    ///  This class is the most important class in %Phonon. Use it to open a media
    ///  file at an arbitrary location, a CD or DVD or to stream media data from
    ///  the application to the backend.
    ///  This class controls the state (play, pause, stop, seek)
    ///  and you can use it to get a lot of information about the media data.
    ///  Notice that most functions of this class are asynchronous.
    ///  That means if you call play() the object only starts playing when the
    ///  stateChanged() signal tells you that the object changed into PlayingState.
    ///  The states you can expect are documented for those methods.
    ///  A common usage example is the following:
    ///  <pre>
    ///  media = new MediaObject(this);
    ///  connect(media, SIGNAL("finished()"), SLOT("slotFinished()");
    ///  media.SetCurrentSource("/home/username/music/filename.ogg");
    ///  media.Play();
    ///  </pre>
    ///  If you want to play more that one media file (one after another) you can
    ///  either tell MediaObject about all those files
    ///  <pre>
    ///  media.SetCurrentSource(":/sounds/startsound.ogg");
    ///  media.Enqueue("/home/username/music/song.mp3");
    ///  media.Enqueue(":/sounds/endsound.ogg");
    ///  </pre>
    ///  or provide the next file just in time:
    ///  <pre>
    ///    media.SetCurrentSource(":/sounds/startsound.ogg");
    ///    connect(media, SIGNAL("aboutToFinish()"), SLOT("enqueueNextSource()"));
    ///  }
    ///  void enqueueNextSource()
    ///  {
    ///    media.Enqueue("/home/username/music/song.mp3");
    ///  }
    ///  </pre>
    ///  \ingroup Playback
    ///  \ingroup Recording
    ///  \author Matthias Kretz <kretz@kde.org>
    ///       See <see cref="IMediaObjectSignals"></see> for signals emitted by MediaObject
    /// </remarks>        <short>   \class MediaObject mediaobject.</short>
    [SmokeClass("Phonon::MediaObject")]
    public class MediaObject : QObject, Phonon.IMediaNode, IDisposable {
        protected MediaObject(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(MediaObject), this);
        }
        [Q_PROPERTY("int", "transitionTime")]
        public int TransitionTime {
            get { return (int) interceptor.Invoke("transitionTime", "transitionTime()", typeof(int)); }
            set { interceptor.Invoke("setTransitionTime$", "setTransitionTime(int)", typeof(void), typeof(int), value); }
        }
        [Q_PROPERTY("int", "prefinishMark")]
        public int PrefinishMark {
            get { return (int) interceptor.Invoke("prefinishMark", "prefinishMark()", typeof(int)); }
            set { interceptor.Invoke("setPrefinishMark$", "setPrefinishMark(int)", typeof(void), typeof(int), value); }
        }
        [Q_PROPERTY("int", "tickInterval")]
        public int TickInterval {
            get { return (int) interceptor.Invoke("tickInterval", "tickInterval()", typeof(int)); }
            set { interceptor.Invoke("setTickInterval$", "setTickInterval(int)", typeof(void), typeof(int), value); }
        }
        // QMultiMap<QString, QString> metaData(); >>>> NOT CONVERTED
        // Phonon::MediaNode* MediaNode(Phonon::MediaNodePrivate& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Get the current state.
        /// </remarks>        <return> The state of the object.
        /// </return>
        ///         <short>    Get the current state.</short>
        ///         <see> State</see>
        ///         <see> \see</see>
        ///         <see> stateChanged</see>
        public Phonon.State state() {
            return (Phonon.State) interceptor.Invoke("state", "state() const", typeof(Phonon.State));
        }
        /// <remarks>
        ///  Check whether the media data includes a video stream.
        ///  \warning This information cannot be known immediately. It is best
        ///  to also listen to the hasVideoChanged signal.
        ///  <pre>
        ///    connect(media, SIGNAL("hasVideoChanged(bool)"), hasVideoChanged(bool));
        ///    media.SetCurrentSource("somevideo.avi");
        ///    media.HasVideo(); // returns false;
        ///  }
        ///  void hasVideoChanged(bool b)
        ///  {
        ///    // b == true
        ///    media.HasVideo(); // returns true;
        ///  }
        ///  </pre>
        ///  \return <code>true</code> if the media contains video data. <code>false</code>
        ///  otherwise.
        ///  \see hasVideoChanged
        ///              </remarks>        <short>    Check whether the media data includes a video stream.</short>
        public bool HasVideo() {
            return (bool) interceptor.Invoke("hasVideo", "hasVideo() const", typeof(bool));
        }
        /// <remarks>
        ///  Check whether the current media may be seeked.
        ///  \warning This information cannot be known immediately. It is best
        ///  to also listen to the hasVideoChanged signal.
        ///  <pre>
        ///    connect(media, SIGNAL("hasVideoChanged(bool)"), hasVideoChanged(bool));
        ///    media.SetCurrentSource("somevideo.avi");
        ///    media.HasVideo(); // returns false;
        ///  }
        ///  void hasVideoChanged(bool b)
        ///  {
        ///    // b == true
        ///    media.HasVideo(); // returns true;
        ///  }
        ///  </pre>
        ///  \return <code>true</code> when the current media may be seeked. <code>false</code>
        ///  otherwise.
        ///  \see seekableChanged()
        ///              </remarks>        <short>    Check whether the current media may be seeked.</short>
        public bool IsSeekable() {
            return (bool) interceptor.Invoke("isSeekable", "isSeekable() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the strings associated with the given <pre>key</pre>.
        ///  Backends should use the keys specified in the Ogg Vorbis
        ///  documentation: http://xiph.org/vorbis/doc/v-comment.html
        ///  Therefore the following should work with every backend:
        ///  A typical usage looks like this:
        ///  <pre>
        ///  setMetaArtist (media.MetaData("ARTIST"     ));
        ///  setMetaAlbum  (media.MetaData("ALBUM"      ));
        ///  setMetaTitle  (media.MetaData("TITLE"      ));
        ///  setMetaDate   (media.MetaData("DATE"       ));
        ///  setMetaGenre  (media.MetaData("GENRE"      ));
        ///  setMetaTrack  (media.MetaData("TRACKNUMBER"));
        ///  setMetaComment(media.MetaData("DESCRIPTION"));
        ///  </pre>
        ///  For Audio CDs you can query
        ///  <pre>
        ///  metaData("MUSICBRAINZ_DISCID");
        ///  </pre>
        ///  to get a DiscID hash that you can use with the MusicBrainz
        ///  service:
        ///  http://musicbrainz.org/doc/ClientHOWTO
        ///              </remarks>        <short>    Returns the strings associated with the given \p key.</short>
        public List<string> metaData(string key) {
            return (List<string>) interceptor.Invoke("metaData$", "metaData(const QString&) const", typeof(List<string>), typeof(string), key);
        }
        /// <remarks>
        ///  Returns the strings associated with the given <pre>key</pre>.
        ///  Same as above except that the keys are defined in the
        ///  Phonon.MetaData enum.
        ///              </remarks>        <short>    Returns the strings associated with the given \p key.</short>
        public List<string> metaData(Phonon.MetaData key) {
            return (List<string>) interceptor.Invoke("metaData$", "metaData(Phonon::MetaData) const", typeof(List<string>), typeof(Phonon.MetaData), key);
        }
        /// <remarks>
        ///  Returns all meta data.
        ///              </remarks>        <short>    Returns all meta data.</short>
        /// <remarks>
        ///  Returns a human-readable description of the last error that occurred.
        ///              </remarks>        <short>    Returns a human-readable description of the last error that occurred.</short>
        public string ErrorString() {
            return (string) interceptor.Invoke("errorString", "errorString() const", typeof(string));
        }
        /// <remarks>
        ///  Tells your program what to do about the error.
        ///  \see Phonon.ErrorType
        ///              </remarks>        <short>    Tells your program what to do about the error.</short>
        public Phonon.ErrorType errorType() {
            return (Phonon.ErrorType) interceptor.Invoke("errorType", "errorType() const", typeof(Phonon.ErrorType));
        }
        /// <remarks>
        ///  Returns the current media source.
        ///  \see setCurrentSource
        ///              </remarks>        <short>    Returns the current media source.</short>
        public Phonon.MediaSource CurrentSource() {
            return (Phonon.MediaSource) interceptor.Invoke("currentSource", "currentSource() const", typeof(Phonon.MediaSource));
        }
        /// <remarks>
        ///  Set the media source the MediaObject should use.
        ///  \param source The MediaSource object to the media data. You can
        ///  just as well use a QUrl or string (for a local file) here.
        ///  Setting an empty (invalid) source, will stop and remove the
        ///  current source.
        ///  <pre>
        ///  QUrl url("http://www.example.com/music.ogg");
        ///  media.SetCurrentSource(url);
        ///  </pre>
        ///  \see currentSource
        ///              </remarks>        <short>    Set the media source the MediaObject should use.</short>
        public void SetCurrentSource(Phonon.MediaSource source) {
            interceptor.Invoke("setCurrentSource#", "setCurrentSource(const Phonon::MediaSource&)", typeof(void), typeof(Phonon.MediaSource), source);
        }
        /// <remarks>
        ///  Returns the queued media sources. This does list does not include
        ///  the current source (returned by currentSource).
        ///              </remarks>        <short>    Returns the queued media sources.</short>
        public List<Phonon.MediaSource> Queue() {
            return (List<Phonon.MediaSource>) interceptor.Invoke("queue", "queue() const", typeof(List<Phonon.MediaSource>));
        }
        /// <remarks>
        ///  Set the MediaSources to play when the current media has finished.
        ///  This function will overwrite the current queue.
        ///  \see clearQueue
        ///  \see enqueue
        ///              </remarks>        <short>    Set the MediaSources to play when the current media has finished.</short>
        public void SetQueue(List<Phonon.MediaSource> sources) {
            interceptor.Invoke("setQueue?", "setQueue(const QList<Phonon::MediaSource>&)", typeof(void), typeof(List<Phonon.MediaSource>), sources);
        }
        /// <remarks>
        ///  Set the MediaSources to play when the current media has finished.
        ///  This function overwrites the current queue.
        ///  \see clearQueue
        ///  \see enqueue
        ///              </remarks>        <short>    Set the MediaSources to play when the current media has finished.</short>
        public void SetQueue(List<QUrl> urls) {
            interceptor.Invoke("setQueue?", "setQueue(const QList<QUrl>&)", typeof(void), typeof(List<QUrl>), urls);
        }
        /// <remarks>
        ///  Appends one source to the queue. Use this function to provide
        ///  the next source just in time after the aboutToFinish signal was
        ///  emitted.
        ///  \see aboutToFinish
        ///  \see setQueue
        ///  \see clearQueue
        ///              </remarks>        <short>    Appends one source to the queue.</short>
        public void Enqueue(Phonon.MediaSource source) {
            interceptor.Invoke("enqueue#", "enqueue(const Phonon::MediaSource&)", typeof(void), typeof(Phonon.MediaSource), source);
        }
        /// <remarks>
        ///  Appends multiple sources to the queue.
        ///  \see setQueue
        ///  \see clearQueue
        ///              </remarks>        <short>    Appends multiple sources to the queue.</short>
        public void Enqueue(List<Phonon.MediaSource> sources) {
            interceptor.Invoke("enqueue?", "enqueue(const QList<Phonon::MediaSource>&)", typeof(void), typeof(List<Phonon.MediaSource>), sources);
        }
        /// <remarks>
        ///  Appends multiple sources to the queue.
        ///  \see setQueue
        ///  \see clearQueue
        ///              </remarks>        <short>    Appends multiple sources to the queue.</short>
        public void Enqueue(List<QUrl> urls) {
            interceptor.Invoke("enqueue?", "enqueue(const QList<QUrl>&)", typeof(void), typeof(List<QUrl>), urls);
        }
        /// <remarks>
        ///  Clears the queue of sources.
        ///              </remarks>        <short>    Clears the queue of sources.</short>
        public void ClearQueue() {
            interceptor.Invoke("clearQueue", "clearQueue()", typeof(void));
        }
        /// <remarks>
        ///  Get the current time (in milliseconds) of the file currently being played.
        ///  \return The current time in milliseconds.
        ///  \see tick
        ///              </remarks>        <short>    Get the current time (in milliseconds) of the file currently being played.</short>
        public long CurrentTime() {
            return (long) interceptor.Invoke("currentTime", "currentTime() const", typeof(long));
        }
        /// <remarks>
        ///  Get the total time (in milliseconds) of the file currently being played.
        ///  \return The total time in milliseconds.
        ///  \see totalTimeChanged
        ///              </remarks>        <short>    Get the total time (in milliseconds) of the file currently being played.</short>
        public long TotalTime() {
            return (long) interceptor.Invoke("totalTime", "totalTime() const", typeof(long));
        }
        /// <remarks>
        ///  Get the remaining time (in milliseconds) of the file currently being played.
        ///  \return The remaining time in milliseconds.
        ///              </remarks>        <short>    Get the remaining time (in milliseconds) of the file currently being played.</short>
        public long RemainingTime() {
            return (long) interceptor.Invoke("remainingTime", "remainingTime() const", typeof(long));
        }
        public MediaObject() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MediaObject", "MediaObject()", typeof(void));
        }
        [Q_SLOT("void setTickInterval(qint32)")]
        public void SetTickInterval(int newTickInterval) {
            interceptor.Invoke("setTickInterval$", "setTickInterval(int)", typeof(void), typeof(int), newTickInterval);
        }
        /// <remarks>
        ///  Requests playback of the media data to start. Playback only
        ///  starts when stateChanged() signals that it goes into PlayingState,
        ///  though.
        ///  \par Possible states right after this call:
        ///  <li>BufferingState</li>
        ///  <li>PlayingState</li>
        ///  <li>ErrorState</li>
        ///              </remarks>        <short>    Requests playback of the media data to start.</short>
        [Q_SLOT("void play()")]
        public void Play() {
            interceptor.Invoke("play", "play()", typeof(void));
        }
        /// <remarks>
        ///  Requests playback to pause. If it was paused before nothing changes.
        ///  \par Possible states right after this call:
        ///  <li>PlayingState</li>
        ///  <li>PausedState</li>
        ///  <li>ErrorState</li>
        ///              </remarks>        <short>    Requests playback to pause.</short>
        [Q_SLOT("void pause()")]
        public void Pause() {
            interceptor.Invoke("pause", "pause()", typeof(void));
        }
        /// <remarks>
        ///  Requests playback to stop. If it was stopped before nothing changes.
        ///  \par Possible states right after this call:
        ///  <li>the</li> state it was in before (e.g. PlayingState)
        ///  <li>StoppedState</li>
        ///  <li>ErrorState</li>
        ///              </remarks>        <short>    Requests playback to stop.</short>
        [Q_SLOT("void stop()")]
        public void Stop() {
            interceptor.Invoke("stop", "stop()", typeof(void));
        }
        /// <remarks>
        ///  Requests a seek to the time indicated.
        ///  You can only seek if state() == PlayingState, BufferingState or PausedState.
        ///  The call is asynchronous, so currentTime can still be the old
        ///  value right after this method was called. If all you need is a
        ///  slider that shows the current position and allows the user to
        ///  seek use the class SeekSlider.
        /// <param> name="time" The time in milliseconds where to continue playing.
        /// </param> \par Possible states right after this call:
        ///  <li>BufferingState</li>
        ///  <li>PlayingState</li>
        ///  <li>ErrorState</li>
        ///  \see SeekSlider
        ///              </remarks>        <short>    Requests a seek to the time indicated.</short>
        [Q_SLOT("void seek(qint64)")]
        public void Seek(long time) {
            interceptor.Invoke("seek$", "seek(qint64)", typeof(void), typeof(long), time);
        }
        /// <remarks>
        ///  Stops and removes all playing and enqueued media sources.
        ///  \see setCurrentSource
        ///              </remarks>        <short>    Stops and removes all playing and enqueued media sources.</short>
        [Q_SLOT("void clear()")]
        public void Clear() {
            interceptor.Invoke("clear", "clear()", typeof(void));
        }
        ~MediaObject() {
            interceptor.Invoke("~MediaObject", "~MediaObject()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~MediaObject", "~MediaObject()", typeof(void));
        }
        /// <remarks>
        ///  Tells whether the backend provides an implementation of this
        ///  class.
        ///  \return <code>true</code> if backend provides an implementation
        ///  \return <code>false</code> if the object is not implemented by the backend
        ///          </remarks>        <short>    Tells whether the backend provides an implementation of this  class.</short>
        public bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        public List<Phonon.Path> InputPaths() {
            return (List<Phonon.Path>) interceptor.Invoke("inputPaths", "inputPaths() const", typeof(List<Phonon.Path>));
        }
        public List<Phonon.Path> OutputPaths() {
            return (List<Phonon.Path>) interceptor.Invoke("outputPaths", "outputPaths() const", typeof(List<Phonon.Path>));
        }
        protected new IMediaObjectSignals Emit {
            get { return (IMediaObjectSignals) Q_EMIT; }
        }
    }

    public interface IMediaObjectSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted when the state of the MediaObject has changed.
        ///  In case you're not interested in the old state you can also
        ///  connect to a slot that only has one State argument.
        /// <param> name="newstate" The state the Player is in now.
        /// </param><param> name="oldstate" The state the Player was in before.
        ///              </param></remarks>        <short>    Emitted when the state of the MediaObject has changed.</short>
        [Q_SIGNAL("void stateChanged(Phonon::State, Phonon::State)")]
        void StateChanged(Phonon.State newstate, Phonon.State oldstate);
        /// <remarks>
        ///  This signal gets emitted every tickInterval milliseconds.
        /// <param> name="time" The position of the media file in milliseconds.
        /// </param></remarks>        <short>    This signal gets emitted every tickInterval milliseconds.</short>
        ///         <see> setTickInterval</see>
        ///         <see> tickInterval</see>
        [Q_SIGNAL("void tick(qint64)")]
        void Tick(long time);
        /// <remarks>
        ///  This signal is emitted whenever the audio/video data that is
        ///  being played is associated with new meta data. E.g. for radio
        ///  streams this happens when the next song is played.
        ///  You can get the new meta data with the metaData methods.
        ///              </remarks>        <short>    This signal is emitted whenever the audio/video data that is  being played is associated with new meta data.</short>
        [Q_SIGNAL("void metaDataChanged()")]
        void MetaDataChanged();
        /// <remarks>
        ///  Emitted whenever the return value of isSeekable() changes.
        ///  Normally you'll check isSeekable() first and then let this signal
        ///  tell you whether seeking is possible now or not. That way you
        ///  don't have to poll isSeekable().
        ///  \param isSeekable <pre>true</pre>  if the stream is seekable (i.e. calling
        ///                             seek() works)
        ///                    <pre>false</pre> if the stream is not seekable (i.e.
        ///                             all calls to seek() will be ignored)
        ///              </remarks>        <short>    Emitted whenever the return value of isSeekable() changes.</short>
        [Q_SIGNAL("void seekableChanged(bool)")]
        void SeekableChanged(bool isSeekable);
        /// <remarks>
        ///  Emitted whenever the return value of hasVideo() changes.
        ///  Normally you'll check hasVideo() first and then let this signal
        ///  tell you whether video is available now or not. That way you
        ///  don't have to poll hasVideo().
        ///  \param hasVideo <pre>true</pre>  The stream contains video and adding a
        ///                           VideoWidget will show a video.
        ///                  <pre>false</pre> There is no video data in the stream and
        ///                           adding a VideoWidget will show an empty (black)
        ///                           VideoWidget.
        ///              </remarks>        <short>    Emitted whenever the return value of hasVideo() changes.</short>
        [Q_SIGNAL("void hasVideoChanged(bool)")]
        void HasVideoChanged(bool hasVideo);
        /// <remarks>
        ///  Tells about the status of the buffer.
        ///  You can use this signal to show a progress bar to the user when
        ///  in BufferingState:
        ///  <pre>
        ///  progressBar.SetRange(0, 100); // this is the default
        ///  connect(media, SIGNAL("bufferStatus(int)"), progressBar, SLOT("setValue(int)"));
        ///  </pre>
        ///  \param percentFilled A number between 0 and 100 telling you how
        ///                       much the buffer is filled.
        ///              </remarks>        <short>    Tells about the status of the buffer.</short>
        [Q_SIGNAL("void bufferStatus(int)")]
        void BufferStatus(int percentFilled);
        /// <remarks>
        ///  Emitted when the object has finished playback.
        ///  It is not emitted if you call stop(), pause() or
        ///  load(), but only on end-of-queue or a critical error.
        ///  \warning This signal is not emitted when the current source has
        ///  finished and there's another source in the queue. It is only
        ///  emitted when the queue is empty.
        ///  \see currentSourceChanged
        ///  \see aboutToFinish
        ///  \see prefinishMarkReached
        ///              </remarks>        <short>    Emitted when the object has finished playback.</short>
        [Q_SIGNAL("void finished()")]
        void Finished();
        /// <remarks>
        ///  Emitted when the MediaObject makes a transition to the next
        ///  MediaSource in the queue().
        ///  In other words, it is emitted when an individual MediaSource is
        ///  finished.
        ///  \param newSource The source that starts to play at the time the
        ///  signal is emitted.
        ///              </remarks>        <short>    Emitted when the MediaObject makes a transition to the next  MediaSource in the queue().</short>
        [Q_SIGNAL("void currentSourceChanged(Phonon::MediaSource)")]
        void CurrentSourceChanged(Phonon.MediaSource newSource);
        /// <remarks>
        ///  Emitted before the playback of the whole queue stops. When this
        ///  signal is emitted you still have time to provide the next
        ///  MediaSource (using enqueue()) so that playback continues.
        ///  This signal can be used to provide the next MediaSource just in
        ///  time for the transition still to work.
        ///  \see enqueue
        ///              </remarks>        <short>    Emitted before the playback of the whole queue stops.</short>
        [Q_SIGNAL("void aboutToFinish()")]
        void AboutToFinish();
        /// <remarks>
        ///  Emitted when there are only <pre>msecToEnd</pre> milliseconds left
        ///  for playback.
        ///  \param msecToEnd The remaining time until the playback queue finishes.
        ///  \warning This signal is not emitted when there is another source in the queue.
        ///  It is only emitted when the queue is empty.
        ///  \see setPrefinishMark
        ///  \see prefinishMark
        ///  \see aboutToFinish
        ///  \see finished
        ///              </remarks>        <short>    Emitted when there are only \p msecToEnd milliseconds left  for playback.</short>
        [Q_SIGNAL("void prefinishMarkReached(qint32)")]
        void PrefinishMarkReached(int msecToEnd);
        /// <remarks>
        ///  This signal is emitted as soon as the total time of the media file is
        ///  known or has changed. For most non-local media data the total
        ///  time of the media can only be known after some time. At that time the
        ///  totalTime function can not return useful information. You have
        ///  to wait for this signal to know the real total time.
        ///  \param newTotalTime The length of the media file in milliseconds.
        ///  \see totalTime
        ///              </remarks>        <short>    This signal is emitted as soon as the total time of the media file is  known or has changed.</short>
        [Q_SIGNAL("void totalTimeChanged(qint64)")]
        void TotalTimeChanged(long newTotalTime);
    }
}
