/*
 *  Copyright (c) 2004 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "kis_multi_double_filter_widget.h"

#include <qlabel.h>
#include <qlayout.h>

#include <knuminput.h>
#include <klocale.h>

#include "kis_filter.h"

KisDoubleWidgetParam::KisDoubleWidgetParam(double nmin, double nmax, double ninitvalue, QString nname) :
	min(nmin),
	max(nmax),
	initvalue(ninitvalue),
	name(nname)
{

}

KisMultiDoubleFilterWidget::KisMultiDoubleFilterWidget( KisFilter* nfilter, QWidget * parent, const char * name, const char * caption, vKisDoubleWidgetParam dwparam) : KisFilterConfigurationWidget( nfilter, parent, name )
{
	Q_INT32 m_nbdoubleWidgets = dwparam.size();

	this->setCaption(caption);

	QGridLayout *widgetLayout = new QGridLayout(this, m_nbdoubleWidgets + 1, 3);
	widgetLayout -> setColStretch ( 1, 1 );

	m_doubleWidgets = new KDoubleNumInput*[ m_nbdoubleWidgets ];

	for( Q_INT32 i = 0; i < m_nbdoubleWidgets; ++i)
	{
		m_doubleWidgets[i] = new KDoubleNumInput(this, dwparam[i].name.ascii());
		m_doubleWidgets[i] -> setRange( dwparam[i].min, dwparam[i].max ); 
		m_doubleWidgets[i] -> setValue( dwparam[i].initvalue );

		connect(m_doubleWidgets[i], SIGNAL(valueChanged(double)), filter(), SLOT(refreshPreview()));

		QLabel* lbl = new QLabel(dwparam[i].name+":", this);
		widgetLayout -> addWidget( lbl, i , 0);

		widgetLayout -> addWidget( m_doubleWidgets[i], i , 1);
	}
	QSpacerItem * sp = new QSpacerItem(1, 1);
	widgetLayout -> addItem(sp, m_nbdoubleWidgets, 0);

}

#include "kis_multi_double_filter_widget.moc"
