/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/
#include "autogeneratetextplugintoolinterface.h"
#include "ruqola.h"
#include "textautogeneratetext_version.h"
#if TEXTAUTOGENERATETEXT_VERSION >= QT_VERSION_CHECK(1, 6, 50)
#include <TextAutoGenerateText/TextAutoGenerateQuickAskDialog>
#else
#include <TextAutoGenerateText/TextAutoGenerateDialog>
#endif
AutoGenerateTextPluginToolInterface::AutoGenerateTextPluginToolInterface(QObject *parent)
    : PluginToolInterface{parent}
{
}

AutoGenerateTextPluginToolInterface::~AutoGenerateTextPluginToolInterface() = default;

void AutoGenerateTextPluginToolInterface::activateTool()
{
#if TEXTAUTOGENERATETEXT_VERSION >= QT_VERSION_CHECK(1, 6, 50)
    TextAutoGenerateText::TextAutoGenerateQuickAskDialog d(Ruqola::self()->textAutoGenerateManager(), nullptr);
#elif TEXTAUTOGENERATETEXT_VERSION >= QT_VERSION_CHECK(1, 6, 45)
    TextAutoGenerateText::TextAutoGenerateDialog d(Ruqola::self()->textAutoGenerateManager(), nullptr);
#else
    TextAutoGenerateText::TextAutoGenerateDialog d;
#endif
    d.exec();
}

#include "moc_autogeneratetextplugintoolinterface.cpp"
