/***************************************************************************
                          wizpage5.cpp  -  description
                             -------------------
    begin                : Thu Feb 10 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "wizpage5.h"

WizPage5::WizPage5(QWidget *parent, const char *name )
		: QFrame(parent,name)
{
	QLabel *lab = new QLabel(i18n("Set up Retry's and Output"), this);
	lab->setGeometry(5,5,435,15);
	lab->setAlignment(AlignCenter);
	lab->setFont(QFont("helvetica", 14, QFont::Bold));

	QLabel *infoLab = new QLabel(i18n("If the server has to much traffic, it's possible, that a download stops.\n"
				"In this case, KWebGet can retry the download.\n"), this);
	infoLab->setFont(QFont("helvetica", 10));
	infoLab->setGeometry(5,35,435,35);

	retryBut = new QCheckBox(i18n("Number of Retry's:"), this);
	retryBut->setGeometry(5,80,130,20);
	connect(retryBut, SIGNAL(clicked()), this, SLOT(enableRetry()));

	retryBox = new QSpinBox(1,9999,1,this);
	retryBox->setGeometry(145,80,60,20);
	retryBox->setEnabled(false);

	QLabel *waitLab = new QLabel(i18n("Wait seconds:"), this);
	waitLab->setGeometry(25,105,100,20);

	waitBox = new QSpinBox(0,999,1,this);
	waitBox->setGeometry(145,105,60,20);
	waitBox->setEnabled(false);

	QLabel *cautLab = new QLabel(i18n("Your X-Server can slow down, if KWebGet produces to much Output-Messages\n"
			"and your system has a high load, or is not the fastest."), this);
	cautLab->setFont(QFont("helvetica", 10));
	cautLab->setGeometry(5,135,435,30);

	outputBut = new QCheckBox(i18n("Disable Output Messages"), this);
	outputBut->setGeometry(5,175,210,20);
}

WizPage5::~WizPage5()
{
}

void WizPage5::enableRetry()
{
	if ( retryBut->isChecked() ) {
		retryBox->setEnabled(true);
		waitBox->setEnabled(true);
	} else {
		retryBox->setEnabled(false);
		waitBox->setEnabled(false);
	}
}