/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.text.resources.cldr.chr;

import java.util.ListResourceBundle;

public class FormatData_chr extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "MonthNames",
                new String[] {
                    "\u13a4\u13c3\u13b8\u13d4\u13c5",
                    "\u13a7\u13a6\u13b5",
                    "\u13a0\u13c5\u13f1",
                    "\u13a7\u13ec\u13c2",
                    "\u13a0\u13c2\u13cd\u13ac\u13d8",
                    "\u13d5\u13ad\u13b7\u13f1",
                    "\u13ab\u13f0\u13c9\u13c2",
                    "\u13a6\u13b6\u13c2",
                    "\u13da\u13b5\u13cd\u13d7",
                    "\u13da\u13c2\u13c5\u13d7",
                    "\u13c5\u13d3\u13d5\u13c6",
                    "\u13a4\u13cd\u13a9\u13f1",
                    "",
                }
            },
            { "MonthAbbreviations",
                new String[] {
                    "\u13a4\u13c3",
                    "\u13a7\u13a6",
                    "\u13a0\u13c5",
                    "\u13a7\u13ec",
                    "\u13a0\u13c2",
                    "\u13d5\u13ad",
                    "\u13ab\u13f0",
                    "\u13a6\u13b6",
                    "\u13da\u13b5",
                    "\u13da\u13c2",
                    "\u13c5\u13d3",
                    "\u13a4\u13cd",
                    "",
                }
            },
            { "MonthNarrows",
                new String[] {
                    "\u13a4",
                    "\u13a7",
                    "\u13a0",
                    "\u13a7",
                    "\u13a0",
                    "\u13d5",
                    "\u13ab",
                    "\u13a6",
                    "\u13da",
                    "\u13da",
                    "\u13c5",
                    "\u13a4",
                    "",
                }
            },
            { "DayNames",
                new String[] {
                    "\u13a4\u13be\u13d9\u13d3\u13c6\u13cd\u13ac",
                    "\u13a4\u13be\u13d9\u13d3\u13c9\u13c5\u13af",
                    "\u13d4\u13b5\u13c1\u13a2\u13a6",
                    "\u13e6\u13a2\u13c1\u13a2\u13a6",
                    "\u13c5\u13a9\u13c1\u13a2\u13a6",
                    "\u13e7\u13be\u13a9\u13b6\u13cd\u13d7",
                    "\u13a4\u13be\u13d9\u13d3\u13c8\u13d5\u13be",
                }
            },
            { "DayAbbreviations",
                new String[] {
                    "\u13c6\u13cd\u13ac",
                    "\u13c9\u13c5\u13af",
                    "\u13d4\u13b5\u13c1",
                    "\u13e6\u13a2\u13c1",
                    "\u13c5\u13a9\u13c1",
                    "\u13e7\u13be\u13a9",
                    "\u13c8\u13d5\u13be",
                }
            },
            { "DayNarrows",
                new String[] {
                    "\u13c6",
                    "\u13c9",
                    "\u13d4",
                    "\u13e6",
                    "\u13c5",
                    "\u13e7",
                    "\u13a4",
                }
            },
            { "AmPmMarkers",
                new String[] {
                    "\u13cc\u13be\u13b4",
                    "\u13d2\u13af\u13f1\u13a2\u13d7\u13e2",
                }
            },
            { "long.Eras",
                new String[] {
                    "\u13cf \u13e5\u13cc \u13be\u13d5\u13b2\u13cd\u13ac\u13be",
                    "\u13a0\u13a9\u13c3\u13ae\u13b5\u13d3\u13cd\u13d7\u13f1 \u13a0\u13d5\u13d8\u13f1\u13cd\u13ac \u13f1\u13b0\u13e9 \u13e7\u13d3\u13c2\u13b8\u13a2\u13cd\u13d7",
                }
            },
            { "Eras",
                new String[] {
                    "\u13a4\u13d3\u13b7\u13b8",
                    "\u13a4\u13b6\u13d0\u13c5",
                }
            },
            { "field.era", "\u13a1\u13b6\u13af \u13a0\u13e3\u13a2\u13b5\u13d2\u13a2" },
            { "field.year", "\u13d1\u13d5\u13d8\u13f4\u13d3" },
            { "field.month", "\u13cf\u13c5\u13d3" },
            { "field.week", "\u13d2\u13be\u13d9\u13d3\u13c6\u13cd\u13d7" },
            { "field.weekday", "\u13d2\u13be\u13d9\u13d3\u13c6\u13cd\u13d7 \u13a0\u13e3\u13a2\u13b5\u13d2" },
            { "field.hour", "\u13d1\u13e3\u13b6\u13d3" },
            { "field.minute", "\u13a2\u13ef\u13d4\u13ec\u13cd\u13d4\u13c5" },
            { "field.second", "\u13a0\u13ce\u13e2" },
            { "field.zone", "\u13a1\u13b6\u13af \u13a0\u13cd\u13d3\u13c5\u13c5" },
            { "TimePatterns",
                new String[] {
                    "h:mm:ss a zzzz",
                    "h:mm:ss a z",
                    "h:mm:ss a",
                    "h:mm a",
                }
            },
            { "DatePatterns",
                new String[] {
                    "EEEE, MMMM d, y",
                    "MMMM d, y",
                    "MMM d, y",
                    "M/d/yy",
                }
            },
            { "calendarname.gregorian", "\u13c5\u13d9 \u13d7\u13ce\u13d7" },
            { "calendarname.gregory", "\u13c5\u13d9 \u13d7\u13ce\u13d7" },
            { "DefaultNumberingSystem", "latn" },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4#,##0.00;(\u00a4#,##0.00)",
                    "#,##0%",
                }
            },
        };
        return data;
    }
}
