"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const helper_1 = require("../helper");
function simulateClientSettings(workspaceManager, settings) {
    workspaceManager.clientCapabilities.workspace = {
        configuration: true,
    };
    workspaceManager.connection.workspace.getConfiguration = function () {
        return Promise.resolve(settings);
    };
}
describe("get()", () => {
    describe("Merge settings from client", () => {
        describe("When client provides empty settings", () => {
            let context;
            let mergedSettings;
            before(async () => {
                const workspaceManager = (0, helper_1.createTestWorkspaceManager)();
                simulateClientSettings(workspaceManager, []);
                context = workspaceManager.getContext("");
                if (typeof context !== "undefined") {
                    mergedSettings = await context.documentSettings.get("");
                }
            });
            it("should return default value for all settings", () => {
                (0, chai_1.expect)(typeof context !== "undefined");
                if (typeof context !== "undefined") {
                    (0, chai_1.expect)(mergedSettings).to.deep.equal(context.documentSettings.globalSettings);
                }
            });
        });
        describe("When client provides partial settings", () => {
            let context;
            let mergedSettings;
            before(async () => {
                const workspaceManager = (0, helper_1.createTestWorkspaceManager)();
                simulateClientSettings(workspaceManager, {
                    validation: { lint: { enabled: false } },
                });
                context = workspaceManager.getContext("");
                if (typeof context !== "undefined") {
                    mergedSettings = await context.documentSettings.get("");
                }
            });
            it("should return setting from client when defined", () => {
                (0, chai_1.expect)(mergedSettings.validation.lint.enabled).to.equal(false);
            });
            it("should return default value otherwise", () => {
                if (typeof context !== "undefined") {
                    (0, chai_1.expect)(mergedSettings.validation.lint.path).to.equal(context.documentSettings.globalSettings.validation.lint.path);
                }
            });
        });
    });
});
