"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @internal */
function stringRepeat(str, times) {
    /* istanbul ignore else */
    if (typeof String.prototype.repeat === "function")
        return str.repeat(times);
    else
        return es5StringRepeat(str, times);
}
exports.stringRepeat = stringRepeat;
/** @internal */
function es5StringRepeat(str, times) {
    if (times < 0)
        throw new Error("Invalid times value.");
    var newStr = "";
    for (var i = 0; i < times; i++)
        newStr += str;
    return newStr;
}
exports.es5StringRepeat = es5StringRepeat;
var newlineRegex = /(\r?\n)/g;
/** @internal */
function escapeForWithinString(str, quoteKind) {
    return escapeChar(str, quoteKind).replace(newlineRegex, "\\$1");
}
exports.escapeForWithinString = escapeForWithinString;
/** @internal */
function escapeChar(str, char) {
    if (char.length !== 1)
        throw new Error("Specified char must be one character long.");
    var result = "";
    for (var i = 0; i < str.length; i++) {
        if (str[i] === char)
            result += "\\";
        result += str[i];
    }
    return result;
}
exports.escapeChar = escapeChar;
/** @internal */
function getStringFromStrOrFunc(strOrFunc) {
    return strOrFunc instanceof Function ? strOrFunc() : strOrFunc;
}
exports.getStringFromStrOrFunc = getStringFromStrOrFunc;
//# sourceMappingURL=stringUtils.js.map