/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.demo;

import com.github.lgooddatepicker.tableeditors.DateTableEditor;
import com.github.lgooddatepicker.tableeditors.DateTimeTableEditor;
import com.github.lgooddatepicker.tableeditors.TimeTableEditor;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableEditorsDemo
extends JPanel {
    public TableEditorsDemo() {
        super(new GridLayout(1, 0));
        int clickCountToEdit = 1;
        JTable table = new JTable(new DemoTableModel());
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
        table.setBackground(new Color(190, 240, 255));
        InternalUtilities.setDefaultTableEditorsClicks(table, clickCountToEdit);
        table.setDefaultRenderer(LocalDate.class, new DateTableEditor());
        DateTableEditor dateEdit = new DateTableEditor();
        dateEdit.clickCountToEdit = clickCountToEdit;
        table.setDefaultEditor(LocalDate.class, dateEdit);
        table.setDefaultRenderer(LocalTime.class, new TimeTableEditor());
        TimeTableEditor timeEdit = new TimeTableEditor();
        timeEdit.clickCountToEdit = clickCountToEdit;
        table.setDefaultEditor(LocalTime.class, timeEdit);
        table.setDefaultRenderer(LocalDateTime.class, new DateTimeTableEditor());
        DateTimeTableEditor dateTimeEdit = new DateTimeTableEditor();
        dateTimeEdit.clickCountToEdit = clickCountToEdit;
        table.setDefaultEditor(LocalDateTime.class, dateTimeEdit);
        this.zSetAllColumnEditorsAndRenderers(table);
        table.getColumnModel().getColumn(DemoTableModel.dateTimeColumnIndex).setPreferredWidth(180);
    }

    public static void createAndShowTableDemoFrame() {
        JFrame frame = new JFrame("LGoodDatePicker Table Editors Demo " + InternalUtilities.getProjectVersionString());
        frame.setDefaultCloseOperation(2);
        TableEditorsDemo tableDemoPanel = new TableEditorsDemo();
        frame.setContentPane(tableDemoPanel);
        tableDemoPanel.setOpaque(true);
        frame.pack();
        frame.setSize(new Dimension(1000, 700));
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableEditorsDemo.createAndShowTableDemoFrame();
            }
        });
    }

    private void zSetAllColumnEditorsAndRenderers(JTable table) {
        int maxStartRowsToRead = 30;
        int maxBulkRowsToRead = 70;
        int maxFoundSamplesToExamine = 21;
        TableModel model = table.getModel();
        int columnCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        if (columnCount < 1 || rowCount < 1) {
            return;
        }
        int bulkRowIncrement = Math.max(1, rowCount / maxBulkRowsToRead);
        block0: for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            TableColumn column = table.getColumnModel().getColumn(columnIndex);
            ArrayList nonNullTypes = new ArrayList();
            for (int rowIndex = 0; rowIndex < rowCount; rowIndex += rowIndex < maxStartRowsToRead ? 1 : bulkRowIncrement) {
                Object value = model.getValueAt(rowIndex, columnIndex);
                if (value == null) continue;
                nonNullTypes.add(value.getClass());
                if (nonNullTypes.size() < maxFoundSamplesToExamine) continue;
                Class mostCommonType = (Class)InternalUtilities.getMostCommonElementInList(nonNullTypes);
                column.setCellRenderer(table.getDefaultRenderer(mostCommonType));
                column.setCellEditor(table.getDefaultEditor(mostCommonType));
                continue block0;
            }
            if (nonNullTypes.size() > 0) {
                Class mostCommonType = (Class)InternalUtilities.getMostCommonElementInList(nonNullTypes);
                column.setCellRenderer(table.getDefaultRenderer(mostCommonType));
                column.setCellEditor(table.getDefaultEditor(mostCommonType));
                continue;
            }
            column.setCellRenderer(table.getDefaultRenderer(Object.class));
            column.setCellEditor(table.getDefaultEditor(Object.class));
        }
    }

    static class DemoTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Date", "Time", "DateTime", "String", "Integer", "Boolean"};
        public static int dateTimeColumnIndex = 2;
        private Object[][] data = new Object[][]{{LocalDate.now(), LocalTime.now(), LocalDateTime.now(), "Jane", 5, false}, {LocalDate.now().plusDays(1L), LocalTime.now().plusHours(1L), LocalDateTime.now(), "Alison", 3, true}, {LocalDate.now().plusDays(2L), LocalTime.now().plusHours(2L), LocalDateTime.now(), "Kathy", -2, false}, {LocalDate.now().plusDays(3L), LocalTime.now().plusHours(3L), LocalDateTime.now(), "Sharon", 2, true}, {LocalDate.now().plusDays(4L), LocalTime.now().plusHours(4L), LocalDateTime.now(), "Philip", 10, false}, {"randomtext", "randomtext", "randomtext", "randomtext", "randomtext", false}, {null, null, null, null, null, null}};

        DemoTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

