/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableList;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.javafx.bookmark.BookmarkData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookmarkDataList {
    private final ObservableList<BookmarkData> olist;
    private static BookmarkDataList instance;
    private static final Logger logger;

    /*
     * Exception decompiling
     */
    private BookmarkDataList(Daten daten) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BookmarkDataList getInstance(Daten daten) {
        return instance == null ? (instance = new BookmarkDataList(daten)) : instance;
    }

    public ObservableList<BookmarkData> getObervableList() {
        return this.olist;
    }

    public int getNbOfEntries() {
        return this.olist.size();
    }

    public void clear() {
        this.olist.clear();
    }

    public int getSeenNbOfEntries() {
        int count = 0;
        for (BookmarkData d : this.olist) {
            if (!d.getSeen()) continue;
            ++count;
        }
        return count;
    }

    public void checkAndBookmarkMovies(List<DatenFilm> movies) {
        ArrayList<DatenFilm> addlist = new ArrayList<DatenFilm>();
        ArrayList<BookmarkData> dellist = new ArrayList<BookmarkData>();
        boolean add = false;
        for (DatenFilm datenFilm : movies) {
            if (!datenFilm.isBookmarked()) {
                add = true;
                addlist.add(datenFilm);
                continue;
            }
            BookmarkData bookmarkData = this.findMovieInList(datenFilm);
            if (bookmarkData == null) continue;
            dellist.add(bookmarkData);
        }
        if (add) {
            try (SeenHistoryController history = new SeenHistoryController();){
                for (DatenFilm datenFilm : addlist) {
                    BookmarkData bdata = new BookmarkData(datenFilm);
                    datenFilm.setBookmark(bdata);
                    bdata.setSeen(!bdata.isLiveStream() && history.hasBeenSeen(datenFilm));
                    this.olist.add(bdata);
                }
            }
            catch (Exception ex) {
                logger.error("history produced error", (Throwable)ex);
            }
        } else {
            for (DatenFilm datenFilm : movies) {
                datenFilm.setBookmark(null);
            }
            this.olist.removeAll((Collection<?>)dellist);
        }
    }

    public void deleteEntries(ObservableList<BookmarkData> bookmarks) {
        for (BookmarkData bookmark : bookmarks) {
            DatenFilm movie = bookmark.getDatenFilm();
            if (movie == null) continue;
            movie.setBookmark(null);
        }
        this.olist.removeAll((Collection<?>)bookmarks);
    }

    public void loadFromFile(Path filePath) {
        try (JsonParser parser = new MappingJsonFactory().createParser(filePath.toFile());){
            JsonToken jToken;
            while ((jToken = parser.nextToken()) != null) {
                if (jToken != JsonToken.START_ARRAY) continue;
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    BookmarkData obj = parser.readValueAs(BookmarkData.class);
                    this.olist.add(obj);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Could not read bookmarks from file {}, error {} => file ignored", (Object)filePath.toString(), (Object)e.getMessage());
        }
        if (this.olist.size() > 1000) {
            logger.warn("Bookmark entries exceed threshold: {}", (Object)this.olist.size());
        }
    }

    public void saveToFile(Path filePath) {
        try (JsonGenerator jGenerator = new MappingJsonFactory().createGenerator(filePath.toFile(), JsonEncoding.UTF8).useDefaultPrettyPrinter();){
            jGenerator.writeStartObject();
            jGenerator.writeFieldName("bookmarks");
            jGenerator.writeStartArray();
            for (BookmarkData bookmarkData : this.olist) {
                jGenerator.writeObject(bookmarkData);
            }
            jGenerator.writeEndArray();
            jGenerator.writeEndObject();
        }
        catch (IOException e) {
            logger.warn("Could not save bookmarks to file {}, error {}", (Object)filePath.toString(), (Object)e.toString());
        }
    }

    public void updateSeen(boolean seen, List<DatenFilm> list) {
        list.stream().filter(DatenFilm::isBookmarked).forEachOrdered(movie -> movie.getBookmark().setSeen(seen));
    }

    public void updateSeen(boolean seen, DatenFilm film) {
        if (film.isBookmarked()) {
            film.getBookmark().setSeen(seen);
        }
    }

    private BookmarkData findMovieInList(DatenFilm movie) {
        BookmarkData result = null;
        for (BookmarkData data : this.olist) {
            if (data.getDatenFilm() == null || !data.getDatenFilm().equals(movie)) continue;
            result = data;
            break;
        }
        return result;
    }

    public void updateBookMarksFromFilmList() {
        Iterator iterator2 = this.olist.iterator();
        ListeFilme listefilme = Daten.getInstance().getListeFilme();
        while (iterator2.hasNext()) {
            BookmarkData data = (BookmarkData)iterator2.next();
            DatenFilm filmdata = listefilme.getFilmByUrlAndSender(data.getUrl(), data.getSender());
            if (filmdata != null) {
                data.setDatenFilm(filmdata);
                filmdata.setBookmark(data);
                continue;
            }
            data.setDatenFilm(null);
        }
    }

    static {
        logger = LogManager.getLogger();
    }
}

