/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.config.CorrectionMode;
import com.amazon.randomcutforest.parkservices.config.ScoringStrategy;
import com.amazon.randomcutforest.parkservices.returntypes.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.preprocessor.Preprocessor;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.Neighbor;
import com.amazon.randomcutforest.statistics.Deviation;
import com.amazon.randomcutforest.util.Weighted;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public class PredictorCorrector {
    private static double DEFAULT_DIFFERENTIAL_FACTOR = 0.3;
    public static int DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS = 5;
    public static double DEFAULT_NOISE_SUPPRESSION_FACTOR = 1.0;
    public static double DEFAULT_MULTI_MODE_SAMPLING_RATE = 0.1;
    public static double DEFAULT_SAMPLING_SUPPORT = 0.1;
    public static int DEFAULT_RUN_ALLOWED = 2;
    protected static int NUMBER_OF_MODES = 2;
    protected static final int EXPECTED_INVERSE_DEPTH_INDEX = 0;
    protected static final int DISTANCE_INDEX = 1;
    double[] ignoreNearExpectedFromBelow;
    double[] ignoreNearExpectedFromAbove;
    double[] ignoreNearExpectedFromBelowByRatio;
    double[] ignoreNearExpectedFromAboveByRatio;
    protected int numberOfAttributors = DEFAULT_NUMBER_OF_MAX_ATTRIBUTORS;
    protected double[] lastScore = new double[NUMBER_OF_MODES];
    protected ScoringStrategy lastStrategy = ScoringStrategy.EXPECTED_INVERSE_DEPTH;
    protected BasicThresholder[] thresholders;
    protected int baseDimension;
    protected long randomSeed;
    protected double[] modeInformation;
    protected Deviation[] deviationsActual;
    protected Deviation[] deviationsExpected;
    protected double samplingRate = DEFAULT_MULTI_MODE_SAMPLING_RATE;
    protected double noiseFactor = DEFAULT_NOISE_SUPPRESSION_FACTOR;
    protected boolean autoAdjust = false;
    protected RCFComputeDescriptor lastDescriptor;
    protected int runLength;
    protected boolean ignoreDrift = false;
    protected double samplingSupport = DEFAULT_SAMPLING_SUPPORT;

    public PredictorCorrector(double timeDecay, double anomalyRate, boolean adjust, int baseDimension, long randomSeed) {
        this.thresholders = new BasicThresholder[NUMBER_OF_MODES];
        this.thresholders[0] = new BasicThresholder(timeDecay, anomalyRate, adjust);
        this.thresholders[1] = new BasicThresholder(timeDecay);
        this.baseDimension = baseDimension;
        this.randomSeed = randomSeed;
        this.autoAdjust = adjust;
        if (adjust) {
            this.deviationsActual = new Deviation[baseDimension];
            this.deviationsExpected = new Deviation[baseDimension];
            for (int i = 0; i < baseDimension; ++i) {
                this.deviationsActual[i] = new Deviation(timeDecay);
                this.deviationsExpected[i] = new Deviation(timeDecay);
            }
        }
        this.ignoreNearExpectedFromAbove = new double[baseDimension];
        this.ignoreNearExpectedFromBelow = new double[baseDimension];
        this.ignoreNearExpectedFromAboveByRatio = new double[baseDimension];
        this.ignoreNearExpectedFromBelowByRatio = new double[baseDimension];
    }

    public PredictorCorrector(BasicThresholder[] thresholders, Deviation[] deviations, int baseDimension, long randomSeed) {
        int i;
        CommonUtils.checkArgument((thresholders.length > 0 ? 1 : 0) != 0, (String)" cannot be empty");
        this.thresholders = new BasicThresholder[NUMBER_OF_MODES];
        int size = Math.min(thresholders.length, NUMBER_OF_MODES);
        for (int i2 = 0; i2 < size; ++i2) {
            this.thresholders[i2] = thresholders[i2];
        }
        Deviation deviation = thresholders[0].getPrimaryDeviation();
        for (i = size; i < NUMBER_OF_MODES; ++i) {
            this.thresholders[i] = new BasicThresholder(thresholders[0].getPrimaryDeviation().getDiscount());
        }
        this.deviationsActual = new Deviation[baseDimension];
        this.deviationsExpected = new Deviation[baseDimension];
        if (deviations != null) {
            CommonUtils.checkArgument((deviations.length == 2 * baseDimension ? 1 : 0) != 0, (String)"incorrect state");
            for (i = 0; i < baseDimension; ++i) {
                this.deviationsActual[i] = deviations[i];
            }
            for (i = 0; i < baseDimension; ++i) {
                this.deviationsExpected[i] = deviations[i + baseDimension];
            }
        }
        this.baseDimension = baseDimension;
        this.randomSeed = randomSeed;
        this.ignoreNearExpectedFromAbove = new double[baseDimension];
        this.ignoreNearExpectedFromBelow = new double[baseDimension];
        this.ignoreNearExpectedFromAboveByRatio = new double[baseDimension];
        this.ignoreNearExpectedFromBelowByRatio = new double[baseDimension];
    }

    public PredictorCorrector(BasicThresholder thresholder, int baseDimension) {
        this(new BasicThresholder[]{thresholder}, null, baseDimension, 0L);
    }

    protected double nextDouble() {
        Random random = new Random(this.randomSeed);
        this.randomSeed = random.nextLong();
        return random.nextDouble();
    }

    protected int maxContribution(DiVector diVector, int baseDimension, int startIndex) {
        int i;
        double val = 0.0;
        int index = startIndex;
        int position = diVector.getDimensions() + startIndex * baseDimension;
        for (i = 0; i < baseDimension; ++i) {
            val += diVector.getHighLowSum(i + position);
        }
        for (i = position + baseDimension; i < diVector.getDimensions(); i += baseDimension) {
            double sum = 0.0;
            for (int j = 0; j < baseDimension; ++j) {
                sum += diVector.getHighLowSum(i + j);
            }
            if (!(sum > val)) continue;
            val = sum;
            index = (i - diVector.getDimensions()) / baseDimension;
        }
        return index;
    }

    protected float[] getExpectedPoint(DiVector diVector, int position, int baseDimension, float[] point, RandomCutForest forest) {
        int[] likelyMissingIndices;
        if (baseDimension == 1) {
            likelyMissingIndices = new int[]{position};
        } else {
            int pick;
            double sum = 0.0;
            double[] values = new double[baseDimension];
            for (int i = 0; i < baseDimension; ++i) {
                values[i] = diVector.getHighLowSum(i + position);
                sum += values[i];
            }
            Arrays.sort(values);
            if (values[baseDimension - pick] < 0.1 * sum) {
                return null;
            }
            double threshold = Math.min(0.1 * sum, 0.1);
            for (pick = 1; pick < baseDimension && values[baseDimension - pick - 1] >= threshold; ++pick) {
            }
            if (pick > this.numberOfAttributors) {
                return null;
            }
            double cutoff = values[baseDimension - pick];
            likelyMissingIndices = new int[pick];
            int count = 0;
            for (int i = 0; i < baseDimension && count < pick; ++i) {
                if (!(diVector.getHighLowSum(i + position) >= cutoff) || count != 0 && !(diVector.getHighLowSum(i + position) > sum * 0.1)) continue;
                likelyMissingIndices[count++] = position + i;
            }
        }
        if ((double)likelyMissingIndices.length > 0.5 * (double)forest.getDimensions()) {
            return null;
        }
        return forest.imputeMissingValues(point, likelyMissingIndices.length, likelyMissingIndices);
    }

    protected boolean trigger(DiVector candidate, int difference, int baseDimension, DiVector ideal, RCFComputeDescriptor lastAnomalyDescriptor, double workingThreshold) {
        int dimensions = candidate.getDimensions();
        if (difference >= dimensions || ideal == null) {
            return true;
        }
        double lastAnomalyScore = lastAnomalyDescriptor.getRCFScore();
        double differentialRemainder = 0.0;
        for (int i = dimensions - difference; i < dimensions; ++i) {
            differentialRemainder += Math.abs(candidate.low[i] - ideal.low[i]) + Math.abs(candidate.high[i] - ideal.high[i]);
        }
        return differentialRemainder > DEFAULT_DIFFERENTIAL_FACTOR * lastAnomalyScore && differentialRemainder * (double)dimensions / (double)difference > 1.2 * workingThreshold;
    }

    public double[] getCorrectionOfLastAnomaly(TransformMethod transformMethod, int gap, RCFComputeDescriptor lastAnomalyDescriptor, double[] currentScale) {
        double[] deltaShift = lastAnomalyDescriptor.getDeltaShift();
        double[] answer = new double[currentScale.length];
        if (deltaShift != null && gap < 2 * lastAnomalyDescriptor.getShingleSize() && (transformMethod == TransformMethod.NORMALIZE || transformMethod == TransformMethod.SUBTRACT_MA)) {
            double factor = Math.exp((double)(-gap) * lastAnomalyDescriptor.getTransformDecay());
            for (int y = 0; y < answer.length; ++y) {
                answer[y] = currentScale[y] == 0.0 ? 0.0 : deltaShift[y] * factor / currentScale[y];
            }
        }
        return answer;
    }

    protected <P extends AnomalyDescriptor> float[] applyPastCorrector(float[] point, int gap, int shingleSize, int baseDimensions, double[] currentScale, TransformMethod transformMethod, RCFComputeDescriptor lastAnomalyDescriptor) {
        float[] correctedPoint = Arrays.copyOf(point, point.length);
        if (lastAnomalyDescriptor.getExpectedRCFPoint() != null) {
            float[] lastExpectedPoint = lastAnomalyDescriptor.getExpectedRCFPoint();
            float[] lastAnomalyPoint = lastAnomalyDescriptor.getRCFPoint();
            int lastRelativeIndex = lastAnomalyDescriptor.getRelativeIndex();
            if (gap < shingleSize) {
                System.arraycopy(lastExpectedPoint, gap * baseDimensions, correctedPoint, 0, point.length - gap * baseDimensions);
            }
            if (gap <= shingleSize && lastRelativeIndex == 0) {
                if (transformMethod == TransformMethod.DIFFERENCE || transformMethod == TransformMethod.NORMALIZE_DIFFERENCE) {
                    for (int y = 0; y < baseDimensions; ++y) {
                        int n = point.length - gap * baseDimensions + y;
                        correctedPoint[n] = correctedPoint[n] + (lastAnomalyPoint[point.length - baseDimensions + y] - lastExpectedPoint[point.length - baseDimensions + y]);
                    }
                }
                if (lastAnomalyDescriptor.getForestMode() == ForestMode.TIME_AUGMENTED) {
                    int n = point.length - (gap - 1) * baseDimensions - 1;
                    correctedPoint[n] = correctedPoint[n] + (lastAnomalyPoint[point.length - 1] - lastExpectedPoint[point.length - 1]);
                }
            }
        }
        double[] correctionVector = this.getCorrectionOfLastAnomaly(transformMethod, gap, lastAnomalyDescriptor, currentScale);
        int number = Math.min(gap, shingleSize);
        for (int y = 0; y < baseDimensions; ++y) {
            for (int j = 0; j < number; ++j) {
                int n = point.length - (number - j) * baseDimensions + y;
                correctedPoint[n] = (float)((double)correctedPoint[n] + correctionVector[y]);
            }
        }
        return correctedPoint;
    }

    protected <P extends AnomalyDescriptor> double centeredTransformPass(P result, float[] point) {
        double scaleFactor;
        int i;
        double maxFactor = 0.0;
        double[] scale = result.getScale();
        double[] shift = result.getShift();
        double[] deviations = result.getDeviations();
        for (i = 0; i < point.length && maxFactor == 0.0; ++i) {
            double shiftBase;
            scaleFactor = scale == null ? 1.0 : scale[i % this.baseDimension];
            double d = shiftBase = shift == null ? 0.0 : shift[i % this.baseDimension];
            if (!((double)Math.abs(point[i]) * scaleFactor > Preprocessor.DEFAULT_NORMALIZATION_PRECISION * (1.0 + Math.abs(shiftBase)))) continue;
            maxFactor = 1.0;
        }
        if (maxFactor > 0.0) {
            for (i = 0; i < this.baseDimension; ++i) {
                double deviation;
                scaleFactor = scale == null ? 1.0 : Math.abs(scale[i]);
                double z = (double)Math.abs(point[point.length - this.baseDimension + i]) * scaleFactor;
                double d = deviation = deviations == null ? 0.0 : Math.abs(deviations[i + this.baseDimension]);
                if (!(z > this.noiseFactor * deviation)) continue;
                maxFactor = deviation == 0.0 ? 1.0 : Math.min(1.0, Math.max(maxFactor, z / (3.0 * deviation)));
            }
        }
        return maxFactor;
    }

    double calculatePathDeviation(float[] point, int startPosition, int index, int baseDimension, boolean differenced) {
        int position = startPosition;
        double variation = 0.0;
        int observation = 0;
        while (position + index + baseDimension < point.length) {
            variation += differenced ? (double)Math.abs(point[position + index]) : (double)Math.abs(point[position + index] - point[position + baseDimension + index]);
            position += baseDimension;
            ++observation;
        }
        return observation == 0 ? 0.0 : variation / (double)observation;
    }

    protected <P extends AnomalyDescriptor> DiVector constructUncertaintyBox(float[] point, int startPosition, P result) {
        TransformMethod method = result.getTransformMethod();
        boolean differenced = method == TransformMethod.DIFFERENCE || method == TransformMethod.NORMALIZE_DIFFERENCE;
        double[] scale = result.getScale();
        double[] shift = result.getShift();
        int baseDimensions = result.getDimension() / result.getShingleSize();
        double[] gapLow = new double[baseDimensions];
        double[] gapHigh = new double[baseDimensions];
        for (int y = 0; y < baseDimensions; ++y) {
            double a = scale[y] * (double)point[startPosition + y];
            double shiftBase = shift[y];
            double shiftAmount = 0.0;
            if (shiftBase != 0.0) {
                shiftAmount += Preprocessor.DEFAULT_NORMALIZATION_PRECISION * (scale[y] + Math.abs(shiftBase));
            }
            double pathGap = this.calculatePathDeviation(point, startPosition, y, this.baseDimension, differenced);
            double noiseGap = this.noiseFactor * result.getDeviations()[this.baseDimension + y];
            double gap = Math.max(scale[y] * pathGap, noiseGap) + shiftAmount + Preprocessor.DEFAULT_NORMALIZATION_PRECISION;
            gapLow[y] = Math.max(Math.max(this.ignoreNearExpectedFromBelow[y], this.ignoreNearExpectedFromBelowByRatio[y] * Math.abs(a + shiftBase)), gap);
            gapHigh[y] = Math.max(Math.max(this.ignoreNearExpectedFromAbove[y], this.ignoreNearExpectedFromAboveByRatio[y] * Math.abs(a + shiftBase)), gap);
        }
        return new DiVector(gapHigh, gapLow);
    }

    protected boolean withinGap(DiVector gap, int startPosition, double[] scale, float[] point, float[] otherPoint, int baseDimension) {
        boolean answer = false;
        for (int y = 0; y < baseDimension && !answer; ++y) {
            double a = scale[y] * (double)point[startPosition + y];
            double b = scale[y] * (double)otherPoint[startPosition + y];
            boolean lower = a < b - gap.low[y];
            boolean upper = a > b + gap.high[y];
            answer = lower || upper;
        }
        return !answer;
    }

    protected <P extends AnomalyDescriptor> boolean explainedByConditionalField(DiVector uncertaintyBox, float[] point, float[] correctedPoint, int startPosition, P result, RandomCutForest forest) {
        List list = forest.getNearNeighborsInSample(correctedPoint);
        double averageDistance = list.stream().mapToDouble(e -> e.distance).average().getAsDouble();
        double weight = 0.0;
        for (Neighbor e2 : list) {
            if (!(e2.distance < 1.1 * averageDistance) || !this.withinGap(uncertaintyBox, startPosition, result.getScale(), point, e2.point, point.length / result.getShingleSize())) continue;
            weight += (double)e2.count;
        }
        return weight >= this.samplingSupport * (double)forest.getNumberOfTrees();
    }

    protected int populateScores(ScoringStrategy strategy, float[] point, RandomCutForest forest, double[] scoreVector, DiVector[] attributionVector) {
        if (strategy != ScoringStrategy.DISTANCE) {
            scoreVector[0] = forest.getAnomalyScore(point);
            if (strategy == ScoringStrategy.MULTI_MODE || strategy == ScoringStrategy.MULTI_MODE_RECALL) {
                attributionVector[1] = forest.getSimpleDensity((float[])point).distances;
                scoreVector[1] = attributionVector[1].getHighLowSum();
            }
            return 0;
        }
        attributionVector[1] = forest.getSimpleDensity((float[])point).distances;
        scoreVector[1] = attributionVector[1].getHighLowSum();
        return 1;
    }

    DiVector getCachedAttribution(int choice, float[] point, DiVector[] attributionVector, RandomCutForest forest) {
        if (attributionVector[choice] == null) {
            CommonUtils.checkArgument((choice == 0 ? 1 : 0) != 0, (String)"incorrect cached state of scores");
            attributionVector[0] = forest.getAnomalyAttribution(point);
        }
        return attributionVector[choice];
    }

    DiVector getNewAttribution(int choice, float[] point, RandomCutForest forest) {
        if (choice == 0) {
            return forest.getAnomalyAttribution(point);
        }
        return forest.getSimpleDensity((float[])point).distances;
    }

    double getNewScore(int choice, float[] point, RandomCutForest forest) {
        if (choice == 0) {
            return forest.getAnomalyScore(point);
        }
        return forest.getSimpleDensity((float[])point).distances.getHighLowSum();
    }

    protected Weighted<Double> getThresholdAndGrade(ScoringStrategy strategy, int choice, double[] scoreVector, TransformMethod method, int dimension, int shingleSize) {
        if (choice == 0) {
            return this.thresholders[0].getThresholdAndGrade(scoreVector[0], method, dimension, shingleSize);
        }
        return this.thresholders[1].getPrimaryThresholdAndGrade(scoreVector[1]);
    }

    protected void saveScores(ScoringStrategy strategy, int choice, double[] scoreVector, double correctedScore, TransformMethod method, int shingleSize) {
        if (scoreVector[0] > 0.0) {
            double temp = choice == 0 ? correctedScore : scoreVector[0];
            double last = strategy == this.lastStrategy ? this.lastScore[0] : 0.0;
            this.thresholders[0].update(scoreVector[0], temp, last, method);
        }
        if (scoreVector[1] > 0.0) {
            this.thresholders[1].update(scoreVector[1], this.lastScore[1]);
        }
        if (shingleSize > 1) {
            for (int i = 0; i < NUMBER_OF_MODES; ++i) {
                this.lastScore[i] = scoreVector[i];
            }
        }
    }

    protected <P extends AnomalyDescriptor> P detect(P result, RCFComputeDescriptor lastSignificantDescriptor, RandomCutForest forest) {
        double originalThreshold;
        if (result.getRCFPoint() == null) {
            return result;
        }
        float[] point = result.getRCFPoint();
        ScoringStrategy strategy = result.getScoringStrategy();
        double[] scoreVector = new double[NUMBER_OF_MODES];
        DiVector[] attributionVector = new DiVector[NUMBER_OF_MODES];
        int originalChoice = this.populateScores(strategy, point, forest, scoreVector, attributionVector);
        DiVector attribution = null;
        double score = scoreVector[originalChoice];
        result.setRCFScore(score);
        if (score == 0.0) {
            return result;
        }
        long internalTimeStamp = result.getInternalTimeStamp();
        int shingleSize = result.getShingleSize();
        Weighted<Double> thresholdAndGrade = this.getThresholdAndGrade(strategy, originalChoice, scoreVector, result.getTransformMethod(), point.length, shingleSize);
        double workingThreshold = originalThreshold = ((Double)thresholdAndGrade.index).doubleValue();
        double workingGrade = thresholdAndGrade.weight;
        result.setThreshold(originalThreshold);
        boolean candidate = false;
        if (workingGrade > 0.0 && this.lastDescriptor != null) {
            if (score > this.lastDescriptor.getRCFScore()) {
                candidate = true;
            } else {
                double runDiscount = Math.max(workingThreshold, this.lastDescriptor.getThreshold()) * (1.0 + Math.max(0.2, (double)this.runLength / (2.0 * (double)Math.max(10, shingleSize))));
                if (this.lastDescriptor.getRCFScore() - this.lastDescriptor.getThreshold() > score - runDiscount) {
                    candidate = true;
                }
            }
        }
        if (workingGrade > 0.0 && strategy == ScoringStrategy.MULTI_MODE) {
            Weighted<Double> temp = this.thresholders[1].getPrimaryThresholdAndGrade(scoreVector[1]);
            if ((Double)temp.index > 0.0 && temp.weight == 0.0f) {
                workingGrade = 0.0;
                result.setCorrectionMode(CorrectionMode.MULTI_MODE);
            }
        }
        if (this.lastDescriptor != null && this.lastDescriptor.getExpectedRCFPoint() != null) {
            lastSignificantDescriptor = this.lastDescriptor;
        }
        int gap = (int)(internalTimeStamp - lastSignificantDescriptor.getInternalTimeStamp());
        int difference = gap * this.baseDimension;
        float[] correctedPoint = null;
        double correctedScore = score;
        float[] expectedPoint = null;
        boolean inHighScoreRegion = false;
        int index = 0;
        int relative = gap >= shingleSize ? -shingleSize : -gap;
        int choice = originalChoice;
        if (strategy == ScoringStrategy.MULTI_MODE_RECALL && workingGrade == 0.0 && gap >= shingleSize) {
            Weighted<Double> temp = this.thresholders[1].getPrimaryThresholdAndGrade(scoreVector[1]);
            choice = 1;
            correctedScore = scoreVector[1];
            workingGrade = temp.weight;
            workingThreshold = (Double)temp.index;
        }
        correctedPoint = this.applyPastCorrector(point, gap, shingleSize, point.length / shingleSize, result.getScale(), result.getTransformMethod(), lastSignificantDescriptor);
        if (workingGrade > 0.0 && (workingGrade *= this.centeredTransformPass(result, correctedPoint)) == 0.0) {
            result.setCorrectionMode(CorrectionMode.NOISE);
        }
        if (workingGrade > 0.0) {
            inHighScoreRegion = true;
            if (!Arrays.equals(correctedPoint, point)) {
                int tempIndex;
                int tempStartPosition;
                float[] tempPoint;
                attribution = this.getNewAttribution(choice, correctedPoint, forest);
                correctedScore = attribution.getHighLowSum();
                if (correctedScore > workingThreshold && (tempPoint = this.getExpectedPoint(attribution, tempStartPosition = point.length + ((tempIndex = this.maxContribution(attribution, point.length / shingleSize, relative) + 1) - 1) * point.length / shingleSize, point.length / shingleSize, correctedPoint, forest)) != null) {
                    DiVector tempAttribution = this.getNewAttribution(choice, tempPoint, forest);
                    correctedScore = tempAttribution.getHighLowSum();
                    if (!this.trigger(attribution, difference, point.length / shingleSize, tempAttribution, lastSignificantDescriptor, workingThreshold)) {
                        workingGrade = 0.0;
                        result.setCorrectionMode(CorrectionMode.ANOMALY_IN_SHINGLE);
                    }
                }
            } else {
                attribution = this.getCachedAttribution(choice, point, attributionVector, forest);
            }
            if (workingGrade > 0.0 && result.getScale() != null) {
                index = shingleSize == 1 ? 0 : this.maxContribution(attribution, point.length / shingleSize, relative) + 1;
                int startPosition = point.length + (index - 1) * point.length / shingleSize;
                DiVector uncertaintyBox = this.constructUncertaintyBox(point, startPosition, result);
                if (this.autoAdjust && this.explainedByConditionalField(uncertaintyBox, point, correctedPoint, startPosition, result, forest)) {
                    workingGrade = 0.0;
                    result.setCorrectionMode(CorrectionMode.CONDITIONAL_FORECAST);
                } else {
                    expectedPoint = this.getExpectedPoint(attribution, startPosition, point.length / shingleSize, correctedPoint, forest);
                    if (expectedPoint != null) {
                        if (difference < point.length) {
                            DiVector newAttribution = this.getNewAttribution(choice, expectedPoint, forest);
                            correctedScore = newAttribution.getHighLowSum();
                            if (!this.trigger(attribution, difference, point.length / shingleSize, newAttribution, lastSignificantDescriptor, workingThreshold)) {
                                workingGrade = 0.0;
                                result.setCorrectionMode(CorrectionMode.ANOMALY_IN_SHINGLE);
                            }
                        } else {
                            correctedScore = this.getNewScore(choice, point, forest);
                        }
                        if (workingGrade > 0.0 && this.withinGap(uncertaintyBox, startPosition, result.getScale(), point, expectedPoint, point.length / shingleSize)) {
                            workingGrade = 0.0;
                            result.setCorrectionMode(CorrectionMode.FORECAST);
                        }
                    }
                }
            }
            if (workingGrade == 0.0) {
                correctedScore = score;
            }
        }
        if (candidate) {
            if (this.autoAdjust) {
                for (int y = 0; y < this.baseDimension; ++y) {
                    this.deviationsActual[y].update((double)point[point.length - this.baseDimension + y]);
                    if (expectedPoint == null) continue;
                    this.deviationsExpected[y].update((double)expectedPoint[point.length - this.baseDimension + y]);
                }
                if (this.runLength > DEFAULT_RUN_ALLOWED && workingGrade > 0.0) {
                    boolean within = true;
                    for (int y = 0; y < this.baseDimension && within; ++y) {
                        boolean bl = within = Math.abs(this.deviationsActual[y].getMean() - (double)point[point.length - this.baseDimension + y]) < Math.max(2.0 * this.deviationsActual[y].getDeviation(), this.noiseFactor * result.getDeviations()[this.baseDimension + y] / result.getScale()[y]);
                        if (expectedPoint == null) continue;
                        double u = Math.abs(this.deviationsExpected[y].getMean() - (double)expectedPoint[point.length - this.baseDimension + y]);
                        within = within && Math.abs(this.deviationsExpected[y].getMean() - (double)expectedPoint[point.length - this.baseDimension + y]) < 2.0 * Math.max(this.deviationsExpected[y].getDeviation(), this.deviationsActual[y].getDeviation()) + 0.1 * Math.abs(this.deviationsActual[y].getMean() - this.deviationsExpected[y].getMean());
                    }
                    if (within) {
                        result.setCorrectionMode(CorrectionMode.DATA_DRIFT);
                        workingGrade = 0.0;
                    }
                }
            }
            if (this.ignoreDrift && workingGrade > 0.0 && this.runLength > 0 && gap < shingleSize) {
                result.setCorrectionMode(CorrectionMode.ALERT_ONCE);
                workingGrade = 0.0;
            }
        }
        result.setAnomalyGrade(workingGrade);
        result.setInHighScoreRegion(inHighScoreRegion);
        if (workingGrade > 0.0) {
            if (expectedPoint != null) {
                result.setExpectedRCFPoint(expectedPoint);
            }
            attribution.renormalize(result.getRCFScore());
            result.setStartOfAnomaly(true);
            result.setAttribution(attribution);
            result.setRelativeIndex(index);
            ++this.runLength;
        } else if (result.getCorrectionMode() == CorrectionMode.NONE) {
            this.runLength = 0;
            if (this.autoAdjust) {
                for (int y = 0; y < this.baseDimension; ++y) {
                    this.deviationsActual[y].reset();
                    this.deviationsExpected[y].reset();
                }
            }
        } else if (this.runLength > 0) {
            ++this.runLength;
        }
        this.lastDescriptor = result.copyOf();
        this.saveScores(strategy, choice, scoreVector, correctedScore, result.getTransformMethod(), shingleSize);
        return result;
    }

    public void setZfactor(double factor) {
        for (int i = 0; i < this.thresholders.length; ++i) {
            this.thresholders[i].setZfactor(factor);
        }
    }

    public void setAbsoluteThreshold(double lower) {
        this.thresholders[0].setAbsoluteThreshold(lower);
    }

    public void setScoreDifferencing(double persistence) {
        this.thresholders[0].setScoreDifferencing(persistence);
    }

    public void setInitialThreshold(double initial) {
        this.thresholders[0].setInitialThreshold(initial);
    }

    public void setNumberOfAttributors(int numberOfAttributors) {
        CommonUtils.checkArgument((numberOfAttributors > 0 ? 1 : 0) != 0, (String)"cannot be negative");
        this.numberOfAttributors = numberOfAttributors;
    }

    public int getNumberOfAttributors() {
        return this.numberOfAttributors;
    }

    public double[] getLastScore() {
        return this.lastScore;
    }

    public void setLastScore(double[] score) {
        if (score != null) {
            System.arraycopy(score, 0, this.lastScore, 0, Math.min(NUMBER_OF_MODES, score.length));
        }
    }

    void validateIgnore(double[] shift, int length) {
        CommonUtils.checkArgument((shift.length == length ? 1 : 0) != 0, () -> String.format(Locale.ROOT, "has to be of length %d but is %d", length, shift.length));
        for (double element : shift) {
            CommonUtils.checkArgument((element >= 0.0 ? 1 : 0) != 0, (String)"has to be non-negative");
        }
    }

    public void setIgnoreNearExpectedFromAbove(double[] ignoreSimilarShift) {
        if (ignoreSimilarShift != null) {
            this.validateIgnore(ignoreSimilarShift, this.baseDimension);
            System.arraycopy(ignoreSimilarShift, 0, this.ignoreNearExpectedFromAbove, 0, this.baseDimension);
        }
    }

    public void setIgnoreNearExpectedFromBelow(double[] ignoreSimilarShift) {
        if (ignoreSimilarShift != null) {
            this.validateIgnore(ignoreSimilarShift, this.baseDimension);
            System.arraycopy(ignoreSimilarShift, 0, this.ignoreNearExpectedFromBelow, 0, this.baseDimension);
        }
    }

    public void setIgnoreNearExpectedFromAboveByRatio(double[] ignoreSimilarShift) {
        if (ignoreSimilarShift != null) {
            this.validateIgnore(ignoreSimilarShift, this.baseDimension);
            System.arraycopy(ignoreSimilarShift, 0, this.ignoreNearExpectedFromAboveByRatio, 0, this.baseDimension);
        }
    }

    public void setIgnoreNearExpectedFromBelowByRatio(double[] ignoreSimilarShift) {
        if (ignoreSimilarShift != null) {
            this.validateIgnore(ignoreSimilarShift, this.baseDimension);
            System.arraycopy(ignoreSimilarShift, 0, this.ignoreNearExpectedFromBelowByRatio, 0, this.baseDimension);
        }
    }

    public void setIgnoreNearExpected(double[] ignoreSimilarShift) {
        if (ignoreSimilarShift != null) {
            this.validateIgnore(ignoreSimilarShift, 4 * this.baseDimension);
            System.arraycopy(ignoreSimilarShift, 0, this.ignoreNearExpectedFromAbove, 0, this.baseDimension);
            System.arraycopy(ignoreSimilarShift, this.baseDimension, this.ignoreNearExpectedFromBelow, 0, this.baseDimension);
            System.arraycopy(ignoreSimilarShift, 2 * this.baseDimension, this.ignoreNearExpectedFromAboveByRatio, 0, this.baseDimension);
            System.arraycopy(ignoreSimilarShift, 3 * this.baseDimension, this.ignoreNearExpectedFromBelowByRatio, 0, this.baseDimension);
        }
    }

    public double[] getIgnoreNearExpected() {
        double[] answer = new double[4 * this.baseDimension];
        System.arraycopy(this.ignoreNearExpectedFromAbove, 0, answer, 0, this.baseDimension);
        System.arraycopy(this.ignoreNearExpectedFromBelow, 0, answer, this.baseDimension, this.baseDimension);
        System.arraycopy(this.ignoreNearExpectedFromAboveByRatio, 0, answer, 2 * this.baseDimension, this.baseDimension);
        System.arraycopy(this.ignoreNearExpectedFromBelowByRatio, 0, answer, 3 * this.baseDimension, this.baseDimension);
        return answer;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public BasicThresholder[] getThresholders() {
        return this.thresholders;
    }

    public int getBaseDimension() {
        return this.baseDimension;
    }

    public ScoringStrategy getLastStrategy() {
        return this.lastStrategy;
    }

    public void setLastStrategy(ScoringStrategy strategy) {
        this.lastStrategy = strategy;
    }

    public Deviation[] getDeviations() {
        int i;
        if (!this.autoAdjust) {
            return null;
        }
        CommonUtils.checkArgument((this.deviationsActual.length == this.deviationsExpected.length ? 1 : 0) != 0, (String)"incorrect state");
        CommonUtils.checkArgument((this.deviationsActual.length == this.baseDimension ? 1 : 0) != 0, (String)"length should be base dimension");
        Deviation[] answer = new Deviation[2 * this.deviationsActual.length];
        for (i = 0; i < this.deviationsActual.length; ++i) {
            answer[i] = this.deviationsActual[i];
        }
        for (i = 0; i < this.deviationsExpected.length; ++i) {
            answer[i + this.deviationsActual.length] = this.deviationsExpected[i];
        }
        return answer;
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(double samplingRate) {
        CommonUtils.checkArgument((samplingRate > 0.0 ? 1 : 0) != 0, (String)" cannot be negative");
        CommonUtils.checkArgument((samplingRate < 1.0 ? 1 : 0) != 0, (String)" has to be in [0,1)");
        this.samplingRate = samplingRate;
    }

    public double[] getModeInformation() {
        return this.modeInformation;
    }

    public void setModeInformation(double[] modeInformation) {
    }

    public boolean isAutoAdjust() {
        return this.autoAdjust;
    }

    public void setAutoAdjust(boolean autoAdjust) {
        this.autoAdjust = autoAdjust;
    }

    public double getNoiseFactor() {
        return this.noiseFactor;
    }

    public void setNoiseFactor(double noiseFactor) {
        this.noiseFactor = noiseFactor;
    }

    public void setIgnoreDrift(boolean ignoreDrift) {
        this.ignoreDrift = ignoreDrift;
    }

    public boolean isIgnoreDrift() {
        return this.ignoreDrift;
    }

    public void setLastDescriptor(RCFComputeDescriptor lastDescriptor) {
        this.lastDescriptor = lastDescriptor.copyOf();
    }

    public RCFComputeDescriptor getLastDescriptor() {
        return this.lastDescriptor;
    }

    public int getRunLength() {
        return this.runLength;
    }

    public void setRunLength(int runLength) {
        this.runLength = runLength;
    }

    public double getSamplingSupport() {
        return this.samplingSupport;
    }

    public void setSamplingSupport(double sampling) {
        CommonUtils.checkArgument((sampling >= 0.0 ? 1 : 0) != 0, (String)" cannot be negative ");
        CommonUtils.checkArgument((sampling < 2.0 * DEFAULT_SAMPLING_SUPPORT ? 1 : 0) != 0, (String)(" cannot be more than " + 2.0 * DEFAULT_SAMPLING_SUPPORT));
    }
}

