/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.emrserverless.model.ResourceUtilization;

@SdkInternalApi
public class ResourceUtilizationMarshaller {
    private static final MarshallingInfo<Double> VCPUHOUR_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vCPUHour").build();
    private static final MarshallingInfo<Double> MEMORYGBHOUR_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memoryGBHour").build();
    private static final MarshallingInfo<Double> STORAGEGBHOUR_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storageGBHour").build();
    private static final ResourceUtilizationMarshaller instance = new ResourceUtilizationMarshaller();

    public static ResourceUtilizationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceUtilization resourceUtilization, ProtocolMarshaller protocolMarshaller) {
        if (resourceUtilization == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceUtilization.getVCPUHour(), VCPUHOUR_BINDING);
            protocolMarshaller.marshall(resourceUtilization.getMemoryGBHour(), MEMORYGBHOUR_BINDING);
            protocolMarshaller.marshall(resourceUtilization.getStorageGBHour(), STORAGEGBHOUR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

