/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.AdditiveValue;
import com.google.uzaygezen.core.ranges.Range;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Predicate;

public class FilteredIndexRange<F, R> {
    private final R indexRange;
    private final F filter;
    private final boolean potentialOverSelectivity;
    private static final Function<FilteredIndexRange<?, ?>, Object> FILTER_EXTRACTOR = new Function<FilteredIndexRange<?, ?>, Object>(){

        @Override
        public Object apply(FilteredIndexRange<?, ?> from) {
            return from.getFilter();
        }
    };
    private static final Predicate<FilteredIndexRange<?, ?>> IS_POTENTIAL_OVER_SELECTIVITY = new Predicate<FilteredIndexRange<?, ?>>(){

        @Override
        public boolean apply(FilteredIndexRange<?, ?> from) {
            return ((FilteredIndexRange)from).potentialOverSelectivity;
        }
    };

    public FilteredIndexRange(R indexRange, F filter, boolean potentialOverSelectivity) {
        this.indexRange = Preconditions.checkNotNull(indexRange, "range");
        this.filter = Preconditions.checkNotNull(filter, "filter");
        this.potentialOverSelectivity = potentialOverSelectivity;
    }

    public static <F, R> FilteredIndexRange<F, R> of(R indexRange, F filter, boolean potentialOverSelectivity) {
        return new FilteredIndexRange<F, R>(indexRange, filter, potentialOverSelectivity);
    }

    public R getIndexRange() {
        return this.indexRange;
    }

    public F getFilter() {
        return this.filter;
    }

    public boolean isPotentialOverSelectivity() {
        return this.potentialOverSelectivity;
    }

    public int hashCode() {
        return Objects.hashCode(this.indexRange, this.filter, this.potentialOverSelectivity);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilteredIndexRange)) {
            return false;
        }
        FilteredIndexRange other = (FilteredIndexRange)o;
        return this.indexRange.equals(other.indexRange) && this.filter.equals(other.filter) && this.potentialOverSelectivity == other.potentialOverSelectivity;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static <F, T, V, R extends Range<T, V>> Function<FilteredIndexRange<F, R>, F> filterExtractor() {
        return FILTER_EXTRACTOR;
    }

    public static <F, R> Predicate<FilteredIndexRange<F, R>> potentialOverSelectivityExtractor() {
        return IS_POTENTIAL_OVER_SELECTIVITY;
    }

    public static <F, T, V extends AdditiveValue<V>, R extends Range<T, V>> V sumRangeLengths(Iterable<FilteredIndexRange<F, R>> iterable, V zero2) {
        AdditiveValue sum = (AdditiveValue)zero2.clone();
        for (FilteredIndexRange<F, R> r : iterable) {
            sum.add(((Range)r.getIndexRange()).length());
        }
        return (V)sum;
    }
}

