/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlAsOperator
extends SqlSpecialOperator {
    public SqlAsOperator() {
        this("AS", SqlKind.AS, 20, true, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    protected SqlAsOperator(String name, SqlKind kind, int prec, boolean leftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, prec, leftAssoc, returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() >= 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.AS);
        Object op0 = call.operand(0);
        boolean measure = ((SqlNode)op0).getKind() == SqlKind.MEASURE;
        Object op01 = measure ? ((SqlCall)op0).operand(0) : op0;
        ((SqlNode)op01).unparse(writer, leftPrec, this.getLeftPrec());
        boolean needsSpace = true;
        writer.setNeedWhitespace(true);
        if (writer.getDialect().allowsAs()) {
            writer.sep("AS");
            if (measure) {
                writer.sep("MEASURE");
            }
            writer.setNeedWhitespace(true);
        }
        ((SqlNode)call.operand(1)).unparse(writer, this.getRightPrec(), rightPrec);
        if (call.operandCount() > 2) {
            SqlWriter.Frame frame1 = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE, "(", ")");
            for (SqlNode operand : Util.skip(call.getOperandList(), 2)) {
                writer.sep(",", false);
                operand.unparse(writer, 0, 0);
            }
            writer.endList(frame1);
        }
        writer.endList(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope2, SqlValidatorScope operandScope) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        assert (operands.get(1) instanceof SqlIdentifier);
        operands.get(0).validateExpr(validator, scope2);
        SqlIdentifier id = (SqlIdentifier)operands.get(1);
        if (!id.isSimple()) {
            throw validator.newValidationError(id, Static.RESOURCE.aliasMustBeSimpleIdentifier());
        }
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor2, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            argHandler.visitChild(visitor2, call, 0, (SqlNode)call.operand(0));
        } else {
            super.acceptCall(visitor2, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        RelDataType nodeType = validator.deriveType(scope2, (SqlNode)call.operand(0));
        Objects.requireNonNull(nodeType, "nodeType");
        return this.validateOperands(validator, scope2, call);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0);
    }
}

