/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;
import shaded.com.google.common.collect.ImmutableList;

public class ArrayElementOperandTypeChecker
implements SqlOperandTypeChecker {
    private final boolean arrayMayBeNull;
    private final boolean elementMayBeNull;

    public ArrayElementOperandTypeChecker(boolean arrayMayBeNull, boolean elementMayBeNull) {
        this.arrayMayBeNull = arrayMayBeNull;
        this.elementMayBeNull = elementMayBeNull;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode op0 = callBinding.operand(0);
        RelDataType arrayType = SqlTypeUtil.deriveType(callBinding, op0);
        if (!this.arrayMayBeNull && arrayType.getSqlTypeName() == SqlTypeName.NULL) {
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(op0, Static.RESOURCE.nullIllegal());
            }
            return false;
        }
        if (!OperandTypes.ARRAY.checkSingleOperandType(callBinding, op0, 0, throwOnFailure)) {
            return false;
        }
        RelDataType arrayComponentType = NonNullableAccessors.getComponentTypeOrThrow(SqlTypeUtil.deriveType(callBinding, op0));
        SqlNode op1 = callBinding.operand(1);
        RelDataType elementType = SqlTypeUtil.deriveType(callBinding, op1);
        if (!this.elementMayBeNull && elementType.getSqlTypeName() == SqlTypeName.NULL) {
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(op1, Static.RESOURCE.nullIllegal());
            }
            return false;
        }
        RelDataType biggest = callBinding.getTypeFactory().leastRestrictive(ImmutableList.of(arrayComponentType, elementType));
        if (biggest == null) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.typeNotComparable(arrayComponentType.toString(), elementType.toString()));
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<ARRAY> " + opName + " <ARRAY>";
    }
}

