/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OrderByScope
extends DelegatingScope {
    private final SqlNodeList orderList;
    private final SqlSelect select;

    OrderByScope(SqlValidatorScope parent, SqlNodeList orderList, SqlSelect select) {
        super(parent);
        this.orderList = orderList;
        this.select = select;
    }

    @Override
    public SqlNode getNode() {
        return this.orderList;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result2) {
        SqlValidatorNamespace ns = this.validator.getNamespaceOrThrow(this.select);
        this.addColumnNames(ns, result2);
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        SqlQualified qualified;
        if (identifier.isSimple() && this.validator.config().conformance().isSortByAlias() && (qualified = this.qualifyUsingAlias(this.select, identifier)) != null) {
            return qualified;
        }
        return super.fullyQualify(identifier);
    }

    @Override
    public @Nullable RelDataType resolveColumn(String name, SqlNode ctx) {
        SqlValidatorNamespace selectNs = this.validator.getNamespaceOrThrow(this.select);
        RelDataType rowType = selectNs.getRowType();
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        RelDataTypeField field = nameMatcher.field(rowType, name);
        if (field != null) {
            return field.getType();
        }
        SqlValidatorScope selectScope = this.validator.getSelectScope(this.select);
        return selectScope.resolveColumn(name, ctx);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        SqlNode expanded = this.validator.expandOrderExpr(this.select, expr);
        this.parent.validateExpr(expanded);
    }
}

