/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRules;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelNodes;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.MeasureRules;
import org.apache.calcite.rel.rules.MultiJoinOptimizeBushyRule;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.Util;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.common.collect.Lists;

public class Programs {
    @Deprecated
    public static final ImmutableList<RelOptRule> CALC_RULES = RelOptRules.CALC_RULES;
    public static final Program CALC_PROGRAM = Programs.calc(DefaultRelMetadataProvider.INSTANCE);
    public static final Program SUB_QUERY_PROGRAM = Programs.subQuery(DefaultRelMetadataProvider.INSTANCE);
    public static final ImmutableSet<RelOptRule> RULE_SET = ImmutableSet.of(EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, EnumerableRules.ENUMERABLE_JOIN_RULE, EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, EnumerableRules.ENUMERABLE_CORRELATE_RULE, EnumerableRules.ENUMERABLE_PROJECT_RULE, EnumerableRules.ENUMERABLE_FILTER_RULE, new RelOptRule[]{EnumerableRules.ENUMERABLE_AGGREGATE_RULE, EnumerableRules.ENUMERABLE_SORT_RULE, EnumerableRules.ENUMERABLE_LIMIT_RULE, EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_MERGE_UNION_RULE, EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_MATCH_RULE, CoreRules.PROJECT_TO_SEMI_JOIN, CoreRules.JOIN_ON_UNIQUE_TO_SEMI_JOIN, CoreRules.JOIN_TO_SEMI_JOIN, CoreRules.MATCH, CalciteSystemProperty.COMMUTE.value() != false ? CoreRules.JOIN_ASSOCIATE : CoreRules.PROJECT_MERGE, CoreRules.AGGREGATE_STAR_TABLE, CoreRules.AGGREGATE_PROJECT_STAR_TABLE, CoreRules.FILTER_SCAN, CoreRules.FILTER_PROJECT_TRANSPOSE, CoreRules.FILTER_INTO_JOIN, CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES, CoreRules.AGGREGATE_REDUCE_FUNCTIONS, CoreRules.FILTER_AGGREGATE_TRANSPOSE, CoreRules.JOIN_COMMUTE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, CoreRules.SORT_PROJECT_TRANSPOSE});

    private Programs() {
    }

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Util.transform(Arrays.asList(ruleSets), Programs::of);
    }

    public static List<Program> listOf(List<RuleSet> ruleSets) {
        return Util.transform(ruleSets, Programs::of);
    }

    public static Program ofRules(RelOptRule ... rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program ofRules(Iterable<? extends RelOptRule> rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program sequence(Program ... programs) {
        return new SequenceProgram(ImmutableList.copyOf(programs));
    }

    public static Program conditional(Predicate<RelNode> predicate, Program program) {
        return new ConditionalProgram(predicate, program);
    }

    public static Program hep(Iterable<? extends RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule relOptRule : rules) {
            builder.addRuleInstance(relOptRule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(HepProgram hepProgram, boolean noDag, RelMetadataProvider metadataProvider) {
        Objects.requireNonNull(metadataProvider, "metadataProvider");
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
            ArrayList<RelMetadataProvider> list = Lists.newArrayList(metadataProvider);
            hepPlanner.registerMetadataProviders(list);
            for (RelOptMaterialization materialization : materializations) {
                hepPlanner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                hepPlanner.addLattice(lattice);
            }
            RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
            rel.getCluster().setMetadataProvider(plannerChain);
            hepPlanner.setRoot(rel);
            return hepPlanner.findBestExp();
        };
    }

    public static Program heuristicJoinOrder(Iterable<? extends RelOptRule> rules, boolean bushy, int minJoinCount) {
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            Program program;
            int joinCount = RelOptUtil.countJoins(rel);
            if (joinCount < minJoinCount) {
                program = Programs.ofRules(rules);
            } else {
                HepProgram hep = new HepProgramBuilder().addRuleInstance(CoreRules.FILTER_INTO_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance(CoreRules.JOIN_TO_MULTI_JOIN).build();
                Program program1 = Programs.of(hep, false, DefaultRelMetadataProvider.INSTANCE);
                ArrayList<MultiJoinOptimizeBushyRule> list = Lists.newArrayList(rules);
                list.removeAll(ImmutableList.of(CoreRules.JOIN_COMMUTE, CoreRules.JOIN_ASSOCIATE, JoinPushThroughJoinRule.LEFT, JoinPushThroughJoinRule.RIGHT));
                list.add((MultiJoinOptimizeBushyRule)(bushy ? CoreRules.MULTI_JOIN_OPTIMIZE_BUSHY : CoreRules.MULTI_JOIN_OPTIMIZE));
                Program program2 = Programs.ofRules(list);
                program = Programs.sequence(program1, program2);
            }
            return program.run(planner, rel, requiredOutputTraits, materializations, lattices);
        };
    }

    public static Program calc(RelMetadataProvider metadataProvider) {
        return Programs.hep(RelOptRules.CALC_RULES, true, metadataProvider);
    }

    @Deprecated
    public static Program subquery(RelMetadataProvider metadataProvider) {
        return Programs.subQuery(metadataProvider);
    }

    public static Program subQuery(RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        builder.addRuleCollection(ImmutableList.of(CoreRules.FILTER_SUB_QUERY_TO_CORRELATE, CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE, CoreRules.JOIN_SUB_QUERY_TO_CORRELATE, CoreRules.PROJECT_OVER_SUM_TO_SUM0_RULE));
        return Programs.of(builder.build(), true, metadataProvider);
    }

    public static Program measure(RelMetadataProvider metadataProvider) {
        return Programs.conditional(Programs::containsAggM2v, Programs.sequence(Programs.hep(MeasureRules.rules(), true, metadataProvider), Programs.subQuery(metadataProvider), new DecorrelateProgram()));
    }

    private static boolean containsAggM2v(RelNode rel) {
        return RelNodes.contains(rel, aggCall -> aggCall.getAggregation().kind == SqlKind.AGG_M2V, RexUtil.find(ImmutableSet.of(SqlKind.AGG_M2V, SqlKind.M2V)));
    }

    @Deprecated
    public static Program getProgram() {
        return (planner, rel, requiredOutputTraits, materializations, lattices) -> Nullness.castNonNull(null);
    }

    public static Program standard() {
        return Programs.standard(DefaultRelMetadataProvider.INSTANCE, true);
    }

    public static Program standard(RelMetadataProvider metadataProvider) {
        return Programs.standard(metadataProvider, true);
    }

    public static Program standard(RelMetadataProvider metadataProvider, boolean enableFieldTrimming) {
        Program program1 = (planner, rel, requiredOutputTraits, materializations, lattices) -> {
            for (RelOptMaterialization materialization : materializations) {
                planner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                planner.addLattice(lattice);
            }
            planner.setRoot(rel);
            RelNode rootRel2 = rel.getTraitSet().equals(requiredOutputTraits) ? rel : planner.changeTraits(rel, requiredOutputTraits);
            Objects.requireNonNull(rootRel2, "rootRel2");
            planner.setRoot(rootRel2);
            RelOptPlanner planner2 = planner.chooseDelegate();
            RelNode rootRel3 = planner2.findBestExp();
            return Objects.requireNonNull(rootRel3, "could not implement exp");
        };
        ArrayList<Program> programs = Lists.newArrayList(Programs.subQuery(metadataProvider), new DecorrelateProgram(), Programs.measure(metadataProvider), new TrimFieldsProgram(), program1, Programs.calc(metadataProvider));
        programs.removeIf(program -> !enableFieldTrimming && program instanceof TrimFieldsProgram);
        return new SequenceProgram(ImmutableList.copyOf(programs));
    }

    private static class TrimFieldsProgram
    implements Program {
        private TrimFieldsProgram() {
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            return new RelFieldTrimmer(null, relBuilder).trim(rel);
        }
    }

    private static class DecorrelateProgram
    implements Program {
        private DecorrelateProgram() {
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            CalciteConnectionConfig config = planner.getContext().maybeUnwrap(CalciteConnectionConfig.class).orElse(CalciteConnectionConfig.DEFAULT);
            if (config.forceDecorrelate()) {
                RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
                return RelDecorrelator.decorrelateQuery(rel, relBuilder);
            }
            return rel;
        }
    }

    private static class ConditionalProgram
    implements Program {
        private final Predicate<RelNode> predicate;
        private final Program program;

        ConditionalProgram(Predicate<RelNode> predicate, Program program) {
            this.predicate = predicate;
            this.program = program;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            if (this.predicate.test(rel)) {
                return this.program.run(planner, rel, requiredOutputTraits, materializations, lattices);
            }
            return rel;
        }
    }

    private static class SequenceProgram
    implements Program {
        private final ImmutableList<Program> programs;

        SequenceProgram(ImmutableList<Program> programs) {
            this.programs = programs;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            for (Program program : this.programs) {
                rel = program.run(planner, rel, requiredOutputTraits, materializations, lattices);
            }
            return rel;
        }
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            for (RelOptMaterialization materialization : materializations) {
                planner.addMaterialization(materialization);
            }
            for (RelOptLattice lattice : lattices) {
                planner.addLattice(lattice);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

