/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputValidator;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.crypto.internal.pqc.lms.DigestProvider;
import org.bouncycastle.crypto.internal.pqc.lms.HSSKeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.HSSKeyPairGenerator;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.HSSPublicKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMOtsParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContext;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContextBasedSigner;
import org.bouncycastle.crypto.internal.pqc.lms.LMSContextBasedVerifier;
import org.bouncycastle.crypto.internal.pqc.lms.LMSKeyGenerationParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSKeyPairGenerator;
import org.bouncycastle.crypto.internal.pqc.lms.LMSParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPrivateKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSPublicKeyParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LMSigParameters;
import org.bouncycastle.crypto.internal.pqc.lms.LmsDigestUtil;

public class LMS {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("LMS");
    public static final Parameters SIG = new Parameters(ALGORITHM);
    public static final OTSParameters sha256_n32_w1 = new OTSParameters(LMOtsParameters.sha256_n32_w1);
    public static final OTSParameters sha256_n32_w2 = new OTSParameters(LMOtsParameters.sha256_n32_w2);
    public static final OTSParameters sha256_n32_w4 = new OTSParameters(LMOtsParameters.sha256_n32_w4);
    public static final OTSParameters sha256_n32_w8 = new OTSParameters(LMOtsParameters.sha256_n32_w8);
    public static final KeyParameters lms_sha256_n32_h5 = new KeyParameters(LMSigParameters.lms_sha256_n32_h5);
    public static final KeyParameters lms_sha256_n32_h10 = new KeyParameters(LMSigParameters.lms_sha256_n32_h5);
    public static final KeyParameters lms_sha256_n32_h15 = new KeyParameters(LMSigParameters.lms_sha256_n32_h5);
    public static final KeyParameters lms_sha256_n32_h20 = new KeyParameters(LMSigParameters.lms_sha256_n32_h5);
    public static final KeyParameters lms_sha256_n32_h25 = new KeyParameters(LMSigParameters.lms_sha256_n32_h5);

    static {
        LmsDigestUtil.setProvider(new LmsDigestProvider());
    }

    private static class ByteArrayUpdateOutputStream
    extends UpdateOutputStream {
        ExposedByteArrayOutputStream exOut = new ExposedByteArrayOutputStream();

        private ByteArrayUpdateOutputStream() {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            this.exOut.write(byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            this.exOut.write(n);
        }

        void outputTo(Digest digest) {
            this.exOut.outputTo(digest);
            this.exOut.reset();
        }
    }

    private static class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        private ExposedByteArrayOutputStream() {
        }

        void outputTo(Digest digest) {
            digest.update(this.buf, 0, this.count);
        }
    }

    public static abstract class KeyCache {
        protected abstract Object getInternalKey();
    }

    private static class KeyCacheAccessor
    extends KeyCache {
        private final KeyCache key;

        KeyCacheAccessor(KeyCache keyCache) {
            this.key = keyCache;
        }

        @Override
        protected Object getInternalKey() {
            return this.key.getInternalKey();
        }
    }

    public static final class KeyGenParameters
    extends GeneralParameters<GeneralAlgorithm> {
        private final KeyParameters[] keyParameters;

        public KeyGenParameters(KeyParameters ... keyParametersArray) {
            super(ALGORITHM);
            if (keyParametersArray.length == 0) {
                throw new IllegalArgumentException("at least one keyParameter required");
            }
            this.keyParameters = keyParametersArray;
        }
    }

    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey> {
        private AsymmetricCipherKeyPairGenerator engine;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            KeyParameters[] keyParametersArray = keyGenParameters.keyParameters;
            if (keyParametersArray.length == 1) {
                LMSKeyGenerationParameters lMSKeyGenerationParameters = new LMSKeyGenerationParameters(new LMSParameters(keyParametersArray[0].sigParams, keyParametersArray[0].otsParams), secureRandom);
                this.engine = new LMSKeyPairGenerator();
                this.engine.init(lMSKeyGenerationParameters);
            } else {
                LMSParameters[] lMSParametersArray = new LMSParameters[keyParametersArray.length];
                for (int i = 0; i != keyParametersArray.length; ++i) {
                    lMSParametersArray[i] = new LMSParameters(keyParametersArray[i].sigParams, keyParametersArray[i].otsParams);
                }
                HSSKeyGenerationParameters hSSKeyGenerationParameters = new HSSKeyGenerationParameters(lMSParametersArray, secureRandom);
                this.engine = new HSSKeyPairGenerator();
                this.engine.init(hSSKeyGenerationParameters);
            }
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            if (this.engine instanceof LMSKeyPairGenerator) {
                LMSPublicKeyParameters lMSPublicKeyParameters = (LMSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
                LMSPrivateKeyParameters lMSPrivateKeyParameters = (LMSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
                return new AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey>(new AsymmetricLMSPublicKey(1, lMSPublicKeyParameters.getEncoded()), new AsymmetricLMSPrivateKey(1, lMSPrivateKeyParameters.getEncoded(), lMSPublicKeyParameters.getEncoded()));
            }
            HSSPublicKeyParameters hSSPublicKeyParameters = (HSSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            HSSPrivateKeyParameters hSSPrivateKeyParameters = (HSSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            return new AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey>(new AsymmetricLMSPublicKey(hSSPublicKeyParameters.getL(), hSSPublicKeyParameters.getLMSPublicKey().getEncoded()), new AsymmetricLMSPrivateKey(hSSPrivateKeyParameters.getL(), hSSPrivateKeyParameters.getEncoded(), hSSPublicKeyParameters.getLMSPublicKey().getEncoded()));
        }
    }

    public static final class KeyParameters
    extends GeneralParameters<GeneralAlgorithm> {
        private final LMSigParameters sigParams;
        private final LMOtsParameters otsParams;

        private KeyParameters(LMSigParameters lMSigParameters, LMOtsParameters lMOtsParameters) {
            super(ALGORITHM);
            this.sigParams = lMSigParameters;
            this.otsParams = lMOtsParameters;
        }

        KeyParameters(LMSigParameters lMSigParameters) {
            this(lMSigParameters, sha256_n32_w4.otsParameters);
        }

        public KeyParameters using(OTSParameters oTSParameters) {
            return new KeyParameters(this.sigParams, oTSParameters.otsParameters);
        }
    }

    private static class LmsDigestProvider
    implements DigestProvider {
        private LmsDigestProvider() {
        }

        @Override
        public Digest getDigest(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha256)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHA256).createEngine();
            }
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_sha512)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHA512).createEngine();
            }
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake128)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHAKE128).createEngine();
            }
            if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_shake256)) {
                return (Digest)FipsRegister.getProvider(FipsSHS.Algorithm.SHAKE256).createEngine();
            }
            throw new IllegalArgumentException("unrecognized digest OID: " + aSN1ObjectIdentifier);
        }
    }

    public static final class OTSParameters {
        private final LMOtsParameters otsParameters;

        OTSParameters(LMOtsParameters lMOtsParameters) {
            this.otsParameters = lMOtsParameters;
        }
    }

    public static final class OperatorFactory
    extends GuardedSignatureOperatorFactory<Parameters> {
        @Override
        protected OutputSigner<Parameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, final Parameters parameters2) {
            final LMSContextBasedSigner lMSContextBasedSigner = (LMSContextBasedSigner)new KeyCacheAccessor((AsymmetricLMSPrivateKey)asymmetricPrivateKey).getInternalKey();
            return new OutputSigner<Parameters>(){
                final LMSContext lmsContext;
                {
                    this.lmsContext = lMSContextBasedSigner.generateLMSContext();
                }

                @Override
                public Parameters getParameters() {
                    return parameters2;
                }

                @Override
                public UpdateOutputStream getSigningStream() {
                    return new DigestOutputStream(this.lmsContext);
                }

                @Override
                public byte[] getSignature() throws PlainInputProcessingException {
                    byte[] byArray = lMSContextBasedSigner.generateSignature(this.lmsContext);
                    return byArray;
                }

                @Override
                public int getSignature(byte[] byArray, int n) throws PlainInputProcessingException {
                    byte[] byArray2 = this.getSignature();
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    return byArray2.length;
                }
            };
        }

        @Override
        protected OutputVerifier<Parameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, final Parameters parameters2) {
            final LMSContextBasedVerifier lMSContextBasedVerifier = (LMSContextBasedVerifier)new KeyCacheAccessor((AsymmetricLMSPublicKey)asymmetricPublicKey).getInternalKey();
            return new OutputVerifier<Parameters>(){
                final ByteArrayUpdateOutputStream bOut = new ByteArrayUpdateOutputStream();

                @Override
                public Parameters getParameters() {
                    return parameters2;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return this.bOut;
                }

                @Override
                public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
                    LMSContext lMSContext = lMSContextBasedVerifier.generateLMSContext(byArray);
                    this.bOut.outputTo(lMSContext);
                    return lMSContextBasedVerifier.verify(lMSContext);
                }
            };
        }

        @Override
        protected OutputValidator<Parameters> doCreateValidator(AsymmetricPublicKey asymmetricPublicKey, final Parameters parameters2, final byte[] byArray) {
            final LMSContextBasedVerifier lMSContextBasedVerifier = (LMSContextBasedVerifier)new KeyCacheAccessor((AsymmetricLMSPublicKey)asymmetricPublicKey).getInternalKey();
            return new OutputValidator<Parameters>(){
                LMSContext lmsContext;
                final DigestOutputStream dOut;
                {
                    this.lmsContext = lMSContextBasedVerifier.generateLMSContext(byArray);
                    this.dOut = new DigestOutputStream(this.lmsContext);
                }

                @Override
                public Parameters getParameters() {
                    return parameters2;
                }

                @Override
                public UpdateOutputStream getValidatingStream() {
                    return this.dOut;
                }

                @Override
                public boolean isValidated() {
                    return lMSContextBasedVerifier.verify(this.lmsContext);
                }
            };
        }
    }

    public static final class Parameters
    extends GeneralParameters<GeneralAlgorithm> {
        Parameters(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }
    }
}

