/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.List;
import lombok.Generated;
import shaded.com.google.common.collect.ImmutableList;

public enum SpanUnit {
    UNKNOWN("unknown"),
    NONE(""),
    MILLISECOND("ms"),
    MS("ms"),
    SECOND("s"),
    S("s"),
    MINUTE("m"),
    m("m"),
    HOUR("h"),
    H("h"),
    DAY("d"),
    D("d"),
    WEEK("w"),
    W("w"),
    MONTH("M"),
    M("M"),
    QUARTER("q"),
    Q("q"),
    YEAR("y"),
    Y("y");

    private final String name;
    private static final List<SpanUnit> SPAN_UNITS;

    public static SpanUnit of(String unit) {
        switch (unit) {
            case "": {
                return NONE;
            }
            case "M": {
                return M;
            }
            case "m": {
                return m;
            }
        }
        return SPAN_UNITS.stream().filter(v -> unit.equalsIgnoreCase(v.name())).findFirst().orElse(UNKNOWN);
    }

    public static String getName(SpanUnit unit) {
        return unit.name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    private SpanUnit(String name) {
        this.name = name;
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        SPAN_UNITS = ((ImmutableList.Builder)builder.add((Object[])SpanUnit.values())).build();
    }
}

