/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import inet.ipaddr.IPAddress;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.utils.IPUtils;

public class ExprIpValue
extends AbstractExprValue {
    private final IPAddress value;

    public ExprIpValue(String addressString) {
        this.value = IPUtils.toAddress(addressString);
    }

    @Override
    public String value() {
        return this.value.toCanonicalString();
    }

    @Override
    public ExprIpValue valueForCalcite() {
        return this;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.IP;
    }

    @Override
    public int compare(ExprValue other) {
        return IPUtils.compare(this.value, ((ExprIpValue)other).value);
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.compare(other) == 0;
    }

    public String toString() {
        return String.format("IP %s", this.value());
    }

    @Override
    public IPAddress ipValue() {
        return this.value;
    }
}

