/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window;

import java.util.Collections;
import java.util.function.Supplier;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionImplementation;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.window.patterns.BufferPatternWindowFunction;
import org.opensearch.sql.expression.window.ranking.DenseRankFunction;
import org.opensearch.sql.expression.window.ranking.RankFunction;
import org.opensearch.sql.expression.window.ranking.RankingWindowFunction;
import org.opensearch.sql.expression.window.ranking.RowNumberFunction;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public final class WindowFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(WindowFunctions.rowNumber());
        repository.register(WindowFunctions.rank());
        repository.register(WindowFunctions.denseRank());
        repository.register(WindowFunctions.brain());
    }

    private static DefaultFunctionResolver rowNumber() {
        return WindowFunctions.rankingFunction(BuiltinFunctionName.ROW_NUMBER.getName(), RowNumberFunction::new);
    }

    private static DefaultFunctionResolver rank() {
        return WindowFunctions.rankingFunction(BuiltinFunctionName.RANK.getName(), RankFunction::new);
    }

    private static DefaultFunctionResolver denseRank() {
        return WindowFunctions.rankingFunction(BuiltinFunctionName.DENSE_RANK.getName(), DenseRankFunction::new);
    }

    private static DefaultFunctionResolver brain() {
        FunctionName functionName = BuiltinFunctionName.BRAIN.getName();
        FunctionBuilder functionBuilder = (functionProperties, arguments2) -> new BufferPatternWindowFunction(arguments2);
        return new DefaultFunctionResolver(functionName, ImmutableMap.of(new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.STRING)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.INTEGER)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.DOUBLE)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.DOUBLE)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.DOUBLE)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.DOUBLE, ExprCoreType.INTEGER)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.INTEGER, ExprCoreType.DOUBLE)), functionBuilder, new FunctionSignature(functionName, ImmutableList.of(ExprCoreType.STRING, ExprCoreType.STRING, ExprCoreType.DOUBLE, ExprCoreType.INTEGER)), functionBuilder));
    }

    private static DefaultFunctionResolver rankingFunction(FunctionName functionName, Supplier<RankingWindowFunction> constructor) {
        FunctionSignature functionSignature = new FunctionSignature(functionName, Collections.emptyList());
        FunctionBuilder functionBuilder = (functionProperties, arguments2) -> (FunctionImplementation)constructor.get();
        return new DefaultFunctionResolver(functionName, ImmutableMap.of(functionSignature, functionBuilder));
    }

    @Generated
    private WindowFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

