/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.types.special;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;

public class Product
implements Type {
    private final List<Type> types;

    public Product(List<Type> itemTypes) {
        this.types = Collections.unmodifiableList(itemTypes);
    }

    @Override
    public String getName() {
        return "Product of types " + String.valueOf(this.types);
    }

    @Override
    public boolean isCompatible(Type other) {
        if (!(other instanceof Product)) {
            return false;
        }
        Product otherProd = (Product)other;
        if (this.types.size() != otherProd.types.size()) {
            return false;
        }
        for (int i = 0; i < this.types.size(); ++i) {
            Type otherType;
            Type type2 = this.types.get(i);
            if (this.isCompatibleEitherWay(type2, otherType = otherProd.types.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type construct(List<Type> others) {
        return this;
    }

    @Override
    public String usage() {
        if (this.types.isEmpty()) {
            return "(*)";
        }
        return this.types.stream().map(Type::usage).collect(Collectors.joining(", ", "(", ")"));
    }

    private boolean isCompatibleEitherWay(Type type1, Type type2) {
        return type1.isCompatible(type2) || type2.isCompatible(type1);
    }

    public List<Type> getTypes() {
        return this.types;
    }
}

